/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro;

import com.jp.protection.pub.License;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.launch.ProtectionLauncher;
import com.jp.protection.pub.pro.LicenseHostPro;
import java.io.File;

public class BackgroundLicenseCheck {
    protected LicenseHostPro fLicenseHost;
    protected ProductInfo fProductInfo;
    protected boolean fCheckLicense = true;
    protected Thread fCheckLicenseThread;
    protected long fLicenseFileModificationTime;
    protected boolean fLicenseFileCanRead = false;
    protected long fCheckPeriod = 60000L;

    public BackgroundLicenseCheck(LicenseHostPro aLicenseHost, ProductInfo aProductInfo) {
        this.fLicenseHost = aLicenseHost;
        this.fProductInfo = aProductInfo;
    }

    public BackgroundLicenseCheck(ProtectionLauncher aProtectionLauncher) {
        this.fLicenseHost = (LicenseHostPro)aProtectionLauncher.getLicenseHost();
        this.fProductInfo = aProtectionLauncher.getProductInfo();
    }

    public boolean isRunning() {
        return this.fCheckLicenseThread != null && this.fCheckLicense;
    }

    public void start() {
        if (!this.isRunning()) {
            this.fCheckLicense = true;
            this.getCheckLicenseThread().start();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            if (this.fCheckLicenseThread != null) {
                this.fCheckLicenseThread.interrupt();
            }
            this.fCheckLicense = false;
        }
    }

    public long getCheckPeriod() {
        return this.fCheckPeriod;
    }

    public void setCheckPeriod(long aCheckPeriod) {
        this.fCheckPeriod = aCheckPeriod;
    }

    protected Thread getCheckLicenseThread() {
        if (this.fCheckLicenseThread == null) {
            this.fCheckLicenseThread = new Thread(){

                public void run() {
                    BackgroundLicenseCheck.this.checkLicense();
                    while (BackgroundLicenseCheck.this.fCheckLicense) {
                        try {
                            1.sleep(BackgroundLicenseCheck.this.getCheckPeriod());
                            if (!BackgroundLicenseCheck.this.fCheckLicense) continue;
                            BackgroundLicenseCheck.this.checkLicense();
                        }
                        catch (Exception exception) {}
                    }
                    BackgroundLicenseCheck.this.fCheckLicenseThread = null;
                }
            };
        }
        return this.fCheckLicenseThread;
    }

    public boolean checkLicense() {
        File licenseFile = this.fLicenseHost.getLicenseReader().getLicenseFile();
        boolean forceRead = licenseFile.canRead() && licenseFile.lastModified() != this.fLicenseFileModificationTime || this.fLicenseFileCanRead != licenseFile.canRead();
        return this.checkLicense(forceRead);
    }

    public boolean checkLicense(boolean aForceLicenseRead) {
        boolean result = false;
        this.checkLicenseImpl(aForceLicenseRead);
        License license = this.fLicenseHost.getLicense();
        result = license != null && license.getLicenseState() == 2;
        File licenseFile = this.fLicenseHost.getLicenseReader().getLicenseFile();
        if (licenseFile.canRead()) {
            this.fLicenseFileModificationTime = licenseFile.lastModified();
        }
        this.fLicenseFileCanRead = licenseFile.canRead();
        return result;
    }

    protected void checkLicenseImpl(boolean aForceLicenseRead) {
        this.fLicenseHost.checkLicense(this.fProductInfo.getID(), this.fProductInfo.getMajorVersion(), this.fProductInfo.getMinorVersion(), aForceLicenseRead);
    }
}

