/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.launch;

import com.jp.protection.pub.launch.ProtectionLauncherConfig;
import com.jp.protection.security.SecurityProvider;
import com.jp.protection.security.SecurityProviderFactory;
import com.jp.protection.utils.LicenseUtils;
import dev.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.PublicKey;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ProtectionLauncherConfigReader {
    protected boolean fVerbose = false;
    protected boolean fSkipEncryption = false;
    protected String fSecurityAlgorithm = "RSA";
    protected byte[] fDecryptKeyBytes;
    protected SecurityProvider fSecurityProvider;

    protected SecurityProvider getSecurityProvider() {
        if (this.fSecurityProvider == null || !this.fSecurityProvider.getID().equals(this.fSecurityAlgorithm)) {
            this.fSecurityProvider = SecurityProviderFactory.getSecurityProvider(this.fSecurityAlgorithm);
        }
        return this.fSecurityProvider;
    }

    public ProtectionLauncherConfigReader() {
    }

    public ProtectionLauncherConfigReader(String aSecurityAlgorithm, byte[] aDecryptKeyBytes) {
        this.fSecurityAlgorithm = aSecurityAlgorithm;
        this.fDecryptKeyBytes = aDecryptKeyBytes;
    }

    public String getSecurityAlgorithm() {
        return this.fSecurityAlgorithm;
    }

    public void setSecurityAlgorithm(String aSecurityAlgorithm) {
        this.fSecurityAlgorithm = aSecurityAlgorithm;
    }

    public byte[] getDecryptKeyBytes() {
        return this.fDecryptKeyBytes;
    }

    public void setDecryptKeyBytes(byte[] aDecryptKeyBytes) {
        this.fDecryptKeyBytes = aDecryptKeyBytes;
    }

    public void setDecryptKeyBytes(String aDecryptKeyBytes) {
        this.fDecryptKeyBytes = LicenseUtils.toBytes(aDecryptKeyBytes);
    }

    public boolean isSkipEncryption() {
        return this.fSkipEncryption;
    }

    public void setSkipEncryption(boolean aSkipEncryption) {
        this.fSkipEncryption = aSkipEncryption;
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean aVerbose) {
        this.fVerbose = aVerbose;
    }

    protected void error(Throwable aThrowable) {
        if (this.isVerbose()) {
            aThrowable.printStackTrace();
        }
    }

    private byte[] decode(byte[] aConfigBytes) {
        byte[] result = aConfigBytes;
        if (!this.isSkipEncryption()) {
            try {
                SecurityProvider securityProvider = this.getSecurityProvider();
                PublicKey publicKey = securityProvider.getPublicKey(this.fDecryptKeyBytes);
                result = securityProvider.decode(aConfigBytes, publicKey);
            }
            catch (Exception ex) {
                result = null;
                this.error(ex);
            }
        }
        return result;
    }

    public ProtectionLauncherConfig read(InputStream anInputStream) throws IOException {
        return this.read(StreamUtil.readB(anInputStream));
    }

    public ProtectionLauncherConfig read(Class aBaseClass, String aResourceName) throws IOException {
        InputStream stream = aBaseClass.getResourceAsStream(aResourceName);
        if (stream == null) {
            throw new IllegalArgumentException("Unable to load launcher: " + aBaseClass.getName() + " - " + aResourceName);
        }
        return this.read(stream);
    }

    protected ProtectionLauncherConfig read(byte[] aConfigBytes) throws IOException {
        ProtectionLauncherConfig result = null;
        if ((aConfigBytes = this.decode(aConfigBytes)) == null) {
            throw new IOException("Unable to decode Launcher");
        }
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(aConfigBytes));
        try {
            result = (ProtectionLauncherConfig)in.readObject();
            result.setUseEncryption(!this.isSkipEncryption());
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            in.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectionLauncherConfig read(File aFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(aFile);
        try {
            ProtectionLauncherConfig protectionLauncherConfig = this.read(inputStream);
            return protectionLauncherConfig;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectionLauncherConfig read(File aJarFile, String anEntryName) throws IOException {
        JarFile jarFile = new JarFile(aJarFile);
        try {
            ProtectionLauncherConfig protectionLauncherConfig;
            JarEntry jarEntry = jarFile.getJarEntry(anEntryName);
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            try {
                protectionLauncherConfig = this.read(inputStream);
            }
            catch (Throwable throwable) {
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return protectionLauncherConfig;
        }
        finally {
            jarFile.close();
        }
    }
}

