/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.launch;

import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.SecretStorage;
import com.jp.protection.pub.launch.FacadeConnectionConfig;
import com.jp.protection.pub.launch.LicensingServerConnectionConfig;
import com.jp.protection.pub.launch.ProtectionLauncherConfigBase;
import dev.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class ProtectionLauncherConfig
extends ProtectionLauncherConfigBase {
    public static final long serialVersionUID = 1L;
    protected String fSecurityAlgorithm;
    protected byte[] fDecryptKeyBytes;
    protected boolean fProfessional = false;
    protected ProductInfo fProductInfo;
    protected transient boolean fUseEncryption = true;
    protected boolean fVerbose = false;
    private static final byte[] SALT = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};

    public ProtectionLauncherConfig() {
    }

    public ProtectionLauncherConfig(ProtectionLauncherConfigBase aLauncherConfig) {
        LicensingServerConnectionConfig[] licensingServerConnectionConfigs;
        FacadeConnectionConfig[] facadeConnectionConfigs;
        this.fCopyright = aLauncherConfig.getCopyright();
        this.fCompany = aLauncherConfig.getCompany();
        this.fCompanyLogo = aLauncherConfig.getCompanyLogo();
        this.fCompanyLogoRes = aLauncherConfig.getCompanyLogoRes();
        this.fLicenseFileName = aLauncherConfig.getLicenseFileName();
        this.fLicenseFolder = aLauncherConfig.getLicenseFolder();
        this.fLicenseUserHomeRelative = aLauncherConfig.isLicenseUserHomeRelative();
        this.fLicenseResourceFolder = aLauncherConfig.getLicenseResourceFolder();
        this.fLicenseTextCommercial = aLauncherConfig.getLicenseTextCommercial();
        this.fLicenseTextCommercialRes = aLauncherConfig.getLicenseTextCommercialRes();
        this.fLicenseTextEvaluation = aLauncherConfig.getLicenseTextEvaluation();
        this.fLicenseTextEvaluationRes = aLauncherConfig.getLicenseTextEvaluationRes();
        this.fGUI = aLauncherConfig.isGUI();
        this.fAllowFlexibleExpirationDate = aLauncherConfig.isAllowFlexibleExpirationDate();
        this.fCheckPreviousShutdownDate = aLauncherConfig.isCheckPreviousShutdownDate();
        this.fSilentActivation = aLauncherConfig.isSilentActivation();
        this.fUseStrippedActivationKeyChars = aLauncherConfig.isUseStrippedActivationKeyChars();
        this.fAcceptLicenseAgreement = aLauncherConfig.isAcceptLicenseAgreement();
        this.fMaintainPreviousShutdownDate = aLauncherConfig.isMaintainPreviousShutdownDate();
        this.fActivationLockOptions = aLauncherConfig.getActivationLockOptions();
        SecretStorage.Provider[] secretStorageProviders = aLauncherConfig.getSecretStorageProviders();
        if (secretStorageProviders != null) {
            this.fSecretStorageProviders = new SecretStorage.Provider[secretStorageProviders.length];
            for (int i = 0; i < secretStorageProviders.length; ++i) {
                this.fSecretStorageProviders[i] = (SecretStorage.Provider)secretStorageProviders[i].clone();
            }
        }
        if ((facadeConnectionConfigs = aLauncherConfig.getFacadeConnectionConfigs()) != null) {
            this.fFacadeConnectionConfigs = new FacadeConnectionConfig[facadeConnectionConfigs.length];
            for (int i = 0; i < facadeConnectionConfigs.length; ++i) {
                this.fFacadeConnectionConfigs[i] = (FacadeConnectionConfig)facadeConnectionConfigs[i].clone();
            }
        }
        if ((licensingServerConnectionConfigs = aLauncherConfig.getLicensingServerConnectionConfigs()) != null) {
            this.fLicensingServerConnectionConfigs = new LicensingServerConnectionConfig[licensingServerConnectionConfigs.length];
            for (int i = 0; i < licensingServerConnectionConfigs.length; ++i) {
                this.fLicensingServerConnectionConfigs[i] = (LicensingServerConnectionConfig)licensingServerConnectionConfigs[i].clone();
            }
        }
        this.fLicensingWizardLogo = aLauncherConfig.getLicensingWizardLogo();
        this.fLicensingWizardLogoRes = aLauncherConfig.getLicensingWizardLogoRes();
        this.fLicensingWizardOptions = aLauncherConfig.getLicensingWizardOptions();
        this.fActivationWizardLogo = aLauncherConfig.getActivationWizardLogo();
        this.fActivationWizardLogoRes = aLauncherConfig.getActivationWizardLogoRes();
        this.fActivationWizardOptions = aLauncherConfig.getActivationWizardOptions();
        this.fDeactivationWizardLogo = aLauncherConfig.getDeactivationWizardLogo();
        this.fDeactivationWizardLogoRes = aLauncherConfig.getDeactivationWizardLogoRes();
        this.fDeactivationWizardOptions = aLauncherConfig.getDeactivationWizardOptions();
        this.fLicenseLockWizardLogo = aLauncherConfig.getLicenseLockWizardLogo();
        this.fLicenseLockWizardLogoRes = aLauncherConfig.getLicenseLockWizardLogoRes();
        this.fLicenseLockWizardOptions = aLauncherConfig.getLicenseLockWizardOptions();
    }

    public ProductInfo getProductInfo() {
        return this.fProductInfo;
    }

    public void setProductInfo(ProductInfo aProductInfo) {
        this.fProductInfo = aProductInfo;
    }

    public boolean isProfessional() {
        return this.fProfessional;
    }

    public void setProfessional(boolean aProfessional) {
        this.fProfessional = aProfessional;
    }

    public byte[] getDecryptKeyBytes() {
        return this.fDecryptKeyBytes;
    }

    public void setDecryptKeyBytes(byte[] aDecryptKeyBytes) {
        this.fDecryptKeyBytes = aDecryptKeyBytes;
    }

    public String getSecurityAlgorithm() {
        return this.fSecurityAlgorithm;
    }

    public void setSecurityAlgorithm(String aSecurityAlgorithm) {
        this.fSecurityAlgorithm = aSecurityAlgorithm;
    }

    public boolean isUseEncryption() {
        return this.fUseEncryption;
    }

    public void setUseEncryption(boolean aUseEncryption) {
        this.fUseEncryption = aUseEncryption;
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean aVerbose) {
        this.fVerbose = aVerbose;
    }

    public static ProtectionLauncherConfig loadDecrypted(InputStream anInputStream) throws IOException {
        ProtectionLauncherConfig result = ProtectionLauncherConfig.load(StreamUtil.getDecryptedInputStream(anInputStream, ProtectionLauncherConfig.getCipher(false)));
        result.setUseEncryption(true);
        return result;
    }

    protected static Cipher getCipher(boolean isEncrypt) {
        try {
            PBEParameterSpec paramSpec = new PBEParameterSpec(SALT, 20);
            PBEKeySpec keySpec = new PBEKeySpec("Sk:0&M?1^~wPf_lQ<DKyvB".toCharArray());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            SecretKey key = keyFactory.generateSecret(keySpec);
            Cipher result = Cipher.getInstance("PBEWithMD5AndDES");
            result.init(isEncrypt ? 1 : 2, (Key)key, paramSpec);
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ProtectionLauncherConfig load(InputStream anInputStream) throws IOException {
        ProtectionLauncherConfig result = null;
        ObjectInputStream in = new ObjectInputStream(anInputStream);
        try {
            result = (ProtectionLauncherConfig)in.readObject();
            result.setUseEncryption(false);
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            in.close();
        }
        return result;
    }

    public static void storeEncrypted(ProtectionLauncherConfig aLauncherConfig, OutputStream anOutputStream) throws IOException {
        ProtectionLauncherConfig.store(aLauncherConfig, StreamUtil.getEncryptedOutputStream(anOutputStream, ProtectionLauncherConfig.getCipher(true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(ProtectionLauncherConfig aLauncherConfig, OutputStream anOutputStream) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(anOutputStream);
        try {
            out.writeObject(aLauncherConfig);
        }
        finally {
            out.close();
        }
    }
}

