/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.launch;

import com.jp.protection.gui.dialogs.DefaultLicenseAdapter;
import com.jp.protection.gui.dialogs.DefaultLicenseReaderIssueResolver;
import com.jp.protection.gui.dialogs.LicenseAboutDialog;
import com.jp.protection.gui.dialogs.LicensingWizard;
import com.jp.protection.gui.dialogs.pro.DefaultLicenseHostIssueResolver;
import com.jp.protection.gui.dialogs.pro.DefaultLicenseReaderIssueResolverPro;
import com.jp.protection.gui.dialogs.pro.LicenseDeactivationWizard;
import com.jp.protection.gui.dialogs.pro.LicensingWizardPro;
import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseAcceptanceDelegate;
import com.jp.protection.pub.LicenseAdapter;
import com.jp.protection.pub.LicenseHost;
import com.jp.protection.pub.LicenseHostIssueResolver;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.LicenseReaderIssueResolver;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.ProtectionFactory;
import com.jp.protection.pub.SimpleLicenseAcceptanceDelegate;
import com.jp.protection.pub.launch.HeadlessProtectionLauncher;
import com.jp.protection.pub.launch.ProtectionLauncherConfig;
import com.jp.protection.pub.launch.ProtectionLauncherConfigReader;
import com.jp.protection.pub.pro.LicenseHostPro;
import dev.gui.ResourceUtils;
import dev.util.StringUtils;
import java.awt.Component;
import java.io.IOException;
import javax.swing.ImageIcon;

public class ProtectionLauncher
extends HeadlessProtectionLauncher {
    protected Component fOwner;
    protected ImageIcon fLicensingWizardLogo;
    protected ImageIcon fActivationWizardLogo;
    protected int fLicensingWizardOptions = 0;
    protected int fActivationWizardOptions = 0;
    protected ImageIcon fDeactivationWizardLogo;
    protected int fDeactivationWizardOptions = 0;
    protected ImageIcon fLicenseLockWizardLogo;
    protected int fLicenseLockWizardOptions = 0;

    public ProtectionLauncher(ProtectionLauncherConfig aLauncherConfig) {
        this(aLauncherConfig, null, null);
    }

    public ProtectionLauncher(ProtectionLauncherConfig aLauncherConfig, Component anOwner) {
        this(aLauncherConfig, anOwner, null);
    }

    public ProtectionLauncher(ProtectionLauncherConfig aLauncherConfig, Component anOwner, LicenseReader aLicenseReader) {
        super(aLauncherConfig, aLicenseReader);
        this.fOwner = anOwner;
    }

    public void showAboutDialog() {
        ProductInfo productInfo = this.getProductInfo();
        LicenseAboutDialog licenseAboutDialog = ProtectionFactory.createLicenseAboutDialog(this.fOwner, productInfo);
        ProtectionLauncherConfig config = this.getLauncherConfig();
        licenseAboutDialog.setLogoIcon(this.loadIcon(config.getCompanyLogo(), config.getCompanyLogoRes()));
        License license = this.fLicenseHost.getLicense();
        if (license != null) {
            String productName = productInfo.getName();
            if (license.getProductEdition() != null) {
                productName = productName + " " + this.getProductEditionName(license);
            }
            licenseAboutDialog.setProductName(productName);
        }
        LicenseAboutDialog.execute(licenseAboutDialog, this.fLicenseHost);
    }

    protected void initLicenseReader() {
        ProtectionLauncherConfig config = this.getLauncherConfig();
        if (this.fLicenseReader == null) {
            this.fLicenseReader = this.createLicenseReader();
        }
        this.fLicenseReader.setIssueResolver(this.createLicenseReaderIssueResolver());
        this.fLicenseReader.setLicenseResourceFolder(config.getLicenseResourceFolder());
        this.fLicenseReader.setLicenseFileName(config.getLicenseFileName());
        this.fLicenseReader.setLicenseFolder(config.getLicenseFolder());
        this.fLicenseReader.setUserHomeRelative(config.isLicenseUserHomeRelative());
        this.fLicenseReader.setDecryptKeyBytes(config.getDecryptKeyBytes());
        this.fLicenseReader.setSecurityAlgorithm(config.getSecurityAlgorithm());
    }

    public void init() {
        super.init();
        this.initWizards();
    }

    protected LicenseReaderIssueResolver createLicenseReaderIssueResolver() {
        return this.getLauncherConfig().isGUI() ? ProtectionFactory.createLicenseReaderIssueResolver(this.fLicenseReader, this.fOwner, this.getProductInfo()) : null;
    }

    protected void initLicenseListener() {
        if (this.getLauncherConfig().isGUI()) {
            DefaultLicenseAdapter listener = new DefaultLicenseAdapter(this.fOwner);
            listener.setProductInfo(this.getProductInfo());
            this.fLicenseListener = listener;
        } else {
            this.fLicenseListener = new LicenseAdapter();
        }
    }

    protected void initLicenseHost() {
        super.initLicenseHost();
        if (this.fLicenseReader.getIssueResolver() instanceof DefaultLicenseReaderIssueResolverPro) {
            ((DefaultLicenseReaderIssueResolverPro)this.fLicenseReader.getIssueResolver()).setLicenseHost((LicenseHostPro)this.fLicenseHost);
        }
        if (this.fLicenseHost.getIssueResolver() instanceof DefaultLicenseHostIssueResolver) {
            ((DefaultLicenseHostIssueResolver)this.fLicenseHost.getIssueResolver()).setLicensingWizardOptions(this.fLicensingWizardOptions);
        }
    }

    protected LicenseHostIssueResolver createLicenseHostIssueResolver() {
        LicenseHostIssueResolver result = null;
        if (this.fLauncherConfig.isGUI() && (result = ProtectionFactory.createLicenseHostIssueResolver(this.fLicenseHost, this.fOwner, this.getProductInfo())) instanceof DefaultLicenseHostIssueResolver) {
            ((DefaultLicenseHostIssueResolver)result).setSilentActivation(this.getLauncherConfig().isSilentActivation());
        }
        return result;
    }

    protected LicenseAcceptanceDelegate createLicenseAcceptanceDelegate() {
        LicenseAcceptanceDelegate result = null;
        result = this.getLauncherConfig().isGUI() && this.getLauncherConfig().isAcceptLicenseAgreement() ? ProtectionFactory.createLicenseAcceptanceDelegate(this.fOwner, this.getProductInfo().getShortName() + " License Agreement") : new SimpleLicenseAcceptanceDelegate();
        return result;
    }

    protected LicenseHost createLicenseHost() {
        return ProtectionFactory.createLicenseHost(this.fLicenseReader, this.fLicenseListener);
    }

    protected void initProfessional(ProtectionLauncherConfig config) {
        if (config.isProfessional()) {
            ProtectionFactory.initProfessional();
        }
    }

    private void initWizards() {
        ProtectionLauncherConfig config = this.getLauncherConfig();
        this.setLicensingWizardOptions(config.getLicensingWizardOptions());
        ImageIcon logo = this.loadIcon(config.getLicensingWizardLogo(), config.getLicensingWizardLogoRes());
        if (logo != null) {
            this.setLicensingWizardLogo(logo);
        }
        this.setActivationWizardOptions(config.getActivationWizardOptions());
        logo = this.loadIcon(config.getActivationWizardLogo(), config.getActivationWizardLogoRes());
        if (logo != null) {
            this.setActivationWizardLogo(logo);
        }
        this.setDeactivationWizardOptions(config.getDeactivationWizardOptions());
        logo = this.loadIcon(config.getDeactivationWizardLogo(), config.getDeactivationWizardLogoRes());
        if (logo != null) {
            this.setDeactivationWizardLogo(logo);
        }
        this.setLicenseLockWizardOptions(config.getLicenseLockWizardOptions());
        logo = this.loadIcon(config.getLicenseLockWizardLogo(), config.getLicenseLockWizardLogoRes());
        if (logo != null) {
            this.setLicenseLockWizardLogo(logo);
        }
    }

    protected ImageIcon loadIcon(String aFileName, String aResource) {
        ImageIcon result = null;
        if (!StringUtils.noValue(aResource)) {
            result = ResourceUtils.loadImageIcon(this.getClass(), aResource);
        } else if (!StringUtils.noValue(aFileName)) {
            result = new ImageIcon(aFileName);
        }
        return result;
    }

    public void setLicensingWizardLogo(ImageIcon aLicensingWizardLogo) {
        this.fLicensingWizardLogo = aLicensingWizardLogo;
        if (this.fLicensingWizardLogo != null) {
            LicenseHostIssueResolver hostResolver;
            LicenseReaderIssueResolver resolver = this.fLicenseReader.getIssueResolver();
            if (resolver instanceof DefaultLicenseReaderIssueResolver) {
                ((DefaultLicenseReaderIssueResolver)resolver).setLicensingWizardLogo(this.fLicensingWizardLogo);
            }
            if ((hostResolver = this.fLicenseHost.getIssueResolver()) instanceof DefaultLicenseHostIssueResolver) {
                ((DefaultLicenseHostIssueResolver)hostResolver).setLicensingWizardLogo(this.fLicensingWizardLogo);
            }
        }
    }

    public void setActivationWizardLogo(ImageIcon anActivationWizardLogo) {
        LicenseHostIssueResolver resolver;
        this.fActivationWizardLogo = anActivationWizardLogo;
        if (this.fActivationWizardLogo != null && (resolver = this.fLicenseHost.getIssueResolver()) instanceof DefaultLicenseHostIssueResolver) {
            ((DefaultLicenseHostIssueResolver)resolver).setActivationWizardLogo(this.fActivationWizardLogo);
        }
    }

    protected void setLicensingWizardOptions(int anOptions) {
        LicenseHostIssueResolver hostResolver;
        this.fLicensingWizardOptions = anOptions;
        LicenseReaderIssueResolver resolver = this.fLicenseReader.getIssueResolver();
        if (resolver instanceof DefaultLicenseReaderIssueResolver) {
            ((DefaultLicenseReaderIssueResolver)resolver).setLicensingWizardOptions(this.fLicensingWizardOptions);
        }
        if ((hostResolver = this.fLicenseHost.getIssueResolver()) instanceof DefaultLicenseHostIssueResolver) {
            ((DefaultLicenseHostIssueResolver)hostResolver).setLicensingWizardOptions(this.fLicensingWizardOptions);
        }
    }

    protected void setActivationWizardOptions(int anOptions) {
        this.fActivationWizardOptions = anOptions;
        LicenseHostIssueResolver resolver = this.fLicenseHost.getIssueResolver();
        if (resolver instanceof DefaultLicenseHostIssueResolver) {
            ((DefaultLicenseHostIssueResolver)resolver).setActivationWizardOptions(this.fActivationWizardOptions);
        }
    }

    protected void setDeactivationWizardLogo(ImageIcon aDeactivationWizardLogo) {
        this.fDeactivationWizardLogo = aDeactivationWizardLogo;
    }

    protected void setDeactivationWizardOptions(int anOptions) {
        this.fDeactivationWizardOptions = anOptions;
    }

    protected void setLicenseLockWizardLogo(ImageIcon aLicenseLockWizardLogo) {
        LicenseHostIssueResolver resolver;
        this.fLicenseLockWizardLogo = aLicenseLockWizardLogo;
        if (this.fLicenseLockWizardLogo != null && (resolver = this.fLicenseHost.getIssueResolver()) instanceof DefaultLicenseHostIssueResolver) {
            ((DefaultLicenseHostIssueResolver)resolver).setLicenseLockWizardLogo(this.fLicenseLockWizardLogo);
        }
    }

    protected void setLicenseLockWizardOptions(int anOptions) {
        this.fLicenseLockWizardOptions = anOptions;
        LicenseHostIssueResolver resolver = this.fLicenseHost.getIssueResolver();
        if (resolver instanceof DefaultLicenseHostIssueResolver) {
            ((DefaultLicenseHostIssueResolver)resolver).setLicenseLockWizardOptions(this.fLicenseLockWizardOptions);
        }
    }

    public boolean upgradeLicense(Component anOwner) {
        boolean result = false;
        LicensingWizard licensingWizard = this.createLicensingWizard(anOwner);
        licensingWizard.setOptions(this.fLicensingWizardOptions);
        if (this.fLicensingWizardLogo != null) {
            licensingWizard.setWizardIcon(this.fLicensingWizardLogo);
        }
        ((LicensingWizardPro)licensingWizard).setLicenseHost((LicenseHostPro)this.fLicenseHost);
        if (licensingWizard.executeModal()) {
            ((LicenseHostPro)this.fLicenseHost).setAutoIncUseCount(true);
            result = this.checkLicense(true);
        }
        return result;
    }

    protected LicensingWizard createLicensingWizard(Component anOwner) {
        return ProtectionFactory.createLicensingWizard(this.fLicenseHost.getLicenseReader(), anOwner, this.getProductInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deactivateLicense(Component anOwner) {
        int result = 0;
        if (this.getLauncherConfig().isProfessional()) {
            LicenseDeactivationWizard wizard = this.createLicenseDeactivationWizard(anOwner);
            try {
                wizard.setLicenseHost((LicenseHostPro)this.fLicenseHost);
                wizard.setProductInfo(this.getProductInfo());
                wizard.setOptions(this.fDeactivationWizardOptions);
                if (this.fDeactivationWizardLogo != null) {
                    wizard.setWizardIcon(this.fDeactivationWizardLogo);
                }
                result = wizard.execute();
            }
            finally {
                wizard.dispose();
            }
        }
        return result;
    }

    protected LicenseDeactivationWizard createLicenseDeactivationWizard(Component anOwner) {
        return new LicenseDeactivationWizard(anOwner);
    }

    public static ProtectionLauncher getProtectionLauncher(ProtectionLauncherConfigReader aReader, Class aBaseCLass, String aLauncherConfigResourceName, Component anOwner, LicenseReader aLicenseReader) throws IOException {
        ProtectionLauncher result = new ProtectionLauncher(aReader.read(aBaseCLass, aLauncherConfigResourceName), anOwner, aLicenseReader);
        result.init();
        return result;
    }

    public static ProtectionLauncher getProtectionLauncher(ProtectionLauncherConfigReader aReader, Class aBaseCLass, String aLauncherConfigResourceName, Component anOwner) throws IOException {
        return ProtectionLauncher.getProtectionLauncher(aReader, aBaseCLass, aLauncherConfigResourceName, anOwner, null);
    }

    public static ProtectionLauncher getProtectionLauncher(ProtectionLauncherConfigReader aReader, Class aBaseCLass, String aLauncherConfigResourceName) throws IOException {
        return ProtectionLauncher.getProtectionLauncher(aReader, aBaseCLass, aLauncherConfigResourceName, null, null);
    }
}

