/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.launch;

import com.jp.protection.pub.launch.LicensingServerConnectionConfigRMI;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;

public class LicensingServerConnectionConfig
implements Serializable,
Cloneable {
    public static final long serialVersionUID = 1L;
    protected String fID;
    protected Class fProviderClass;
    protected String fName;
    protected String fAddress;
    protected String fLogin;
    protected String fPassword;
    protected boolean fDefault = false;
    private static final MessageFormat INSTANTIATION_FORMAT = new MessageFormat("\"{0}\", {1}.class, \"{2}\", \"{3}\", \"{4}\", true");

    public LicensingServerConnectionConfig(String anID, Class aProviderClass, String aName, boolean aDefault) {
        this.fID = anID;
        this.fProviderClass = aProviderClass;
        this.fName = aName;
        this.fDefault = aDefault;
    }

    public LicensingServerConnectionConfig() {
    }

    public Class getProviderClass() {
        return this.fProviderClass;
    }

    public boolean isDefault() {
        return this.fDefault;
    }

    public String getID() {
        return this.fID;
    }

    public String toString() {
        return this.fName;
    }

    public String getLogin() {
        return this.fLogin;
    }

    public void setLogin(String aLogin) {
        this.fLogin = aLogin;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public void setPassword(String aPassword) {
        this.fPassword = aPassword;
    }

    public String getAddress() {
        return this.fAddress;
    }

    public void setAddress(String aAddress) {
        this.fAddress = aAddress;
    }

    public String getName() {
        return this.fName;
    }

    public String getInstantiationStr() {
        return INSTANTIATION_FORMAT.format(new Object[]{this.fName, this.fProviderClass.getName(), this.fAddress, this.fLogin, this.fPassword});
    }

    public String getSampleAddress() {
        return null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public static abstract class Provider {
        protected String fID;
        protected Class fProviderClass;
        protected String fName;
        protected boolean fDefault = false;

        public Provider(String aID, Class aProviderClass, String aName, boolean aDefault) {
            this.fID = aID;
            this.fProviderClass = aProviderClass;
            this.fName = aName;
            this.fDefault = aDefault;
        }

        public String getID() {
            return this.fID;
        }

        public String getName() {
            return this.fName;
        }

        public String toString() {
            return this.fName;
        }

        public boolean isDefault() {
            return this.fDefault;
        }

        public abstract LicensingServerConnectionConfig create();
    }

    public static class ProviderRegistry {
        protected static HashMap fRegistry = new HashMap();

        public static void add(Provider aProvider) {
            fRegistry.put(aProvider.getID(), aProvider);
        }

        public static void remove(Provider aProvider) {
            fRegistry.remove(aProvider.getID());
        }

        public static Provider get(String anID) {
            return (Provider)fRegistry.get(anID);
        }

        public static Collection getAll() {
            return fRegistry.values();
        }

        static {
            ProviderRegistry.add(new LicensingServerConnectionConfigRMI.Provider(true));
        }
    }
}

