/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.launch;

import com.jp.protection.pub.HeadlessProtectionFactory;
import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseAcceptanceDelegate;
import com.jp.protection.pub.LicenseAdapter;
import com.jp.protection.pub.LicenseHost;
import com.jp.protection.pub.LicenseHostIssueResolver;
import com.jp.protection.pub.LicenseListener;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.LicenseReaderIssueResolver;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.SecretStorage;
import com.jp.protection.pub.SimpleLicenseAcceptanceDelegate;
import com.jp.protection.pub.launch.FacadeConnectionConfig;
import com.jp.protection.pub.launch.LicensingServerConnectionConfig;
import com.jp.protection.pub.launch.ProtectionLauncherConfig;
import com.jp.protection.pub.launch.ProtectionLauncherConfigReader;
import com.jp.protection.pub.pro.LicenseHostPro;
import com.jp.protection.pub.pro.integration.LicensingFacadeProvider;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderFactory;
import dev.util.StringUtils;
import java.io.IOException;
import java.util.prefs.Preferences;

public class HeadlessProtectionLauncher {
    protected ProtectionLauncherConfig fLauncherConfig;
    protected LicenseReader fLicenseReader;
    protected LicenseHost fLicenseHost;
    protected LicenseListener fLicenseListener;
    protected boolean fVerbose = false;

    public HeadlessProtectionLauncher(ProtectionLauncherConfig aLauncherConfig) {
        this(aLauncherConfig, null);
    }

    public HeadlessProtectionLauncher(ProtectionLauncherConfig aLauncherConfig, LicenseReader aLicenseReader) {
        this.fLauncherConfig = aLauncherConfig;
        this.fLicenseReader = aLicenseReader;
    }

    public ProductInfo getProductInfo() {
        return this.fLauncherConfig.getProductInfo();
    }

    public ProtectionLauncherConfig getLauncherConfig() {
        return this.fLauncherConfig;
    }

    protected String getProductEditionName(License license) {
        return this.getProductInfo().getProductEditionName(license.getProductEdition());
    }

    public LicenseHost getLicenseHost() {
        return this.fLicenseHost;
    }

    public LicenseReader getLicenseReader() {
        return this.fLicenseHost.getLicenseReader();
    }

    protected void initLicenseReader() {
        ProtectionLauncherConfig config = this.getLauncherConfig();
        if (this.fLicenseReader == null) {
            this.fLicenseReader = this.createLicenseReader();
        }
        this.fLicenseReader.setIssueResolver(this.createLicenseReaderIssueResolver());
        this.fLicenseReader.setLicenseResourceFolder(config.getLicenseResourceFolder());
        this.fLicenseReader.setLicenseFileName(config.getLicenseFileName());
        this.fLicenseReader.setLicenseFolder(config.getLicenseFolder());
        this.fLicenseReader.setUserHomeRelative(config.isLicenseUserHomeRelative());
        this.fLicenseReader.setDecryptKeyBytes(config.getDecryptKeyBytes());
        this.fLicenseReader.setSecurityAlgorithm(config.getSecurityAlgorithm());
    }

    protected LicenseReaderIssueResolver createLicenseReaderIssueResolver() {
        return null;
    }

    protected LicenseReader createLicenseReader() {
        return HeadlessProtectionFactory.createLicenseReader();
    }

    protected void initLicenseListener() {
        this.fLicenseListener = new LicenseAdapter();
    }

    protected void initLicenseHost() {
        ProtectionLauncherConfig config = this.getLauncherConfig();
        this.fLicenseHost = this.createLicenseHost();
        this.fLicenseHost.setLicenseAcceptanceDelegate(this.createLicenseAcceptanceDelegate());
        this.fLicenseHost.setLicenseTextCommercial(!StringUtils.noValue(config.getLicenseTextCommercialRes()) ? LicenseHost.loadText(this.getClass(), config.getLicenseTextCommercialRes()) : config.getLicenseTextCommercial());
        this.fLicenseHost.setLicenseTextEvaluation(!StringUtils.noValue(config.getLicenseTextEvaluationRes()) ? LicenseHost.loadText(this.getClass(), config.getLicenseTextEvaluationRes()) : config.getLicenseTextEvaluation());
        this.fLicenseHost.setIssueResolver(this.createLicenseHostIssueResolver());
        this.fLicenseHost.setLicenseAcceptanceDelegate(this.createLicenseAcceptanceDelegate());
        this.fLicenseHost.setAllowFlexibleExpirationDate(config.isAllowFlexibleExpirationDate());
        if (config.isProfessional()) {
            LicenseHostPro licenseHostPro = (LicenseHostPro)this.fLicenseHost;
            licenseHostPro.setActivationLockOptions(config.getActivationLockOptions());
            licenseHostPro.setUseStrippedActivationKeyChars(config.isUseStrippedActivationKeyChars());
            licenseHostPro.setCheckPreviousShutdownDate(config.isCheckPreviousShutdownDate());
            licenseHostPro.getLicensingServiceSupport().setPreferences(this.getPreferences());
        }
    }

    protected LicenseHostIssueResolver createLicenseHostIssueResolver() {
        return null;
    }

    protected LicenseAcceptanceDelegate createLicenseAcceptanceDelegate() {
        return new SimpleLicenseAcceptanceDelegate();
    }

    protected LicenseHost createLicenseHost() {
        return HeadlessProtectionFactory.createLicenseHost(this.fLicenseReader, this.fLicenseListener);
    }

    public void init() {
        ProtectionLauncherConfig config = this.getLauncherConfig();
        this.initProfessional(config);
        this.initLicenseReader();
        this.initLicenseListener();
        this.initLicenseHost();
        this.initSecretStorages();
        this.initLicensingFacades();
        this.initLicensingServerConnections();
        this.setVerbose(config.isVerbose());
    }

    protected void initProfessional(ProtectionLauncherConfig config) {
        if (config.isProfessional()) {
            HeadlessProtectionFactory.initProfessional();
        }
    }

    protected void initSecretStorages() {
        SecretStorage.Provider[] providers = this.getLauncherConfig().getSecretStorageProviders();
        for (int i = 0; providers != null && i < providers.length; ++i) {
            this.fLicenseHost.addSecretStorage(providers[i].create());
        }
    }

    protected void initLicensingFacades() {
        FacadeConnectionConfig[] configs = this.getLauncherConfig().getFacadeConnectionConfigs();
        for (int i = 0; configs != null && i < configs.length; ++i) {
            LicensingFacadeProvider.addProvider(configs[i].getID(), configs[i].createProvider());
        }
    }

    protected void initLicensingServerConnections() {
        LicensingServerConnectionConfig[] configs = this.getLauncherConfig().getLicensingServerConnectionConfigs();
        for (int i = 0; configs != null && i < configs.length; ++i) {
            LicensingServiceProviderFactory.getInstance().registerProvider(configs[i].getName(), configs[i].getProviderClass(), configs[i].getAddress(), configs[i].getLogin(), configs[i].getPassword(), configs[i].isDefault());
        }
    }

    public boolean checkLicense(boolean aForceLicenseRead) {
        ProductInfo productInfo = this.getProductInfo();
        this.fLicenseHost.checkLicense(productInfo.getID(), productInfo.getMajorVersion(), productInfo.getMinorVersion(), aForceLicenseRead);
        License license = this.fLicenseHost.getLicense();
        return license != null && license.getLicenseState() == 2;
    }

    public boolean checkLicense() {
        return this.checkLicense(false);
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean aVerbose) {
        if (this.fVerbose != aVerbose) {
            this.fVerbose = aVerbose;
            if (this.fLicenseListener instanceof LicenseAdapter) {
                ((LicenseAdapter)this.fLicenseListener).setVerbose(this.fVerbose);
            }
            this.fLicenseReader.setVerbose(this.fVerbose);
            this.fLicenseHost.setVerbose(this.fVerbose);
        }
    }

    public static HeadlessProtectionLauncher getHeadlessProtectionLauncher(ProtectionLauncherConfigReader aReader, Class aBaseCLass, String aLauncherConfigResourceName, LicenseReader aLicenseReader) throws IOException {
        HeadlessProtectionLauncher result = new HeadlessProtectionLauncher(aReader.read(aBaseCLass, aLauncherConfigResourceName), aLicenseReader);
        result.init();
        return result;
    }

    public static HeadlessProtectionLauncher getHeadlessProtectionLauncher(ProtectionLauncherConfigReader aReader, Class aBaseCLass, String aLauncherConfigResourceName) throws IOException {
        return HeadlessProtectionLauncher.getHeadlessProtectionLauncher(aReader, aBaseCLass, aLauncherConfigResourceName, null);
    }

    public void replaceDefaultLicenseListener(LicenseListener aLicenseListener) {
        if (this.fLicenseListener != null) {
            this.fLicenseReader.removeLicenseReaderListener(this.fLicenseListener);
            this.fLicenseHost.removeLicenseHostListener(this.fLicenseListener);
        }
        this.fLicenseListener = aLicenseListener;
        if (this.fLicenseListener != null) {
            this.fLicenseReader.addLicenseReaderListener(this.fLicenseListener);
            this.fLicenseHost.addLicenseHostListener(this.fLicenseListener);
            if (this.fLicenseListener instanceof LicenseAdapter) {
                ((LicenseAdapter)this.fLicenseListener).setVerbose(this.isVerbose());
            }
        }
    }

    protected Preferences getPreferences() {
        String name = this.getProductInfo().getShortName();
        if (name == null) {
            name = this.getProductInfo().getName();
        }
        Preferences prefs = Preferences.userRoot().node(name);
        return prefs;
    }
}

