/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.launch;

import com.jp.protection.pub.launch.FacadeConnectionConfigLocal;
import com.jp.protection.pub.launch.FacadeConnectionConfigWS;
import com.jp.protection.pub.pro.integration.LicensingFacadeProvider;
import dev.crypto.PasswordCipher;
import dev.util.HashedList;
import dev.util.HashedListStrategy;
import dev.util.StringConverter;
import dev.util.StringUtils;
import dev.util.collections.HashedBoundList;
import dev.util.prefs.IndexedPreferencesSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;

public abstract class FacadeConnectionConfig
implements Serializable,
Cloneable {
    public static final long serialVersionUID = 1L;
    protected String fName;
    protected String fURL;
    protected String fLogin;
    protected String fPassword;
    protected boolean fDefault = false;
    public static final String PROPERTY_ID = "ID";
    public static final String PROPERTY_URL = "URL";
    public static final String PROPERTY_LOGIN = "login";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String PROPERTY_DEFAULT = "default";
    public static final String INDEX_NAME = "facadeConfigs";
    private static final PasswordCipher fPasswordCipher = new PasswordCipher("G9!jQmP6aR<$uF'lcyD~71JnMd8xZ");

    public FacadeConnectionConfig(String aName, String aURL, String aLogin, String aPassword) {
        this.fName = aName;
        this.fURL = aURL;
        this.fLogin = aLogin;
        this.fPassword = aPassword;
    }

    public FacadeConnectionConfig() {
    }

    public String toString() {
        return this.fName;
    }

    public String getLogin() {
        return this.fLogin;
    }

    public void setLogin(String aLogin) {
        this.fLogin = aLogin;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public void setPassword(String aPassword) {
        this.fPassword = aPassword;
    }

    public String getURL() {
        return this.fURL;
    }

    public void setURL(String aURL) {
        this.fURL = aURL;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String aName) {
        this.fName = aName;
    }

    public boolean isDefault() {
        return this.fDefault;
    }

    public void setDefault(boolean aDefault) {
        this.fDefault = aDefault;
    }

    public static void toPreferences(Preferences aPreferences, List aConfigs) {
        IndexedPreferencesSupport support = new IndexedPreferencesSupport(aPreferences);
        support.setIndexName(INDEX_NAME);
        support.setItemCount(aConfigs.size());
        int index = 0;
        Iterator configs = aConfigs.iterator();
        while (configs.hasNext()) {
            support.setIndex(index++);
            FacadeConnectionConfig config = (FacadeConnectionConfig)configs.next();
            support.setProperty(PROPERTY_ID, config.getID());
            support.setProperty(PROPERTY_URL, config.getURL());
            support.setProperty(PROPERTY_LOGIN, config.getLogin());
            support.setProperty(PROPERTY_PASSWORD, StringUtils.noValue(config.getPassword()) ? "" : StringConverter.toString(fPasswordCipher.encrypt(config.getPassword().getBytes())));
            support.setProperty(PROPERTY_DEFAULT, config.isDefault() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        }
    }

    public static boolean isSavedInPreferences(Preferences aPreferences) {
        IndexedPreferencesSupport support = new IndexedPreferencesSupport(aPreferences);
        support.setIndexName(INDEX_NAME);
        return support.getItemCount() > -1;
    }

    public static List fromPreferences(Preferences aPreferences) {
        ArrayList<FacadeConnectionConfig> result = new ArrayList<FacadeConnectionConfig>();
        IndexedPreferencesSupport support = new IndexedPreferencesSupport(aPreferences);
        support.setIndexName(INDEX_NAME);
        int itemCount = support.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            Provider provider;
            support.setIndex(i);
            String id = support.getProperty(PROPERTY_ID, null);
            if (id == null || (provider = ProviderRegistry.get(id)) == null) continue;
            String password = support.getProperty(PROPERTY_PASSWORD, null);
            password = StringUtils.noValue(password) ? null : new String(fPasswordCipher.decrypt(StringConverter.toBytes(password)));
            FacadeConnectionConfig config = provider.create(support.getProperty(PROPERTY_URL, null), support.getProperty(PROPERTY_LOGIN, null), password);
            config.setDefault(support.getProperty(PROPERTY_DEFAULT, Boolean.FALSE.toString()).equals(Boolean.TRUE.toString()));
            result.add(config);
        }
        return result;
    }

    public abstract String getInstantiationStr();

    public abstract LicensingFacadeProvider createProvider();

    public abstract String getID();

    public abstract String getSampleURL();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public static interface Provider {
        public String getName();

        public String getID();

        public FacadeConnectionConfig create(String var1, String var2, String var3);
    }

    public static class ProviderRegistry {
        protected static HashedList fRegistry = new HashedBoundList(new ArrayList(), new HashedListStrategy(){

            public Object getKeyForObject(Object anObject) {
                return ((Provider)anObject).getID();
            }
        });

        public static void add(Provider aProvider) {
            fRegistry.add(aProvider);
        }

        public static void remove(Provider aProvider) {
            fRegistry.remove(aProvider);
        }

        public static Provider get(String anID) {
            return (Provider)fRegistry.get(anID);
        }

        public static Collection getAll() {
            return fRegistry;
        }

        static {
            ProviderRegistry.add(new FacadeConnectionConfigWS.Provider());
            ProviderRegistry.add(new FacadeConnectionConfigLocal.Provider());
        }
    }
}

