/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub;

import dev.util.HashedListStrategy;
import dev.util.StringUtils;
import dev.util.collections.ContainerAdapter;
import dev.util.collections.HashedBoundList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class ProductInfo
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_SHORT_NAME = "shortName";
    public static final String PROPERTY_ID = "ID";
    public static final String PROPERTY_MAJOR_VERSION = "majorVersion";
    public static final String PROPERTY_MINOR_VERSION = "minorVersion";
    public static final String PROPERTY_EDITION = "edition";
    public static final String PROPERTY_EDITION_NAME = "editionName";
    public static final String PROPERTY_COMPANY = "company";
    public static final String PROPERTY_COPYRIGHT = "copyright";
    public static final String PROPERTY_SITE_TEXT = "siteText";
    public static final String PROPERTY_SITE_URL = "siteURL";
    public static final String PROPERTY_SITE_TOOLTIP_TEXT = "siteTooltipText";
    public static final String PROPERTY_FEEDBACK_TEXT = "feedbackText";
    public static final String PROPERTY_FEEDBACK_URL = "feedbackURL";
    public static final String PROPERTY_FEEDBACK_TOOLTIP_TEXT = "feedbackTooltipText";
    public static final String PRODUCT_INFO_LINK_ID_SITE = "site";
    public static final String PRODUCT_INFO_LINK_ID_FEEDBACK = "feedback";
    public static final String PRODUCT_INFO_LINK_ID_SUPPORT = "support";
    public static final String PRODUCT_INFO_LINK_ID_SALES = "sales";
    public static final String PRODUCT_INFO_LINK_ID_BUY_ONLINE = "buyOnline";
    public static final String PRODUCT_INFO_LINK_ID_ACTIVATE = "activate";
    public static final String PRODUCT_INFO_LINK_ID_DEACTIVATE = "deactivate";
    protected String fID;
    protected String fName;
    protected String fShortName;
    protected int fMajorVersion = 1;
    protected int fMinorVersion = 0;
    protected String fEdition;
    protected String fEditionName;
    protected String fCompany;
    protected String fCopyright;
    protected HashedBoundList fProductInfoLinks = new HashedBoundList(new ArrayList(), new HashedListStrategy(){
        public static final long serialVersionUID = 1L;

        public Object getKeyForObject(Object anObject) {
            return ((ProductInfoLink)anObject).getID();
        }
    }, new ContainerAdapter(){

        public void elementAdded(Object anElement, Object aSource) {
            ((ProductInfoLink)anElement).setProductInfo(ProductInfo.this);
        }

        public void elementRemoved(Object anElement, Object aSource) {
            ((ProductInfoLink)anElement).setProductInfo(null);
        }
    });
    private transient Vector fPropertyChangeListeners;
    protected HashMap fProductEditionMap;

    public HashedBoundList getProductInfoLinks() {
        return this.fProductInfoLinks;
    }

    public ProductInfoLink getProductInfoLink(int anIndex) {
        return (ProductInfoLink)this.fProductInfoLinks.get(anIndex);
    }

    public ProductInfoLink getProductInfoLink(String anID) {
        return (ProductInfoLink)this.fProductInfoLinks.get(anID);
    }

    public String getEdition() {
        return this.fEdition;
    }

    public void setEdition(String aEdition) {
        this.fEdition = aEdition;
    }

    public String getEditionName() {
        return this.fEditionName;
    }

    public void setEditionName(String aEditionName) {
        this.fEditionName = aEditionName;
    }

    public int getMajorVersion() {
        return this.fMajorVersion;
    }

    public void setMajorVersion(int aMajorVersion) {
        this.fMajorVersion = aMajorVersion;
    }

    public int getMinorVersion() {
        return this.fMinorVersion;
    }

    public void setMinorVersion(int aMinorVersion) {
        this.fMinorVersion = aMinorVersion;
    }

    public String getID() {
        return this.fID;
    }

    public void setID(String aID) {
        this.fID = aID;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String aName) {
        String oldValue = this.fName;
        this.fName = aName;
        if (!StringUtils.equals(oldValue, this.fName)) {
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_NAME, oldValue, this.fName));
        }
    }

    public void setShortName(String aShortName) {
        String oldValue = this.fShortName;
        this.fShortName = aShortName;
        if (!StringUtils.equals(oldValue, this.fShortName)) {
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_SHORT_NAME, oldValue, this.fShortName));
        }
    }

    public String getShortName() {
        return this.fShortName;
    }

    public String getFeedbackText() {
        ProductInfoLink linkInfo = this.getProductInfoLink(PRODUCT_INFO_LINK_ID_FEEDBACK);
        return linkInfo != null ? linkInfo.getText() : null;
    }

    public String getFeedbackTooltipText() {
        ProductInfoLink linkInfo = this.getProductInfoLink(PRODUCT_INFO_LINK_ID_FEEDBACK);
        return linkInfo != null ? linkInfo.getTooltip() : null;
    }

    public String getFeedbackURL() {
        ProductInfoLink linkInfo = this.getProductInfoLink(PRODUCT_INFO_LINK_ID_FEEDBACK);
        return linkInfo != null ? linkInfo.getURL() : null;
    }

    public String getCompany() {
        return this.fCompany;
    }

    public void setCompany(String aCompany) {
        String oldValue = this.fCompany;
        this.fCompany = aCompany;
        if (!StringUtils.equals(oldValue, this.fCompany)) {
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_COMPANY, oldValue, this.fCompany));
        }
    }

    public String getCopyright() {
        return this.fCopyright;
    }

    public void setCopyright(String aCopyright) {
        String oldValue = this.fCopyright;
        this.fCopyright = aCopyright;
        if (!StringUtils.equals(oldValue, this.fCopyright)) {
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_COPYRIGHT, oldValue, this.fCopyright));
        }
    }

    public String getSiteText() {
        ProductInfoLink linkInfo = this.getProductInfoLink(PRODUCT_INFO_LINK_ID_SITE);
        return linkInfo != null ? linkInfo.getText() : null;
    }

    public String getSiteTooltipText() {
        ProductInfoLink linkInfo = this.getProductInfoLink(PRODUCT_INFO_LINK_ID_SITE);
        return linkInfo != null ? linkInfo.getTooltip() : null;
    }

    public String getSiteURL() {
        ProductInfoLink linkInfo = this.getProductInfoLink(PRODUCT_INFO_LINK_ID_SITE);
        return linkInfo != null ? linkInfo.getURL() : null;
    }

    public String getSiteURLDomain() {
        return ProductInfo.getDomain(this.getSiteURL());
    }

    public static String getDomain(String anUrl) {
        String result = null;
        if (anUrl != null) {
            try {
                URL url = new URL(anUrl);
                result = url.getHost();
                String[] parts = result.split("\\.");
                if (parts.length > 1) {
                    result = parts[parts.length - 2] + "." + parts[parts.length - 1];
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return result;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.fPropertyChangeListeners != null && this.fPropertyChangeListeners.contains(l)) {
            Vector v = (Vector)this.fPropertyChangeListeners.clone();
            v.removeElement(l);
            this.fPropertyChangeListeners = v;
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        Vector v;
        Vector vector = v = this.fPropertyChangeListeners == null ? new Vector(2) : (Vector)this.fPropertyChangeListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.fPropertyChangeListeners = v;
        }
    }

    protected void firePropertyChange(PropertyChangeEvent e) {
        if (this.fPropertyChangeListeners != null) {
            Vector listeners = this.fPropertyChangeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((PropertyChangeListener)listeners.elementAt(i)).propertyChange(e);
            }
        }
    }

    public HashMap getProductEditionMap() {
        if (this.fProductEditionMap == null) {
            this.fProductEditionMap = new HashMap();
        }
        return this.fProductEditionMap;
    }

    public String getProductEditionName(String aProductEditionID) {
        String result = (String)this.getProductEditionMap().get(aProductEditionID);
        return result != null ? result : aProductEditionID;
    }

    public void addProductEditionName(String aProductEditionID, String aProductEditionName) {
        this.getProductEditionMap().put(aProductEditionID, aProductEditionName);
    }

    public void removeProductEditionName(String aProductEditionID) {
        this.getProductEditionMap().remove(aProductEditionID);
    }

    public static class ProductInfoLink
    implements Serializable {
        public static final long serialVersionUID = 1L;
        public static final String PROPERTY_ID = "ID";
        public static final String PROPERTY_TEXT = "Text";
        public static final String PROPERTY_URL = "URL";
        public static final String PROPERTY_TOOLTIP = "Tooltip";
        protected String fID;
        protected String fText;
        protected String fURL;
        protected String fTooltip;
        protected ProductInfo fProductInfo;

        public ProductInfoLink() {
        }

        public ProductInfoLink(String aID) {
            this.fID = aID;
        }

        public ProductInfoLink(String aID, String aText, String aURL, String aTooltip) {
            this.fID = aID;
            this.fText = aText;
            this.fURL = aURL;
            this.fTooltip = aTooltip;
        }

        public String getID() {
            return this.fID;
        }

        public void setID(String aID) {
            this.fID = aID;
        }

        public String getText() {
            return this.fText;
        }

        public void setText(String aText) {
            if (this.fText != aText) {
                String oldValue = this.fText;
                this.fText = aText;
                if (this.fProductInfo != null) {
                    this.fProductInfo.firePropertyChange(new PropertyChangeEvent(this.fProductInfo, this.fID + PROPERTY_TEXT, oldValue, this.fText));
                }
            }
        }

        public String getTooltip() {
            return this.fTooltip;
        }

        public void setTooltip(String aTooltip) {
            if (this.fTooltip != aTooltip) {
                String oldValue = this.fTooltip;
                this.fTooltip = aTooltip;
                if (this.fProductInfo != null) {
                    this.fProductInfo.firePropertyChange(new PropertyChangeEvent(this.fProductInfo, this.fID + PROPERTY_TOOLTIP, oldValue, this.fTooltip));
                }
            }
        }

        public String getURL() {
            return this.fURL;
        }

        public void setURL(String aURL) {
            if (this.fURL != aURL) {
                String oldValue = this.fURL;
                this.fURL = aURL;
                if (this.fProductInfo != null) {
                    this.fProductInfo.firePropertyChange(new PropertyChangeEvent(this.fProductInfo, this.fID + PROPERTY_URL, oldValue, this.fURL));
                }
            }
        }

        public void update(ProductInfoLink aProductInfoLink) {
            aProductInfoLink.setText(this.fText);
            aProductInfoLink.setURL(this.fURL);
            aProductInfoLink.setTooltip(this.fTooltip);
        }

        public ProductInfo getProductInfo() {
            return this.fProductInfo;
        }

        public void setProductInfo(ProductInfo aProductInfo) {
            this.fProductInfo = aProductInfo;
        }
    }
}

