/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub;

import com.jp.protection.pub.SecretStorage;
import dev.util.prefs.PreferencesUtil;
import java.text.MessageFormat;
import java.util.prefs.Preferences;

public class PreferencesSecretStorage
implements SecretStorage {
    private Preferences preferences;
    private final boolean skipEncryption;
    protected boolean fVerbose = false;

    public PreferencesSecretStorage(String aNodeName, boolean isUserPreferences, boolean skipEncryption) {
        this(PreferencesUtil.getNode(isUserPreferences ? Preferences.userRoot() : Preferences.systemRoot(), aNodeName), skipEncryption);
    }

    public PreferencesSecretStorage(String aNodeName, boolean isUserPreferences) {
        this(aNodeName, isUserPreferences, false);
    }

    public PreferencesSecretStorage(Preferences preferences) {
        this(preferences, false);
    }

    public PreferencesSecretStorage(Preferences preferences, boolean skipEncryption) {
        this.setPreferences(preferences);
        this.skipEncryption = skipEncryption;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        if (key == null) {
            return null;
        }
        String value = this.preferences.get(this.encrypt(key), defaultValue);
        if (value != null && !value.equals(defaultValue)) {
            value = this.decrypt(value);
        }
        return value;
    }

    public Object setProperty(String key, String value) {
        if (key == null) {
            return null;
        }
        String old = this.getProperty(key);
        if (value != null) {
            this.preferences.put(this.encrypt(key), this.encrypt(value));
        } else {
            this.preferences.remove(this.encrypt(key));
        }
        return old;
    }

    public void load() {
        try {
            this.preferences.sync();
        }
        catch (Exception ex) {
            this.error(ex);
        }
    }

    public void save() {
        try {
            this.preferences.flush();
        }
        catch (Exception ex) {
            this.error(ex);
        }
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences argument should be specified");
        }
        this.preferences = preferences;
    }

    public boolean isSkipEncryption() {
        return this.skipEncryption;
    }

    private String encrypt(String string) {
        if (this.isSkipEncryption()) {
            return string;
        }
        char[] chars = string.toCharArray();
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            chars[i] = ~chars[i];
        }
        return new String(chars);
    }

    private String decrypt(String string) {
        if (this.isSkipEncryption()) {
            return string;
        }
        char[] chars = string.toCharArray();
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            chars[i] = ~chars[i];
        }
        return new String(chars);
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean aVerbose) {
        this.fVerbose = aVerbose;
    }

    protected void error(Throwable ex) {
        if (this.isVerbose()) {
            ex.printStackTrace();
        }
    }

    public static class Provider
    implements SecretStorage.Provider {
        public static final long serialVersionUID = 1L;
        protected boolean fUserPreferences = true;
        protected String fNodeName;
        private static final MessageFormat INSTANTIATION_FORMAT = new MessageFormat("new PreferencesSecretStorage.Provider(\"{0}\", {1})");
        public static final String TYPE = "Preferences";

        public Provider() {
        }

        public Provider(String aNodeName, boolean aUserPreferences) {
            this.fNodeName = aNodeName;
            this.fUserPreferences = aUserPreferences;
        }

        public String getInstantiationStr() {
            return INSTANTIATION_FORMAT.format(new Object[]{this.fNodeName, this.fUserPreferences ? Boolean.TRUE : Boolean.FALSE});
        }

        public String getNodeName() {
            return this.fNodeName;
        }

        public void setNodeName(String aNodeName) {
            this.fNodeName = aNodeName;
        }

        public boolean isUserPreferences() {
            return this.fUserPreferences;
        }

        public void setUserPreferences(boolean aUserPreferences) {
            this.fUserPreferences = aUserPreferences;
        }

        public SecretStorage create() {
            return new PreferencesSecretStorage(this.getNodeName(), this.isUserPreferences());
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage());
            }
        }

        public String toString() {
            return (this.isUserPreferences() ? "<USER>" : "<SYSTEM>") + this.getNodeName();
        }

        public String getType() {
            return TYPE;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Provider)) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }
    }
}

