/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseImpl;
import com.jp.protection.pub.LicenseOutdatedException;
import com.jp.protection.pub.LicenseReaderIssueResolver;
import com.jp.protection.pub.LicenseReaderListener;
import com.jp.protection.security.SecurityProvider;
import com.jp.protection.security.SecurityProviderFactory;
import com.jp.protection.utils.CustomCRC32;
import com.jp.protection.utils.LicenseUtils;
import dev.util.StreamUtil;
import dev.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.Properties;
import java.util.Vector;

public class LicenseReader {
    private transient Vector fLicenseReaderListeners;
    protected License fLicense;
    protected String fLicenseFileName = "license.key";
    protected boolean fUserHomeRelative = true;
    protected String fLicenseFolder = "";
    protected String fLicenseResourceFolder = "";
    protected boolean fLicenseRead = false;
    protected boolean fVerbose = false;
    protected boolean fSkipEncryption = false;
    protected byte[] fDecryptKeyBytes;
    protected LicenseReaderIssueResolver fLicenseReaderIssueResolver;
    protected boolean fSearchLicenseInFile = true;
    protected SecurityProvider fSecurityProvider;
    protected String fSecurityAlgorithm = "RSA";
    protected Class fClassForLoadLicenseResource;
    static /* synthetic */ Class class$com$jp$protection$pub$LicenseReader;

    public String getLicenseResourceFolder() {
        return this.fLicenseResourceFolder;
    }

    public void setLicenseResourceFolder(String aLicenseResourceFolder) {
        this.fLicenseResourceFolder = aLicenseResourceFolder;
    }

    public byte[] getDecryptKeyBytes() {
        return this.fDecryptKeyBytes;
    }

    public void setDecryptKeyBytes(byte[] aDecryptKeyBytes) {
        this.fDecryptKeyBytes = aDecryptKeyBytes;
    }

    public void setDecryptKeyBytes(String aDecryptKeyBytes) {
        String[] bytes = aDecryptKeyBytes.split(",");
        this.fDecryptKeyBytes = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            this.fDecryptKeyBytes[i] = Byte.parseByte(bytes[i].trim());
        }
    }

    public byte[] getPrivateKeyBytes() {
        return this.getDecryptKeyBytes();
    }

    public void setPrivateKeyBytes(byte[] aPrivateKeyBytes) {
        this.setDecryptKeyBytes(aPrivateKeyBytes);
    }

    public void setPrivateKeyBytes(String aPrivateKeyBytes) {
        this.setDecryptKeyBytes(aPrivateKeyBytes);
    }

    public boolean isLicenseRead() {
        return this.fLicenseRead;
    }

    public boolean isSkipEncryption() {
        return this.fSkipEncryption;
    }

    public void setSkipEncryption(boolean aSkipEncryption) {
        this.fSkipEncryption = aSkipEncryption;
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean aVerbose) {
        this.fVerbose = aVerbose;
    }

    protected void error(String aMessage) {
        if (this.isVerbose()) {
            System.err.println(aMessage);
        }
    }

    protected void error(Throwable ex) {
        if (this.isVerbose()) {
            ex.printStackTrace();
        }
    }

    public boolean isUserHomeRelative() {
        return this.fUserHomeRelative;
    }

    public void setUserHomeRelative(boolean aUserHomeRelative) {
        this.fUserHomeRelative = aUserHomeRelative;
    }

    public String getLicenseFileName() {
        return this.fLicenseFileName;
    }

    public void setLicenseFileName(String aLicenseFileName) {
        this.fLicenseFileName = aLicenseFileName;
    }

    public String getLicenseFolder() {
        return this.fLicenseFolder;
    }

    public void setLicenseFolder(String aLicenseFolder) {
        this.fLicenseFolder = aLicenseFolder;
    }

    public License getLicense() {
        return this.getLicense(false);
    }

    public License getLicense(boolean aForceRead) {
        if (!this.isLicenseRead() || aForceRead) {
            this.readLicense();
        }
        return this.fLicense;
    }

    protected synchronized void readLicense() {
        block7: {
            this.fLicenseRead = true;
            this.fLicense = null;
            try {
                InputStream licenseInputStream = this.getLicenseInputStream();
                while (true) {
                    try {
                        do {
                            if (licenseInputStream != null) continue;
                            if (this.fLicenseReaderIssueResolver != null && this.fLicenseReaderIssueResolver.resolveLicenseMissing(this)) {
                                licenseInputStream = this.getLicenseFileInputStream();
                                continue;
                            }
                            this.fireLicenseMissing(this, this.getLicenseFileLocation());
                            break block7;
                        } while (licenseInputStream == null);
                        this.readLicense(licenseInputStream, licenseInputStream instanceof FileInputStream ? this.getLicenseFileLocation() : this.getLicenseResourceLocation());
                    }
                    catch (LicenseOutdatedException ex) {
                        licenseInputStream = this.getLicenseFileInputStream();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ex) {
                this.error(ex);
            }
        }
    }

    public boolean isSearchLicenseInFile() {
        return this.fSearchLicenseInFile;
    }

    public void setSearchLicenseInFile(boolean aSearchLicenseInFile) {
        this.fSearchLicenseInFile = aSearchLicenseInFile;
    }

    public InputStream getLicenseInputStream() {
        InputStream licenseInputStream;
        InputStream inputStream = licenseInputStream = this.fSearchLicenseInFile ? this.getLicenseFileInputStream() : this.getLicenseResourceInputStream();
        if (licenseInputStream == null) {
            licenseInputStream = this.fSearchLicenseInFile ? this.getLicenseResourceInputStream() : this.getLicenseFileInputStream();
        }
        return licenseInputStream;
    }

    public OutputStream getLicenseOutputStream() {
        this.checkLicenseFile();
        FileOutputStream result = null;
        if (this.fLicenseFolder != null) {
            try {
                File licenseFile = this.getLicenseFile();
                if (licenseFile.getParentFile() != null && !licenseFile.getParentFile().exists()) {
                    licenseFile.getParentFile().mkdirs();
                }
                if (!licenseFile.exists() || licenseFile.canWrite()) {
                    result = new FileOutputStream(licenseFile);
                }
            }
            catch (FileNotFoundException ex) {
                this.error(ex);
            }
        }
        return result;
    }

    private void checkLicenseFile() throws IllegalStateException {
        if (this.fLicenseFileName == null) {
            throw new IllegalStateException("License file name is not specified");
        }
        if (this.fLicenseFolder == null && this.fLicenseResourceFolder == null) {
            throw new IllegalStateException("License location is not specified");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void readLicense(InputStream aLicenseInputStream, String aLicenseLocation) throws IOException {
        this.fLicenseRead = true;
        this.fLicense = null;
        byte[] licenseBytes = null;
        try {
            licenseBytes = this.smartGetLicenseBytes(aLicenseInputStream);
        }
        finally {
            aLicenseInputStream.close();
        }
        if (licenseBytes == null) {
            this.fireLicenseCorrupted(this, aLicenseLocation);
        } else if ((licenseBytes = this.smartDecodeLicense(licenseBytes)) == null) {
            this.fireLicenseCorrupted(this, aLicenseLocation);
        } else {
            this.smartReadLicense(licenseBytes);
            if (this.fLicense != null) {
                ((LicenseImpl)this.fLicense).setLicenseLocation(aLicenseLocation);
                this.fireLicenseAvailable(this, aLicenseLocation);
            } else {
                this.fireLicenseCorrupted(this, aLicenseLocation);
            }
        }
    }

    protected byte[] smartDecodeLicense(byte[] aLicenseBytes) {
        byte[] result = this.decodeLicense(aLicenseBytes);
        if (result == null && this.fLicenseReaderIssueResolver != null && this.fLicenseReaderIssueResolver.resolveLicenseCorrupted(this)) {
            throw new LicenseOutdatedException();
        }
        return result;
    }

    protected byte[] decodeLicense(byte[] aLicenseBytes) {
        byte[] result = aLicenseBytes;
        if (!this.isSkipEncryption()) {
            try {
                SecurityProvider securityProvider = this.getSecurityProvider();
                PublicKey publicKey = securityProvider.getPublicKey(this.fDecryptKeyBytes);
                result = securityProvider.decode(aLicenseBytes, publicKey);
            }
            catch (Exception ex) {
                result = null;
                this.error(ex);
            }
        }
        return result;
    }

    public String getSecurityAlgorithm() {
        return this.fSecurityAlgorithm;
    }

    public void setSecurityAlgorithm(String aSecurityAlgorithm) {
        if (aSecurityAlgorithm == null) {
            throw new IllegalArgumentException("Security algorithm should be specified");
        }
        this.fSecurityAlgorithm = aSecurityAlgorithm;
        this.fSecurityProvider = null;
    }

    protected SecurityProvider getSecurityProvider() {
        if (this.fSecurityProvider == null) {
            this.fSecurityProvider = SecurityProviderFactory.getSecurityProvider(this.fSecurityAlgorithm);
        }
        return this.fSecurityProvider;
    }

    protected void smartReadLicense(byte[] aLicenseBytes) {
        this.readLicense(aLicenseBytes);
        if (this.fLicense == null && this.fLicenseReaderIssueResolver != null && this.fLicenseReaderIssueResolver.resolveLicenseCorrupted(this)) {
            throw new LicenseOutdatedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readLicense(byte[] aLicenseBytes) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(aLicenseBytes);
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                this.fLicense = new LicenseImpl();
                LicenseUtils.load(this.fLicense, properties);
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        catch (Exception ex) {
            this.fLicense = null;
            this.error(ex);
        }
    }

    public String getLicenseProduct(InputStream aLicenseInputStream) {
        String result = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(aLicenseInputStream);
            result = dataInputStream.readUTF();
        }
        catch (Exception ex) {
            this.error(ex);
        }
        return result;
    }

    protected byte[] smartGetLicenseBytes(InputStream aLicenseInputStream) {
        byte[] result = this.getLicenseBytes(aLicenseInputStream);
        if (result == null && this.fLicenseReaderIssueResolver != null && this.fLicenseReaderIssueResolver.resolveLicenseCorrupted(this)) {
            throw new LicenseOutdatedException();
        }
        return result;
    }

    protected byte[] getLicenseBytes(InputStream aLicenseInputStream) {
        byte[] result = null;
        DataInputStream dataInputStream = new DataInputStream(aLicenseInputStream);
        try {
            int bytesRead;
            String productID = dataInputStream.readUTF();
            this.fireLicenseAboutToRead(this, productID);
            long savedCRC = dataInputStream.readLong();
            int available = dataInputStream.available();
            result = new byte[available];
            int startIndex = 0;
            do {
                bytesRead = dataInputStream.read(result, startIndex, available);
                startIndex += bytesRead;
            } while (bytesRead != -1 && (available -= bytesRead) > 0);
            CustomCRC32 crc32 = new CustomCRC32();
            crc32.proceed(result);
            if (savedCRC != crc32.getCRC() && aLicenseInputStream instanceof FileInputStream) {
                result = null;
            }
        }
        catch (IOException ex) {
            this.error(ex);
            result = null;
        }
        return result;
    }

    public String getLicenseFileLocation() {
        return this.getLicenseFile().toString();
    }

    public String getLicenseResourceLocation() {
        String result = this.fLicenseFileName;
        if (!StringUtils.noValue(this.fLicenseResourceFolder)) {
            result = this.fLicenseResourceFolder.endsWith("/") ? this.fLicenseResourceFolder + result : this.fLicenseResourceFolder + "/" + result;
        }
        return result;
    }

    public InputStream getLicenseFileInputStream() {
        this.checkLicenseFile();
        FileInputStream result = null;
        if (this.fLicenseFolder != null) {
            try {
                File licenseFile = this.getLicenseFile();
                if (licenseFile.canRead()) {
                    result = new FileInputStream(licenseFile);
                }
            }
            catch (FileNotFoundException ex) {
                this.error(ex);
            }
        }
        return result;
    }

    public InputStream getLicenseResourceInputStream() {
        return (this.fClassForLoadLicenseResource != null ? this.fClassForLoadLicenseResource : (class$com$jp$protection$pub$LicenseReader == null ? (class$com$jp$protection$pub$LicenseReader = LicenseReader.class$("com.jp.protection.pub.LicenseReader")) : class$com$jp$protection$pub$LicenseReader)).getResourceAsStream(this.getLicenseResourceLocation());
    }

    public Class getClassForLoadLicenseResource() {
        return this.fClassForLoadLicenseResource;
    }

    public void setClassForLoadLicenseResource(Class aClassForLoadLicenseResource) {
        this.fClassForLoadLicenseResource = aClassForLoadLicenseResource;
    }

    public File getLicenseFile() {
        File licenseFile = null;
        licenseFile = this.isUserHomeRelative() ? new File(new File(System.getProperties().getProperty("user.home"), this.fLicenseFolder), this.fLicenseFileName) : (!StringUtils.noValue(this.fLicenseFolder) ? new File(this.fLicenseFolder, this.fLicenseFileName) : new File(this.fLicenseFileName));
        return licenseFile;
    }

    public synchronized void addLicenseReaderListener(LicenseReaderListener l) {
        Vector v;
        Vector vector = v = this.fLicenseReaderListeners == null ? new Vector(2) : (Vector)this.fLicenseReaderListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.fLicenseReaderListeners = v;
        }
    }

    public synchronized void removeLicenseReaderListener(LicenseReaderListener l) {
        if (this.fLicenseReaderListeners != null && this.fLicenseReaderListeners.contains(l)) {
            Vector v = (Vector)this.fLicenseReaderListeners.clone();
            v.removeElement(l);
            this.fLicenseReaderListeners = v;
        }
    }

    protected void fireLicenseMissing(LicenseReader e, String aLicenseLocation) {
        if (this.fLicenseReaderListeners != null) {
            Vector listeners = this.fLicenseReaderListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseReaderListener)listeners.elementAt(i)).licenseMissing(e, aLicenseLocation);
            }
        }
    }

    protected void fireLicenseCorrupted(LicenseReader e, String aLicenseLocation) {
        if (this.fLicenseReaderListeners != null) {
            Vector listeners = this.fLicenseReaderListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseReaderListener)listeners.elementAt(i)).licenseCorrupted(e, aLicenseLocation);
            }
        }
    }

    protected void fireLicenseAvailable(LicenseReader e, String aLicenseLocation) {
        if (this.fLicenseReaderListeners != null) {
            Vector listeners = this.fLicenseReaderListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseReaderListener)listeners.elementAt(i)).licenseAvailable(e, aLicenseLocation);
            }
        }
    }

    protected void fireLicenseAboutToRead(LicenseReader e, String aProductID) {
        if (this.fLicenseReaderListeners != null) {
            Vector listeners = this.fLicenseReaderListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseReaderListener)listeners.elementAt(i)).licenseAboutToRead(e, aProductID);
            }
        }
    }

    public LicenseReaderIssueResolver getIssueResolver() {
        return this.fLicenseReaderIssueResolver;
    }

    public void setIssueResolver(LicenseReaderIssueResolver aLicenseReaderIssueResolver) {
        this.fLicenseReaderIssueResolver = aLicenseReaderIssueResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getLicenseBytes() {
        byte[] result = null;
        InputStream licenseInputStream = this.getLicenseInputStream();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                StreamUtil.copy(licenseInputStream, byteArrayOutputStream);
                byteArrayOutputStream.close();
                result = byteArrayOutputStream.toByteArray();
            }
            finally {
                licenseInputStream.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

