/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseBaseImpl;
import dev.lang.BitTools;
import dev.util.StringUtils;
import java.text.DateFormat;
import java.util.Collection;
import java.util.HashMap;

public class LicenseImpl
extends LicenseBaseImpl
implements License,
Cloneable {
    public static final long serialVersionUID = 1L;
    protected int fLicenseState = 1;
    protected String fLicenseText;
    protected HashMap fProductFeaturesMap = new HashMap();
    protected String fLicenseLocation;
    protected HashMap fProperties = new HashMap();
    protected static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);
    public static final String TYPE_STR_COMMERCIAL = "Commercial";
    public static final String TYPE_STR_EVALUATION = "Evaluation";
    public static final String TYPE_STR_EXTENDED_EVALUATION = "Extended Evaluation";
    public static final String USER_LICENSING_UNKNOWN_STR = "Unknown";
    public static final String USER_LICENSING_UNCOUNTED_STR = "Uncounted";
    public static final String USER_LICENSING_FLOATING_STR = "Floating";
    public static final String USER_LICENSING_NAMED_STR = "Named";
    public static final String USER_LICENSING_FLOATING_LS_STR = "Floating - Licensing Server";
    public static final String USER_LICENSING_NAMED_LS_STR = "Named - Licensing Server";

    public String getLicenseLocation() {
        return this.fLicenseLocation;
    }

    public void setLicenseLocation(String aLicenseLocation) {
        this.fLicenseLocation = aLicenseLocation;
    }

    public void setLicenseText(String aLicenseText) {
        this.fLicenseText = aLicenseText;
    }

    public HashMap getProductFeaturesMap() {
        return this.fProductFeaturesMap;
    }

    public int getLicenseState() {
        return this.fLicenseState;
    }

    public void setLicenseState(int aLicenseState) {
        this.fLicenseState = aLicenseState;
    }

    public String getLicenseText() {
        return this.fLicenseText;
    }

    public boolean isProductFeatureInLicense(String aFeature) {
        return this.fProductFeaturesMap.containsKey(aFeature);
    }

    public void setProductFeatureSupported(String aFeature, boolean aValue) {
        this.fProductFeaturesMap.put(aFeature, new Boolean(aValue));
    }

    public Collection getProductFeatureNames() {
        return this.fProductFeaturesMap.keySet();
    }

    public boolean isProductFeatureSupported(String aFeature) {
        return this.isProductFeatureSupported(aFeature, 0);
    }

    public boolean isProductFeatureSupported(String aFeature, int anIndex) {
        if (!this.isProductFeatureInLicense(aFeature)) {
            throw new IllegalArgumentException("Feature is not stated in license: " + aFeature);
        }
        boolean result = false;
        Object value = this.fProductFeaturesMap.get(aFeature);
        if (value instanceof Boolean) {
            if (anIndex == 0 || anIndex == 1) {
                result = (Boolean)value;
            }
        } else if (value instanceof Boolean[]) {
            Boolean[] values = (Boolean[])value;
            if (anIndex >= 0 && anIndex < values.length) {
                result = values[anIndex];
            }
        }
        return result;
    }

    public void setProductFeatureSupported(String aFeature, int aCase, boolean aValue) {
        Object value = this.fProductFeaturesMap.get(aFeature);
        if (value instanceof Boolean) {
            if (aCase != 0) {
                throw new IllegalArgumentException("Illegal feature index: " + aCase);
            }
            this.fProductFeaturesMap.put(aFeature, aValue ? Boolean.TRUE : Boolean.FALSE);
        } else if (value instanceof Boolean[] || value == null) {
            if (value == null) {
                value = new Boolean[5];
                this.fProductFeaturesMap.put(aFeature, value);
            }
            Boolean[] values = (Boolean[])value;
            if (aCase >= 0 && aCase < values.length) {
                values[aCase] = aValue ? Boolean.TRUE : Boolean.FALSE;
            } else {
                throw new IllegalArgumentException("Illegal feature index: " + aCase);
            }
        }
    }

    public HashMap getProperties() {
        return this.fProperties;
    }

    public String getProperty(String aName, String aDefault) {
        String result = (String)this.fProperties.get(aName);
        return result != null ? result : aDefault;
    }

    public void putProperty(String aName, String aValue) {
        this.fProperties.put(aName, aValue);
    }

    public Collection getPropertyNames() {
        return this.fProperties.keySet();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getActivationTypeStr(int anOptions) {
        String result = "No Activation";
        if (BitTools.checkBit(anOptions, 1)) {
            result = "Activation";
        } else if (BitTools.checkBit(anOptions, 2)) {
            result = "Activation and Lock";
        }
        return result;
    }

    public static String getLicenseTypeStr(int aLicenseType) {
        String result = null;
        switch (aLicenseType) {
            case 3: {
                result = TYPE_STR_COMMERCIAL;
                break;
            }
            case 1: {
                result = TYPE_STR_EVALUATION;
                break;
            }
            case 2: {
                result = TYPE_STR_EXTENDED_EVALUATION;
            }
        }
        return result;
    }

    public static int getLicenseType(String aLicenseType) {
        int result = 1;
        if (TYPE_STR_COMMERCIAL.equals(aLicenseType)) {
            result = 3;
        } else if (TYPE_STR_EVALUATION.equals(aLicenseType)) {
            result = 1;
        }
        if (TYPE_STR_EXTENDED_EVALUATION.equals(aLicenseType)) {
            result = 2;
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("License Number: " + this.getLicenseNumber());
        result.append("\n");
        result.append("Issued:         " + DATE_FORMAT.format(this.getLicenseIssueDate()));
        result.append("\n");
        result.append("Type:           ");
        result.append(LicenseImpl.getLicenseTypeStr(this.getLicenseType()));
        result.append("\n");
        result.append("State:          ");
        switch (this.getLicenseState()) {
            case 1: {
                result.append("UNKNOWN");
                break;
            }
            case 2: {
                result.append("OK");
                break;
            }
            case 3: {
                result.append("EXPIRED");
                break;
            }
            case 4: {
                result.append("INVALID");
                break;
            }
            case 5: {
                result.append("NOT_ACTIVATED");
                break;
            }
            case 7: {
                result.append("NOT_LOCKED");
                break;
            }
            case 6: {
                result.append("LOCK_VIOLATED");
            }
        }
        return result.toString();
    }

    public int getIntProperty(String aPropertyName, int aDefault) {
        String result = this.getProperty(aPropertyName, null);
        return StringUtils.noValue(result) ? aDefault : Integer.parseInt(result);
    }

    public void putIntProperty(String aPropertyName, int aValue) {
        this.putProperty(aPropertyName, String.valueOf(aValue));
    }

    public String getLicensingServerAddress() {
        return this.getProperty("pr.lsaddr", null);
    }

    public void setLicensingServerAddress(String aValue) {
        this.putProperty("pr.lsaddr", aValue);
    }

    public int getLockGracePeriod() {
        return this.getIntProperty("pr.lgp", -1);
    }

    public void setLockGracePeriod(int aValue) {
        this.putIntProperty("pr.lgp", aValue);
    }

    public int getActivationGracePeriod() {
        return this.getIntProperty("pr.agp", -1);
    }

    public void setActivationGracePeriod(int aValue) {
        this.putIntProperty("pr.agp", aValue);
    }

    public String getActivationKey() {
        return this.getProperty("pr.ak", null);
    }

    public void setActivationKey(String anActivationKey) {
        this.putProperty("pr.ak", anActivationKey);
    }

    public String getSerialNumber() {
        return this.getProperty("pr.s/n", null);
    }

    public int getUsageGracePeriod() {
        return this.getIntProperty("pr.ugp", -1);
    }

    public int getUsageLimit() {
        return this.getIntProperty("pr.usl", -1);
    }

    public int smartGetUserLicensingModel() {
        return LicenseImpl.smartGetUserLicensingModel(this);
    }

    public static int smartGetUserLicensingModel(License aLicense) {
        int result = aLicense.getUserLicensingModel();
        if (result == 0) {
            result = BitTools.checkBit(aLicense.getLicenseOptions(), 1) || BitTools.checkBit(aLicense.getLicenseOptions(), 2) ? 3 : (BitTools.checkBit(aLicense.getLicenseOptions(), 8) ? 2 : 1);
        }
        return result;
    }

    public static String getUserLicensingModelStr(int aModel) {
        String result = USER_LICENSING_UNKNOWN_STR;
        switch (aModel) {
            case 1: {
                result = USER_LICENSING_UNCOUNTED_STR;
                break;
            }
            case 2: {
                result = USER_LICENSING_FLOATING_STR;
                break;
            }
            case 4: {
                result = USER_LICENSING_FLOATING_LS_STR;
                break;
            }
            case 3: {
                result = USER_LICENSING_NAMED_STR;
                break;
            }
            case 5: {
                result = USER_LICENSING_NAMED_LS_STR;
            }
        }
        return result;
    }
}

