/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseAcceptanceDelegate;
import com.jp.protection.pub.LicenseHostIssueResolver;
import com.jp.protection.pub.LicenseHostListener;
import com.jp.protection.pub.LicenseImpl;
import com.jp.protection.pub.LicenseOutdatedException;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.LicenseReaderListener;
import com.jp.protection.pub.SecretStorage;
import com.jp.protection.utils.LicenseUtils;
import dev.util.CalendarUtil;
import dev.util.StreamUtil;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class LicenseHost {
    protected LicenseReader fLicenseReader;
    protected List fSecretStorages = new ArrayList();
    protected LicenseAcceptanceDelegate fLicenseAcceptanceDelegate;
    protected String fLicenseTextCommercial;
    protected String fLicenseTextEvaluation;
    protected LicenseHostIssueResolver fIssueResolver;
    protected boolean fVerbose = false;
    public static final String PROPERTY_LICENSE_ACCEPTED = "licenseAccepted";
    public static final String PROPERTY_ALREADY_EXPIRED = "alreadyExpired";
    public static final String PROPERTY_PREVIOUS_EXPIRATION_DATE = "previousExpirationDate";
    public static final String PROPERTY_PREVIOUS_SHUTDOWN_DATE = "previousShutdownDate";
    public static final String LICENSE_HOST_HINT_CLEAR_PREVIOUS_SHUTDOWN_DATE = "licenseHostHint-clearPreviousShutdownDate";
    protected Vector fLicenseHostListeners;
    protected boolean fAllowFlexibleExpirationDate = false;
    protected static final String PROPERTY_FLEXIBLE_EXP_DATE_PROCESSED = "$$lpr_flex_exp_date_processed$$";
    protected static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);

    public LicenseHostIssueResolver getIssueResolver() {
        return this.fIssueResolver;
    }

    public void setIssueResolver(LicenseHostIssueResolver aIssueResolver) {
        this.fIssueResolver = aIssueResolver;
    }

    public LicenseHost() {
        this(null, null);
    }

    public LicenseHost(LicenseReader aLicenseReader) {
        this(aLicenseReader, null);
    }

    public LicenseHost(LicenseReader aLicenseReader, LicenseHostListener aLicenseHostListener) {
        this.setLicenseReader(aLicenseReader);
        if (aLicenseHostListener != null) {
            this.addLicenseHostListener(aLicenseHostListener);
        }
    }

    public String getLicenseTextCommercial() {
        return this.fLicenseTextCommercial;
    }

    public void setLicenseTextCommercial(String aLicenseTextCommercial) {
        this.fLicenseTextCommercial = aLicenseTextCommercial;
    }

    public String getLicenseTextEvaluation() {
        return this.fLicenseTextEvaluation;
    }

    public void setLicenseTextEvaluation(String aLicenseTextEvaluation) {
        this.fLicenseTextEvaluation = aLicenseTextEvaluation;
    }

    public LicenseAcceptanceDelegate getLicenseAcceptanceDelegate() {
        return this.fLicenseAcceptanceDelegate;
    }

    public void setLicenseAcceptanceDelegate(LicenseAcceptanceDelegate aLicenseAcceptanceDelegate) {
        this.fLicenseAcceptanceDelegate = aLicenseAcceptanceDelegate;
    }

    public void addSecretStorage(SecretStorage aSecretStorage) {
        this.fSecretStorages.add(aSecretStorage);
    }

    public void removeSecretStorage(SecretStorage aSecretStorage) {
        this.fSecretStorages.remove(aSecretStorage);
    }

    public List getSecretStorages() {
        return this.fSecretStorages;
    }

    public LicenseReader getLicenseReader() {
        return this.fLicenseReader;
    }

    public void setLicenseReader(LicenseReader aLicenseReader) {
        this.fLicenseReader = aLicenseReader;
    }

    public void checkLicense(String aProduct, int aProductMajorVersion, int aProductMinorVersion) {
        this.checkLicense(aProduct, aProductMajorVersion, aProductMinorVersion, false);
    }

    public synchronized void checkLicense(String aProduct, int aProductMajorVersion, int aProductMinorVersion, boolean aForceLicenseRead) {
        if (this.fLicenseReader == null) {
            throw new IllegalStateException("License reader is not specified");
        }
        boolean forceLicenseRead = aForceLicenseRead;
        while (true) {
            try {
                LicenseImpl license = (LicenseImpl)this.fLicenseReader.getLicense(forceLicenseRead);
                if (license == null) break;
                if (license.getLicenseType() == 3) {
                    this.checkCommercial(license, aProduct, aProductMajorVersion, aProductMinorVersion);
                } else {
                    this.checkEvaluation(license, aProduct, aProductMajorVersion, aProductMinorVersion);
                }
                this.fireProductFeaturesSupported(license);
            }
            catch (LicenseOutdatedException ex) {
                forceLicenseRead = true;
                continue;
            }
            catch (Throwable ex) {
                this.error(ex);
            }
            break;
        }
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean aVerbose) {
        this.fVerbose = aVerbose;
    }

    protected void error(String aMessage) {
        if (this.isVerbose()) {
            System.err.println(aMessage);
        }
    }

    protected void error(Throwable ex) {
        if (this.isVerbose()) {
            ex.printStackTrace();
        }
    }

    protected void fireProductFeaturesSupported(License aLicense) {
        Iterator iterator = aLicense.getProductFeatureNames().iterator();
        while (iterator.hasNext()) {
            String productFeature;
            this.fireFeatureChecked(this, aLicense, productFeature, aLicense.isProductFeatureSupported(productFeature = (String)iterator.next()) && aLicense.getLicenseState() == 2);
        }
    }

    private void saveSecretStorages() {
        Iterator secretStorages = this.fSecretStorages.iterator();
        while (secretStorages.hasNext()) {
            ((SecretStorage)secretStorages.next()).save();
        }
    }

    protected void setLicenseState(LicenseImpl aLicense, int aState) {
        aLicense.setLicenseState(aState);
        switch (aState) {
            case 3: {
                this.setAreadyExpired(true);
                if (this.getPreviousExpirationDate() == null) {
                    this.setPreviousExpirationDate(aLicense.getLicenseExpireDate());
                }
                this.fireLicenseExpired(this, aLicense);
                break;
            }
            case 4: {
                this.fireLicenseInvalid(this, aLicense);
                break;
            }
            case 2: {
                if ((aLicense.getLicenseType() == 1 || aLicense.getLicenseType() == 2) && this.getPreviousExpirationDate() == null) {
                    this.setPreviousExpirationDate(aLicense.getLicenseExpireDate());
                }
                this.fireLicenseOk(this, aLicense);
            }
        }
    }

    protected boolean checkProductImpl(LicenseImpl aLicense, String aProduct, int aProductMajorVersion, int aProductMinorVersion) {
        return aLicense.getProduct().equals(aProduct);
    }

    protected boolean checkProduct(LicenseImpl aLicense, String aProduct, int aProductMajorVersion, int aProductMinorVersion) {
        boolean result = this.checkProductImpl(aLicense, aProduct, aProductMajorVersion, aProductMinorVersion);
        if (!result) {
            if (this.fIssueResolver != null && this.fIssueResolver.resolveLicenseInvalid(this)) {
                throw new LicenseOutdatedException();
            }
            this.setLicenseState(aLicense, 4);
        }
        return result;
    }

    protected boolean checkProductVersionsImpl(LicenseImpl aLicense, String aProduct, int aProductMajorVersion, int aProductMinorVersion) {
        return aLicense.getProductMajorVersion() == aProductMajorVersion;
    }

    protected boolean checkProductVersions(LicenseImpl aLicense, String aProduct, int aProductMajorVersion, int aProductMinorVersion) {
        boolean result = this.checkProductVersionsImpl(aLicense, aProduct, aProductMajorVersion, aProductMinorVersion);
        if (!result) {
            if (this.fIssueResolver != null && this.fIssueResolver.resolveLicenseInvalid(this)) {
                throw new LicenseOutdatedException();
            }
            this.setLicenseState(aLicense, 4);
        }
        return result;
    }

    protected boolean checkProductFeaturesImpl(LicenseImpl aLicense, String aProduct, int aProductMajorVersion, int aProductMinorVersion) {
        return true;
    }

    protected boolean checkProductFeatures(LicenseImpl aLicense, String aProduct, int aProductMajorVersion, int aProductMinorVersion) {
        boolean result = this.checkProductFeaturesImpl(aLicense, aProduct, aProductMajorVersion, aProductMinorVersion);
        if (!result) {
            this.setLicenseState(aLicense, 4);
        }
        return result;
    }

    protected static boolean dateIn(Date aDate, Date aStart, Date aFinish) {
        return aDate.getTime() >= aStart.getTime() && aFinish.getTime() > aDate.getTime();
    }

    protected final boolean checkExpiration(LicenseImpl aLicense, String aProduct, int aProductMajorVersion, int aProductMinorVersion) {
        boolean result = this.checkExpirationImpl(aLicense, aProduct, aProductMajorVersion, aProductMinorVersion);
        if (!result) {
            if (this.fIssueResolver != null && this.fIssueResolver.resolveLicenseExpired(this)) {
                throw new LicenseOutdatedException();
            }
            this.setLicenseState(aLicense, 3);
        }
        return result;
    }

    protected boolean checkExpirationImpl(LicenseImpl aLicense, String aProduct, int aProductMajorVersion, int aProductMinorVersion) {
        boolean result = true;
        if (aLicense.getLicenseExpireDate() != null) {
            int evalDuration = CalendarUtil.getDaysDifference(aLicense.getLicenseIssueDate(), aLicense.getLicenseExpireDate());
            this.processFlexibleExpirationDate(aLicense);
            Date date = new Date();
            result = LicenseHost.dateIn(date, aLicense.getLicenseIssueDate(), aLicense.getLicenseExpireDate());
            if (result && aLicense.getLicenseType() == 1) {
                Date prevExpDate;
                boolean bl = result = !this.isAlreadyExpired();
                if (result && (prevExpDate = this.getPreviousExpirationDate()) != null) {
                    Date prevIssueDate = LicenseUtils.getLicenseIssueDate(CalendarUtil.incDay(prevExpDate, evalDuration));
                    result = LicenseHost.dateIn(date, prevIssueDate, prevExpDate);
                }
            }
        }
        return result;
    }

    protected void checkLicenseAcceptance(License aLicense) {
        boolean accepted = this.isLicenseAccepted();
        if (!accepted && this.fLicenseAcceptanceDelegate != null) {
            accepted = this.fLicenseAcceptanceDelegate.acceptLicense(this);
        }
        this.setLicenseAccepted(accepted);
    }

    protected void checkCommercial(LicenseImpl aLicense, String aProduct, int aProductMajorVersion, int aProductMinorVersion) {
        if (aLicense.getLicenseText() == null) {
            aLicense.setLicenseText(this.fLicenseTextCommercial);
        }
        this.checkLicenseAcceptance(aLicense);
        if (!this.checkProduct(aLicense, aProduct, aProductMajorVersion, aProductMinorVersion)) {
            return;
        }
        if (!this.checkProductVersions(aLicense, aProduct, aProductMajorVersion, aProductMinorVersion)) {
            return;
        }
        if (!this.checkExpiration(aLicense, aProduct, aProductMajorVersion, aProductMinorVersion)) {
            return;
        }
        if (!this.checkProductFeatures(aLicense, aProduct, aProductMajorVersion, aProductMinorVersion)) {
            return;
        }
        if (!this.checkActivation(aLicense)) {
            return;
        }
        if (!this.checkLicenseLock(aLicense)) {
            return;
        }
        this.setLicenseState(aLicense, 2);
    }

    protected boolean checkActivation(LicenseImpl aLicense) {
        return true;
    }

    protected boolean checkLicenseLock(LicenseImpl aLicense) {
        return true;
    }

    protected void checkEvaluation(LicenseImpl aLicense, String aProduct, int aProductMajorVersion, int aProductMinorVersion) {
        if (aLicense.getLicenseText() == null) {
            aLicense.setLicenseText(this.fLicenseTextEvaluation);
        }
        this.checkLicenseAcceptance(aLicense);
        if (!this.checkProduct(aLicense, aProduct, aProductMajorVersion, aProductMinorVersion)) {
            return;
        }
        if (!this.checkProductVersions(aLicense, aProduct, aProductMajorVersion, aProductMinorVersion)) {
            return;
        }
        if (aLicense.getLicenseExpireDate() != null && !this.checkExpiration(aLicense, aProduct, aProductMajorVersion, aProductMinorVersion)) {
            return;
        }
        if (!this.checkProductFeatures(aLicense, aProduct, aProductMajorVersion, aProductMinorVersion)) {
            return;
        }
        if (!this.checkActivation(aLicense)) {
            return;
        }
        if (!this.checkLicenseLock(aLicense)) {
            return;
        }
        this.setLicenseState(aLicense, 2);
    }

    public Date getLicenseExpirationDate(boolean useGracePeriod) {
        Date result = null;
        License license = this.getLicense();
        if (license.getLicenseType() == 1) {
            result = this.getPreviousExpirationDate();
        }
        if (result == null) {
            result = license.getLicenseExpireDate();
        }
        if (useGracePeriod && result != null && license.getGracePeriod() != -1) {
            result = CalendarUtil.incDay(result, -license.getGracePeriod());
        }
        return result;
    }

    protected String getPreviousExpirationDatePropertyName() {
        License license = this.getLicense();
        return license != null ? "previousExpirationDate[" + String.valueOf(license.getProductMajorVersion()) + "]" : PROPERTY_PREVIOUS_EXPIRATION_DATE;
    }

    public Date getPreviousExpirationDate() {
        return this.loadSecretStorageDateProperty(this.getPreviousExpirationDatePropertyName(), true, null, false);
    }

    protected void setPreviousExpirationDate(Date aDate) {
        this.saveSecretStorageProperty(this.getPreviousExpirationDatePropertyName(), String.valueOf(aDate.getTime()));
    }

    public Date loadSecretStorageDateProperty(String aPropertyName, boolean isEarliest, Date aDefaultValue, boolean aForceLoad) {
        Date result = null;
        Iterator secretStorages = this.fSecretStorages.iterator();
        while (secretStorages.hasNext()) {
            String property;
            SecretStorage secretStorage = (SecretStorage)secretStorages.next();
            if (aForceLoad) {
                secretStorage.load();
            }
            if ((property = secretStorage.getProperty(aPropertyName)) == null) continue;
            try {
                Date date = new Date(Long.parseLong(property));
                if (result == null) {
                    result = date;
                    continue;
                }
                if (result.getTime() < date.getTime() || !isEarliest) continue;
                result = date;
            }
            catch (NumberFormatException ex) {}
        }
        if (result == null) {
            result = aDefaultValue;
        }
        return result;
    }

    public int loadSecretStorageIntProperty(String aPropertyName, boolean isMax, long aDefaultValue, boolean aForceLoad) {
        return (int)this.loadSecretStorageLongProperty(aPropertyName, isMax, aDefaultValue, aForceLoad);
    }

    public long loadSecretStorageLongProperty(String aPropertyName, boolean isMax, long aDefaultValue, boolean aForceLoad) {
        boolean found = false;
        long result = aDefaultValue;
        Iterator secretStorages = this.fSecretStorages.iterator();
        while (secretStorages.hasNext()) {
            String property;
            SecretStorage secretStorage = (SecretStorage)secretStorages.next();
            if (aForceLoad) {
                secretStorage.load();
            }
            if ((property = secretStorage.getProperty(aPropertyName)) == null) continue;
            try {
                long intValue = Long.parseLong(property);
                if (!found) {
                    result = intValue;
                    found = true;
                    continue;
                }
                result = isMax ? Math.max(result, intValue) : Math.min(result, intValue);
            }
            catch (NumberFormatException ex) {}
        }
        return result;
    }

    public boolean loadSecretStorageBooleanProperty(String aPropertyName, boolean isOrOperation, boolean aDefaultValue, boolean aForceLoad) {
        boolean found = false;
        boolean result = aDefaultValue;
        Iterator secretStorages = this.fSecretStorages.iterator();
        while (secretStorages.hasNext()) {
            String property;
            SecretStorage secretStorage = (SecretStorage)secretStorages.next();
            if (aForceLoad) {
                secretStorage.load();
            }
            if ((property = secretStorage.getProperty(aPropertyName)) == null) continue;
            try {
                boolean booleanValue = property.equals(Boolean.TRUE.toString());
                if (!found) {
                    result = booleanValue;
                    found = true;
                    continue;
                }
                result = isOrOperation ? result || booleanValue : result && booleanValue;
            }
            catch (NumberFormatException ex) {}
        }
        return result;
    }

    public void saveSecretStorageProperty(String aPropertyName, String aValue) {
        Iterator secretStorages = this.fSecretStorages.iterator();
        while (secretStorages.hasNext()) {
            SecretStorage secretStorage = (SecretStorage)secretStorages.next();
            secretStorage.setProperty(aPropertyName, aValue);
            secretStorage.save();
        }
    }

    public String loadSecretStorageProperty(String aPropertyName, String aDefaultValue) {
        String result = aDefaultValue;
        Iterator secretStorages = this.fSecretStorages.iterator();
        while (secretStorages.hasNext()) {
            SecretStorage secretStorage = (SecretStorage)secretStorages.next();
            String value = secretStorage.getProperty(aPropertyName, null);
            if (value == null) continue;
            result = value;
            break;
        }
        return result;
    }

    protected String getAlreadyExpiredPropertyName() {
        License license = this.getLicense();
        return license != null ? "alreadyExpired[" + String.valueOf(license.getProductMajorVersion()) + "]" : PROPERTY_ALREADY_EXPIRED;
    }

    protected boolean isAlreadyExpired() {
        return this.loadSecretStorageBooleanProperty(this.getAlreadyExpiredPropertyName(), true, false, false);
    }

    protected void setAreadyExpired(boolean aValue) {
        this.saveSecretStorageProperty(this.getAlreadyExpiredPropertyName(), (aValue ? Boolean.TRUE : Boolean.FALSE).toString());
    }

    public void setLicenseAccepted(boolean aValue) {
        Iterator secretStorages = this.fSecretStorages.iterator();
        while (secretStorages.hasNext()) {
            SecretStorage secretStorage = (SecretStorage)secretStorages.next();
            secretStorage.setProperty(PROPERTY_LICENSE_ACCEPTED, new Boolean(aValue).toString());
            secretStorage.save();
        }
        this.fireLicenseAccepted(this, this.getLicense(), aValue);
    }

    public boolean isLicenseAccepted() {
        SecretStorage secretStorage;
        boolean result = false;
        Iterator secretStorages = this.fSecretStorages.iterator();
        while (secretStorages.hasNext() && !(result = (secretStorage = (SecretStorage)secretStorages.next()).getProperty(PROPERTY_LICENSE_ACCEPTED, Boolean.FALSE.toString()).equals(Boolean.TRUE.toString()))) {
        }
        return result;
    }

    public synchronized void addLicenseHostListener(LicenseHostListener l) {
        Vector v;
        Vector vector = v = this.fLicenseHostListeners == null ? new Vector(2) : (Vector)this.fLicenseHostListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.fLicenseHostListeners = v;
        }
        if (this.fLicenseReader != null && l instanceof LicenseReaderListener) {
            this.fLicenseReader.addLicenseReaderListener((LicenseReaderListener)((Object)l));
        }
    }

    public synchronized void removeLicenseHostListener(LicenseHostListener l) {
        if (this.fLicenseHostListeners != null && this.fLicenseHostListeners.contains(l)) {
            Vector v = (Vector)this.fLicenseHostListeners.clone();
            v.removeElement(l);
            this.fLicenseHostListeners = v;
        }
        if (this.fLicenseReader != null && l instanceof LicenseReaderListener) {
            this.fLicenseReader.removeLicenseReaderListener((LicenseReaderListener)((Object)l));
        }
    }

    protected void fireLicenseAccepted(LicenseHost aSource, License aLicense, boolean isAccepted) {
        if (this.fLicenseHostListeners != null) {
            Vector listeners = this.fLicenseHostListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseHostListener)listeners.elementAt(i)).licenseAccepted(aSource, aLicense, isAccepted);
            }
        }
    }

    protected void fireLicenseExpired(LicenseHost aSource, License aLicense) {
        if (this.fLicenseHostListeners != null) {
            Vector listeners = this.fLicenseHostListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseHostListener)listeners.elementAt(i)).licenseExpired(aSource, aLicense);
            }
        }
    }

    protected void fireLicenseOk(LicenseHost aSource, License aLicense) {
        if (this.fLicenseHostListeners != null) {
            Vector listeners = this.fLicenseHostListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseHostListener)listeners.elementAt(i)).licenseOk(aSource, aLicense);
            }
        }
    }

    protected void fireLicenseInvalid(LicenseHost aSource, License aLicense) {
        if (this.fLicenseHostListeners != null) {
            Vector listeners = this.fLicenseHostListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseHostListener)listeners.elementAt(i)).licenseInvalid(aSource, aLicense);
            }
        }
    }

    protected void fireFeatureChecked(LicenseHost aSource, License aLicense, String aFeature, boolean isEnabled) {
        if (this.fLicenseHostListeners != null) {
            Vector listeners = this.fLicenseHostListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseHostListener)listeners.elementAt(i)).featureChecked(aSource, aLicense, aFeature, isEnabled);
            }
        }
    }

    public License getLicense() {
        return this.fLicenseReader.getLicense();
    }

    public License getLicense(boolean aForceRead) {
        return this.fLicenseReader.getLicense(aForceRead);
    }

    public boolean isAllowFlexibleExpirationDate() {
        return this.fAllowFlexibleExpirationDate;
    }

    public void setAllowFlexibleExpirationDate(boolean anAllowFlexibleExpirationDate) {
        this.fAllowFlexibleExpirationDate = anAllowFlexibleExpirationDate;
    }

    protected boolean isFlexibleExpirationDateProcessed(LicenseImpl aLicense) {
        return aLicense.getProperty(PROPERTY_FLEXIBLE_EXP_DATE_PROCESSED, null) != null;
    }

    protected void setFlexibleExpirationDateProcessed(LicenseImpl aLicense, boolean aValue) {
        aLicense.putProperty(PROPERTY_FLEXIBLE_EXP_DATE_PROCESSED, aValue ? Boolean.TRUE.toString() : null);
    }

    protected void processFlexibleExpirationDate(LicenseImpl aLicense) {
        if (aLicense.getLicenseType() == 1 && this.isAllowFlexibleExpirationDate() && !this.isFlexibleExpirationDateProcessed(aLicense)) {
            Date newExpireDate = LicenseUtils.getLicenseIssueDate(new Date());
            newExpireDate.setTime(newExpireDate.getTime() + aLicense.getLicenseExpireDate().getTime() - aLicense.getLicenseIssueDate().getTime());
            aLicense.setLicenseExpireDate(newExpireDate);
            this.setFlexibleExpirationDateProcessed(aLicense, true);
        }
    }

    public void release() {
    }

    public static String loadText(Class aBaseClass, String aResourceName) {
        return StreamUtil.loadText(aResourceName, aBaseClass);
    }

    public String getLicenseExpireInfo(License aLicense) {
        Date expireDate;
        String result = null;
        if (aLicense.getLicenseState() != 3 && (expireDate = this.getLicenseExpirationDate(true)) != null) {
            result = DATE_FORMAT.format(expireDate);
        }
        return result;
    }
}

