/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseHost;
import com.jp.protection.pub.LicenseListener;
import com.jp.protection.pub.LicenseReader;

public class LicenseAdapter
implements LicenseListener {
    protected boolean fVerbose = false;

    public LicenseAdapter() {
    }

    public LicenseAdapter(boolean aVerbose) {
        this.fVerbose = aVerbose;
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean aVerbose) {
        this.fVerbose = aVerbose;
    }

    protected void error(String aMessage) {
        if (this.isVerbose()) {
            System.err.println(aMessage);
        }
    }

    protected void message(String aMessage) {
        if (this.isVerbose()) {
            System.out.println(aMessage);
        }
    }

    public void licenseAccepted(LicenseHost aSource, License aLicense, boolean isAccepted) {
        this.message("License is accepted: " + aLicense.getLicenseNumber());
    }

    public void licenseMissing(LicenseReader aSource, String aLicenseLocation) {
        this.error("License is missing: " + aLicenseLocation);
    }

    public void licenseCorrupted(LicenseReader aSource, String aLicenseLocation) {
        this.error("License is corrupted: " + aLicenseLocation);
    }

    public void licenseAvailable(LicenseReader aSource, String aLicenseLocation) {
        this.message("License is available: " + aLicenseLocation);
    }

    public void licenseExpired(LicenseHost aSource, License aLicense) {
        this.error("License is expired: " + aLicense.getLicenseNumber());
    }

    public void licenseOk(LicenseHost aSource, License aLicense) {
        this.message("License is OK: " + aLicense.getLicenseNumber());
    }

    public void licenseInvalid(LicenseHost aSource, License aLicense) {
        this.error("License is invalid: " + aLicense.getLicenseNumber());
    }

    public void featureChecked(LicenseHost aSource, License aLicense, String aFeature, boolean isEnabled) {
        this.message("Feature checked: " + aFeature + "[" + isEnabled + "]");
    }

    public void licenseAboutToExpire(LicenseHost aSource, License aLicense, int aDaysLeft) {
        this.message("License is about to expire: " + aLicense.getLicenseNumber() + " in " + aDaysLeft + " day(s)");
    }

    public void licenseUseLimitAboutReach(LicenseHost aSource, License aLicense, int aUseLeft) {
        this.message("License is about to expire: " + aLicense.getLicenseNumber() + " after " + aUseLeft + " usage(s)");
    }

    public void licenseLockViolation(LicenseHost aSource, License aLicense) {
        this.error("License lock violation: " + aLicense.getLicenseNumber());
    }

    public void numberCopiesViolation(LicenseHost aSource, License aLicense, int aNumberInUse) {
        this.error("Number of copies violation: " + aLicense.getLicenseNumber() + " Actual copies number: " + aNumberInUse);
    }

    public void licenseNotActivated(LicenseHost aSource, License aLicense) {
        this.error("License is not activated: " + aLicense.getLicenseNumber());
    }

    public void licenseNeedActivation(LicenseHost aSource, License aLicense, int aDaysLeft) {
        this.message("License need to be activated: " + aLicense.getLicenseNumber() + " in " + aDaysLeft + " day(s)");
    }

    public void licenseAboutToRead(LicenseReader aSource, String aProductID) {
        this.message("License about to read: " + aProductID);
    }

    public void licenseNeedLock(LicenseHost aSource, License aLicense, int aDaysLeft) {
        this.message("License need to be locked: " + aLicense.getLicenseNumber() + " in " + aDaysLeft + " day(s)");
    }

    public void licenseNotLocked(LicenseHost aSource, License aLicense, String aReason) {
        String message = "License is not locked: " + aLicense.getLicenseNumber();
        if (aReason != null) {
            message = message + ". Reason: " + aReason;
        }
        this.error(message);
    }

    public void licenseLockExpired(LicenseHost aSource, License aLicense, String aReason) {
        String message = "License lock expired: " + aLicense.getLicenseNumber();
        if (aReason != null) {
            message = message + ". Reason: " + aReason;
        }
        this.error(message);
    }

    public void licenseLockRevoked(LicenseHost aSource, License aLicense, String aReason) {
        String message = "License lock revoked: " + aLicense.getLicenseNumber();
        if (aReason != null) {
            message = message + ". Reason: " + aReason;
        }
        this.error(message);
    }
}

