/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub;

import com.jp.protection.utils.CustomCRC32;
import com.jp.protection.utils.CustomMessageDigest;
import dev.util.StreamUtil;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;

public class IntegrityHost {
    protected String[] fDigestEntries;
    protected long fCRC = -1L;
    public static final int ALGORITHM_CRC32 = 1;
    public static final int ALGORITHM_SHA_1 = 2;
    public static final int ALGORITHM_MD5 = 3;
    public static final int ALGORITHM_DEFAULT = 1;
    protected Digest fDigest;
    protected int fAlgorithm = -1;
    protected byte[] fDigestBytes;
    protected static final String WEB_INF = "/WEB-INF/classes";
    protected boolean fVerbose = false;
    protected byte[] fCheckDigest;

    public IntegrityHost(String[] aDigestEntries, long aCRC) {
        this();
        this.fDigestEntries = aDigestEntries;
        this.fCRC = aCRC;
        this.fCheckDigest = IntegrityHost.calculateDigest(this.fCRC);
    }

    public IntegrityHost(String[] aDigestEntries, byte[] aCheckDigest) {
        this();
        this.fDigestEntries = aDigestEntries;
        this.fCheckDigest = aCheckDigest;
    }

    public IntegrityHost() {
        this.setAlgorithm(1);
    }

    public int getAlgorithm() {
        return this.fAlgorithm;
    }

    public static String getAlgorithmStr(int anAlgorithm) {
        String result = null;
        switch (anAlgorithm) {
            case 2: {
                result = "SHA-1";
                break;
            }
            case 3: {
                result = "MD5";
                break;
            }
            case 1: {
                result = "CRC32";
            }
        }
        return result;
    }

    public void setAlgorithm(int aAlgorithm) {
        if (this.fAlgorithm != aAlgorithm) {
            this.fAlgorithm = aAlgorithm;
            switch (this.fAlgorithm) {
                case 1: {
                    this.fDigest = new CRC32Digest();
                    break;
                }
                case 2: {
                    this.fDigest = new MessageDigest("SHA-1");
                    break;
                }
                case 3: {
                    this.fDigest = new MessageDigest("MD5");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid algorithm: " + aAlgorithm);
                }
            }
        }
    }

    public long getCRC() {
        return this.fCRC;
    }

    public void setCRC(long aCRC) {
        this.fCRC = aCRC;
        IntegrityHost.calculateDigest(this.fCRC);
    }

    public String[] getCRCEntries() {
        return this.fDigestEntries;
    }

    public String[] getDigestEntries() {
        return this.fDigestEntries;
    }

    public void setCRCEntries(String[] aDigestEntries) {
        this.fDigestEntries = aDigestEntries;
    }

    public void setDigestEntries(String[] aDigestEntries) {
        this.fDigestEntries = aDigestEntries;
    }

    public boolean check() {
        return this.check(this.fDigestEntries, this.fCheckDigest);
    }

    public static boolean checkStatic(String[] aDigestEntries, long anCRC) {
        return new IntegrityHost().check(aDigestEntries, anCRC);
    }

    public static boolean checkStatic(String[] aDigestEntries, byte[] aCheckDigest, int anAlgorithm) {
        IntegrityHost host = new IntegrityHost();
        host.setAlgorithm(anAlgorithm);
        return host.check(aDigestEntries, aCheckDigest);
    }

    public static boolean checkStatic(String[] aDigestEntries, byte[] aCheckDigest) {
        return IntegrityHost.checkStatic(aDigestEntries, aCheckDigest, 1);
    }

    protected boolean check(String[] aDigestEntries, long anCRC) {
        return this.check(aDigestEntries, IntegrityHost.calculateDigest(anCRC));
    }

    protected boolean check(String[] aDigestEntries, byte[] aCheckDigest) {
        this.calculateDigest(aDigestEntries);
        return Arrays.equals(this.getDigest(), aCheckDigest);
    }

    public void resetDigest() {
        this.fDigestBytes = null;
        this.fDigest.reset();
    }

    public void updateDigest(byte[] aBytes) {
        this.fDigest.update(aBytes);
    }

    public byte[] getDigest() {
        if (this.fDigestBytes == null) {
            this.fDigestBytes = this.fDigest.getDigest();
        }
        return this.fDigestBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateDigest(String[] aDigestEntries) {
        this.resetDigest();
        if (aDigestEntries != null && aDigestEntries.length > 0) {
            try {
                for (int i = 0; i < aDigestEntries.length; ++i) {
                    String crcEntry = aDigestEntries[i];
                    InputStream inputStream = this.getEntryStream(crcEntry);
                    if (inputStream != null) {
                        try {
                            this.updateDigest(StreamUtil.readB(inputStream));
                            continue;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    this.error("Unable to get digest entry: " + crcEntry);
                }
            }
            catch (Exception ex) {
                this.error(ex);
            }
        }
    }

    protected long calculate(byte[] aBytes) {
        CustomCRC32 crc32 = new CustomCRC32();
        crc32.reset();
        crc32.proceed(aBytes);
        return crc32.getCRC();
    }

    protected InputStream getEntryStream(String crcEntry) {
        if (!crcEntry.startsWith("/")) {
            crcEntry = "/" + crcEntry;
        }
        if (crcEntry.startsWith(WEB_INF)) {
            crcEntry = crcEntry.substring(WEB_INF.length(), crcEntry.length());
        }
        return this.getClass().getResourceAsStream(crcEntry);
    }

    public static String toResourceName(Class aClass) {
        return aClass.getName().replace('.', '/') + ".class";
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean aVerbose) {
        this.fVerbose = aVerbose;
    }

    protected void error(String aMessage) {
        if (this.isVerbose()) {
            System.err.println(aMessage);
        }
    }

    protected void error(Throwable ex) {
        if (this.isVerbose()) {
            ex.printStackTrace();
        }
    }

    public byte[] getCheckDigest() {
        return this.fCheckDigest;
    }

    public void setCheckDigest(byte[] aCheckDigest) {
        this.fCheckDigest = aCheckDigest;
    }

    protected static byte[] calculateDigest(long aCRC) {
        return BigInteger.valueOf(aCRC).toByteArray();
    }

    protected static class MessageDigest
    implements Digest {
        protected CustomMessageDigest fMessageDigest;

        public MessageDigest(String anAlgorithm) {
            this.fMessageDigest = CustomMessageDigest.getInstance(anAlgorithm);
        }

        public void reset() {
            this.fMessageDigest.reset();
        }

        public void update(byte[] aBytes) {
            this.fMessageDigest.update(aBytes);
        }

        public byte[] getDigest() {
            return this.fMessageDigest.getDigest();
        }
    }

    protected static class CRC32Digest
    implements Digest {
        private CustomCRC32 fCustomCRC32 = new CustomCRC32();

        protected CRC32Digest() {
        }

        public void reset() {
            this.fCustomCRC32.reset();
        }

        public void update(byte[] aBytes) {
            this.fCustomCRC32.proceed(aBytes);
        }

        public byte[] getDigest() {
            return IntegrityHost.calculateDigest(this.fCustomCRC32.getCRC());
        }
    }

    protected static interface Digest {
        public void reset();

        public void update(byte[] var1);

        public byte[] getDigest();
    }
}

