/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub;

import com.jp.protection.pub.SecretStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Properties;

public class FileSecretStorage
implements SecretStorage {
    protected String fFileName = "storage.dat";
    protected String fFolder;
    protected boolean fUserHomeRelative = true;
    protected Properties fProperties;
    protected boolean fDirty = false;
    protected boolean fLoaded = false;
    protected boolean fVerbose = false;
    protected boolean fSkipEncryption = false;
    private static final int MASK = 18;

    public FileSecretStorage() {
    }

    public FileSecretStorage(String aFolder, String aFileName) {
        this(aFolder, aFileName, true);
    }

    public FileSecretStorage(String aFolder, String aFileName, boolean aUserHomeRelative) {
        this.fFolder = aFolder;
        this.fFileName = aFileName;
        this.fUserHomeRelative = aUserHomeRelative;
    }

    public boolean isUserHomeRelative() {
        return this.fUserHomeRelative;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public void setFileName(String aFileName) {
        this.fFileName = aFileName;
    }

    public String getFolder() {
        return this.fFolder;
    }

    public void setFolder(String aFolder) {
        this.fFolder = aFolder;
    }

    public void setUserHomeRelative(boolean aUserHomeRelative) {
        this.fUserHomeRelative = aUserHomeRelative;
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean aVerbose) {
        this.fVerbose = aVerbose;
    }

    protected void setLoaded(boolean aLoaded) {
        this.fLoaded = aLoaded;
    }

    protected Properties getProperties() {
        if (!this.isLoaded()) {
            this.load();
        }
        if (!this.isLoaded()) {
            this.fProperties = new Properties();
            this.setLoaded(true);
        }
        return this.fProperties;
    }

    public String getProperty(String key) {
        Properties delegate = this.getProperties();
        return delegate.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        Properties delegate = this.getProperties();
        return delegate.getProperty(key, defaultValue);
    }

    public Object setProperty(String key, String value) {
        Properties delegate = this.getProperties();
        this.setDirty(true);
        return value != null ? delegate.setProperty(key, value) : delegate.remove(key);
    }

    protected boolean isLoaded() {
        return this.fLoaded;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public void setDirty(boolean aDirty) {
        this.fDirty = aDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        InputStream inputStream = this.getInputStream();
        if (inputStream != null) {
            try {
                try {
                    if (this.fProperties == null) {
                        this.fProperties = new Properties();
                    }
                    this.fProperties.clear();
                    this.fProperties.load(inputStream);
                    this.setLoaded(true);
                    this.setDirty(false);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Exception ex) {
                this.error(ex);
            }
        }
    }

    protected long generateTimestamp(File aFile) {
        return 0L;
    }

    protected long getTimestamp(File aFile) {
        return aFile != null && aFile.exists() ? aFile.lastModified() : this.generateTimestamp(aFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (this.isDirty()) {
            File file = this.getFile();
            long fileTimestamp = this.getTimestamp(file);
            long folderTimestamp = this.getTimestamp(file.getParentFile());
            OutputStream outputStream = this.getOutputStream();
            if (outputStream != null) {
                try {
                    try {
                        this.fProperties.store(outputStream, null);
                        this.setDirty(false);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                catch (Exception ex) {
                    this.error(ex);
                }
                if (fileTimestamp != 0L) {
                    file.setLastModified(fileTimestamp);
                }
                if (folderTimestamp != 0L && file.getParentFile() != null) {
                    file.getParentFile().setLastModified(folderTimestamp);
                }
            }
        }
    }

    public boolean isSkipEncryption() {
        return this.fSkipEncryption;
    }

    public void setSkipEncryption(boolean aSkipEncryption) {
        this.fSkipEncryption = aSkipEncryption;
    }

    public File getFile() {
        File storageFile;
        if (this.isUserHomeRelative()) {
            String userHome = System.getProperties().getProperty("user.home");
            storageFile = new File(this.fFolder != null ? new File(userHome, this.fFolder) : new File(userHome), this.fFileName);
        } else {
            storageFile = new File(this.fFolder, this.fFileName);
        }
        return storageFile;
    }

    protected InputStream getInputStream() {
        InputStream result = null;
        try {
            File file = this.getFile();
            if (file.canRead()) {
                result = new FileInputStream(file);
                if (!this.isSkipEncryption()) {
                    result = new DecodeInputStream(result);
                }
            }
        }
        catch (FileNotFoundException ex) {
            this.error(ex);
        }
        return result;
    }

    protected OutputStream getOutputStream() {
        OutputStream result = null;
        try {
            File file = this.getFile();
            if (!file.exists() || file.canWrite()) {
                file.getParentFile().mkdirs();
                result = new FileOutputStream(file);
                if (!this.isSkipEncryption()) {
                    result = new EncodeOutputStream(result);
                }
            }
        }
        catch (FileNotFoundException ex) {
            this.error(ex);
        }
        return result;
    }

    protected void error(Throwable ex) {
        if (this.isVerbose()) {
            ex.printStackTrace();
        }
    }

    public static class Provider
    implements SecretStorage.Provider {
        public static final long serialVersionUID = 1L;
        protected String fFileName = "storage.dat";
        protected String fFolder;
        protected boolean fUserHomeRelative = true;
        private static final MessageFormat INSTANTIATION_FORMAT = new MessageFormat("new FileSecretStorage.Provider({0}, \"{1}\", {2})");
        public static final String TYPE = "File";

        public Provider() {
        }

        public Provider(String aFolder, String aFileName) {
            this(aFolder, aFileName, true);
        }

        public Provider(String aFolder, String aFileName, boolean aUserHomeRelative) {
            this.fFolder = aFolder;
            this.fFileName = aFileName;
            this.fUserHomeRelative = aUserHomeRelative;
        }

        public String getInstantiationStr() {
            return INSTANTIATION_FORMAT.format(new Object[]{this.fFolder != null ? "\"" + this.fFolder + "\"" : null, this.fFileName, this.fUserHomeRelative ? Boolean.TRUE : Boolean.FALSE});
        }

        public SecretStorage create() {
            return new FileSecretStorage(this.fFolder, this.fFileName, this.fUserHomeRelative);
        }

        public boolean isUserHomeRelative() {
            return this.fUserHomeRelative;
        }

        public void setUserHomeRelative(boolean aUserHomeRelative) {
            this.fUserHomeRelative = aUserHomeRelative;
        }

        public String getFileName() {
            return this.fFileName;
        }

        public void setFileName(String aFileName) {
            this.fFileName = aFileName;
        }

        public String getFolder() {
            return this.fFolder;
        }

        public void setFolder(String aFolder) {
            this.fFolder = aFolder;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage());
            }
        }

        public String toString() {
            return (this.isUserHomeRelative() ? "<HOME>" : "") + (this.getFolder() != null ? new File(this.getFolder(), this.getFileName()) : new File(this.getFileName())).getPath();
        }

        public String getType() {
            return TYPE;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Provider)) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }
    }

    protected static class DecodeInputStream
    extends FilterInputStream {
        protected int decode(int b) {
            return b ^ 0x12;
        }

        public DecodeInputStream(InputStream anInputStream) {
            super(anInputStream);
        }

        public int read() throws IOException {
            return this.decode(super.read());
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int bytesRead = super.read(b, off, len);
            if (bytesRead != -1) {
                for (int i = off; i < bytesRead; ++i) {
                    b[i] = (byte)this.decode(b[i]);
                }
            }
            return bytesRead;
        }
    }

    protected static class EncodeOutputStream
    extends FilterOutputStream {
        protected int encode(int b) {
            return b ^ 0x12;
        }

        public EncodeOutputStream(OutputStream anOutputStream) {
            super(anOutputStream);
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        public void write(int b) throws IOException {
            super.write(this.encode(b));
        }
    }
}

