/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs.pro.panes;

import com.jp.protection.gui.dialogs.panes.OfflineLicensingWizardPane;
import com.jp.protection.gui.dialogs.pro.LicenseDeactivationWizard;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.pro.LicenseHostPro;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;

public class OfflineDeactivationWizardPane
extends OfflineLicensingWizardPane
implements ActionListener {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.pro.Res");
    public static final String NAME = "OfflineDeactivationWizardPane";
    protected static final MessageFormat FORMAT_BODY_EMAIL = new MessageFormat("<li>{0}<a href=\"{1}?subject=DEACTIVATION%20[LicenseNumber={3} Product={4}%20ActivationKey={5}%20DeactivationKey={6}]\">{2}</a>\n</li>\n");
    protected static final MessageFormat FORMAT_BODY_SITE = new MessageFormat("<li>{0}<a href=\"{1}?licenseNumber={3}&product={4}&activationKey={4}&deactivationKey={6}\">{2}</a>\n</li>\n");
    protected static final MessageFormat FORMAT_HEADER = new MessageFormat("<html>\n<body>\n<table>\n<tr><td>" + res.getString("License_Number") + " </td><td>{0}</td></tr>\n" + "<tr><td>" + res.getString("Product") + " </td><td>{1}</td></tr>\n" + "<tr><td>" + res.getString("Activation_Key") + " </td><td>{2}</td></tr>\n" + "<tr><td>" + res.getString("Deactivation_Key") + " </td><td>{3}</td></tr>\n" + "</table><br>\n" + res.getString("Notify_vendor_Prompt") + "\n<ul>\n");
    protected static final MessageFormat FORMAT_FOOTER = new MessageFormat("");
    JButton btnCopy = new JButton();

    public OfflineDeactivationWizardPane() {
        this.setName(NAME);
        this.setHeaderName(res.getString("Notify_Vendor_Offline"));
        this.setHeaderDescription(res.getString("Please_use_one_of_the"));
        this.putClientProperty("topicID", "activation_assistant/offline");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String composeMessage() {
        return this.composeMessage(FORMAT_HEADER, FORMAT_BODY, FORMAT_FOOTER);
    }

    protected void composeBuyOnline(StringBuffer result) {
    }

    protected void composeHeader(MessageFormat aHeader, StringBuffer result) {
        LicenseHostPro licenseHost = ((LicenseDeactivationWizard)this.getWizardDialog()).getLicenseHost();
        aHeader.format(new Object[]{licenseHost.getLicense().getLicenseNumber(), this.fProductInfo.getShortName(), this.getActivationKey(), this.getDeactivationKey()}, result, new FieldPosition(0));
    }

    protected void composeContactSales(StringBuffer result) {
    }

    protected void composeVisitSite(StringBuffer result) {
    }

    protected void composeDeactivate(StringBuffer result) {
        this.composeDeactivate(result, this.fProductInfo.getProductInfoLink("deactivate"));
    }

    protected void composeDeactivate(StringBuffer result, ProductInfo.ProductInfoLink aLink) {
        if (aLink != null && aLink.getURL() != null) {
            LicenseHostPro licenseHost = ((LicenseDeactivationWizard)this.getWizardDialog()).getLicenseHost();
            boolean mailTo = aLink.getURL().toLowerCase().startsWith("mailto:");
            this.composeBody(mailTo ? FORMAT_BODY_EMAIL : FORMAT_BODY_SITE, result, res.getString(mailTo ? "contacting_us_at" : "visiting_our_site_at") + " ", aLink, new Object[]{licenseHost.getLicense().getLicenseNumber(), this.fProductInfo.getShortName(), this.getActivationKey(), this.getDeactivationKey()});
        }
    }

    protected void composeSupport(StringBuffer result) {
        ProductInfo.ProductInfoLink link = this.fProductInfo.getProductInfoLink("deactivate");
        if (link == null || link.getURL() == null) {
            link = this.fProductInfo.getProductInfoLink("support");
            ProductInfo.ProductInfoLink copyLink = new ProductInfo.ProductInfoLink(link.getID(), link.getText(), OfflineDeactivationWizardPane.removeSubject(link.getURL()), link.getTooltip());
            this.composeDeactivate(result, copyLink);
        }
    }

    private LicenseHostPro getLicenseHost() {
        LicenseHostPro licenseHost = ((LicenseDeactivationWizard)this.getWizardDialog()).getLicenseHost();
        return licenseHost;
    }

    private void jbInit() throws Exception {
        this.btnCopy.setToolTipText(res.getString("btnCopy_ToolTipText"));
        this.btnCopy.setText(res.getString("btnCopy_Text"));
        this.btnCopy.addActionListener(this);
        this.add(this.btnCopy, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(15, 0, 0, 0), 0, 0), 0);
    }

    protected String getDeactivationKey() {
        return ((LicenseDeactivationWizard)this.fWizardDialog).getDeactivationKey();
    }

    protected String getActivationKey() {
        return ((LicenseDeactivationWizard)this.getWizardDialog()).getLicenseHost().getLicense().getProperty("pr.ak", res.getString("NA"));
    }

    void btnCopy_actionPerformed() {
        String selection = "Product: " + this.fProductInfo.getShortName() + "\n";
        selection = selection + "Activation Key: " + this.getActivationKey() + "\n";
        selection = selection + "Deactivation Key: " + this.getDeactivationKey() + "\n";
        selection = selection + "License Number: " + this.getLicenseHost().getLicense().getLicenseNumber();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(selection), null);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnCopy) {
            this.btnCopy_actionPerformed();
        }
    }

    public boolean canFinish() {
        return true;
    }

    public int finish() {
        return 1;
    }
}

