/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs.pro.panes;

import com.jp.protection.gui.dialogs.panes.OfflineLicensingWizardPane;
import com.jp.protection.gui.dialogs.pro.LicenseActivationWizard;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.pro.LicenseHostPro;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;

public class OfflineActivationWizardPane
extends OfflineLicensingWizardPane
implements ActionListener {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.pro.Res");
    public static final String NAME = "OfflineActivationWizardPane";
    protected static final MessageFormat FORMAT_BODY_EMAIL = new MessageFormat("<li>{0}<a href=\"{1}?subject=Activation%20[LicenseNumber={3}%20ActivationKey={4}]\">{2}</a>\n</li>\n");
    protected static final MessageFormat FORMAT_BODY_SITE = new MessageFormat("<li>{0}<a href=\"{1}?licenseNumber={3}&activationKey={4}\">{2}</a>\n</li>\n");
    protected static final MessageFormat FORMAT_HEADER = new MessageFormat("<html>\n<body>\n<table>\n<tr><td>" + res.getString("License_Number") + " </td><td>{0}</td></tr>\n" + "<tr><td>" + res.getString("Activation_Key") + " </td><td>{1}</td></tr>\n" + "</table><br>\n" + res.getString("You_may_activate_this") + "<ul>\n");
    protected static final MessageFormat FORMAT_FOOTER = new MessageFormat("</ul>\n<u>" + res.getString("Please_press_the_Next") + "</u>\n" + "</body>\n" + "</html>");
    JButton btnCopy = new JButton();

    public OfflineActivationWizardPane() {
        this.setName(NAME);
        this.setHeaderName(res.getString("OfflineActivationPane_Name"));
        this.setHeaderDescription(res.getString("OfflineActivationPane_Descr"));
        this.putClientProperty("topicID", "activation_assistant/offline");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String composeMessage() {
        return this.composeMessage(FORMAT_HEADER, FORMAT_BODY, FORMAT_FOOTER);
    }

    protected void composeBuyOnline(StringBuffer result) {
    }

    protected void composeHeader(MessageFormat aHeader, StringBuffer result) {
        LicenseHostPro licenseHost = ((LicenseActivationWizard)this.getWizardDialog()).getLicenseHost();
        aHeader.format(new Object[]{licenseHost.getLicense().getLicenseNumber(), licenseHost.getActivationKey()}, result, new FieldPosition(0));
    }

    protected void composeContactSales(StringBuffer result) {
    }

    protected void composeActivate(StringBuffer result) {
        this.composeActivate(result, this.fProductInfo.getProductInfoLink("activate"));
    }

    protected void composeActivate(StringBuffer result, ProductInfo.ProductInfoLink aLink) {
        if (aLink != null && aLink.getURL() != null) {
            LicenseHostPro licenseHost = ((LicenseActivationWizard)this.getWizardDialog()).getLicenseHost();
            boolean mailTo = aLink.getURL().toLowerCase().startsWith("mailto:");
            this.composeBody(mailTo ? FORMAT_BODY_EMAIL : FORMAT_BODY_SITE, result, res.getString(mailTo ? "contacting_us_at" : "visiting_our_site_at") + " ", aLink, new Object[]{licenseHost.getLicense().getLicenseNumber(), licenseHost.getActivationKey()});
        }
    }

    protected void composeSupport(StringBuffer result) {
        ProductInfo.ProductInfoLink link = this.fProductInfo.getProductInfoLink("activate");
        if (link == null || link.getURL() == null) {
            link = this.fProductInfo.getProductInfoLink("support");
            ProductInfo.ProductInfoLink copyLink = new ProductInfo.ProductInfoLink(link.getID(), link.getText(), OfflineActivationWizardPane.removeSubject(link.getURL()), link.getTooltip());
            this.composeActivate(result, copyLink);
        }
    }

    protected void composeVisitSite(StringBuffer result) {
    }

    private void jbInit() throws Exception {
        this.btnCopy.setToolTipText(res.getString("btnCopy_ToolTipText"));
        this.btnCopy.setText(res.getString("btnCopy_Text"));
        this.btnCopy.addActionListener(this);
        this.add(this.btnCopy, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 24, 0, new Insets(15, 0, 0, 0), 0, 0), 0);
    }

    void btnCopy_actionPerformed() {
        LicenseHostPro licenseHost = ((LicenseActivationWizard)this.getWizardDialog()).getLicenseHost();
        String selection = "License Number: " + licenseHost.getLicense().getLicenseNumber() + "\n";
        selection = selection + "Activation Key: " + licenseHost.getActivationKey();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(selection), null);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnCopy) {
            this.btnCopy_actionPerformed();
        }
    }
}

