/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs.pro.panes;

import dev.gui.net.NetworkDiscoveryCombobox;
import dev.gui.net.NetworkDiscoveryProgress;
import dev.gui.wizard.WizardPane;
import dev.gui.wizard.WizardPaneHeader;
import dev.net.NetworkDiscovery;
import dev.net.NetworkDiscoveryPacket;
import dev.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LicensingServerWizardPane
extends WizardPane {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.pro.Res");
    WizardPaneHeader pnlWizardHeader = new WizardPaneHeader();
    JLabel lblLicensingServer = new JLabel();
    NetworkDiscoveryCombobox cbxLicensingServer = new NetworkDiscoveryCombobox();
    NetworkDiscoveryProgress fNetworkDiscoveryProgress = new NetworkDiscoveryProgress();
    JPanel pnlFillV = new JPanel();
    public static final String NAME = "LicensingServerWizardPane";
    protected static final MessageFormat FMT_FINDING = new MessageFormat(res.getString("Searching_LS"));
    protected static final MessageFormat FMT_FOUND = new MessageFormat(res.getString("Found_LS"));

    public LicensingServerWizardPane() {
        this.setName(NAME);
        try {
            this.jbInit();
            this.putClientProperty("topicID", "licensing_assistant/licensing_server");
            NetworkDiscovery networkDiscovery = new NetworkDiscovery(1){

                protected NetworkDiscoveryPacket createRequest() {
                    NetworkDiscoveryPacket result = new NetworkDiscoveryPacket(this.fSignature, this.fHostID, this.fTimestamp, 0);
                    result.getAttributes().put("command", "remote-management");
                    return result;
                }
            };
            networkDiscovery.setSignature("ProtectionLS");
            this.cbxLicensingServer.setNetworkDiscovery(networkDiscovery);
            networkDiscovery.addNetworkDiscoveryListener(this.fNetworkDiscoveryProgress);
            this.fNetworkDiscoveryProgress.setFindingFormat(FMT_FINDING);
            this.fNetworkDiscoveryProgress.setFoundFormat(FMT_FOUND);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.cbxLicensingServer.setEditable(true);
        this.cbxLicensingServer.setSelectFirstAddress(true);
        this.pnlWizardHeader.setDescriptionText(res.getString("LicensingServerPane_Descr"));
        this.pnlWizardHeader.setNameText(res.getString("LicensingServerPane_Name"));
        this.lblLicensingServer.setLabelFor(this.cbxLicensingServer);
        this.lblLicensingServer.setText(res.getString("lblLicensingServer_Text"));
        this.pnlFillV.setMinimumSize(new Dimension(0, 0));
        this.add((Component)this.pnlWizardHeader, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lblLicensingServer, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(15, 5, 0, 0), 0, 0));
        this.add((Component)this.cbxLicensingServer, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(15, 5, 0, 0), 0, 0));
        this.add((Component)this.fNetworkDiscoveryProgress, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.pnlFillV, new GridBagConstraints(1, 20, 2, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void activate(String aBackPaneName) {
        super.activate(aBackPaneName);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LicensingServerWizardPane.this.cbxLicensingServer.requestFocus();
                try {
                    LicensingServerWizardPane.this.cbxLicensingServer.stop();
                    LicensingServerWizardPane.this.cbxLicensingServer.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public String getLicensingServer() {
        String result = (String)this.cbxLicensingServer.getSelectedItem();
        return StringUtils.noValue(result) ? null : result;
    }

    public void setLicensingServer(String aLicensingServer) {
        this.cbxLicensingServer.setSelectedItem(aLicensingServer);
    }

    public String next() {
        if (this.getLicensingServer() != null) {
            return "InternetConnectionWizardPane";
        }
        this.error();
        this.cbxLicensingServer.requestFocus();
        return "-none-";
    }

    protected void error() {
        this.error(res.getString("Licensing_Server_Not_Specified"));
    }

    public boolean canFinish() {
        return true;
    }

    public int finish() {
        int result;
        int n = result = this.getLicensingServer() != null ? 1 : 0;
        if (result != 1) {
            this.error();
            this.cbxLicensingServer.requestFocus();
        }
        return result;
    }

    public boolean canNext() {
        return true;
    }
}

