/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs.pro.panes;

import com.jp.protection.gui.dialogs.pro.LicenseLockWizard;
import dev.gui.wizard.WizardDialog;
import dev.gui.wizard.WizardPane;
import dev.gui.wizard.WizardPaneHeader;
import dev.lang.BitTools;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class LicenseLockWizardPane
extends WizardPane
implements ActionListener {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.pro.Res");
    public static final String NAME = "LicenseLockWizardPane";
    WizardPaneHeader pnlWizardHeader = new WizardPaneHeader();
    JRadioButton rbtnTryAgain = new JRadioButton();
    JRadioButton rbtnWait = new JRadioButton();
    ButtonGroup fButtonGroup = new ButtonGroup();
    JPanel pnlFill = new JPanel();
    protected int fOptions = 3;
    protected int fSelectedOption = 1;

    public LicenseLockWizardPane() {
        this.setName(NAME);
        try {
            this.jbInit();
            this.putClientProperty("topicID", "lock_assistant/home");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.pnlWizardHeader.setDescriptionText(res.getString("LicenseLockWizardPane_Descr"));
        this.pnlWizardHeader.setNameText(res.getString("LicenseLockWizardPane_Name"));
        this.rbtnTryAgain.setSelected(true);
        this.rbtnTryAgain.setText(res.getString("rbtnTryAgain_Text"));
        this.rbtnTryAgain.addActionListener(this);
        this.rbtnWait.setText(res.getString("rbtnWaitAvailability_Text"));
        this.rbtnWait.addActionListener(this);
        this.add((Component)this.pnlWizardHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.rbtnTryAgain, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(15, 5, 0, 0), 0, 0));
        this.add((Component)this.rbtnWait, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.fButtonGroup.add(this.rbtnTryAgain);
        this.fButtonGroup.add(this.rbtnWait);
        this.add((Component)this.pnlFill, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setWizardDialog(WizardDialog aWizardDialog) {
        super.setWizardDialog(aWizardDialog);
        this.updateOptions();
    }

    public boolean canNext() {
        return this.rbtnTryAgain.isVisible() || this.rbtnWait.isVisible();
    }

    protected boolean isLicensingServerAddressKnown() {
        return ((LicenseLockWizard)this.fWizardDialog).isLicensingServerAddressKnown();
    }

    public String next() {
        return this.isLicensingServerAddressKnown() || !BitTools.checkBit(this.fOptions, 4) ? "InternetConnectionWizardPane" : "LicensingServerWizardPane";
    }

    public boolean canFinish() {
        return this.isLicensingServerAddressKnown() || !BitTools.checkBit(this.fOptions, 4);
    }

    public int finish() {
        return 1;
    }

    public int getOptions() {
        return this.fOptions;
    }

    public void setOptions(int aOptions) {
        if (this.fOptions != aOptions) {
            this.fOptions = aOptions;
            this.updateOptions();
        }
    }

    protected void updateOptions() {
        this.rbtnTryAgain.setVisible(BitTools.checkBit(this.fOptions, 1));
        this.rbtnWait.setVisible(BitTools.checkBit(this.fOptions, 2));
        if (this.rbtnTryAgain.isVisible()) {
            this.rbtnTryAgain.setSelected(true);
        } else if (this.rbtnWait.isVisible()) {
            this.rbtnWait.setSelected(true);
        }
    }

    public int getSelectedOption() {
        return this.fSelectedOption;
    }

    public String getIssueDescription() {
        return this.pnlWizardHeader.getDescriptionText();
    }

    public void setIssueDescription(String aDescription) {
        this.pnlWizardHeader.setDescriptionText(aDescription);
    }

    public String getIssueName() {
        return this.pnlWizardHeader.getNameText();
    }

    public void setIssueName(String aValue) {
        this.pnlWizardHeader.setNameText(aValue);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.rbtnTryAgain.isSelected()) {
            this.fSelectedOption = 1;
        } else if (this.rbtnWait.isSelected()) {
            this.fSelectedOption = 2;
        }
        this.getWizardDialog().update();
    }
}

