/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs.pro.panes;

import com.jp.protection.gui.dialogs.pro.LicenseDeactivationWizard;
import com.jp.protection.pub.License;
import com.jp.protection.pub.pro.LicenseHostPro;
import dev.gui.wizard.WizardDialog;
import dev.gui.wizard.WizardPane;
import dev.gui.wizard.WizardPaneHeader;
import dev.lang.BitTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class LicenseDeactivationWizardPane
extends WizardPane
implements ActionListener {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.pro.Res");
    WizardPaneHeader pnlWizardHeader = new WizardPaneHeader();
    JCheckBox chkConfirmation = new JCheckBox();
    JLabel lblNote = new JLabel();
    JPanel pnlFill = new JPanel();
    public static final String NAME = "LicenseDeactivationWizardPane";
    protected int fOptions = 3;
    JLabel lblIcon = new JLabel();

    public LicenseDeactivationWizardPane() {
        try {
            this.setName(NAME);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected LicenseHostPro getLicenseHost() {
        return ((LicenseDeactivationWizard)this.fWizardDialog).getLicenseHost();
    }

    public String next() {
        String result = this.fNextPaneName;
        LicenseHostPro licenseHost = this.getLicenseHost();
        String deactivationKey = licenseHost.deactivateLicense();
        ((LicenseDeactivationWizard)this.fWizardDialog).setDeactivationKey(deactivationKey);
        License license = licenseHost.getLicense(false);
        if (license.getLicenseState() != 5 && BitTools.checkBit(this.fOptions, 4)) {
            WizardDialog.error(this, res.getString("Unable_to_deactivate"));
            result = "-none-";
        }
        return result;
    }

    public boolean canNext() {
        return this.chkConfirmation.isSelected() && this.getLicenseHost().canDeactivateLicense();
    }

    private void jbInit() throws Exception {
        this.setPreferredSize(new Dimension(370, 220));
        this.chkConfirmation.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.lblIcon.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        this.pnlWizardHeader.setDescriptionText(res.getString("DeactivationWizardPane_Descr"));
        this.pnlWizardHeader.setNameText(res.getString("DeactivationWizardPane_Name"));
        this.chkConfirmation.setText(res.getString("chkConfirmation_Text"));
        this.lblNote.setRequestFocusEnabled(true);
        this.lblNote.setText("<html>" + res.getString("lblNote_Text") + "<br><br>" + "<font color=red>" + res.getString("lblNote_Text2") + "</font></html>");
        this.lblNote.setVerticalAlignment(1);
        this.pnlFill.setMinimumSize(new Dimension(0, 0));
        this.pnlFill.setPreferredSize(new Dimension(0, 0));
        this.add((Component)this.pnlWizardHeader, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.chkConfirmation, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 21, 0, new Insets(15, 5, 0, 0), 0, 0));
        this.add((Component)this.lblNote, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(15, 5, 0, 0), 0, 0));
        this.add((Component)this.pnlFill, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lblIcon, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(15, 5, 0, 0), 0, 0));
    }

    public boolean canFinish() {
        return false;
    }

    public int finish() {
        return 0;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.chkConfirmation) {
            this.update();
        }
    }

    public int getOptions() {
        return this.fOptions;
    }

    public void setOptions(int aOptions) {
        this.fOptions = aOptions;
    }
}

