/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs.pro.panes;

import com.jp.protection.gui.dialogs.pro.LicenseActivationWizard;
import com.jp.protection.pub.License;
import com.jp.protection.pub.pro.integration.LicensingFacadeProvider;
import dev.gui.wizard.WizardDialog;
import dev.gui.wizard.WizardPane;
import dev.gui.wizard.WizardPaneHeader;
import dev.lang.BitTools;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class LicenseActivationWizardPane
extends WizardPane {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.pro.Res");
    public static final String NAME = "LicenseActivationWizardPane";
    WizardPaneHeader pnlWizardHeader = new WizardPaneHeader();
    JRadioButton rbtnActivateOnline = new JRadioButton();
    JRadioButton rbtnActivateOffline = new JRadioButton();
    ButtonGroup fButtonGroup = new ButtonGroup();
    JPanel pnlFill = new JPanel();
    GridBagLayout gridBagLayout = new GridBagLayout();
    protected int fOptions = 7;
    JRadioButton rbtnChooseLicense = new JRadioButton();

    public LicenseActivationWizardPane() {
        this.setName(NAME);
        try {
            this.jbInit();
            this.putClientProperty("topicID", "activation_assistant/home");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        this.pnlWizardHeader.setDescriptionText(res.getString("ActivationWizardPane_Descr"));
        this.pnlWizardHeader.setNameText(res.getString("ActivationWizardPane_Name"));
        this.rbtnActivateOnline.setSelected(true);
        this.rbtnActivateOnline.setText(res.getString("rbtnActivateOnline_Text"));
        this.rbtnActivateOnline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LicenseActivationWizardPane.this.rbtnActivateOnline_actionPerformed(e);
            }
        });
        this.rbtnActivateOffline.setText(res.getString("rbtnActivateOffline_Text"));
        this.rbtnActivateOffline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LicenseActivationWizardPane.this.rbtnActivateOffline_actionPerformed(e);
            }
        });
        this.rbtnChooseLicense.setText(res.getString("rbtnChooseLicense_Text"));
        this.rbtnChooseLicense.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LicenseActivationWizardPane.this.rbtnChooseLicense_actionPerformed(e);
            }
        });
        this.fButtonGroup.add(this.rbtnActivateOnline);
        this.fButtonGroup.add(this.rbtnActivateOffline);
        this.fButtonGroup.add(this.rbtnChooseLicense);
        this.add((Component)this.pnlWizardHeader, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.rbtnActivateOnline, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 21, 0, new Insets(15, 5, 0, 0), 0, 0));
        this.add((Component)this.rbtnActivateOffline, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.rbtnChooseLicense, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.pnlFill, new GridBagConstraints(1, 10, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setWizardDialog(WizardDialog aWizardDialog) {
        super.setWizardDialog(aWizardDialog);
        this.updateOptions();
    }

    public boolean canNext() {
        return this.rbtnActivateOnline.isVisible() || this.rbtnActivateOffline.isVisible();
    }

    public String next() {
        String result = null;
        if (this.rbtnActivateOnline.isSelected()) {
            License license = ((LicenseActivationWizard)this.getWizardDialog()).getLicenseHost().getLicense();
            result = BitTools.checkBit(license.getLicenseOptions(), 4) ? "OnlineActivationWizardPane" : "InternetConnectionWizardPane";
        } else if (this.rbtnActivateOffline.isSelected()) {
            result = "OfflineActivationWizardPane";
        } else if (this.rbtnChooseLicense.isSelected()) {
            result = "LicenseLocationWizardPane";
        }
        return result;
    }

    public boolean canFinish() {
        boolean result = false;
        if (this.rbtnActivateOnline.isSelected()) {
            License license = ((LicenseActivationWizard)this.getWizardDialog()).getLicenseHost().getLicense();
            result = !BitTools.checkBit(license.getLicenseOptions(), 4);
        }
        return result;
    }

    public int finish() {
        if (this.rbtnActivateOnline.isSelected()) {
            License license = ((LicenseActivationWizard)this.getWizardDialog()).getLicenseHost().getLicense();
            return !BitTools.checkBit(license.getLicenseOptions(), 4) ? 1 : 0;
        }
        return 0;
    }

    void rbtnActivateOnline_actionPerformed(ActionEvent e) {
        this.getWizardDialog().update();
    }

    void rbtnActivateOffline_actionPerformed(ActionEvent e) {
        this.getWizardDialog().update();
    }

    public void rbtnChooseLicense_actionPerformed(ActionEvent e) {
        this.getWizardDialog().update();
    }

    public int getOptions() {
        return this.fOptions;
    }

    public void setOptions(int aOptions) {
        if (this.fOptions != aOptions) {
            this.fOptions = aOptions;
            this.updateOptions();
        }
    }

    protected void updateOptions() {
        this.rbtnActivateOnline.setVisible(LicensingFacadeProvider.hasProviders() && BitTools.checkBit(this.fOptions, 1));
        this.rbtnActivateOffline.setVisible(BitTools.checkBit(this.fOptions, 2));
        this.rbtnChooseLicense.setVisible(BitTools.checkBit(this.fOptions, 4));
        if (this.rbtnActivateOnline.isVisible()) {
            this.rbtnActivateOnline.setSelected(true);
        } else if (this.rbtnActivateOffline.isVisible()) {
            this.rbtnActivateOffline.setSelected(true);
        } else if (this.rbtnChooseLicense.isVisible()) {
            this.rbtnActivateOffline.setSelected(true);
        }
    }

    public String getIssueDescription() {
        return this.pnlWizardHeader.getDescriptionText();
    }

    public void setIssueDescription(String aDescription) {
        this.pnlWizardHeader.setDescriptionText(aDescription);
    }

    public String getIssueName() {
        return this.pnlWizardHeader.getNameText();
    }

    public void setIssueName(String aValue) {
        this.pnlWizardHeader.setNameText(aValue);
    }
}

