/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs.pro.panes;

import com.jp.comp.pane.CustomerPane;
import com.jp.protection.gui.dialogs.BasicLicenseWizard;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.utils.LicenseUtils;
import dev.entities.Customer;
import dev.gui.wizard.WizardPane;
import dev.gui.wizard.WizardPaneHeader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CustomerWizardPane
extends WizardPane {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.pro.Res");
    WizardPaneHeader pnlHeader = new WizardPaneHeader();
    protected boolean fActivated = false;
    protected CustomerPane pnlCustomer = new CustomerPane();
    protected Customer fCustomer = new Customer();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JCheckBox chkContactMe = new JCheckBox();
    JPanel pnlFill = new JPanel();
    protected static final MessageFormat FMT_CONTACT_ME = new MessageFormat(res.getString("chkContactMe_Text1"));

    public CustomerWizardPane() {
        try {
            this.jbInit();
            this.putClientProperty("topicID", "licensing_assistant");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.pnlCustomer.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.pnlCustomer.setRequired(false);
        this.chkContactMe.setVerticalAlignment(1);
        this.chkContactMe.setVerticalTextPosition(1);
        this.pnlFill.setMinimumSize(new Dimension(0, 0));
        this.chkContactMe.setPreferredSize(new Dimension(370, 44));
        this.add((Component)this.pnlHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnlCustomer, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.chkContactMe, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.pnlFill, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        result.width = 370;
        return result;
    }

    public String getNameText() {
        return this.pnlHeader.getNameText();
    }

    public void setNameText(String aName) {
        this.pnlHeader.setNameText(aName);
    }

    public String getDescriptionText() {
        return this.pnlHeader.getDescriptionText();
    }

    public void setDescriptionText(String aDescription) {
        this.pnlHeader.setDescriptionText(aDescription);
    }

    public boolean canFinish() {
        return true;
    }

    public int finish() {
        int result = 0;
        if (this.pnlCustomer.checkValid() && this.obtainCustomerData()) {
            result = 1;
        }
        return result;
    }

    public boolean canNext() {
        return true;
    }

    protected boolean obtainCustomerData() {
        boolean result = false;
        if (this.pnlCustomer.checkValid()) {
            this.pnlCustomer.fromForm(this.fCustomer);
            this.fCustomer.setContactMe(this.chkContactMe.isSelected());
            this.fCustomer.toPreferences(this.getPreferences());
            result = true;
        }
        return result;
    }

    public String next() {
        if (this.pnlCustomer.checkValid() && this.obtainCustomerData()) {
            return "InternetConnectionWizardPane";
        }
        return "-none-";
    }

    public Customer getCustomer() {
        return this.fCustomer;
    }

    protected ProductInfo getProductInfo() {
        return ((BasicLicenseWizard)this.getWizardDialog()).getProductInfo();
    }

    protected void doActivate() {
        ProductInfo productInfo = this.getProductInfo();
        if (productInfo != null && productInfo.getShortName() != null && !"".equals(productInfo.getShortName())) {
            try {
                this.fCustomer.fromPreferences(this.getPreferences());
                this.pnlCustomer.toForm(this.fCustomer);
                String company = productInfo.getCompany() != null ? productInfo.getCompany() : "";
                this.chkContactMe.setText("<html>" + FMT_CONTACT_ME.format(new Object[]{company}) + "</html>");
                this.chkContactMe.setSelected(this.fCustomer.isContactMe());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.fActivated = true;
        this.fWizardDialog.update();
    }

    protected Preferences getPreferences() {
        return LicenseUtils.getCustomerPreferences(this.getProductInfo().getID());
    }

    public void activate(String aBackPaneName) {
        super.activate(aBackPaneName);
        this.doActivate();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CustomerWizardPane.this.pnlCustomer.requestFocus();
            }
        });
    }

    public boolean isConfirmEmail() {
        return this.pnlCustomer.isConfirmEmail();
    }

    public void setConfirmEmail(boolean aConfirmEmail) {
        this.pnlCustomer.setConfirmEmail(aConfirmEmail);
    }
}

