/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs.pro;

import com.jp.protection.gui.dialogs.LicensingWizard;
import com.jp.protection.gui.dialogs.pro.panes.CustomWizardPane;
import com.jp.protection.gui.dialogs.pro.panes.CustomerWizardPane;
import com.jp.protection.gui.dialogs.pro.panes.LicensingServerWizardPane;
import com.jp.protection.gui.dialogs.pro.panes.LicensingWizardProgressPane;
import com.jp.protection.gui.dialogs.pro.panes.RequestEvaluationWizardPane;
import com.jp.protection.gui.dialogs.pro.panes.SerialNumberCustomerWizardPane;
import com.jp.protection.gui.dialogs.pro.panes.SerialNumberWizardPane;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.pro.LicenseHostPro;
import com.jp.protection.pub.pro.LicensingServiceSupport;
import com.jp.protection.pub.pro.integration.LicenseDescr;
import com.jp.protection.pub.pro.integration.LicensingFacade;
import com.jp.protection.pub.pro.integration.LicensingFacadeResult;
import com.jp.protection.pub.pro.integration.LicensingFacadeResultBase;
import com.jp.protection.pub.pro.lserver.LicensingService;
import com.jp.protection.pub.pro.lserver.LicensingServiceProvider;
import com.jp.protection.pub.pro.lserver.LicensingServiceResult;
import dev.entities.Customer;
import dev.gui.UIUtils;
import dev.gui.wizard.InternetConnectionWizardPane;
import dev.gui.wizard.MessageWizardPane;
import dev.gui.wizard.ProgressWizardPane;
import dev.gui.wizard.WizardPane;
import dev.lang.BitTools;
import dev.lang.NestedException;
import java.awt.Component;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;

public class LicensingWizardPro
extends LicensingWizard {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.pro.Res");
    protected MessageWizardPane fMessageWizardPane;
    protected RequestEvaluationWizardPane fRequestEvaluationWizardPane;
    protected InternetConnectionWizardPane fInternetConnectionWizardPane;
    protected SerialNumberWizardPane fSerialNumberWizardPane;
    protected SerialNumberCustomerWizardPane fSerialNumberCustomerWizardPane;
    protected LicensingWizardProgressPane fLicensingWizardProgressPane;
    protected LicensingServerWizardPane fLicensingServerWizardPane;
    protected CustomWizardPane fCustomWizardPane;
    protected ProgressWizardPane.Operation fGetOperation = new ProgressWizardPane.Operation(res.getString("Get_OP_Name"), res.getString("Get_OP_Descr"));
    protected boolean fShowCustomPane = false;
    protected LicensingFacadeResult fRequestResult;
    protected String fLogin;
    protected String fPassword;
    protected HashMap fArguments;
    protected LicenseHostPro fLicenseHost;
    protected static final String MSG_UNABLE_TO_GET_EVAL = res.getString("Unable_to_get");
    protected static final String MSG_TRY_AGAIN = res.getString("Try_again");
    protected static final String MSG_UNABLE_TO_GET_EVAL_TRY_AGAIN = MSG_UNABLE_TO_GET_EVAL + "\n" + MSG_TRY_AGAIN;
    protected static final String MSG_UNABLE_TO_GET_LICENSE_BY_S_N = res.getString("Unable_to_get_license");
    protected static final String MSG_UNABLE_TO_GET_LICENSE_BY_S_N_TRY_AGAIN = MSG_UNABLE_TO_GET_LICENSE_BY_S_N + "\n" + MSG_TRY_AGAIN;
    protected static final String MSG_INVALID_S_N = res.getString("Invalid_S_N");
    protected WizardPane fFinishWizardPane;

    public LicensingServerWizardPane getLicensingServerWizardPane() {
        return this.fLicensingServerWizardPane;
    }

    public LicensingWizardProgressPane getLicensingWizardProgressPane() {
        return this.fLicensingWizardProgressPane;
    }

    public SerialNumberCustomerWizardPane getSerialNumberCustomerWizardPane() {
        return this.fSerialNumberCustomerWizardPane;
    }

    public SerialNumberWizardPane getSerialNumberWizardPane() {
        return this.fSerialNumberWizardPane;
    }

    public InternetConnectionWizardPane getInternetConnectionWizardPane() {
        return this.fInternetConnectionWizardPane;
    }

    public RequestEvaluationWizardPane getRequestEvaluationWizardPane() {
        return this.fRequestEvaluationWizardPane;
    }

    public CustomWizardPane getCustomWizardPane() {
        return this.fCustomWizardPane;
    }

    public LicensingWizardPro(Component anOwner) {
        super(anOwner);
        this.fRequestEvaluationWizardPane = new RequestEvaluationWizardPane();
        this.fRequestEvaluationWizardPane.setNextPaneName("InternetConnectionWizardPane");
        this.addWizardPane(this.fRequestEvaluationWizardPane);
        this.fInternetConnectionWizardPane = new InternetConnectionWizardPane();
        this.addWizardPane(this.fInternetConnectionWizardPane);
        this.fSerialNumberWizardPane = new SerialNumberWizardPane();
        this.addWizardPane(this.fSerialNumberWizardPane);
        this.fLicensingServerWizardPane = new LicensingServerWizardPane();
        this.addWizardPane(this.fLicensingServerWizardPane);
        this.fMessageWizardPane = new MessageWizardPane();
        this.addWizardPane(this.fMessageWizardPane);
        this.fLicensingWizardPane.setRequestEvalEnabled(true);
        this.fLicensingWizardPane.setEnterSerialNumberEnabled(true);
        this.fSerialNumberCustomerWizardPane = new SerialNumberCustomerWizardPane();
        this.addWizardPane(this.fSerialNumberCustomerWizardPane);
        this.fLicensingWizardProgressPane = new LicensingWizardProgressPane();
        this.addWizardPane(this.fLicensingWizardProgressPane);
        this.fLicensingWizardProgressPane.addOperation(this.fInitOperation);
        this.fLicensingWizardProgressPane.addOperation(this.fGetOperation);
        this.fLicensingWizardProgressPane.addOperation(this.fSaveLicenseOperation);
        this.fCustomWizardPane = new CustomWizardPane();
        this.addWizardPane(this.fCustomWizardPane);
        UIUtils.applyComponentOrientation(this);
    }

    public LicensingWizardPro() {
        this((Component)null);
    }

    protected boolean isShowCustomPane(int aSelectedOperation) {
        boolean result = false;
        switch (aSelectedOperation) {
            case 2: {
                result = true;
            }
        }
        return result;
    }

    public boolean isShowCustomPane() {
        return this.fShowCustomPane;
    }

    public void setShowCustomPane(boolean aValue) {
        this.fShowCustomPane = aValue;
    }

    protected boolean isNeedShowCustomPane() {
        return this.isShowCustomPane() && this.isShowCustomPane(this.getLicensingWizardPane().getSelectedOperation());
    }

    protected String doNext() {
        String result = super.doNext();
        if (!"-none-".equals(result) && this.fActiveWizardPane instanceof CustomerWizardPane && this.isNeedShowCustomPane()) {
            result = "CustomWizardPane";
        }
        return result;
    }

    protected boolean canFinish() {
        boolean result = super.canFinish();
        if (result && this.fActiveWizardPane instanceof CustomerWizardPane && this.isNeedShowCustomPane()) {
            result = false;
        }
        return result;
    }

    protected Preferences getPreferences() {
        String name = this.getProductInfo().getShortName();
        if (name == null) {
            name = this.getProductInfo().getName();
        }
        Preferences prefs = Preferences.userRoot().node(name);
        return prefs;
    }

    public void setProductInfo(ProductInfo aProductInfo) {
        super.setProductInfo(aProductInfo);
        if (this.fProductInfo != null) {
            this.fInternetConnectionWizardPane.setPreferences(this.getPreferences().node("httpProxy"));
        }
    }

    public LicensingFacadeResult getRequestResult() {
        return this.fRequestResult;
    }

    protected boolean saveLicense(byte[] licenseBytes) {
        boolean result = super.saveLicense(licenseBytes);
        if (!result) {
            this.fRequestResult = null;
        }
        return result;
    }

    protected LicenseDescr getLicenseDescr() {
        ProductInfo productInfo = this.getProductInfo();
        LicenseDescr result = new LicenseDescr();
        result.setProductMajorVersion(productInfo.getMajorVersion());
        result.setProductMinorVersion(productInfo.getMinorVersion());
        result.setProduct(productInfo.getID());
        result.setProductEdition(productInfo.getEdition());
        result.setLicenseType(this.isRequestExtEvaluation() ? 2 : 1);
        return result;
    }

    public String getLogin() {
        return this.fLogin;
    }

    public void setLogin(String aLogin) {
        this.fLogin = aLogin;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public void setPassword(String aPassword) {
        this.fPassword = aPassword;
    }

    public HashMap getArguments() {
        return this.fArguments;
    }

    public void setArguments(HashMap aArguments) {
        this.fArguments = aArguments;
    }

    public void requestEvaluation() {
        boolean result = false;
        this.fRequestResult = null;
        byte[] licenseBytes = null;
        try {
            this.fRequestResult = null;
            Customer customer = this.fRequestEvaluationWizardPane.getCustomer();
            LicensingFacade licensingFacade = this.getLicensingFacade();
            this.fGetOperation.setStatus(2);
            try {
                Map arguments = this.getArguments();
                if (this.isShowCustomPane()) {
                    if (arguments == null) {
                        arguments = this.fCustomWizardPane.getValues();
                    } else {
                        arguments.putAll(this.fCustomWizardPane.getValues());
                    }
                }
                this.fRequestResult = licensingFacade.getLicense(this.getLicenseDescr(), customer, this.getLogin(), this.getPassword(), arguments);
                this.fGetOperation.setStatus(3);
            }
            catch (Exception ex) {
                this.fGetOperation.setStatus(4);
                throw ex;
            }
            if (this.fRequestResult != null) {
                if (this.fRequestResult.getResult() == 1) {
                    licenseBytes = this.fRequestResult.getLicenseBytes();
                } else {
                    this.error(MSG_UNABLE_TO_GET_EVAL + "\n" + this.fRequestResult.getMessage());
                }
            } else {
                this.error(MSG_UNABLE_TO_GET_EVAL_TRY_AGAIN);
            }
        }
        catch (NestedException ne) {
            this.error(ne);
            if (ne.getNestedException() instanceof ConnectException || ne.getNestedException() instanceof java.rmi.ConnectException) {
                this.error(MSG_UNABLE_TO_GET_EVAL + "\n" + ne.getMessage() + "\n" + MSG_TRY_AGAIN);
            } else {
                this.error(MSG_UNABLE_TO_GET_EVAL_TRY_AGAIN);
            }
        }
        catch (Throwable ex) {
            this.error(ex);
            this.error(MSG_UNABLE_TO_GET_EVAL_TRY_AGAIN);
        }
        if (licenseBytes != null) {
            this.saveLicense(licenseBytes);
        }
    }

    public LicenseHostPro getLicenseHost() {
        return this.fLicenseHost;
    }

    public void setLicenseHost(LicenseHostPro aLicenseHost) {
        this.fLicenseHost = aLicenseHost;
    }

    protected HashMap prepareArguments(String aSerialNumber) {
        HashMap<String, String> result = this.getArguments();
        if (this.fLicenseHost != null) {
            if (result == null) {
                result = new HashMap<String, String>();
            }
            result.put("$activationKey$", this.fLicenseHost.getActivationKey(aSerialNumber));
            result.put("$activationLockKey$", this.fLicenseHost.getActivationLockKey(aSerialNumber));
        }
        return result;
    }

    public boolean requestLicenseBySerialNumber() {
        boolean result = false;
        this.fRequestResult = null;
        byte[] licenseBytes = null;
        try {
            this.fRequestResult = null;
            Customer customer = this.fSerialNumberCustomerWizardPane.getCustomer();
            LicensingFacade licensingFacade = this.getLicensingFacade();
            this.fGetOperation.setStatus(2);
            try {
                String serialNumber = this.fSerialNumberWizardPane.getSerialNumber();
                this.fRequestResult = licensingFacade.getLicense(serialNumber, customer, this.getLogin(), this.getPassword(), (Map)this.prepareArguments(serialNumber));
                this.fGetOperation.setStatus(3);
            }
            catch (Throwable ex) {
                this.fGetOperation.setStatus(4);
                throw ex;
            }
            if (this.fRequestResult != null) {
                if (this.fRequestResult.getResult() == 1) {
                    licenseBytes = this.fRequestResult.getLicenseBytes();
                    result = licenseBytes != null;
                } else {
                    this.error(MSG_UNABLE_TO_GET_LICENSE_BY_S_N + "\n" + this.fRequestResult.getMessage());
                }
            } else {
                this.error(MSG_UNABLE_TO_GET_LICENSE_BY_S_N_TRY_AGAIN);
            }
        }
        catch (NestedException ne) {
            this.error(ne);
            if (ne.getMessage().indexOf("SerialNumberException:") != -1) {
                this.error(MSG_INVALID_S_N);
                this.fFinishWizardPane = this.fSerialNumberWizardPane;
            } else if (ne.getNestedException() instanceof ConnectException || ne.getNestedException() instanceof java.rmi.ConnectException) {
                this.error(MSG_UNABLE_TO_GET_LICENSE_BY_S_N + "\n" + ne.getMessage() + "\n" + MSG_TRY_AGAIN);
            } else {
                this.error(MSG_UNABLE_TO_GET_LICENSE_BY_S_N_TRY_AGAIN);
            }
        }
        catch (Throwable ex) {
            this.error(ex);
            this.error(MSG_UNABLE_TO_GET_LICENSE_BY_S_N_TRY_AGAIN);
        }
        if (licenseBytes != null) {
            this.saveLicense(licenseBytes);
        }
        return result;
    }

    protected int doFinish() {
        boolean result = false;
        if (this.fActiveWizardPane instanceof RequestEvaluationWizardPane || this.fActiveWizardPane instanceof InternetConnectionWizardPane || this.fActiveWizardPane instanceof SerialNumberWizardPane || this.fActiveWizardPane instanceof SerialNumberCustomerWizardPane || this.fActiveWizardPane instanceof LicensingServerWizardPane || this.fActiveWizardPane instanceof CustomWizardPane) {
            boolean bl = result = this.fActiveWizardPane.finish() == 1;
            if (result) {
                this.fFinishWizardPane = this.fActiveWizardPane;
                this.fLicensingWizardProgressPane.setBackPaneName(this.fActiveWizardPane.getName());
                this.setActiveWizardPane(this.fLicensingWizardProgressPane);
                result = false;
            }
        } else {
            result = super.doFinish() == 1;
        }
        return result ? 1 : 0;
    }

    public void processRequestResult() {
        Object result;
        byte[] licenseBytes = null;
        boolean isOK = false;
        if (this.getLicensingWizardPane().getSelectedOperation() == 5) {
            result = this.fLicenseHost.getLicensingServiceSupport().getObtainLicenseResult();
            if (result != null && result.getResult() == 1) {
                isOK = true;
                if (result instanceof LicensingServiceResult.LicenseResult) {
                    licenseBytes = ((LicensingServiceResult.LicenseResult)result).getResponse().getLicenseBytes();
                }
            }
        } else {
            result = this.getRequestResult();
            if (result != null && ((LicensingFacadeResultBase)result).getResult() == 1) {
                isOK = true;
                licenseBytes = ((LicensingFacadeResult)result).getLicenseBytes();
            }
        }
        result = this.getRequestResult();
        if (isOK) {
            if (licenseBytes == null) {
                this.initMessagePane(this.fMessageWizardPane, (LicensingFacadeResult)result);
                this.fMessageWizardPane.setBackPaneName(this.fActiveWizardPane.getBackPaneName());
                this.setActiveWizardPane(this.fMessageWizardPane);
            } else {
                this.setModalResult(1);
                this.setVisible(false);
            }
        } else if (this.fFinishWizardPane != null) {
            this.setActiveWizardPane(this.fFinishWizardPane);
        }
    }

    public boolean isSkipCustomerInfoForSerialNumbers() {
        return BitTools.checkBit(this.getOptions(), 1);
    }

    public void setSkipCustomerInfoForSerialNumbers(boolean aSkipCustomerInfoForSerialNumbers) {
        this.setOptions(BitTools.toggleBit(this.getOptions(), 1, aSkipCustomerInfoForSerialNumbers));
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLicenseFromLS() {
        this.fInitOperation.setStatus(2);
        LicensingServiceSupport support = this.fLicenseHost.getLicensingServiceSupport();
        LicensingServiceProvider provider = support.createLicensingServiceProvider(this.fLicensingServerWizardPane.getLicensingServer());
        try {
            LicensingService service = support.createLicensingService(provider);
            try {
                this.fInitOperation.setStatus(3);
            }
            catch (RuntimeException ex) {
                this.fInitOperation.setStatus(4);
                this.error(LicensingServiceSupport.createResult(ex));
            }
            if (service != null) {
                this.fGetOperation.setStatus(2);
                if (support.obtainLicense(service, this.getProductInfo())) {
                    this.fGetOperation.setStatus(3);
                    byte[] licenseBytes = support.getObtainedLicenseBytes();
                    if (licenseBytes != null) {
                        this.saveLicense(licenseBytes);
                    }
                } else {
                    this.fGetOperation.setStatus(4);
                    this.error(support.getObtainLicenseResult());
                }
            }
        }
        catch (Throwable ex) {
            this.error(LicensingServiceSupport.getUserMessage(ex));
        }
        finally {
            if (provider != null) {
                provider.release();
            }
        }
    }

    protected void error(LicensingServiceResult aResult) {
        String message = this.getMessage(aResult);
        this.error(message != null ? message : res.getString("No_license_allocated"));
    }

    protected String getMessage(LicensingServiceResult aResult) {
        return aResult.getResult() == 3 ? res.getString("Unable_to_obtain_ls") + " " + res.getString("Try_again") : aResult.getMessage();
    }

    public void request() {
        switch (this.getLicensingWizardPane().getSelectedOperation()) {
            case 2: {
                this.requestEvaluation();
                break;
            }
            case 3: {
                this.requestLicenseBySerialNumber();
                break;
            }
            case 5: {
                this.requestLicenseFromLS();
            }
        }
    }

    public boolean executeModal() {
        if (this.fLicenseHost != null) {
            this.fLicensingServerWizardPane.setLicensingServer(this.fLicenseHost.getLicensingServiceSupport().getLicensingServerAddress());
        }
        return super.executeModal();
    }
}

