/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs.pro;

import com.jp.protection.gui.dialogs.BasicLicenseWizard;
import com.jp.protection.gui.dialogs.pro.panes.LicenseLockProgressPane;
import com.jp.protection.gui.dialogs.pro.panes.LicenseLockWizardPane;
import com.jp.protection.gui.dialogs.pro.panes.LicensingServerWizardPane;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.pro.LicenseHostPro;
import com.jp.protection.pub.pro.LicensingServiceSupport;
import com.jp.protection.pub.pro.lserver.LicensingService;
import com.jp.protection.pub.pro.lserver.LicensingServiceResult;
import dev.gui.ResourceUtils;
import dev.gui.UIUtils;
import dev.gui.wizard.InternetConnectionWizardPane;
import dev.gui.wizard.MessageWizardPane;
import dev.gui.wizard.ProgressWizardPane;
import dev.gui.wizard.WizardPane;
import dev.lang.BitTools;
import java.awt.Component;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JPanel;

public class LicenseLockWizard
extends BasicLicenseWizard {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.pro.Res");
    protected LicenseLockWizardPane fLicenseLockWizardPane;
    protected InternetConnectionWizardPane fInternetConnectionWizardPane;
    protected MessageWizardPane fMessageWizardPane;
    protected LicensingServerWizardPane fLicensingServerWizardPane;
    protected LicenseLockProgressPane fLicenseLockProgressPane;
    protected static final Icon WIZARD_ICON = ResourceUtils.loadImageIcon(class$com$jp$protection$gui$dialogs$pro$LicenseLockWizard == null ? (class$com$jp$protection$gui$dialogs$pro$LicenseLockWizard = LicenseLockWizard.class$("com.jp.protection.gui.dialogs.pro.LicenseLockWizard")) : class$com$jp$protection$gui$dialogs$pro$LicenseLockWizard, "res/Activation Wizard.png");
    protected ProgressWizardPane.Operation fInitConnectionOperation = new ProgressWizardPane.Operation(res.getString("InitConn_OP_Name"), res.getString("InitConn_OP_Descr"));
    protected ProgressWizardPane.Operation fConnectingOperation = new ProgressWizardPane.Operation(res.getString("Conn_OP_Name"), res.getString("Conn_OP_Descr"));
    protected ProgressWizardPane.Operation fCanLockOperation = new ProgressWizardPane.Operation(res.getString("CanLock_OP_Name"), res.getString("CanLock_OP_Descr"));
    protected ProgressWizardPane.Operation fAcquiringLockOperation = new ProgressWizardPane.Operation(res.getString("AcqLock_OP_Name"), res.getString("AcqLock_OP_Descr"));
    protected ProgressWizardPane.Operation fWaitingOperation = new ProgressWizardPane.Operation(res.getString("Wait_OP_Name"), res.getString("Wait_OP_Descr"));
    protected LicenseHostPro fLicenseHost;
    protected WizardPane fFinishWizardPane;
    public static final int OPTION_TRY_AGAIN = 1;
    public static final int OPTION_WAIT = 2;
    public static final int OPTION_CHOOSE_LS = 4;
    public static final int DEFAULT_OPTIONS = 3;
    protected boolean fLockLicenseResult = false;
    public static final int SLEEP_DECORATION = 700;
    public static final int SLEEP_NEXT_TRY = 25000;
    public static final int SLEEP_NEXT_TRY_PERIOD = 1000;
    static /* synthetic */ Class class$com$jp$protection$gui$dialogs$pro$LicenseLockWizard;

    public LicenseLockWizard(Component anOwner) {
        super(anOwner);
        this.init();
        ((JPanel)this.getContentPane()).putClientProperty("topicID", "lock_assistant");
    }

    public LicenseLockWizard() {
        this((Component)null);
    }

    protected Preferences getPreferences() {
        String name = this.getProductInfo().getShortName();
        if (name == null) {
            name = this.getProductInfo().getName();
        }
        Preferences prefs = Preferences.userRoot().node(name);
        return prefs;
    }

    public void setProductInfo(ProductInfo aProductInfo) {
        super.setProductInfo(aProductInfo);
        if (this.fProductInfo != null) {
            this.setTitle(this.fProductInfo.getShortName() + " - " + res.getString("License_Lock"));
            this.fInternetConnectionWizardPane.setPreferences(this.getPreferences().node("httpProxy"));
        }
    }

    public InternetConnectionWizardPane getInternetConnectionWizardPane() {
        return this.fInternetConnectionWizardPane;
    }

    public LicenseLockWizardPane getLicenseLockWizardPane() {
        return this.fLicenseLockWizardPane;
    }

    public LicenseLockProgressPane getLicenseLockProgressPane() {
        return this.fLicenseLockProgressPane;
    }

    private void init() {
        this.setTitle(res.getString("License_Lock"));
        this.setWizardIcon(WIZARD_ICON);
        this.fLicenseLockWizardPane = new LicenseLockWizardPane();
        this.addWizardPane(this.fLicenseLockWizardPane);
        this.fLicensingServerWizardPane = new LicensingServerWizardPane(){

            public int finish() {
                int result = super.finish();
                if (result == 1) {
                    LicenseLockWizard.this.fLicenseHost.getLicensingServiceSupport().setLicensingServerAddress(this.getLicensingServer());
                }
                return result;
            }

            public String next() {
                String result = super.next();
                if (result != "-none-") {
                    LicenseLockWizard.this.fLicenseHost.getLicensingServiceSupport().setLicensingServerAddress(this.getLicensingServer());
                }
                return result;
            }
        };
        this.addWizardPane(this.fLicensingServerWizardPane);
        this.fInternetConnectionWizardPane = new InternetConnectionWizardPane();
        this.addWizardPane(this.fInternetConnectionWizardPane);
        this.fMessageWizardPane = new MessageWizardPane();
        this.addWizardPane(this.fMessageWizardPane);
        this.fLicenseLockProgressPane = new LicenseLockProgressPane();
        this.fLicenseLockProgressPane.addOperation(this.fInitConnectionOperation);
        this.fLicenseLockProgressPane.addOperation(this.fConnectingOperation);
        this.fLicenseLockProgressPane.addOperation(this.fCanLockOperation);
        this.fLicenseLockProgressPane.addOperation(this.fAcquiringLockOperation);
        this.fLicenseLockProgressPane.addOperation(this.fWaitingOperation);
        this.addWizardPane(this.fLicenseLockProgressPane);
        UIUtils.applyComponentOrientation(this);
    }

    public LicenseHostPro getLicenseHost() {
        return this.fLicenseHost;
    }

    public void setLicenseHost(LicenseHostPro aLicenseHost) {
        this.fLicenseHost = aLicenseHost;
    }

    public LicenseReader getLicenseReader() {
        return this.fLicenseHost != null ? this.fLicenseHost.getLicenseReader() : super.getLicenseReader();
    }

    public boolean executeModal() {
        this.fLockLicenseResult = false;
        this.setActiveWizardPane(this.fLicenseLockWizardPane);
        this.fLicensingServerWizardPane.setLicensingServer(this.fLicenseHost.getLicensingServiceSupport().getLicensingServerAddress());
        return super.executeModal();
    }

    public int getOptions() {
        return this.fLicenseLockWizardPane.getOptions();
    }

    public void setOptions(int anOptions) {
        this.fLicenseLockWizardPane.setOptions(anOptions);
    }

    public String getIssueDescription() {
        return this.fLicenseLockWizardPane.getIssueDescription();
    }

    public void setIssueDescription(String aDescription) {
        this.fLicenseLockWizardPane.setIssueDescription(aDescription);
    }

    public String getIssueName() {
        return this.fLicenseLockWizardPane.getIssueName();
    }

    public void setIssueName(String aName) {
        this.fLicenseLockWizardPane.setIssueName(aName);
    }

    protected int doFinish() {
        boolean result = false;
        if (this.fActiveWizardPane instanceof LicenseLockWizardPane || this.fActiveWizardPane instanceof InternetConnectionWizardPane || this.fActiveWizardPane instanceof LicensingServerWizardPane) {
            boolean bl = result = this.fActiveWizardPane.finish() == 1;
            if (result) {
                this.fFinishWizardPane = this.fActiveWizardPane;
                switch (this.fLicenseLockWizardPane.getSelectedOption()) {
                    case 1: {
                        this.fWaitingOperation.setVisible(false);
                        this.fCanLockOperation.setVisible(false);
                        break;
                    }
                    case 2: {
                        this.fWaitingOperation.setVisible(false);
                        this.fCanLockOperation.setVisible(true);
                    }
                }
                this.fLockLicenseResult = false;
                this.fLicenseLockProgressPane.setBackPaneName(this.fActiveWizardPane.getName());
                this.setActiveWizardPane(this.fLicenseLockProgressPane);
                result = false;
            }
        } else {
            result = super.doFinish() == 1;
        }
        return result ? 1 : 0;
    }

    public void processLockLicenseResult() {
        if (this.fLockLicenseResult) {
            this.setModalResult(1);
            this.setVisible(false);
        } else if (this.fFinishWizardPane != null) {
            this.setActiveWizardPane(this.fFinishWizardPane);
        }
    }

    protected void tryOnce() {
        this.fInitConnectionOperation.setStatus(2);
        LicensingServiceSupport support = this.fLicenseHost.getLicensingServiceSupport();
        this.fInitConnectionOperation.setStatus(3);
        this.fConnectingOperation.setStatus(2);
        LicensingService service = null;
        try {
            support.release();
            service = support.getLicensingService();
        }
        catch (RuntimeException ex) {
            this.fConnectingOperation.setStatus(4);
            support.setLockResult(LicensingServiceSupport.createResult(ex));
            this.error(support.getLockResult());
        }
        if (service != null) {
            this.fConnectingOperation.setStatus(3);
            this.fAcquiringLockOperation.setStatus(2);
            if (support.lockLicense(false)) {
                this.fAcquiringLockOperation.setStatus(3);
                this.fLockLicenseResult = true;
            } else {
                this.fAcquiringLockOperation.setStatus(4);
                this.error(support.getLockResult());
            }
        }
    }

    protected void error(LicensingServiceResult aResult) {
        this.error(this.getMessage(aResult));
    }

    protected String getMessage(LicensingServiceResult aResult) {
        return aResult.getResult() == 3 ? res.getString("LicenseLockWizard_SystemError") + " " + res.getString("Try_again") : aResult.getMessage();
    }

    protected void tryWait() {
        block11: {
            this.fInitConnectionOperation.setStatus(2);
            LicensingServiceSupport support = this.fLicenseHost.getLicensingServiceSupport();
            this.fInitConnectionOperation.setStatus(3);
            String sec = res.getString("Sec");
            try {
                while (true) {
                    this.fConnectingOperation.setStatus(2);
                    LicensingService service = null;
                    try {
                        support.release();
                        service = support.getLicensingService();
                    }
                    catch (RuntimeException ex) {
                        this.fConnectingOperation.setStatus(4);
                        support.setLockResult(LicensingServiceSupport.createResult(ex));
                    }
                    if (service != null) {
                        this.fConnectingOperation.setStatus(3);
                        this.fCanLockOperation.setStatus(2);
                        LicensingServiceResult canLockResult = support.canLockLicense();
                        if (canLockResult.getResult() == 1) {
                            this.fCanLockOperation.setStatus(3);
                            this.fAcquiringLockOperation.setStatus(2);
                            if (support.lockLicense(false)) {
                                this.fAcquiringLockOperation.setStatus(3);
                                this.fLockLicenseResult = true;
                                break block11;
                            }
                            Thread.currentThread();
                            Thread.sleep(700L);
                            this.fAcquiringLockOperation.setStatus(4);
                            this.fAcquiringLockOperation.setStatusText(this.getMessage(support.getLockResult()));
                        } else {
                            Thread.currentThread();
                            Thread.sleep(700L);
                            this.fCanLockOperation.setStatus(4);
                            this.fCanLockOperation.setStatusText(this.getMessage(canLockResult));
                            this.fAcquiringLockOperation.setStatus(4);
                        }
                    } else {
                        this.fConnectingOperation.setStatus(4);
                        this.fConnectingOperation.setStatusText(this.getMessage(support.getLockResult()));
                        this.fCanLockOperation.setStatus(4);
                        this.fAcquiringLockOperation.setStatus(4);
                    }
                    this.fWaitingOperation.setVisible(true);
                    this.fWaitingOperation.setStatus(2);
                    int tickCount = 25;
                    for (int i = 0; i < tickCount; ++i) {
                        this.fWaitingOperation.setStatusText(25000 / tickCount * (tickCount - i) / 1000 + " " + sec);
                        Thread.currentThread();
                        Thread.sleep(25000 / tickCount);
                    }
                    this.fWaitingOperation.setStatus(1);
                    this.fWaitingOperation.setVisible(false);
                    this.fConnectingOperation.setStatus(1);
                    this.fConnectingOperation.setStatusText(null);
                    this.fCanLockOperation.setStatus(1);
                    this.fCanLockOperation.setStatusText(null);
                    this.fAcquiringLockOperation.setStatus(1);
                    this.fAcquiringLockOperation.setStatusText(null);
                }
            }
            catch (Exception ex) {}
            {
            }
        }
    }

    public boolean isLicensingServerAddressKnown() {
        return this.fLicenseHost.getLicensingServiceSupport().isLicensingServerAddressKnown();
    }

    public void lockLicense() {
        switch (this.fLicenseLockWizardPane.getSelectedOption()) {
            case 1: {
                this.tryOnce();
                break;
            }
            case 2: {
                this.tryWait();
            }
        }
        this.fFinishWizardPane = this.isLicensingServerAddressKnown() || !BitTools.checkBit(this.getOptions(), 4) ? this.fLicenseLockWizardPane : this.fLicensingServerWizardPane;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

