/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs.pro;

import com.jp.protection.gui.dialogs.BasicLicenseWizard;
import com.jp.protection.gui.dialogs.pro.panes.LicenseDeactivationProgressPane;
import com.jp.protection.gui.dialogs.pro.panes.LicenseDeactivationWizardPane;
import com.jp.protection.gui.dialogs.pro.panes.NotifyVendorDeactivationWizardPane;
import com.jp.protection.gui.dialogs.pro.panes.OfflineDeactivationWizardPane;
import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.pro.LicenseHostPro;
import com.jp.protection.pub.pro.integration.LicensingFacade;
import com.jp.protection.pub.pro.integration.LicensingFacadeResult;
import dev.gui.ResourceUtils;
import dev.gui.UIUtils;
import dev.gui.wizard.InternetConnectionWizardPane;
import dev.gui.wizard.ProgressWizardPane;
import dev.gui.wizard.WizardPane;
import dev.lang.NestedException;
import java.awt.Component;
import java.net.ConnectException;
import java.util.ResourceBundle;
import javax.swing.Icon;

public class LicenseDeactivationWizard
extends BasicLicenseWizard {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.pro.Res");
    protected static final Icon WIZARD_ICON = ResourceUtils.loadImageIcon(class$com$jp$protection$gui$dialogs$pro$LicenseActivationWizard == null ? (class$com$jp$protection$gui$dialogs$pro$LicenseActivationWizard = LicenseDeactivationWizard.class$("com.jp.protection.gui.dialogs.pro.LicenseActivationWizard")) : class$com$jp$protection$gui$dialogs$pro$LicenseActivationWizard, "res/Activation Wizard.png");
    protected LicenseDeactivationWizardPane fLicenseDeactivationWizardPane;
    protected NotifyVendorDeactivationWizardPane fNotifyVendorDeactivationWizardPane;
    protected InternetConnectionWizardPane fInternetConnectionWizardPane;
    protected OfflineDeactivationWizardPane fOfflineDeactivationWizardPane;
    protected LicenseDeactivationProgressPane fLicenseDeactivationProgressPane;
    protected ProgressWizardPane.Operation fDeactivateOperation = new ProgressWizardPane.Operation(res.getString("Deactivate_OP_Name"), res.getString("Deactivate_OP_Descr"));
    protected LicenseHostPro fLicenseHost;
    public static final int OPTION_DEACTIVATE_ONLINE = 1;
    public static final int OPTION_DEACTIVATE_OFFLINE = 2;
    public static final int OPTION_NOTIFY_VENDOR_ON_FAIL = 4;
    public static final int DEFAULT_OPTIONS = 3;
    protected int fOptions = 3;
    protected String fDeactivationKey = res.getString("NA");
    protected static final String MSG_UNABLE_TO_DEACTIVATE = res.getString("Unable_to_notify");
    protected static final String MSG_TRY_AGAIN = res.getString("Try_again");
    protected static final String MSG_UNABLE_TO_DEACTIVATE_TRY_AGAIN = MSG_UNABLE_TO_DEACTIVATE + "\n" + MSG_TRY_AGAIN;
    protected String fLogin;
    protected String fPassword;
    protected LicensingFacadeResult fDeactivationResult;
    protected WizardPane fFinishWizardPane;
    public static final int DEACTIVATE_FAIL = 0;
    public static final int DEACTIVATE_LOCAL = 1;
    public static final int DEACTIVATE_LOCAL_VENDOR = 2;
    static /* synthetic */ Class class$com$jp$protection$gui$dialogs$pro$LicenseActivationWizard;

    public InternetConnectionWizardPane getInternetConnectionWizardPane() {
        return this.fInternetConnectionWizardPane;
    }

    public LicenseDeactivationWizardPane getLicenseDeactivationWizardPane() {
        return this.fLicenseDeactivationWizardPane;
    }

    public NotifyVendorDeactivationWizardPane getNotifyVendorDeactivationWizardPane() {
        return this.fNotifyVendorDeactivationWizardPane;
    }

    public OfflineDeactivationWizardPane getOfflineDeactivationWizardPane() {
        return this.fOfflineDeactivationWizardPane;
    }

    public LicenseDeactivationWizard(Component anOwner) {
        super(anOwner);
        this.init();
    }

    public LicenseDeactivationWizard() {
        this((Component)null);
    }

    private void init() {
        this.setTitle(res.getString("License_Deactivation"));
        this.setWizardIcon(WIZARD_ICON);
        this.fLicenseDeactivationWizardPane = new LicenseDeactivationWizardPane();
        this.fLicenseDeactivationWizardPane.setNextPaneName("LicenseDeactivationWizardNotifyVendorPane");
        this.addWizardPane(this.fLicenseDeactivationWizardPane);
        this.fNotifyVendorDeactivationWizardPane = new NotifyVendorDeactivationWizardPane();
        this.addWizardPane(this.fNotifyVendorDeactivationWizardPane);
        this.fInternetConnectionWizardPane = new InternetConnectionWizardPane();
        this.addWizardPane(this.fInternetConnectionWizardPane);
        this.fOfflineDeactivationWizardPane = new OfflineDeactivationWizardPane();
        this.addWizardPane(this.fOfflineDeactivationWizardPane);
        this.fLicenseDeactivationProgressPane = new LicenseDeactivationProgressPane();
        this.addWizardPane(this.fLicenseDeactivationProgressPane);
        this.fLicenseDeactivationProgressPane.addOperation(this.fInitOperation);
        this.fLicenseDeactivationProgressPane.addOperation(this.fDeactivateOperation);
        this.setOptions(3);
        UIUtils.applyComponentOrientation(this);
    }

    public void setProductInfo(ProductInfo aProductInfo) {
        super.setProductInfo(aProductInfo);
        this.setTitle(aProductInfo.getShortName() + " - " + res.getString("License_Deactivation"));
        this.fOfflineDeactivationWizardPane.setProductInfo(aProductInfo);
    }

    public LicenseHostPro getLicenseHost() {
        return this.fLicenseHost;
    }

    public void setLicenseHost(LicenseHostPro aLicenseHost) {
        this.fLicenseHost = aLicenseHost;
    }

    public LicenseReader getLicenseReader() {
        return this.fLicenseHost != null ? this.fLicenseHost.getLicenseReader() : super.getLicenseReader();
    }

    public boolean executeModal() {
        this.setActiveWizardPane(this.fLicenseDeactivationWizardPane);
        return super.executeModal();
    }

    public int getOptions() {
        return this.fOptions;
    }

    public void setOptions(int aOptions) {
        this.fOptions = aOptions;
        this.fLicenseDeactivationWizardPane.setOptions(this.fOptions);
        this.fNotifyVendorDeactivationWizardPane.setOptions(this.fOptions);
    }

    public String getDeactivationKey() {
        return this.fDeactivationKey;
    }

    public void setDeactivationKey(String aDeactivationKey) {
        this.fDeactivationKey = aDeactivationKey;
    }

    public String getLogin() {
        return this.fLogin;
    }

    public void setLogin(String aLogin) {
        this.fLogin = aLogin;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public void setPassword(String aPassword) {
        this.fPassword = aPassword;
    }

    public LicensingFacadeResult getDeactivationResult() {
        return this.fDeactivationResult;
    }

    protected int doFinish() {
        boolean result = false;
        if (this.fActiveWizardPane instanceof NotifyVendorDeactivationWizardPane || this.fActiveWizardPane instanceof InternetConnectionWizardPane) {
            boolean bl = result = this.fActiveWizardPane.finish() == 1;
            if (result) {
                this.fFinishWizardPane = this.fActiveWizardPane;
                this.setActiveWizardPane(this.fLicenseDeactivationProgressPane);
                result = false;
            }
        } else {
            result = super.doFinish() == 1;
        }
        return result ? 1 : 0;
    }

    public void processDeactivationResult() {
        LicensingFacadeResult result = this.getDeactivationResult();
        if (result != null && result.getResult() == 1) {
            this.setModalResult(1);
            this.setVisible(false);
        } else if (this.fFinishWizardPane != null) {
            this.setActiveWizardPane(this.fFinishWizardPane);
        }
    }

    public void deactivateOnline() {
        try {
            LicensingFacade licensingFacade = this.getLicensingFacade();
            License license = this.getLicenseHost().getLicense();
            this.fDeactivateOperation.setStatus(2);
            try {
                this.fDeactivationResult = licensingFacade.deactivateLicense(this.fLicenseHost.getLicenseReader().getLicenseBytes(), this.getDeactivationKey(), this.fLogin, this.fPassword, null);
                this.fDeactivateOperation.setStatus(3);
            }
            catch (Throwable ex) {
                this.fDeactivateOperation.setStatus(4);
                throw ex;
            }
            if (this.fDeactivationResult != null) {
                if (this.fDeactivationResult.getResult() != 1) {
                    this.error(this.fDeactivationResult.getMessage());
                }
            } else {
                this.error(MSG_UNABLE_TO_DEACTIVATE_TRY_AGAIN);
            }
        }
        catch (NestedException ne) {
            this.error(ne);
            if (ne.getNestedException() instanceof ConnectException || ne.getNestedException() instanceof java.rmi.ConnectException) {
                this.error(MSG_UNABLE_TO_DEACTIVATE + "\n" + ne.getMessage() + "\n" + MSG_TRY_AGAIN);
            } else {
                this.error(MSG_UNABLE_TO_DEACTIVATE_TRY_AGAIN);
            }
        }
        catch (Throwable ex) {
            this.error(ex);
            this.error(MSG_UNABLE_TO_DEACTIVATE_TRY_AGAIN);
        }
    }

    public int execute() {
        int result = 0;
        if (this.fLicenseHost.canDeactivateLicense()) {
            boolean localDeactivated;
            boolean vendorDeactivated = this.executeModal();
            boolean bl = localDeactivated = this.fLicenseHost.getLicense(false).getLicenseState() == 5;
            if (vendorDeactivated && localDeactivated) {
                result = 2;
            } else if (localDeactivated) {
                result = 1;
            }
        } else {
            LicenseDeactivationWizard.error(this, res.getString("No_Need_Deactivate"));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

