/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs.pro;

import com.jp.protection.gui.dialogs.BasicLicenseWizard;
import com.jp.protection.gui.dialogs.panes.LicenseLocationWizardPane;
import com.jp.protection.gui.dialogs.pro.panes.LicenseActivationProgressPane;
import com.jp.protection.gui.dialogs.pro.panes.LicenseActivationWizardPane;
import com.jp.protection.gui.dialogs.pro.panes.OfflineActivationWizardPane;
import com.jp.protection.gui.dialogs.pro.panes.OnlineActivationWizardPane;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.pro.LicenseHostPro;
import com.jp.protection.pub.pro.integration.LicensingFacade;
import com.jp.protection.pub.pro.integration.LicensingFacadeResult;
import dev.entities.Customer;
import dev.gui.ResourceUtils;
import dev.gui.UIUtils;
import dev.gui.wizard.InternetConnectionWizardPane;
import dev.gui.wizard.MessageWizardPane;
import dev.gui.wizard.ProgressWizardPane;
import dev.gui.wizard.WizardPane;
import dev.lang.NestedException;
import java.awt.Component;
import java.net.ConnectException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JPanel;

public class LicenseActivationWizard
extends BasicLicenseWizard {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.pro.Res");
    protected LicenseLocationWizardPane fLicenseLocationWizardPane;
    protected LicenseActivationWizardPane fLicenseActivationWizardPane;
    protected OfflineActivationWizardPane fOfflineActivationWizardPane;
    protected OnlineActivationWizardPane fOnlineActivationWizardPane;
    protected InternetConnectionWizardPane fInternetConnectionWizardPane;
    protected MessageWizardPane fMessageWizardPane;
    protected ProgressWizardPane.Operation fActivateOperation = new ProgressWizardPane.Operation(res.getString("Activating_OP_Name"), res.getString("Activating_OP_Descr"));
    protected LicenseActivationProgressPane fLicenseActivationProgressPane;
    protected static final Icon WIZARD_ICON = ResourceUtils.loadImageIcon(class$com$jp$protection$gui$dialogs$pro$LicenseActivationWizard == null ? (class$com$jp$protection$gui$dialogs$pro$LicenseActivationWizard = LicenseActivationWizard.class$("com.jp.protection.gui.dialogs.pro.LicenseActivationWizard")) : class$com$jp$protection$gui$dialogs$pro$LicenseActivationWizard, "res/Activation Wizard.png");
    protected LicenseHostPro fLicenseHost;
    protected LicensingFacadeResult fActivateResult;
    protected String fLogin;
    protected String fPassword;
    protected static final String MSG_UNABLE_TO_ACTIVATE = res.getString("Unable_to_activate");
    protected static final String MSG_TRY_AGAIN = res.getString("Try_again");
    protected static final String MSG_UNABLE_TO_ACTIVATE_TRY_AGAIN = MSG_UNABLE_TO_ACTIVATE + "\n" + MSG_TRY_AGAIN;
    protected WizardPane fFinishWizardPane;
    public static final int OPTION_ACTIVATE_ONLINE = 1;
    public static final int OPTION_ACTIVATE_OFFLINE = 2;
    public static final int OPTION_CHOOSE_LICENSE = 4;
    public static final int DEFAULT_OPTIONS = 7;
    static /* synthetic */ Class class$com$jp$protection$gui$dialogs$pro$LicenseActivationWizard;

    public LicenseActivationWizard(Component anOwner) {
        super(anOwner);
        this.init();
        ((JPanel)this.getContentPane()).putClientProperty("topicID", "activation_assistant");
    }

    public LicenseActivationWizard() {
        this((Component)null);
    }

    public void setProductInfo(ProductInfo aProductInfo) {
        super.setProductInfo(aProductInfo);
        this.setTitle(aProductInfo.getShortName() + " - " + res.getString("License_Activation"));
        this.fOfflineActivationWizardPane.setProductInfo(aProductInfo);
    }

    public LicenseLocationWizardPane getLicenseLocationWizardPane() {
        return this.fLicenseLocationWizardPane;
    }

    public LicenseActivationWizardPane getLicenseActivationWizardPane() {
        return this.fLicenseActivationWizardPane;
    }

    public OfflineActivationWizardPane getOfflineActivationWizardPane() {
        return this.fOfflineActivationWizardPane;
    }

    public OnlineActivationWizardPane getOnlineActivationWizardPane() {
        return this.fOnlineActivationWizardPane;
    }

    public InternetConnectionWizardPane getInternetConnectionWizardPane() {
        return this.fInternetConnectionWizardPane;
    }

    private void init() {
        this.setTitle(res.getString("License_Activation"));
        this.setWizardIcon(WIZARD_ICON);
        this.fLicenseActivationWizardPane = new LicenseActivationWizardPane();
        this.addWizardPane(this.fLicenseActivationWizardPane);
        this.fLicenseLocationWizardPane = new LicenseLocationWizardPane();
        this.addWizardPane(this.fLicenseLocationWizardPane);
        this.fOfflineActivationWizardPane = new OfflineActivationWizardPane();
        this.fOfflineActivationWizardPane.setProductInfo(this.getProductInfo());
        this.fOfflineActivationWizardPane.setNextPaneName("LicenseLocationWizardPane");
        this.addWizardPane(this.fOfflineActivationWizardPane);
        this.fOnlineActivationWizardPane = new OnlineActivationWizardPane();
        this.fOnlineActivationWizardPane.setNextPaneName("InternetConnectionWizardPane");
        this.addWizardPane(this.fOnlineActivationWizardPane);
        this.fInternetConnectionWizardPane = new InternetConnectionWizardPane();
        this.addWizardPane(this.fInternetConnectionWizardPane);
        this.fMessageWizardPane = new MessageWizardPane();
        this.addWizardPane(this.fMessageWizardPane);
        this.fLicenseActivationProgressPane = new LicenseActivationProgressPane();
        this.addWizardPane(this.fLicenseActivationProgressPane);
        this.fLicenseActivationProgressPane.addOperation(this.fInitOperation);
        this.fLicenseActivationProgressPane.addOperation(this.fActivateOperation);
        this.fLicenseActivationProgressPane.addOperation(this.fSaveLicenseOperation);
        UIUtils.applyComponentOrientation(this);
    }

    public LicenseHostPro getLicenseHost() {
        return this.fLicenseHost;
    }

    public void setLicenseHost(LicenseHostPro aLicenseHost) {
        this.fLicenseHost = aLicenseHost;
    }

    public LicenseReader getLicenseReader() {
        return this.fLicenseHost != null ? this.fLicenseHost.getLicenseReader() : super.getLicenseReader();
    }

    public LicensingFacadeResult getActivationResult() {
        return this.fActivateResult;
    }

    protected byte[] getLicenseBytes() {
        return this.fLicenseHost.getLicenseReader().getLicenseBytes();
    }

    public String getLogin() {
        return this.fLogin;
    }

    public void setLogin(String aLogin) {
        this.fLogin = aLogin;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public void setPassword(String aPassword) {
        this.fPassword = aPassword;
    }

    public boolean activateLicense() {
        return this.activateLicense(true);
    }

    public boolean activateLicense(boolean isShowMessages) {
        byte[] licenseBytes;
        boolean result;
        block14: {
            result = false;
            this.fActivateResult = null;
            licenseBytes = null;
            try {
                Customer customer = this.fOnlineActivationWizardPane.getCustomer();
                LicensingFacade licensingFacade = this.getLicensingFacade();
                this.fActivateOperation.setStatus(2);
                try {
                    this.fActivateResult = licensingFacade.activateLicense(this.getLicenseBytes(), customer, this.getLicenseHost().getActivationKey(), this.fLogin, this.fPassword, null);
                    this.fActivateOperation.setStatus(3);
                }
                catch (Throwable ex) {
                    this.fActivateOperation.setStatus(4);
                    throw ex;
                }
                if (this.fActivateResult != null) {
                    if (this.fActivateResult.getResult() == 1) {
                        licenseBytes = this.fActivateResult.getLicenseBytes();
                    } else if (isShowMessages) {
                        this.error(MSG_UNABLE_TO_ACTIVATE + "\n" + this.fActivateResult.getMessage());
                    }
                } else {
                    this.error(MSG_UNABLE_TO_ACTIVATE_TRY_AGAIN);
                }
            }
            catch (NestedException ne) {
                this.error(ne);
                if (isShowMessages) {
                    if (ne.getNestedException() instanceof ConnectException || ne.getNestedException() instanceof java.rmi.ConnectException) {
                        this.error(MSG_UNABLE_TO_ACTIVATE + "\n" + ne.getMessage() + "\n" + MSG_TRY_AGAIN);
                    } else {
                        this.error(MSG_UNABLE_TO_ACTIVATE_TRY_AGAIN);
                    }
                }
            }
            catch (Throwable ex) {
                this.error(ex);
                if (!isShowMessages) break block14;
                this.error(MSG_UNABLE_TO_ACTIVATE_TRY_AGAIN);
            }
        }
        if (licenseBytes != null) {
            result = this.saveLicense(licenseBytes);
        }
        return result;
    }

    protected boolean saveLicense(byte[] licenseBytes) {
        boolean result = super.saveLicense(licenseBytes);
        if (!result) {
            this.fActivateResult = null;
        }
        return result;
    }

    protected int doFinish() {
        boolean result = false;
        if (this.fActiveWizardPane instanceof LicenseActivationWizardPane || this.fActiveWizardPane instanceof OnlineActivationWizardPane || this.fActiveWizardPane instanceof InternetConnectionWizardPane) {
            boolean bl = result = this.fActiveWizardPane.finish() == 1;
            if (result) {
                this.fFinishWizardPane = this.fActiveWizardPane;
                this.fLicenseActivationProgressPane.setBackPaneName(this.fActiveWizardPane.getName());
                this.setActiveWizardPane(this.fLicenseActivationProgressPane);
                result = false;
            }
        } else {
            result = super.doFinish() == 1;
        }
        return result ? 1 : 0;
    }

    public void processActivationResult() {
        LicensingFacadeResult result = this.getActivationResult();
        if (result != null && result.getResult() == 1) {
            if (result.getLicenseBytes() == null) {
                this.initMessagePane(this.fMessageWizardPane, result);
                this.fMessageWizardPane.setBackPaneName(this.fActiveWizardPane.getBackPaneName());
                this.setActiveWizardPane(this.fMessageWizardPane);
            } else {
                this.setModalResult(1);
                this.setVisible(false);
            }
        } else if (this.fFinishWizardPane != null) {
            this.setActiveWizardPane(this.fFinishWizardPane);
        }
    }

    public boolean executeModal() {
        this.setActiveWizardPane(this.fLicenseActivationWizardPane);
        return super.executeModal();
    }

    public int getOptions() {
        return this.fLicenseActivationWizardPane.getOptions();
    }

    public void setOptions(int anOptions) {
        this.fLicenseActivationWizardPane.setOptions(anOptions);
    }

    public String getIssueDescription() {
        return this.fLicenseActivationWizardPane.getIssueDescription();
    }

    public void setIssueDescription(String aDescription) {
        this.fLicenseActivationWizardPane.setIssueDescription(aDescription);
    }

    public String getIssueName() {
        return this.fLicenseActivationWizardPane.getIssueName();
    }

    public void setIssueName(String aName) {
        this.fLicenseActivationWizardPane.setIssueName(aName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

