/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs.pro;

import com.jp.protection.gui.dialogs.LicensingWizard;
import com.jp.protection.gui.dialogs.pro.LicenseActivationWizard;
import com.jp.protection.gui.dialogs.pro.LicenseLockWizard;
import com.jp.protection.gui.dialogs.pro.LicensingWizardPro;
import com.jp.protection.pub.LicenseHost;
import com.jp.protection.pub.LicenseHostIssueResolver;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.pro.LicenseHostPro;
import dev.lang.BitTools;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.Icon;

public class DefaultLicenseHostIssueResolver
implements LicenseHostIssueResolver {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.pro.Res");
    protected LicenseHost fLicenseHost;
    protected LicensingWizardPro fLicensingWizard;
    protected LicenseLockWizard fLicenseLockWizard;
    protected String fLogin;
    protected String fPassword;
    protected LicenseActivationWizard fLicenseActivationWizard;
    protected Component fOwner;
    protected ProductInfo fProductInfo;
    protected boolean fSilentActivation = false;

    public DefaultLicenseHostIssueResolver(LicenseHost aLicenseHost, Component anOwner) {
        this.fOwner = anOwner;
        this.fLicenseHost = aLicenseHost;
    }

    public LicensingWizardPro getLicensingWizard() {
        if (this.fLicensingWizard == null) {
            this.fLicensingWizard = this.createLicensingWizard();
            this.fLicensingWizard.setProductInfo(this.fProductInfo);
            this.fLicensingWizard.setLicenseReader(this.fLicenseHost.getLicenseReader());
            this.fLicensingWizard.setLogin(this.getLogin());
            this.fLicensingWizard.setPassword(this.getPassword());
            this.fLicensingWizard.setLicenseHost((LicenseHostPro)this.fLicenseHost);
        }
        return this.fLicensingWizard;
    }

    protected LicensingWizardPro createLicensingWizard() {
        return new LicensingWizardPro(this.fOwner);
    }

    public LicenseLockWizard getLicenseLockWizard() {
        if (this.fLicenseLockWizard == null) {
            this.fLicenseLockWizard = this.createLicenseLockWizard();
            this.fLicenseLockWizard.setProductInfo(this.fProductInfo);
            this.fLicenseLockWizard.setLicenseReader(this.fLicenseHost.getLicenseReader());
            this.fLicenseLockWizard.setLicenseHost((LicenseHostPro)this.fLicenseHost);
        }
        return this.fLicenseLockWizard;
    }

    protected LicenseLockWizard createLicenseLockWizard() {
        return new LicenseLockWizard(this.fOwner);
    }

    public ProductInfo getProductInfo() {
        return this.fProductInfo;
    }

    public void setProductInfo(ProductInfo aProductInfo) {
        this.fProductInfo = aProductInfo;
        if (this.fLicenseActivationWizard != null) {
            this.fLicenseActivationWizard.setProductInfo(this.fProductInfo);
        }
    }

    public LicenseActivationWizard getLicenseActivationWizard() {
        if (this.fLicenseActivationWizard == null) {
            this.fLicenseActivationWizard = new LicenseActivationWizard(this.fOwner);
            this.fLicenseActivationWizard.setProductInfo(this.fProductInfo);
            this.fLicenseActivationWizard.setLogin(this.getLogin());
            this.fLicenseActivationWizard.setPassword(this.getPassword());
        }
        return this.fLicenseActivationWizard;
    }

    public String getLogin() {
        return this.fLogin;
    }

    public void setLogin(String aLogin) {
        this.fLogin = aLogin;
        if (this.fLicenseActivationWizard != null) {
            this.fLicenseActivationWizard.setLogin(aLogin);
        }
        if (this.fLicensingWizard != null) {
            this.fLicensingWizard.setLogin(aLogin);
        }
    }

    public String getPassword() {
        return this.fPassword;
    }

    public void setPassword(String aPassword) {
        this.fPassword = aPassword;
        if (this.fLicenseActivationWizard != null) {
            this.fLicenseActivationWizard.setPassword(aPassword);
        }
        if (this.fLicensingWizard != null) {
            this.fLicensingWizard.setPassword(aPassword);
        }
    }

    public int getLicensingWizardOptions() {
        return this.getLicensingWizard().getOptions();
    }

    public void setLicensingWizardOptions(int anOptions) {
        this.getLicensingWizard().setOptions(anOptions);
    }

    public String getLicensingFacadeProviderName() {
        return this.getLicensingWizard().getLicensingFacadeProviderName();
    }

    public void setLicensingFacadeProviderName(String aName) {
        this.getLicensingWizard().setLicensingFacadeProviderName(aName);
    }

    public void setLicensingWizardLogo(Icon anIcon) {
        this.getLicensingWizard().setWizardIcon(anIcon);
    }

    public int getActivationWizardOptions() {
        return this.getLicenseActivationWizard().getOptions();
    }

    public void setActivationWizardOptions(int anOptions) {
        this.getLicenseActivationWizard().setOptions(anOptions);
    }

    public void setLicenseLockWizardOptions(int anOptions) {
        this.getLicenseLockWizard().setOptions(anOptions);
    }

    public int getLicenseLockWizardOptions() {
        return this.getLicenseLockWizard().getOptions();
    }

    public String getActivationFacadeProviderName() {
        return this.getLicenseActivationWizard().getLicensingFacadeProviderName();
    }

    public void setActivationFacadeProviderName(String aName) {
        this.getLicenseActivationWizard().setLicensingFacadeProviderName(aName);
    }

    public void setActivationWizardLogo(Icon anIcon) {
        this.getLicenseActivationWizard().setWizardIcon(anIcon);
    }

    public void setLicenseLockWizardLogo(Icon anIcon) {
        this.getLicenseLockWizard().setWizardIcon(anIcon);
    }

    public boolean resolveLicenseExpired(LicenseHost aSource) {
        LicensingWizardPro wizard = this.getLicensingWizard();
        wizard.setIssueName(res.getString("wizard_IssueName_Expired"));
        wizard.setRequestExtEvaluation(true);
        return ((LicensingWizard)wizard).executeModal();
    }

    public boolean resolveLicenseInvalid(LicenseHost aSource) {
        LicensingWizardPro wizard = this.getLicensingWizard();
        wizard.setIssueName(res.getString("wizard_IssueName_Invalid"));
        wizard.setRequestExtEvaluation(false);
        return ((LicensingWizard)wizard).executeModal();
    }

    public boolean isSilentActivation() {
        return this.fSilentActivation;
    }

    public void setSilentActivation(boolean aSilentActivation) {
        this.fSilentActivation = aSilentActivation;
    }

    public boolean resolveLicenseActivationLockViolation(LicenseHost aSource) {
        LicenseActivationWizard licenseHostIssueWizard = this.getLicenseActivationWizard();
        licenseHostIssueWizard.setLicenseHost((LicenseHostPro)aSource);
        return licenseHostIssueWizard.executeModal();
    }

    public boolean resolveLicenseMissingActivation(LicenseHost aSource, String aLicenseKey) {
        LicenseActivationWizard licenseHostIssueWizard = this.getLicenseActivationWizard();
        licenseHostIssueWizard.setLicenseHost((LicenseHostPro)aSource);
        boolean result = false;
        if (this.isSilentActivation() && !BitTools.checkBit(aSource.getLicense().getLicenseOptions(), 4)) {
            result = licenseHostIssueWizard.activateLicense(false);
        }
        if (!result) {
            result = licenseHostIssueWizard.executeModal();
        }
        return result;
    }

    public boolean resolveLicenseNotLocked(LicenseHost aSource) {
        boolean result = false;
        LicenseHostPro host = (LicenseHostPro)aSource;
        if (host.getLicensingServiceSupport().hasLicensingServiceProvider()) {
            LicenseLockWizard wizard = this.getLicenseLockWizard();
            wizard.setLicenseHost(host);
            result = wizard.executeModal();
        }
        return result;
    }
}

