/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs.panes;

import com.jp.protection.pub.ProductInfo;
import dev.gui.wizard.MessageWizardPane;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class OfflineLicensingWizardPane
extends MessageWizardPane {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.Res");
    public static final String NAME = "OfflineLicensingWizardPane";
    protected ProductInfo fProductInfo;
    public static final String STR_MAIL_TO = "mailto:";
    protected static final MessageFormat FORMAT_HEADER = new MessageFormat("<html>\n<body>\n" + res.getString("You_may_obtain_license") + "<ul>\n");
    protected static final MessageFormat FORMAT_BODY = new MessageFormat("<li>{0}<a href=\"{1}\">{2}</a>\n</li>\n");
    protected static final MessageFormat FORMAT_FOOTER = new MessageFormat("</ul>\n<b>" + res.getString("Press_Next") + "</b></body>\n" + "</html>");

    public ProductInfo getProductInfo() {
        return this.fProductInfo;
    }

    public void setProductInfo(ProductInfo aProductInfo) {
        this.fProductInfo = aProductInfo;
    }

    public OfflineLicensingWizardPane() {
        this.setName(NAME);
        this.setHeaderName(res.getString("OfflineLicensingPane_Name"));
        this.setHeaderDescription(res.getString("OfflineLicensingPane_Descr"));
        this.putClientProperty("topicID", "licensing_assistant/offline");
    }

    public void activate(String aBackPaneName) {
        super.activate(aBackPaneName);
        this.setMessage(this.composeMessage());
    }

    protected String composeMessage() {
        return this.composeMessage(FORMAT_HEADER, FORMAT_BODY, FORMAT_FOOTER);
    }

    protected String composeMessage(MessageFormat aHeader, MessageFormat aBody, MessageFormat aFooter) {
        StringBuffer result = new StringBuffer();
        this.composeHeader(aHeader, result);
        this.composeVisitSite(result);
        this.composeContactSales(result);
        this.composeBuyOnline(result);
        this.composeActivate(result);
        this.composeDeactivate(result);
        this.composeSupport(result);
        this.composeFooter(aFooter, result);
        return result.toString();
    }

    protected void composeFooter(MessageFormat aFooter, StringBuffer result) {
        aFooter.format(null, result, new FieldPosition(0));
    }

    protected void composeHeader(MessageFormat aHeader, StringBuffer result) {
        aHeader.format(null, result, new FieldPosition(0));
    }

    protected void composeVisitSite(StringBuffer result) {
        ProductInfo.ProductInfoLink link = this.fProductInfo.getProductInfoLink("site");
        if (link != null && link.getURL() != null) {
            this.composeBody(result, res.getString("visiting_our_site_at") + " ", link, null);
        }
    }

    protected void composeSupport(StringBuffer result) {
    }

    protected void composeContactSales(StringBuffer result) {
        ProductInfo.ProductInfoLink link = this.fProductInfo.getProductInfoLink("sales");
        if (link != null && link.getURL() != null) {
            this.composeBody(result, res.getString("contacting_sales_at") + " ", link, null);
        }
    }

    protected void composeBuyOnline(StringBuffer result) {
        ProductInfo.ProductInfoLink link = this.fProductInfo.getProductInfoLink("buyOnline");
        if (link != null && link.getURL() != null) {
            this.composeBody(result, res.getString("buying_it_online_at") + " ", link, null);
        }
    }

    protected void composeActivate(StringBuffer result) {
    }

    protected void composeDeactivate(StringBuffer result) {
    }

    protected void composeBody(StringBuffer aBuffer, String aPrompt, ProductInfo.ProductInfoLink aLink, Object[] aParams) {
        this.composeBody(FORMAT_BODY, aBuffer, aPrompt, aLink, aParams);
    }

    protected void composeBody(MessageFormat aBodyFormat, StringBuffer aBuffer, String aPrompt, ProductInfo.ProductInfoLink aLink, Object[] aParams) {
        Object[] params = new Object[aParams == null ? 3 : aParams.length + 3];
        params[0] = aPrompt;
        String linkUrl = aLink.getURL();
        params[1] = linkUrl;
        params[2] = aLink.getText();
        if (params[2] == null || "".equals(params[2])) {
            params[2] = linkUrl.toLowerCase().startsWith(STR_MAIL_TO) ? linkUrl.substring(STR_MAIL_TO.length(), linkUrl.length()) : linkUrl;
        }
        for (int i = 0; aParams != null && i < aParams.length; ++i) {
            params[i + 3] = aParams[i];
        }
        aBodyFormat.format(params, aBuffer, new FieldPosition(0));
    }

    public static final String removeSubject(String aMailTo) {
        String result = aMailTo;
        if (result != null) {
            int index = result.toLowerCase().indexOf("?subject");
            if (result.toLowerCase().startsWith(STR_MAIL_TO) && index != -1) {
                result = result.substring(0, index);
            }
        }
        return result;
    }
}

