/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs.panes;

import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.pro.integration.LicensingFacadeProvider;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderFactory;
import dev.gui.wizard.WizardPane;
import dev.gui.wizard.WizardPaneHeader;
import dev.lang.BitTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class LicensingWizardPane
extends WizardPane {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.Res");
    protected WizardPaneHeader pnlHeader = new WizardPaneHeader();
    protected JRadioButton rbtnGetLS = new JRadioButton();
    protected JRadioButton rbtnSpecifyFile = new JRadioButton();
    protected JRadioButton rbtnRequestOffline = new JRadioButton();
    protected JRadioButton rbtnRequestEvaluation = new JRadioButton();
    protected ButtonGroup fButtonGroup = new ButtonGroup();
    protected JPanel pnlFill = new JPanel();
    public static final String NAME = "LicensingWizardPane";
    protected int fOptions = 30;
    public static final int OPERATION_NONE = 0;
    public static final int OPERATION_CHOOSE_FILE = 1;
    public static final int OPERATION_GET_EVAL = 2;
    public static final int OPERATION_GET_BY_S_N = 3;
    public static final int OPERATION_GET_OFFLINE = 4;
    public static final int OPERATION_GET_FROM_LS = 5;
    GridBagLayout gridBagLayout = new GridBagLayout();
    protected JComponent fSelected;
    protected boolean fRequestExtEvaluation = false;
    protected ProductInfo fProductInfo;
    JRadioButton rbtnEnterSerialNumber = new JRadioButton();
    JPanel pnlGap = new JPanel();

    public int getOptions() {
        return this.fOptions;
    }

    public void setOptions(int anOptions) {
        if (this.fOptions != anOptions) {
            this.fOptions = anOptions;
            this.updateOptions();
        }
    }

    protected void updateOptions() {
        boolean vis = LicensingFacadeProvider.hasProviders();
        this.rbtnGetLS.setVisible(LicensingServiceProviderFactory.getInstance().hasProviders() && BitTools.checkBit(this.fOptions, 32));
        this.rbtnEnterSerialNumber.setVisible(vis && BitTools.checkBit(this.fOptions, 8));
        this.rbtnRequestOffline.setVisible(BitTools.checkBit(this.fOptions, 16));
        if (this.fRequestExtEvaluation) {
            this.rbtnRequestEvaluation.setVisible(vis && BitTools.checkBit(this.fOptions, 4));
            this.rbtnRequestEvaluation.setText(res.getString("rbtnRequestEvaluation_Text_Eval"));
        } else {
            this.rbtnRequestEvaluation.setVisible(vis && BitTools.checkBit(this.fOptions, 2));
            this.rbtnRequestEvaluation.setText(res.getString("rbtnRequestEvaluation_Text_ExtEval"));
        }
    }

    public LicensingWizardPane() {
        this.setName(NAME);
        try {
            this.jbInit();
            this.putClientProperty("topicID", "licensing_assistant/home");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean canFinish() {
        return false;
    }

    public int finish() {
        return 0;
    }

    public boolean canNext() {
        return true;
    }

    public int getSelectedOperation() {
        int result = 0;
        if (this.rbtnSpecifyFile.isSelected()) {
            result = 1;
        } else if (this.rbtnRequestEvaluation.isSelected()) {
            result = 2;
        } else if (this.rbtnRequestOffline.isSelected()) {
            result = 4;
        } else if (this.rbtnEnterSerialNumber.isSelected()) {
            result = 3;
        } else if (this.rbtnGetLS.isSelected()) {
            result = 5;
        }
        return result;
    }

    public String next() {
        String result = null;
        if (this.rbtnSpecifyFile.isSelected()) {
            result = "LicenseLocationWizardPane";
        } else if (this.rbtnRequestEvaluation.isSelected()) {
            result = "RequestEvaluationWizardPane";
        } else if (this.rbtnRequestOffline.isSelected()) {
            result = "OfflineLicensingWizardPane";
        } else if (this.rbtnEnterSerialNumber.isSelected()) {
            result = "EnterSerialNumberWizardPane";
        } else if (this.rbtnGetLS.isSelected()) {
            result = "LicensingServerWizardPane";
        }
        return result;
    }

    public String getIssueDescription() {
        return this.pnlHeader.getDescriptionText();
    }

    public void setIssueDescription(String aDescription) {
        this.pnlHeader.setDescriptionText(aDescription);
    }

    public String getIssueName() {
        return this.pnlHeader.getNameText();
    }

    public void setIssueName(String aValue) {
        this.pnlHeader.setNameText(aValue);
    }

    public boolean isRequestEvalEnabled() {
        return BitTools.checkBit(this.fOptions, 2);
    }

    public void setRequestEvalEnabled(boolean aValue) {
        this.setOptions(BitTools.toggleBit(this.fOptions, 2, aValue));
    }

    public boolean isEnterSerialNumberEnabled() {
        return BitTools.checkBit(this.fOptions, 8);
    }

    public void setEnterSerialNumberEnabled(boolean aValue) {
        this.setOptions(BitTools.toggleBit(this.fOptions, 8, aValue));
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        this.pnlHeader.setDescriptionText(res.getString("LicensingWizardPane_DescriptionText"));
        this.pnlHeader.setNameText(res.getString("LicensingWizardPane_NameText"));
        this.rbtnGetLS.setText(res.getString("rbtnGetLS_Text"));
        this.rbtnGetLS.setVisible(false);
        this.rbtnGetLS.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LicensingWizardPane.this.rbtnGetLS_actionPerformed(e);
            }
        });
        this.rbtnRequestOffline.setText(res.getString("rbtnRequestOffline_Text"));
        this.rbtnRequestOffline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LicensingWizardPane.this.rbtnSite_actionPerformed(e);
            }
        });
        this.rbtnSpecifyFile.setSelected(true);
        this.rbtnSpecifyFile.setText(res.getString("rbtnSpecifyFile_Text"));
        this.rbtnSpecifyFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LicensingWizardPane.this.rbtnSpecifyFile_actionPerformed(e);
            }
        });
        this.rbtnRequestEvaluation.setVisible(false);
        this.rbtnRequestEvaluation.setText(res.getString("rbtnRequestEvaluation_Text_Eval"));
        this.rbtnRequestEvaluation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LicensingWizardPane.this.rbtnRequestEvaluation_actionPerformed(e);
            }
        });
        this.pnlFill.setMinimumSize(new Dimension(0, 0));
        this.rbtnEnterSerialNumber.setVisible(false);
        this.rbtnEnterSerialNumber.setText(res.getString("rbtnEnterSerialNumber_Text"));
        this.rbtnEnterSerialNumber.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LicensingWizardPane.this.rbtnEnterSerialNumber_actionPerformed(e);
            }
        });
        this.pnlGap.setMinimumSize(new Dimension(0, 0));
        this.pnlGap.setPreferredSize(new Dimension(1, 15));
        this.add((Component)this.pnlHeader, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.rbtnGetLS, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.rbtnEnterSerialNumber, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.rbtnSpecifyFile, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.rbtnRequestEvaluation, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.rbtnRequestOffline, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.fButtonGroup.add(this.rbtnRequestOffline);
        this.fButtonGroup.add(this.rbtnSpecifyFile);
        this.fButtonGroup.add(this.rbtnRequestEvaluation);
        this.fButtonGroup.add(this.rbtnGetLS);
        this.add((Component)this.pnlFill, new GridBagConstraints(2, 21, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.fButtonGroup.add(this.rbtnEnterSerialNumber);
        this.add((Component)this.pnlGap, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean isRequestExtEvaluation() {
        return this.fRequestExtEvaluation;
    }

    public void setRequestExtEvaluation(boolean aValue) {
        if (this.fRequestExtEvaluation != aValue) {
            this.fRequestExtEvaluation = aValue;
            this.rbtnRequestEvaluation.setText(this.fRequestExtEvaluation ? res.getString("rbtnRequestEvaluation_Text_ExtEval") : res.getString("rbtnRequestEvaluation_Text_Eval"));
        }
    }

    void rbtnSite_actionPerformed(ActionEvent e) {
        this.update();
        this.fSelected = this.rbtnRequestOffline;
    }

    void rbtnSpecifyFile_actionPerformed(ActionEvent e) {
        this.update();
        this.fSelected = this.rbtnSpecifyFile;
    }

    void rbtnRequestEvaluation_actionPerformed(ActionEvent e) {
        this.update();
        this.fSelected = this.rbtnRequestEvaluation;
    }

    void rbtnEnterSerialNumber_actionPerformed(ActionEvent e) {
        this.update();
        this.fSelected = this.rbtnEnterSerialNumber;
    }

    void rbtnGetLS_actionPerformed(ActionEvent e) {
        this.update();
        this.fSelected = this.rbtnGetLS;
    }

    public void activate(String aBackPaneName) {
        super.activate(aBackPaneName);
        this.updateOptions();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (LicensingWizardPane.this.fSelected != null) {
                    LicensingWizardPane.this.fSelected.requestFocus();
                } else if (LicensingWizardPane.this.rbtnGetLS.isVisible()) {
                    LicensingWizardPane.this.rbtnGetLS.requestFocus();
                    LicensingWizardPane.this.rbtnGetLS.setSelected(true);
                } else if (LicensingWizardPane.this.rbtnEnterSerialNumber.isVisible()) {
                    LicensingWizardPane.this.rbtnEnterSerialNumber.requestFocus();
                    LicensingWizardPane.this.rbtnEnterSerialNumber.setSelected(true);
                } else {
                    LicensingWizardPane.this.rbtnSpecifyFile.requestFocus();
                    LicensingWizardPane.this.rbtnSpecifyFile.setSelected(true);
                }
                LicensingWizardPane.this.update();
            }
        });
    }

    public ProductInfo getProductInfo() {
        return this.fProductInfo;
    }

    public void setProductInfo(ProductInfo aProductInfo) {
        this.fProductInfo = aProductInfo;
    }
}

