/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs.panes;

import com.jp.protection.gui.dialogs.BasicLicenseWizard;
import com.jp.protection.pub.LicenseReader;
import dev.gui.GenericFileFilter;
import dev.gui.field.FileChooserField;
import dev.gui.wizard.WizardPane;
import dev.gui.wizard.WizardPaneHeader;
import dev.util.StreamUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class LicenseLocationWizardPane
extends WizardPane {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.Res");
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    WizardPaneHeader pnlHeader = new WizardPaneHeader();
    JLabel lblLocation = new JLabel();
    FileChooserField edtLocation = new FileChooserField(){

        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            result.width = 200;
            return result;
        }

        public String chooseFile(String aFileName) {
            if (aFileName == null || aFileName.equals("")) {
                aFileName = LicenseLocationWizardPane.this.getLicenseReader().getLicenseFileName();
            }
            return super.chooseFile(aFileName);
        }
    };
    JPanel pnlFill = new JPanel();
    public static final String NAME = "LicenseLocationWizardPane";
    protected FileFilter fLicenseFileFilter = new GenericFileFilter("License File", new String[]{"license", "licence", "key", "lic"});
    protected DocumentListener fDocumentListener = new DocumentListener(){

        public void insertUpdate(DocumentEvent e) {
            LicenseLocationWizardPane.this.update();
        }

        public void removeUpdate(DocumentEvent e) {
            LicenseLocationWizardPane.this.update();
        }

        public void changedUpdate(DocumentEvent e) {
            LicenseLocationWizardPane.this.update();
        }
    };

    public LicenseLocationWizardPane() {
        this.setName(NAME);
        try {
            this.jbInit();
            ((JTextField)this.edtLocation.getField()).getDocument().addDocumentListener(this.fDocumentListener);
            this.putClientProperty("topicID", "licensing_assistant/location");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setChoosableFileFilters(new FileFilter[]{this.fLicenseFileFilter});
        this.setLayout(this.gridBagLayout1);
        this.pnlHeader.setDescriptionText(res.getString("LocationWizardPane_DescriptionText"));
        this.pnlHeader.setNameText(res.getString("LocationWizardPane_NameText"));
        this.lblLocation.setDisplayedMnemonic(res.getString("lblLocation_M").charAt(0));
        this.lblLocation.setLabelFor(this.edtLocation);
        this.lblLocation.setText(res.getString("lblLocation_Text"));
        this.edtLocation.setButtonText(res.getString("edtLocation_Text"));
        this.edtLocation.setButtonToolTipText(res.getString("edtLocation_ToolTipText"));
        this.pnlFill.setMinimumSize(new Dimension(0, 0));
        this.add((Component)this.pnlHeader, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lblLocation, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(15, 5, 0, 0), 0, 0));
        this.add((Component)this.edtLocation, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(15, 5, 0, 0), 0, 0));
        this.add((Component)this.pnlFill, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public FileFilter[] getChoosableFileFilters() {
        return this.edtLocation.getChoosableFileFilters();
    }

    public void setChoosableFileFilters(FileFilter[] aChoosableFileFilters) {
        this.edtLocation.setChoosableFileFilters(aChoosableFileFilters);
    }

    public boolean canFinish() {
        String value = this.edtLocation.getValue();
        return value != null && !value.equals("") && new File(value).canRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean copyLicense() {
        boolean result = true;
        try {
            byte[] licenseBytes;
            LicenseReader licenseReader = this.getLicenseReader();
            FileInputStream in = new FileInputStream(new File(this.edtLocation.getValue()));
            try {
                licenseBytes = StreamUtil.readB(in);
            }
            finally {
                in.close();
            }
            OutputStream out = licenseReader.getLicenseOutputStream();
            try {
                out.write(licenseBytes);
            }
            finally {
                out.close();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, res.getString("Unable_to_write") + ex.getMessage(), res.getString("Error"), 0);
            ex.printStackTrace();
            result = false;
        }
        return result;
    }

    public int finish() {
        return this.copyLicense() ? 1 : 0;
    }

    public boolean canNext() {
        return false;
    }

    protected LicenseReader getLicenseReader() {
        return ((BasicLicenseWizard)this.fWizardDialog).getLicenseReader();
    }

    protected void doActivate() {
        this.edtLocation.requestFocus();
    }

    public void activate(String aBackPaneName) {
        super.activate(aBackPaneName);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LicenseLocationWizardPane.this.doActivate();
            }
        });
    }
}

