/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs;

import com.jp.gui.AboutDialog;
import com.jp.gui.AboutPanel;
import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseHost;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.pro.LicenseHostPro;
import com.jp.protection.utils.LicenseUtils;
import dev.entities.Customer;
import dev.gui.UIUtils;
import dev.lang.BitTools;
import dev.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class LicenseAboutDialog
extends AboutDialog
implements PropertyChangeListener {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.Res");
    protected static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);
    protected static final MessageFormat FMT_REQUIRES_ACTIVATION_IN = new MessageFormat(res.getString("State_Not_Activated_In"));
    protected static final MessageFormat FMT_REQUIRES_LOCK_IN = new MessageFormat(res.getString("State_Not_Locked_In"));
    protected ProductInfo fProductInfo;

    public LicenseAboutDialog() {
        this((Component)null);
    }

    public LicenseAboutDialog(Component anOwner) {
        super(anOwner);
        UIUtils.applyComponentOrientation(this);
    }

    public LicenseAboutDialog(Frame anOwner) {
        super(anOwner);
        UIUtils.applyComponentOrientation(this);
    }

    public LicenseAboutDialog(Dialog anOwner) {
        super(anOwner);
        UIUtils.applyComponentOrientation(this);
    }

    public static void execute(LicenseAboutDialog aDialog, final LicenseHost aLicenseHost) {
        final License license = aLicenseHost.getLicense();
        LicenseAboutDialog.execute(aDialog, license == null ? null : new AboutPanel.LicenseDelegate(){
            protected Customer fCustomer;

            public String getLicenseText() {
                return license.getLicenseText();
            }

            public boolean isLicenseAccepted() {
                return aLicenseHost.isLicenseAccepted();
            }

            public void acceptLicense() {
                aLicenseHost.setLicenseAccepted(true);
            }

            public String getLicenseNumber() {
                return license.getLicenseNumber();
            }

            protected Customer getCustomer() {
                if (this.fCustomer == null) {
                    this.fCustomer = new Customer();
                    LicenseUtils.fromLicense(license, this.fCustomer);
                    if (this.fCustomer.getFirstName() == null && this.fCustomer.getLastName() == null && this.fCustomer.getCompany() == null) {
                        this.fCustomer.fromPreferences(LicenseUtils.getCustomerPreferences(license.getProduct()));
                    }
                }
                return this.fCustomer;
            }

            public String getLicenseOwner() {
                StringBuffer result = new StringBuffer();
                Customer customer = this.getCustomer();
                if (this.fCustomer.getFirstName() != null) {
                    result.append(this.fCustomer.getFirstName());
                }
                if (this.fCustomer.getLastName() != null) {
                    if (result.length() > 0) {
                        result.append(" ");
                    }
                    result.append(this.fCustomer.getLastName());
                }
                if (this.fCustomer.getCompany() != null) {
                    if (result.length() > 0) {
                        result.append(", ");
                    }
                    result.append(this.fCustomer.getCompany());
                }
                return result.toString();
            }

            public String getLicenseIssueInfo() {
                return DATE_FORMAT.format(license.getLicenseIssueDate());
            }

            public String getLicenseExpireInfo() {
                return LicenseAboutDialog.getLicenseExpireInfo(license, aLicenseHost);
            }

            public String getLicenseType() {
                return license.getLicenseType() == 3 ? res.getString("Commercial") : res.getString("Evaluation");
            }

            public boolean isLicenseAvailable() {
                return license.getLicenseState() != 4 && license.getLicenseState() != 1;
            }

            public boolean isLicenseOK() {
                return license.getLicenseState() == 2;
            }

            public String getLicenseState() {
                String result = null;
                switch (license.getLicenseState()) {
                    case 3: {
                        result = res.getString("State_Expired");
                        break;
                    }
                    case 5: 
                    case 6: {
                        result = res.getString("State_Not_Activated");
                        break;
                    }
                    case 7: {
                        result = res.getString("State_Not_Locked");
                        break;
                    }
                    case 2: {
                        if (!(aLicenseHost instanceof LicenseHostPro)) break;
                        LicenseHostPro licenseHost = (LicenseHostPro)aLicenseHost;
                        if ((BitTools.checkBit(license.getLicenseOptions(), 1) || BitTools.checkBit(license.getLicenseOptions(), 2)) && !StringUtils.equals(license.getProperty("pr.ak", null), licenseHost.getActivationKey())) {
                            int daysLeft = licenseHost.getActivationDaysLeft(license);
                            result = daysLeft > 0 ? FMT_REQUIRES_ACTIVATION_IN.format(new Object[]{new Integer(daysLeft)}) : null;
                            break;
                        }
                        if (license.getUserLicensingModel() != 4 && license.getUserLicensingModel() != 5) break;
                        int daysLeft = licenseHost.getLockDaysLeft(license);
                        result = daysLeft > 0 ? FMT_REQUIRES_LOCK_IN.format(new Object[]{new Integer(daysLeft)}) : null;
                    }
                }
                return result;
            }
        });
    }

    public static void execute(Component anOwner, LicenseHost aLicenseHost) {
        LicenseAboutDialog.execute(new LicenseAboutDialog(), aLicenseHost);
    }

    public ProductInfo getProductInfo() {
        return this.fProductInfo;
    }

    public void setProductInfo(ProductInfo aProductInfo) {
        if (this.fProductInfo != null) {
            this.fProductInfo.removePropertyChangeListener(this);
        }
        this.fProductInfo = aProductInfo;
        if (this.fProductInfo != null) {
            this.fProductInfo.addPropertyChangeListener(this);
            this.setProductName(this.fProductInfo.getName());
            this.setSiteText(this.fProductInfo.getSiteText());
            this.setSiteTooltipText(this.fProductInfo.getSiteTooltipText());
            this.setSiteURL(this.fProductInfo.getSiteURL());
            this.setFeedbackText(this.fProductInfo.getFeedbackText());
            this.setFeedbackTooltipText(this.fProductInfo.getFeedbackTooltipText());
            this.assignFeedbackURL(this.fProductInfo.getFeedbackURL());
            this.setCopyright(this.fProductInfo.getCopyright());
        }
    }

    protected void assignFeedbackURL(String anURL) {
        AboutPanel.LicenseDelegate licenseDelegate = this.pnlAbout.getLicenseDelegate();
        this.setFeedbackURL(licenseDelegate != null && anURL != null ? new MessageFormat(anURL).format(new Object[]{licenseDelegate.getLicenseNumber()}) : anURL);
    }

    public void setLicenseDelegate(AboutPanel.LicenseDelegate aLicenseDelegate) {
        super.setLicenseDelegate(aLicenseDelegate);
        if (this.fProductInfo != null) {
            this.assignFeedbackURL(this.fProductInfo.getFeedbackURL());
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof ProductInfo) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("siteText")) {
                this.setSiteText((String)evt.getNewValue());
            } else if (propertyName.equals("siteTooltipText")) {
                this.setSiteTooltipText((String)evt.getNewValue());
            } else if (propertyName.equals("siteURL")) {
                this.setSiteURL((String)evt.getNewValue());
            } else if (propertyName.equals("feedbackText")) {
                this.setFeedbackText((String)evt.getNewValue());
            } else if (propertyName.equals("feedbackTooltipText")) {
                this.setFeedbackTooltipText((String)evt.getNewValue());
            } else if (propertyName.equals("feedbackURL")) {
                this.assignFeedbackURL((String)evt.getNewValue());
            }
        }
    }

    public static String getLicenseExpireInfo(License aLicense, LicenseHost aLicenseHost) {
        return aLicenseHost.getLicenseExpireInfo(aLicense);
    }
}

