/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs;

import com.jp.protection.gui.dialogs.LicensingWizard;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.LicenseReaderIssueResolver;
import com.jp.protection.pub.ProductInfo;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.Icon;

public class DefaultLicenseReaderIssueResolver
implements LicenseReaderIssueResolver {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.Res");
    protected Component fOwner;
    protected LicensingWizard fLicensingWizard;
    protected ProductInfo fProductInfo;
    protected LicenseReader fLicenseReader;

    public DefaultLicenseReaderIssueResolver(LicenseReader aLicenseReader, Component anOwner, ProductInfo aProductInfo) {
        this.fOwner = anOwner;
        this.fLicenseReader = aLicenseReader;
        this.fProductInfo = aProductInfo;
    }

    public DefaultLicenseReaderIssueResolver(LicenseReader aLicenseReader, Component anOwner) {
        this.fOwner = anOwner;
        this.fLicenseReader = aLicenseReader;
    }

    public DefaultLicenseReaderIssueResolver(LicenseReader aLicenseReader) {
        this(aLicenseReader, null);
    }

    public ProductInfo getProductInfo() {
        return this.fProductInfo;
    }

    public void setProductInfo(ProductInfo aProductInfo) {
        this.fProductInfo = aProductInfo;
        if (this.fLicensingWizard != null) {
            this.fLicensingWizard.setProductInfo(this.fProductInfo);
        }
    }

    public LicensingWizard getLicensingWizard() {
        if (this.fLicensingWizard == null) {
            this.fLicensingWizard = this.createLicensingWizard();
            this.fLicensingWizard.setProductInfo(this.fProductInfo);
            this.fLicensingWizard.setLicenseReader(this.fLicenseReader);
        }
        return this.fLicensingWizard;
    }

    public int getLicensingWizardOptions() {
        return this.getLicensingWizard().getOptions();
    }

    public void setLicensingWizardOptions(int anOptions) {
        this.getLicensingWizard().setOptions(anOptions);
    }

    public void setLicensingWizardLogo(Icon anIcon) {
        this.getLicensingWizard().setWizardIcon(anIcon);
    }

    protected LicensingWizard createLicensingWizard() {
        return new LicensingWizard(this.fOwner);
    }

    public boolean resolveLicenseMissing(LicenseReader aSource) {
        LicensingWizard wizard = this.getLicensingWizard();
        wizard.setIssueName(res.getString("wizard_IssueName_Missing"));
        wizard.setRequestExtEvaluation(false);
        return wizard.executeModal();
    }

    public boolean resolveLicenseCorrupted(LicenseReader aSource) {
        LicensingWizard wizard = this.getLicensingWizard();
        wizard.setIssueName(res.getString("wizard_IssueName_Corrupted"));
        wizard.setRequestExtEvaluation(false);
        return wizard.executeModal();
    }
}

