/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs;

import com.jp.protection.gui.dialogs.LicenseErrorDialog;
import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseAdapter;
import com.jp.protection.pub.LicenseHost;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.ProductInfo;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class DefaultLicenseAdapter
extends LicenseAdapter
implements PropertyChangeListener {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.Res");
    protected LicenseErrorDialog fLicenseErrorDialog;
    protected ProductInfo fProductInfo;
    protected static final MessageFormat FMT_ABOUT_EXPIRE = new MessageFormat(res.getString("fLicenseErrorDialog_AboutToExpire"));
    protected static final MessageFormat FMT_USE_LIMIT = new MessageFormat(res.getString("fLicenseErrorDialog_UseLimit"));
    protected static final MessageFormat FMT_NUMBER_COPIES_VIOLATION = new MessageFormat(res.getString("fLicenseErrorDialog_NumberCopies"));
    protected static final MessageFormat FMT_NEED_ACTIVATION = new MessageFormat(res.getString("fLicenseErrorDialog_NeedActivation"));
    protected static final MessageFormat FMT_REASON = new MessageFormat(res.getString("Reason"));
    protected static final MessageFormat FMT_NOT_LOCKED = new MessageFormat(res.getString("fLicenseErrorDialog_NotLocked"));
    protected static final MessageFormat FMT_NEED_LOCK = new MessageFormat(res.getString("fLicenseErrorDialog_NeedLock"));

    public DefaultLicenseAdapter() {
        this(null);
    }

    public DefaultLicenseAdapter(Component aOwner) {
        this.fLicenseErrorDialog = new LicenseErrorDialog(aOwner);
    }

    public String getTitle() {
        return this.fLicenseErrorDialog.getTitle();
    }

    public void setTitle(String aTitle) {
        this.fLicenseErrorDialog.setTitle(aTitle);
    }

    public String getMessage() {
        return this.fLicenseErrorDialog.getMessage();
    }

    public void setMessage(String aMessage) {
        this.fLicenseErrorDialog.setMessage(aMessage);
    }

    public String getSiteText() {
        return this.fLicenseErrorDialog.getSiteText();
    }

    public void setSiteText(String aSiteText) {
        this.fLicenseErrorDialog.setSiteText(aSiteText);
    }

    public String getSiteTooltipText() {
        return this.fLicenseErrorDialog.getSiteTooltipText();
    }

    public void setSiteTooltipText(String aSiteTooltipText) {
        this.fLicenseErrorDialog.setSiteTooltipText(aSiteTooltipText);
    }

    public String getSiteURL() {
        return this.fLicenseErrorDialog.getSiteURL();
    }

    public void setSiteURL(String aSiteURL) {
        this.fLicenseErrorDialog.setSiteURL(aSiteURL);
    }

    public String getFeedbackText() {
        return this.fLicenseErrorDialog.getContactText();
    }

    public void setFeedbackText(String aFeedbackText) {
        this.fLicenseErrorDialog.setContactText(aFeedbackText);
    }

    public String getFeedbackTooltipText() {
        return this.fLicenseErrorDialog.getContactTooltipText();
    }

    public void setFeedbackTooltipText(String aFeedbackTooltipText) {
        this.fLicenseErrorDialog.setContactTooltipText(aFeedbackTooltipText);
    }

    public String getFeedbackURL() {
        return this.fLicenseErrorDialog.getContactURL();
    }

    public void setFeedbackURL(String aFeedbackURL) {
        this.fLicenseErrorDialog.setContactURL(aFeedbackURL);
    }

    public void licenseCorrupted(LicenseReader aSource, String aLicenseLocation) {
        this.fLicenseErrorDialog.setErrorText(res.getString("fLicenseErrorDialog_Corrupted") + " " + aLicenseLocation);
        this.fLicenseErrorDialog.updateUI();
        LicenseErrorDialog.execute(this.fLicenseErrorDialog);
    }

    public void licenseExpired(LicenseHost aSource, License aLicense) {
        this.fLicenseErrorDialog.setErrorText(res.getString("fLicenseErrorDialog_Expired") + " " + aLicense.getLicenseLocation());
        this.fLicenseErrorDialog.updateUI();
        LicenseErrorDialog.execute(this.fLicenseErrorDialog);
    }

    public void licenseInvalid(LicenseHost aSource, License aLicense) {
        this.fLicenseErrorDialog.setErrorText(res.getString("fLicenseErrorDialog_Invalid") + " " + aLicense.getLicenseLocation());
        this.fLicenseErrorDialog.updateUI();
        LicenseErrorDialog.execute(this.fLicenseErrorDialog);
    }

    public void licenseMissing(LicenseReader aSource, String aLicenseLocation) {
        this.fLicenseErrorDialog.setErrorText(res.getString("fLicenseErrorDialog_Missing") + " " + aLicenseLocation);
        this.fLicenseErrorDialog.updateUI();
        LicenseErrorDialog.execute(this.fLicenseErrorDialog);
    }

    public void licenseNotActivated(LicenseHost aSource, License aLicense) {
        this.fLicenseErrorDialog.setErrorText(res.getString("fLicenseErrorDialog_NotActivated"));
        this.fLicenseErrorDialog.updateUI();
        LicenseErrorDialog.execute(this.fLicenseErrorDialog);
    }

    public ProductInfo getProductInfo() {
        return this.fProductInfo;
    }

    public void setProductInfo(ProductInfo aProductInfo) {
        if (this.fProductInfo != null) {
            this.fProductInfo.removePropertyChangeListener(this);
        }
        this.fProductInfo = aProductInfo;
        if (this.fProductInfo != null) {
            this.fProductInfo.addPropertyChangeListener(this);
            this.setTitle(this.fProductInfo.getShortName());
            this.setSiteText(this.fProductInfo.getSiteText());
            this.setSiteTooltipText(this.fProductInfo.getSiteTooltipText());
            this.setSiteURL(this.fProductInfo.getSiteURL());
            this.setFeedbackText(this.fProductInfo.getFeedbackText());
            this.setFeedbackTooltipText(this.fProductInfo.getFeedbackTooltipText());
            this.setFeedbackURL(this.fProductInfo.getFeedbackURL());
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof ProductInfo) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("siteText")) {
                this.setSiteText((String)evt.getNewValue());
            } else if (propertyName.equals("siteTooltipText")) {
                this.setSiteTooltipText((String)evt.getNewValue());
            } else if (propertyName.equals("siteURL")) {
                this.setSiteURL((String)evt.getNewValue());
            } else if (propertyName.equals("feedbackText")) {
                this.setFeedbackText((String)evt.getNewValue());
            } else if (propertyName.equals("feedbackTooltipText")) {
                this.setFeedbackTooltipText((String)evt.getNewValue());
            } else if (propertyName.equals("feedbackURL")) {
                this.setFeedbackURL((String)evt.getNewValue());
            }
        }
    }

    public void licenseAboutToExpire(LicenseHost aSource, License aLicense, int aDaysLeft) {
        this.fLicenseErrorDialog.setErrorText(FMT_ABOUT_EXPIRE.format(new Object[]{new Integer(aDaysLeft)}));
        this.fLicenseErrorDialog.updateUI();
        LicenseErrorDialog.execute(this.fLicenseErrorDialog);
    }

    public void licenseUseLimitAboutReach(LicenseHost aSource, License aLicense, int aUseLeft) {
        this.fLicenseErrorDialog.setErrorText(FMT_USE_LIMIT.format(new Object[]{new Integer(aUseLeft)}));
        this.fLicenseErrorDialog.updateUI();
        LicenseErrorDialog.execute(this.fLicenseErrorDialog);
    }

    public void licenseLockViolation(LicenseHost aSource, License aLicense) {
        this.fLicenseErrorDialog.setErrorText(res.getString("fLicenseErrorDialog_LockViolation"));
        this.fLicenseErrorDialog.updateUI();
        LicenseErrorDialog.execute(this.fLicenseErrorDialog);
    }

    public void numberCopiesViolation(LicenseHost aSource, License aLicense, int aNumberInUse) {
        this.fLicenseErrorDialog.setErrorText(FMT_NUMBER_COPIES_VIOLATION.format(new Object[]{new Integer(aNumberInUse)}));
        this.fLicenseErrorDialog.updateUI();
        LicenseErrorDialog.execute(this.fLicenseErrorDialog);
    }

    public void licenseNeedActivation(LicenseHost aSource, License aLicense, int aDaysLeft) {
        this.fLicenseErrorDialog.setErrorText(FMT_NEED_ACTIVATION.format(new Object[]{new Integer(aDaysLeft)}));
        this.fLicenseErrorDialog.updateUI();
        LicenseErrorDialog.execute(this.fLicenseErrorDialog);
    }

    public void licenseNotLocked(LicenseHost aSource, License aLicense, String aReason) {
        JOptionPane.showMessageDialog(this.fLicenseErrorDialog.getOwner(), FMT_NOT_LOCKED.format(new Object[]{aReason != null ? aReason : res.getString("N_A")}) + "\n" + res.getString("Contact_Admin"), this.fLicenseErrorDialog.getTitle(), 0);
    }

    public void licenseNeedLock(LicenseHost aSource, License aLicense, int aDaysLeft) {
        JOptionPane.showMessageDialog(this.fLicenseErrorDialog.getOwner(), FMT_NEED_LOCK.format(new Object[]{new Integer(aDaysLeft)}) + "\n" + res.getString("Contact_Admin"), this.fLicenseErrorDialog.getTitle(), 0);
    }

    public void licenseLockExpired(LicenseHost aSource, License aLicense, String aReason) {
        String reason = aReason != null ? "\n" + FMT_REASON.format(new Object[]{aReason}) : null;
        JOptionPane.showMessageDialog(this.fLicenseErrorDialog.getOwner(), res.getString("fLicenseErrorDialog_LockExpired") + (reason != null ? reason : ""), this.fLicenseErrorDialog.getTitle(), 0);
    }

    public void licenseLockRevoked(LicenseHost aSource, License aLicense, String aReason) {
        String reason = aReason != null ? "\n" + FMT_REASON.format(new Object[]{aReason}) : null;
        JOptionPane.showMessageDialog(this.fLicenseErrorDialog.getOwner(), res.getString("fLicenseErrorDialog_LockRevoked") + (reason != null ? reason : ""), this.fLicenseErrorDialog.getTitle(), 0);
    }
}

