/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui.dialogs;

import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.pro.integration.LicensingFacade;
import com.jp.protection.pub.pro.integration.LicensingFacadeProvider;
import com.jp.protection.pub.pro.integration.LicensingFacadeResult;
import dev.gui.ComponentHelpDelegate;
import dev.gui.wizard.MessageWizardPane;
import dev.gui.wizard.ProgressWizardPane;
import dev.gui.wizard.WizardDialog;
import dev.gui.wizard.WizardPane;
import java.awt.Component;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class BasicLicenseWizard
extends WizardDialog {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.gui.dialogs.Res");
    static final MessageFormat FMT_NOTE_GET_LICENSE = new MessageFormat(res.getString("Note_Get_License"));
    static final MessageFormat FMT_NOTE_GET_LICENSE_SUPPORT = new MessageFormat(res.getString("Note_Get_License_Support"));
    protected ProductInfo fProductInfo;
    protected ProgressWizardPane.Operation fInitOperation = new ProgressWizardPane.Operation(res.getString("Init_OP_Name"), res.getString("Init_OP_Descr"));
    protected ProgressWizardPane.Operation fSaveLicenseOperation = new ProgressWizardPane.Operation(res.getString("Save_OP_Name"), res.getString("Save_OP_Descr"));
    protected static final MessageFormat FMT_UNABLE_WRITE_LICENSE = new MessageFormat(res.getString("Unable_Write_License"));
    protected LicenseReader fLicenseReader;
    protected String fLicensingFacadeProviderName;

    protected BasicLicenseWizard() {
        this.btnHelp.setVisible(false);
    }

    protected BasicLicenseWizard(Component anOwner) {
        super(JOptionPane.getFrameForComponent(anOwner));
        this.btnHelp.setVisible(false);
    }

    protected void initMessagePane(MessageWizardPane aMessageWizardPane, LicensingFacadeResult aResult) {
        aMessageWizardPane.setMessageIcon(UIManager.getIcon("OptionPane.informationIcon"));
        aMessageWizardPane.setHeaderName(res.getString("aMessageWizardPane_HeaderName"));
        aMessageWizardPane.setHeaderDescription(res.getString("aMessageWizardPane_HeaderDescription"));
        aMessageWizardPane.setMessage(this.composeMessage(aResult));
        aMessageWizardPane.setNeedConfirmation(true);
        aMessageWizardPane.setConfirmation(res.getString("aMessageWizardPane_Confirmation"));
        aMessageWizardPane.setBackConfirmation(res.getString("aMessageWizardPane_BackConfirmation"));
        aMessageWizardPane.setBackPaneName(this.fActiveWizardPane.getName());
        aMessageWizardPane.setNextPaneName("LicenseLocationWizardPane");
    }

    protected String composeMessage(LicensingFacadeResult aResult) {
        String result = "<html>";
        result = result + aResult.getMessage();
        if (aResult.getDeliveryType() == 2) {
            String ourDomain = this.getProductInfo().getSiteURLDomain();
            result = result + "<br><br>" + FMT_NOTE_GET_LICENSE.format(new Object[]{ourDomain != null ? ourDomain : res.getString("Our_Domain")});
            ProductInfo.ProductInfoLink supportLink = this.getProductInfo().getProductInfoLink("support");
            if (supportLink != null) {
                String url = supportLink.getURL();
                String subj = "?subject=";
                url = url.toLowerCase().indexOf("?subject=") == -1 ? url + "?subject=" : url + ": ";
                result = result + "<br><br>" + FMT_NOTE_GET_LICENSE_SUPPORT.format(new Object[]{url, this.getProductInfo().getShortName(), supportLink.getText()});
            }
        }
        result = result + res.getString("Instruction_Get_License");
        result = result + "</html>";
        return result;
    }

    public ProductInfo getProductInfo() {
        return this.fProductInfo;
    }

    public void setProductInfo(ProductInfo aProductInfo) {
        int i;
        if (this.fProductInfo != null) {
            for (i = 0; i < this.getWizardPaneCount(); ++i) {
                this.fProductInfo.removePropertyChangeListener(this.getWizardPane(i));
            }
        }
        this.fProductInfo = aProductInfo;
        if (this.fProductInfo != null) {
            for (i = 0; i < this.getWizardPaneCount(); ++i) {
                this.fProductInfo.addPropertyChangeListener(this.getWizardPane(i));
            }
        }
    }

    public void addWizardPane(WizardPane aWizardPane) {
        super.addWizardPane(aWizardPane);
        if (this.fProductInfo != null) {
            this.fProductInfo.addPropertyChangeListener(aWizardPane);
        }
    }

    public void removeWizardPane(WizardPane aWizardPane) {
        if (this.fProductInfo != null) {
            this.fProductInfo.removePropertyChangeListener(aWizardPane);
        }
        super.removeWizardPane(aWizardPane);
    }

    public LicenseReader getLicenseReader() {
        return this.fLicenseReader;
    }

    public void setLicenseReader(LicenseReader aLicenseReader) {
        this.fLicenseReader = aLicenseReader;
    }

    protected LicensingFacade getLicensingFacade() throws Throwable {
        LicensingFacade licensingFacade;
        this.fInitOperation.setStatus(2);
        try {
            licensingFacade = LicensingFacadeProvider.getInstance(this.getLicensingFacadeProviderName()).getLicensingFacade();
            this.fInitOperation.setStatus(3);
        }
        catch (Throwable ex) {
            this.fInitOperation.setStatus(4);
            throw ex;
        }
        return licensingFacade;
    }

    protected void error(Throwable ex) {
        if (!Thread.currentThread().isInterrupted()) {
            ex.printStackTrace();
        }
    }

    protected void error(String aMessage) {
        if (!Thread.currentThread().isInterrupted()) {
            super.error(aMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveLicense(byte[] licenseBytes) {
        boolean result = false;
        if (!Thread.currentThread().isInterrupted() && licenseBytes != null) {
            this.fSaveLicenseOperation.setStatus(2);
            while (!result) {
                try {
                    OutputStream out = this.getLicenseReader().getLicenseOutputStream();
                    try {
                        out.write(licenseBytes);
                    }
                    finally {
                        out.close();
                    }
                    result = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (BasicLicenseWizard.prompt(this, FMT_UNABLE_WRITE_LICENSE.format(new Object[]{ex.getMessage()})) == 0) continue;
                    break;
                }
            }
            this.fSaveLicenseOperation.setStatus(result ? 3 : 4);
        }
        return result;
    }

    public String getLicensingFacadeProviderName() {
        return this.fLicensingFacadeProviderName;
    }

    public void setLicensingFacadeProviderName(String aName) {
        this.fLicensingFacadeProviderName = aName;
    }

    public void setComponentHelpDelegate(ComponentHelpDelegate aComponentHelpDelegate) {
        super.setComponentHelpDelegate(aComponentHelpDelegate);
        this.btnHelp.setVisible(this.btnHelp.isEnabled());
    }
}

