/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.gui;

import dev.gui.JFormattedTextFieldEx;
import java.awt.Dimension;
import java.awt.Font;
import java.text.ParseException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.MaskFormatter;

public class SerialNumberTextField
extends JFormattedTextFieldEx {
    public SerialNumberTextField() {
        super(SerialNumberTextField.createSerialNumberFormatter());
        this.setFont(new Font("Courier New", 0, 12));
        this.setFocusLostBehavior(3);
        this.setColumns("#####-#####-#####-#####-#####".length());
    }

    public String getSerialNumber() {
        String result = null;
        if (this.isEditValid()) {
            try {
                this.commitEdit();
                result = (String)this.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public void setSerialNumber(String aSerialNumber) {
        this.setValue(aSerialNumber);
    }

    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        result.width += 2;
        return result;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected static SerialNumberFormatter createSerialNumberFormatter() {
        try {
            return new SerialNumberFormatter();
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static class SerialNumberFormatter
    extends MaskFormatter {
        public SerialNumberFormatter() throws ParseException {
            super(SerialNumberFormatter.obtainMask());
        }

        protected static String obtainMask() {
            StringBuffer result = new StringBuffer("#####-#####-#####-#####-#####");
            for (int i = 0; i < result.length(); ++i) {
                if (result.charAt(i) != '#') continue;
                result.setCharAt(i, 'A');
            }
            return result.toString();
        }

        protected DocumentFilter getDocumentFilter() {
            final DocumentFilter documentFilter = super.getDocumentFilter();
            return new DocumentFilter(){

                public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                    documentFilter.insertString(fb, offset, string != null ? string.toUpperCase() : string, attr);
                }

                public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                    documentFilter.remove(fb, offset, length);
                }

                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                    documentFilter.replace(fb, offset, length, text != null ? text.toUpperCase() : text, attrs);
                }
            };
        }
    }
}

