/*
 * Decompiled with CFR 0.152.
 */
package com.jp.gui;

import com.jp.gui.LicenseAcceptanceDialog;
import dev.gui.HyperlinkLabel;
import dev.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class AboutPanel
extends JPanel {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.gui.Res");
    protected JLabel lblLogo = new JLabel();
    protected JLabel lblProductName = new JLabel(){

        public void setFont(Font aFont) {
            super.setFont(aFont.deriveFont(1, aFont.getSize() + 1));
        }
    };
    protected JPanel pnlLicense = new JPanel();
    protected JLabel lblNumber = new JLabel();
    protected JLabel lblExpires = new JLabel();
    protected JLabel lblIssued = new JLabel();
    protected JLabel lblLicense = new JLabel();
    protected Border border1;
    protected JLabel lblLicenseValue = new JLabel();
    protected JLabel lblIssuedValue = new JLabel();
    protected JLabel lblExpiresValue = new JLabel();
    protected JPanel pnlWarning = new JPanel();
    protected JTextArea txtNote = new JTextArea(){

        public void updateUI() {
            super.updateUI();
            this.setOpaque(false);
        }
    };
    protected BorderLayout borderLayout1 = new BorderLayout();
    protected JTextField fldNumberValue = new JTextField(){

        public void updateUI() {
            super.updateUI();
            this.setOpaque(false);
            this.setBorder(null);
        }
    };
    protected JLabel lblComments = new JLabel();
    protected HyperlinkLabel lblFeedback = new HyperlinkLabel();
    protected JPanel pnlCopyright = new JPanel();
    protected JLabel lblCopyright = new JLabel();
    protected HyperlinkLabel lblSiteURL = new HyperlinkLabel();
    protected JLabel lblRights = new JLabel();
    protected HyperlinkLabel lblShowLicense = new HyperlinkLabel();
    protected FlowLayout flowLayout1 = new FlowLayout();
    GridBagLayout gridBagLayout = new GridBagLayout();
    public static final String N_A = res.getString("NA");
    public static final Color ALERT_COLOR = Color.red;
    protected LicenseDelegate fLicenseDelegate;
    JLabel lblLicensedTo = new JLabel();
    JLabel lblLicensedToValue = new JLabel();
    static /* synthetic */ Class class$com$jp$gui$AboutPanel;

    public AboutPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getNoteText() {
        return this.txtNote.getText();
    }

    public void setNoteText(String aText) {
        this.txtNote.setText(aText);
    }

    public int getNoteRows() {
        return this.txtNote.getRows();
    }

    public void setNoteRows(int aRows) {
        this.txtNote.setRows(aRows);
    }

    private void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, Color.white, new Color(142, 142, 142));
        this.setLayout(this.gridBagLayout);
        this.pnlLicense.setLayout(new GridBagLayout());
        this.lblNumber.setText(res.getString("lblNumber_Text"));
        this.lblExpires.setText(res.getString("lblExpireDate_Text"));
        this.lblIssued.setText(res.getString("lblIssueDate_Text"));
        this.lblLicense.setText(res.getString("lblLicense_Text"));
        this.pnlLicense.setVisible(false);
        this.pnlLicense.setBorder(BorderFactory.createEtchedBorder());
        this.pnlLicense.setVerifyInputWhenFocusTarget(true);
        this.pnlWarning.setBorder(BorderFactory.createEtchedBorder());
        this.pnlWarning.setLayout(this.borderLayout1);
        this.txtNote.setFont(new Font("SansSerif", 0, 9));
        this.txtNote.setForeground(UIManager.getColor("Label.foreground"));
        this.txtNote.setEditable(false);
        this.txtNote.setMargin(new Insets(2, 2, 0, 0));
        this.txtNote.setText(res.getString("txtNote_Text"));
        this.txtNote.setLineWrap(true);
        this.txtNote.setRows(4);
        this.txtNote.setWrapStyleWord(true);
        this.fldNumberValue.setEditable(false);
        this.fldNumberValue.setText("0123456789");
        this.lblComments.setText(res.getString("lblComments_Text"));
        this.lblFeedback.setForeground(Color.blue);
        this.lblFeedback.setToolTipText(res.getString("lblFeedback_ToolTipText"));
        this.lblFeedback.setText("info@jproductivity.com");
        this.lblFeedback.setHyperlinkURL("mailto:info@jproductivity.com");
        this.lblFeedback.setHyperlinkColor(Color.red);
        this.lblCopyright.setText(res.getString("lblCopyright_Text") + Calendar.getInstance().get(1) + " jProductivity, LLC");
        this.lblSiteURL.setForeground(Color.blue);
        this.lblSiteURL.setToolTipText(res.getString("lblSiteURL_ToolTipText"));
        this.lblSiteURL.setText("http://www.jproductivity.com");
        this.lblSiteURL.setHyperlinkColor(Color.red);
        this.lblSiteURL.setHyperlinkURL("http://www.jproductivity.com");
        this.lblRights.setToolTipText("");
        this.lblRights.setText(res.getString("lblRights_Text"));
        this.lblShowLicense.setForeground(Color.blue);
        this.lblShowLicense.setText(res.getString("lblShowLicense_View"));
        this.lblShowLicense.setHyperlinkColor(Color.red);
        this.lblShowLicense.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                AboutPanel.this.lblShowLicense_mouseClicked(e);
            }
        });
        this.pnlCopyright.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.flowLayout1.setHgap(5);
        this.flowLayout1.setVgap(0);
        this.lblLicenseValue.setText("Commercial");
        this.lblIssuedValue.setText("12/12/03");
        this.lblExpiresValue.setVisible(true);
        this.lblExpiresValue.setText("12/12/03");
        this.lblProductName.setText("Product");
        this.lblLogo.setIcon(new ImageIcon((class$com$jp$gui$AboutPanel == null ? (class$com$jp$gui$AboutPanel = AboutPanel.class$("com.jp.gui.AboutPanel")) : class$com$jp$gui$AboutPanel).getResource("res/Logo.png")));
        this.lblLicensedTo.setText(res.getString("lblLicensedTo_Text"));
        this.lblLicensedToValue.setText("John Doe");
        this.add((Component)this.lblLogo, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lblProductName, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.pnlLicense, new GridBagConstraints(0, 2, 5, 1, 100.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.pnlLicense.add((Component)this.lblLicense, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 40, 0));
        this.pnlLicense.add((Component)this.lblLicenseValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.pnlLicense.add((Component)this.lblIssued, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 27, 0));
        this.pnlLicense.add((Component)this.lblIssuedValue, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 21, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlLicense.add((Component)this.lblNumber, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlLicense.add((Component)this.fldNumberValue, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.pnlLicense.add((Component)this.lblShowLicense, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.pnlLicense.add((Component)this.lblLicensedTo, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlLicense.add((Component)this.lblLicensedToValue, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 21, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.pnlLicense.add((Component)this.lblExpires, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlLicense.add((Component)this.lblExpiresValue, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 21, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.pnlWarning, new GridBagConstraints(0, 4, 5, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlWarning.add((Component)this.txtNote, "Center");
        this.add((Component)this.lblComments, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.pnlCopyright, new GridBagConstraints(0, 3, 3, 1, 100.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.pnlCopyright.add((Component)this.lblCopyright, null);
        this.pnlCopyright.add((Component)this.lblSiteURL, null);
        this.pnlCopyright.add((Component)this.lblRights, null);
        this.add((Component)this.lblFeedback, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 5, 5), 0, 0));
    }

    public String getProductName() {
        return this.lblProductName.getText();
    }

    public void setProductName(String aProductName) {
        this.lblProductName.setText(aProductName);
    }

    public String getFeedbackText() {
        return this.lblFeedback.getText();
    }

    public void setFeedbackText(String aSendFeedbackText) {
        this.lblFeedback.setText(aSendFeedbackText);
    }

    public String getFeedbackTooltipText() {
        return this.lblFeedback.getToolTipText();
    }

    public void setFeedbackTooltipText(String aSendFeedbackTooltip) {
        this.lblFeedback.setToolTipText(aSendFeedbackTooltip);
    }

    public String getFeedbackURL() {
        return this.lblFeedback.getHyperlinkURL();
    }

    public void setFeedbackURL(String aSendFeedbackURL) {
        this.lblFeedback.setHyperlinkURL(aSendFeedbackURL);
    }

    public String getSiteText() {
        return this.lblSiteURL.getText();
    }

    public void setSiteText(String aSiteText) {
        this.lblSiteURL.setText(aSiteText);
        if (this.lblSiteURL.getHyperlinkURL() == null) {
            this.lblSiteURL.setHyperlinkURL(aSiteText);
        }
    }

    public String getSiteTooltipText() {
        return this.lblSiteURL.getToolTipText();
    }

    public void setSiteTooltipText(String aSiteTooltip) {
        this.lblSiteURL.setToolTipText(aSiteTooltip);
    }

    public String getSiteURL() {
        return this.lblSiteURL.getHyperlinkURL();
    }

    public void setSiteURL(String aSiteURL) {
        this.lblSiteURL.setHyperlinkURL(aSiteURL);
        if (this.lblSiteURL.getText() == null) {
            this.lblSiteURL.setText(aSiteURL);
        }
    }

    public String getCopyright() {
        return this.lblCopyright.getText();
    }

    public void setCopyright(String aCopyright) {
        this.lblCopyright.setText(aCopyright);
    }

    public Icon getLogoIcon() {
        return this.lblLogo.getIcon();
    }

    public void setLogoIcon(Icon anIcon) {
        this.lblLogo.setIcon(anIcon);
    }

    protected Color getLabelForeground() {
        return UIManager.getColor("Label.foreground");
    }

    public LicenseDelegate getLicenseDelegate() {
        return this.fLicenseDelegate;
    }

    public void setLicenseDelegate(LicenseDelegate aLicenseDelegate) {
        this.fLicenseDelegate = aLicenseDelegate;
        if (this.fLicenseDelegate != null) {
            this.pnlLicense.setVisible(true);
            if (this.fLicenseDelegate.isLicenseAvailable()) {
                this.fldNumberValue.setText(this.fLicenseDelegate.getLicenseNumber());
                this.lblIssuedValue.setText(this.fLicenseDelegate.getLicenseIssueInfo());
                String expireInfo = this.fLicenseDelegate.getLicenseExpireInfo();
                if (expireInfo != null) {
                    this.lblExpires.setVisible(true);
                    this.lblExpiresValue.setVisible(true);
                    this.lblExpiresValue.setText(expireInfo);
                } else {
                    this.lblExpires.setVisible(false);
                    this.lblExpiresValue.setVisible(false);
                }
                if (!this.fLicenseDelegate.isLicenseOK() || !this.fLicenseDelegate.isLicenseAccepted()) {
                    this.lblLicenseValue.setForeground(ALERT_COLOR);
                } else {
                    this.lblLicenseValue.setForeground(this.getLabelForeground());
                }
                String licenseType = this.fLicenseDelegate.getLicenseType();
                licenseType = licenseType == null ? "" : licenseType + " ";
                if (this.fLicenseDelegate.getLicenseState() != null) {
                    licenseType = licenseType + this.fLicenseDelegate.getLicenseState();
                }
                this.lblLicenseValue.setText(licenseType);
                this.lblShowLicense.setText(this.fLicenseDelegate.isLicenseAccepted() ? res.getString("lblShowLicense_View") : res.getString("lblShowLicense_Accept"));
                this.lblShowLicense.setEnabled(true);
                this.lblLicensedToValue.setText(this.fLicenseDelegate.getLicenseOwner());
                boolean vis = !StringUtils.noValue(this.fLicenseDelegate.getLicenseOwner());
                this.lblLicensedToValue.setVisible(vis);
                this.lblLicensedTo.setVisible(vis);
            } else {
                this.fldNumberValue.setText(N_A);
                this.lblIssuedValue.setText(N_A);
                this.lblExpiresValue.setText(N_A);
                this.lblLicensedToValue.setText(N_A);
                this.lblLicenseValue.setText(res.getString(" lblLicenseValue_Text"));
                this.lblLicenseValue.setForeground(ALERT_COLOR);
                this.lblShowLicense.setText(null);
                this.lblShowLicense.setEnabled(false);
            }
        } else {
            this.pnlLicense.setVisible(false);
        }
    }

    void lblShowLicense_mouseClicked(MouseEvent e) {
        if (this.fLicenseDelegate == null) {
            return;
        }
        if (this.fLicenseDelegate.isLicenseAccepted()) {
            LicenseAcceptanceDialog.viewLicense(this, null, this.fLicenseDelegate.getLicenseText());
        } else if (LicenseAcceptanceDialog.acceptLicense(this, null, this.fLicenseDelegate.getLicenseText())) {
            this.fLicenseDelegate.acceptLicense();
            this.setLicenseDelegate(this.fLicenseDelegate);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface LicenseDelegate {
        public String getLicenseText();

        public void acceptLicense();

        public String getLicenseNumber();

        public String getLicenseIssueInfo();

        public String getLicenseExpireInfo();

        public String getLicenseType();

        public String getLicenseOwner();

        public boolean isLicenseAccepted();

        public boolean isLicenseAvailable();

        public boolean isLicenseOK();

        public String getLicenseState();
    }
}

