/*
 * Decompiled with CFR 0.152.
 */
package com.jp.comp.pane;

import dev.entities.Customer;
import dev.gui.IndicatorHolder;
import dev.gui.JTextFieldEx;
import dev.gui.combo.CountryCombobox;
import dev.gui.combo.StateCombobox;
import dev.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CustomerPane
extends JPanel
implements DocumentListener,
ActionListener {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.comp.pane.Res");
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel lblFirstName = new JLabel();
    JTextFieldEx edtFirstName = new JTextFieldEx();
    JLabel lblLastName = new JLabel();
    JTextFieldEx edtLastName = new JTextFieldEx();
    JLabel lblTitle = new JLabel();
    JTextFieldEx edtTitle = new JTextFieldEx();
    JLabel lblCompany = new JLabel();
    JTextFieldEx edtCompany = new JTextFieldEx();
    JLabel lblPhone = new JLabel();
    JTextFieldEx edtPhone = new JTextFieldEx();
    JLabel lblEmail = new JLabel();
    JTextFieldEx edtEmail = new JTextFieldEx();
    JLabel lblState = new JLabel();
    JLabel lblCountry = new JLabel();
    CountryCombobox cbxCountry = new CountryCombobox();
    JLabel lblAddress = new JLabel();
    JTextFieldEx edtAddress = new JTextFieldEx();
    JLabel lblZip = new JLabel();
    JTextFieldEx edtZip = new JTextFieldEx();
    JLabel lblCity = new JLabel();
    JTextFieldEx edtCity = new JTextFieldEx();
    StateCombobox cbxState = new StateCombobox();
    protected JComponent fInvalidComponent;
    protected boolean fRequired = true;
    protected boolean fModified = false;
    JLabel lblConfirmEmail = new JLabel();
    JTextFieldEx edtConfirmEmail = new JTextFieldEx();
    protected boolean fConfirmEmail = false;

    public CustomerPane() {
        try {
            this.jbInit();
            this.setRequired(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.edtAddress.getDocument().addDocumentListener(this);
        this.edtCity.getDocument().addDocumentListener(this);
        this.edtCompany.getDocument().addDocumentListener(this);
        this.edtEmail.getDocument().addDocumentListener(this);
        this.edtFirstName.getDocument().addDocumentListener(this);
        this.edtLastName.getDocument().addDocumentListener(this);
        this.edtPhone.getDocument().addDocumentListener(this);
        this.edtTitle.getDocument().addDocumentListener(this);
        this.edtZip.getDocument().addDocumentListener(this);
        this.cbxCountry.addActionListener(this);
        this.cbxState.addActionListener(this);
        this.lblCountry.setDisplayedMnemonic(res.getString("lblCountry_M").charAt(0));
        this.lblCountry.setLabelFor(this.cbxCountry);
        this.lblState.setDisplayedMnemonic(res.getString("lblState_M").charAt(0));
        this.lblState.setLabelFor(this.cbxState);
        this.cbxState.setMinimumWidth(70);
        this.cbxState.setPreferredWidth(70);
        this.lblCity.setDisplayedMnemonic(res.getString("lblCity_M").charAt(0));
        this.lblCity.setLabelFor(this.edtCity);
        this.lblZip.setDisplayedMnemonic(res.getString("lblZip_M").charAt(0));
        this.lblZip.setLabelFor(this.edtZip);
        this.lblAddress.setDisplayedMnemonic(res.getString("lblAddress_M").charAt(0));
        this.lblAddress.setLabelFor(this.edtAddress);
        this.lblEmail.setDisplayedMnemonic(res.getString("lblEmail_M").charAt(0));
        this.lblEmail.setLabelFor(this.edtEmail);
        this.lblPhone.setDisplayedMnemonic(res.getString("lblPhone_M").charAt(0));
        this.lblPhone.setLabelFor(this.edtPhone);
        this.lblCompany.setDisplayedMnemonic(res.getString("lblCompany_M").charAt(0));
        this.lblCompany.setLabelFor(this.edtCompany);
        this.lblTitle.setDisplayedMnemonic(res.getString("lblTitle_M").charAt(0));
        this.lblTitle.setLabelFor(this.edtTitle);
        this.lblLastName.setDisplayedMnemonic(res.getString("lblLastName_M").charAt(0));
        this.lblLastName.setLabelFor(this.edtLastName);
        this.lblFirstName.setDisplayedMnemonic(res.getString("lblFirstName_M").charAt(0));
        this.lblFirstName.setLabelFor(this.edtFirstName);
        this.lblFirstName.setText(res.getString("lblFirstName_Text"));
        this.setLayout(this.gridBagLayout1);
        this.lblLastName.setText(res.getString("lblLastName_Text"));
        this.edtFirstName.setText("");
        this.edtFirstName.setPreferredWidth(100);
        this.edtFirstName.setMinimumWidth(100);
        this.edtLastName.setText("");
        this.lblTitle.setText(res.getString("lblTitle_Text"));
        this.edtTitle.setMinimumWidth(100);
        this.edtTitle.setPreferredWidth(100);
        this.edtTitle.setText("");
        this.lblCompany.setText(res.getString("lblCompany_Text"));
        this.edtCompany.setText("");
        this.lblPhone.setText(res.getString("lblPhone_Text"));
        this.lblEmail.setText(res.getString("lblEmail_Text"));
        this.edtPhone.setText("");
        this.edtEmail.setText("");
        this.lblState.setText(res.getString("lblState_Text"));
        this.lblCountry.setText(res.getString("lblCountry_Text"));
        this.lblAddress.setText(res.getString("lblAddress_Text"));
        this.edtAddress.setText("");
        this.lblZip.setText(res.getString("lblZip_Text"));
        this.edtZip.setText("");
        this.edtZip.setPreferredWidth(70);
        this.edtZip.setMinimumWidth(70);
        this.lblCity.setText(res.getString("lblCity_Text"));
        this.edtCity.setText("");
        this.edtCity.setPreferredWidth(100);
        this.edtCity.setMinimumWidth(100);
        this.cbxCountry.setPreferredWidth(150);
        this.lblConfirmEmail.setVisible(false);
        this.lblConfirmEmail.setDisplayedMnemonic('C');
        this.lblConfirmEmail.setLabelFor(this.edtConfirmEmail);
        this.lblConfirmEmail.setText("Confirm E-mail:");
        this.edtConfirmEmail.setVisible(false);
        this.add((Component)this.lblFirstName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.lblTitle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.lblPhone, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.lblEmail, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.lblZip, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.lblCity, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.lblConfirmEmail, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.lblAddress, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.edtFirstName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.edtTitle, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.edtZip, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.edtLastName, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.edtCompany, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.cbxState, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.edtPhone, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.edtEmail, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.edtConfirmEmail, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 21, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.edtAddress, new GridBagConstraints(1, 5, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.cbxCountry, new GridBagConstraints(3, 7, 1, 1, 1.0, 0.0, 21, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.edtCity, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.lblLastName, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.lblCompany, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.lblState, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.lblCountry, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 10, 0, 0), 0, 0));
    }

    public void toForm(Customer aCustomer) {
        this.edtFirstName.setText(aCustomer.getFirstName());
        this.edtLastName.setText(aCustomer.getLastName());
        this.edtTitle.setText(aCustomer.getTitle());
        this.edtCompany.setText(aCustomer.getCompany());
        this.edtPhone.setText(aCustomer.getPhone());
        this.edtEmail.setText(aCustomer.getEmail());
        this.edtAddress.setText(aCustomer.getAddress());
        this.edtCity.setText(aCustomer.getCity());
        this.edtZip.setText(aCustomer.getZip());
        this.cbxState.setSelectedItem(aCustomer.getState());
        this.cbxCountry.setSelectedCountry(aCustomer.getCountry());
        this.enableStateCombobox();
    }

    public void fromForm(Customer aCustomer) {
        aCustomer.setFirstName(this.edtFirstName.getText());
        aCustomer.setLastName(this.edtLastName.getText());
        aCustomer.setTitle(this.edtTitle.getText());
        aCustomer.setCompany(this.edtCompany.getText());
        aCustomer.setPhone(this.edtPhone.getText());
        aCustomer.setEmail(this.edtEmail.getText());
        aCustomer.setAddress(this.edtAddress.getText());
        aCustomer.setCity(this.edtCity.getText());
        aCustomer.setZip(this.edtZip.getText());
        aCustomer.setState((String)this.cbxState.getSelectedItem());
        aCustomer.setCountry((String)this.cbxCountry.getSelectedItem());
    }

    protected String getMessageTitle() {
        String result = res.getString("Error");
        for (Container p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Dialog)) continue;
            result = ((Dialog)p).getTitle();
            break;
        }
        return result;
    }

    protected void error(String aMessage) {
        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this), aMessage, this.getMessageTitle(), 0);
    }

    protected boolean checkText(String aText) {
        if (aText != null) {
            aText = aText.trim();
        }
        return !StringUtils.noValue(aText);
    }

    public void requestFocusInvalid() {
        if (this.fInvalidComponent != null) {
            this.fInvalidComponent.requestFocus();
        }
    }

    public void requestFocusInvalid(JComponent aComponent) {
        this.fInvalidComponent = aComponent;
        if (this.fInvalidComponent != null) {
            this.fInvalidComponent.requestFocus();
        }
    }

    public boolean checkValid() {
        boolean result = true;
        if (!this.checkText(this.edtFirstName.getText())) {
            this.error(res.getString("First_Name_Invalid"));
            result = false;
            this.requestFocusInvalid(this.edtFirstName);
        } else if (!this.checkText(this.edtLastName.getText())) {
            this.error(res.getString("Last_Name_Invalid"));
            result = false;
            this.requestFocusInvalid(this.edtLastName);
        } else if (!this.checkText(this.edtCompany.getText())) {
            this.error(res.getString("Company_Invalid"));
            result = false;
            this.requestFocusInvalid(this.edtCompany);
        } else if (!this.checkText(this.edtPhone.getText())) {
            this.error(res.getString("Phone_Invalid"));
            result = false;
            this.requestFocusInvalid(this.edtPhone);
        } else if (!this.simpleCheckEmail(this.edtEmail.getText())) {
            result = false;
            this.requestFocusInvalid(this.edtEmail);
        } else if (this.isConfirmEmail() && !this.simpleCheckEmail(this.edtConfirmEmail.getText())) {
            result = false;
            this.requestFocusInvalid(this.edtConfirmEmail);
        } else if (this.isConfirmEmail() && !this.edtEmail.getText().equalsIgnoreCase(this.edtConfirmEmail.getText())) {
            this.error("E-mail and confirm e-mail should match.");
            result = false;
            this.requestFocusInvalid(this.edtConfirmEmail);
        } else if (!this.checkText(this.edtAddress.getText())) {
            this.error(res.getString("Address_Invalid"));
            result = false;
            this.requestFocusInvalid(this.edtAddress);
        } else if (!this.checkText(this.edtCity.getText())) {
            this.error(res.getString("City_Invalid"));
            result = false;
            this.requestFocusInvalid(this.edtCity);
        } else if (!this.checkText(this.edtZip.getText())) {
            this.error(res.getString("ZIP_Invalid"));
            result = false;
            this.requestFocusInvalid(this.edtZip);
        } else if (this.cbxState.isEnabled() && this.cbxState.getSelectedItem() == null) {
            this.error(res.getString("State_Invalid"));
            result = false;
            this.requestFocusInvalid(this.cbxState);
        } else if (this.cbxCountry.getSelectedItem() == null) {
            this.error(res.getString("Country_Invalid"));
            result = false;
            this.requestFocusInvalid(this.cbxCountry);
        }
        return result;
    }

    public void requestFocus() {
        this.edtFirstName.requestFocus();
    }

    void cbxCountry_actionPerformed(ActionEvent e) {
        this.enableStateCombobox();
    }

    protected void enableStateCombobox() {
        Object value = this.cbxCountry.getSelectedItem();
        this.cbxState.setEnabled("United States".equals(value) || "Canada".equals(value));
        if (!this.cbxState.isEnabled()) {
            this.cbxState.setSelectedItem(null);
        }
    }

    protected boolean simpleCheckEmail(String aEmailAddress) {
        boolean result = true;
        if (StringUtils.noValue(aEmailAddress)) {
            this.error(res.getString("Email_Invalid"));
            result = false;
        } else {
            String[] splitAddress = aEmailAddress.split("@");
            if (splitAddress.length != 2) {
                this.error(res.getString("Both_name_and_domain"));
                result = false;
            } else if (StringUtils.noValue(splitAddress[0])) {
                this.error(res.getString("Name_should_be"));
                result = false;
            } else if (StringUtils.noValue(splitAddress[1])) {
                this.error(res.getString("Domain_should_be"));
                result = false;
            } else if (splitAddress[1].split("\\.").length < 2) {
                this.error(res.getString("Domain_is_invalid"));
                result = false;
            }
        }
        return result;
    }

    public boolean isRequired() {
        return this.fRequired;
    }

    public void setRequired(boolean aRequired) {
        this.fRequired = aRequired;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (!(c instanceof IndicatorHolder) || c == this.edtTitle) continue;
            ((IndicatorHolder)((Object)c)).setIndicator(this.fRequired ? "*" : null);
        }
    }

    public boolean isConfirmEmail() {
        return this.fConfirmEmail;
    }

    public void setConfirmEmail(boolean aConfirmEmail) {
        if (this.fConfirmEmail != aConfirmEmail) {
            this.fConfirmEmail = aConfirmEmail;
            this.lblConfirmEmail.setVisible(aConfirmEmail);
            this.edtConfirmEmail.setVisible(aConfirmEmail);
        }
    }

    public boolean isModified() {
        return this.fModified;
    }

    public void setModified(boolean aModified) {
        if (this.fModified != aModified) {
            this.fModified = aModified;
            this.firePropertyChange("modified", !this.fModified, this.fModified);
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.setModified(true);
    }

    public void removeUpdate(DocumentEvent e) {
        this.setModified(true);
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cbxCountry) {
            this.cbxCountry_actionPerformed(e);
        }
        this.setModified(true);
    }
}

