/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.animation;

import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.animation.Animate;
import com.kitfox.svg.animation.AnimationElement;
import com.kitfox.svg.animation.AnimationTimeEval;
import com.kitfox.svg.animation.TrackBase;
import com.kitfox.svg.xml.StyleAttribute;
import java.util.Iterator;

public class TrackDouble
extends TrackBase {
    public TrackDouble(AnimationElement animationElement) throws SVGElementException {
        super(animationElement.getParent(), animationElement);
    }

    public boolean getValue(StyleAttribute styleAttribute, double d2) {
        double d3 = this.getValue(d2);
        if (Double.isNaN(d3)) {
            return false;
        }
        styleAttribute.setStringValue("" + d3);
        return true;
    }

    public double getValue(double d2) {
        boolean bl = AnimationElement.f;
        double d3 = Double.NaN;
        StyleAttribute styleAttribute = null;
        switch (this.attribType) {
            case 0: {
                styleAttribute = this.parent.getStyleAbsolute(this.attribName);
                d3 = styleAttribute.getDoubleValue();
                break;
            }
            case 1: {
                styleAttribute = this.parent.getPresAbsolute(this.attribName);
                d3 = styleAttribute.getDoubleValue();
                break;
            }
            case 2: {
                styleAttribute = this.parent.getStyleAbsolute(this.attribName);
                if (styleAttribute == null) {
                    styleAttribute = this.parent.getPresAbsolute(this.attribName);
                }
                d3 = styleAttribute.getDoubleValue();
            }
        }
        AnimationTimeEval animationTimeEval = new AnimationTimeEval();
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            Animate animate = (Animate)iterator.next();
            animate.evalParametric(animationTimeEval, d2);
            if (Double.isNaN(animationTimeEval.interp)) continue;
            switch (animate.getAdditiveType()) {
                case 1: {
                    d3 += animate.eval(animationTimeEval.interp);
                    if (!bl) break;
                }
                case 0: {
                    d3 = animate.eval(animationTimeEval.interp);
                }
            }
            if (animationTimeEval.rep > 0) {
                switch (animate.getAccumulateType()) {
                    case 1: {
                        d3 += animate.repeatSkipSize(animationTimeEval.rep);
                    }
                }
            }
            if (!bl) continue;
        }
        return d3;
    }
}

