/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.animation;

import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.animation.AnimateBase;
import com.kitfox.svg.animation.AnimateColorIface;
import com.kitfox.svg.animation.AnimationElement;
import com.kitfox.svg.animation.AnimationTimeEval;
import com.kitfox.svg.animation.TrackBase;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Color;
import java.util.Iterator;

public class TrackColor
extends TrackBase {
    public TrackColor(AnimationElement animationElement) throws SVGElementException {
        super(animationElement.getParent(), animationElement);
    }

    public boolean getValue(StyleAttribute styleAttribute, double d2) {
        Color color = this.getValue(d2);
        if (color == null) {
            return false;
        }
        styleAttribute.setStringValue("#" + Integer.toHexString(color.getRGB()));
        return true;
    }

    public Color getValue(double d2) {
        boolean bl = AnimationElement.f;
        Color color = null;
        AnimationTimeEval animationTimeEval = new AnimationTimeEval();
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            AnimateBase animateBase = (AnimateBase)iterator.next();
            AnimateColorIface animateColorIface = (AnimateColorIface)((Object)animateBase);
            animateBase.evalParametric(animationTimeEval, d2);
            if (Double.isNaN(animationTimeEval.interp)) continue;
            if (color == null) {
                color = animateColorIface.evalColor(animationTimeEval.interp);
                if (!bl) continue;
            }
            Color color2 = animateColorIface.evalColor(animationTimeEval.interp);
            switch (animateBase.getAdditiveType()) {
                case 0: {
                    color = color2;
                    if (!bl) break;
                }
                case 1: {
                    color = new Color(color2.getRed() + color.getRed(), color2.getGreen() + color.getGreen(), color2.getBlue() + color.getBlue());
                }
            }
            if (!bl) continue;
        }
        return color;
    }
}

