/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.SVGParseException;
import com.kitfox.svg.SVGRoot;
import com.kitfox.svg.animation.AnimationElement;
import com.kitfox.svg.animation.TrackBase;
import com.kitfox.svg.animation.TrackManager;
import com.kitfox.svg.pathcmd.Arc;
import com.kitfox.svg.pathcmd.BuildHistory;
import com.kitfox.svg.pathcmd.Cubic;
import com.kitfox.svg.pathcmd.CubicSmooth;
import com.kitfox.svg.pathcmd.Horizontal;
import com.kitfox.svg.pathcmd.LineTo;
import com.kitfox.svg.pathcmd.MoveTo;
import com.kitfox.svg.pathcmd.PathCommand;
import com.kitfox.svg.pathcmd.Quadratic;
import com.kitfox.svg.pathcmd.QuadraticSmooth;
import com.kitfox.svg.pathcmd.Terminal;
import com.kitfox.svg.pathcmd.Vertical;
import com.kitfox.svg.xml.StyleAttribute;
import com.kitfox.svg.xml.StyleSheet;
import com.kitfox.svg.xml.XMLParseUtil;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class SVGElement
implements Serializable {
    public static final long serialVersionUID = 0L;
    public static final String SVG_NS;
    protected SVGElement parent = null;
    protected final ArrayList children = new ArrayList();
    protected String id = null;
    protected String cssClass = null;
    protected final HashMap inlineStyles = new HashMap();
    protected final HashMap presAttribs = new HashMap();
    protected static final Set ignorePresAttrib;
    protected URI xmlBase = null;
    protected SVGDiagram diagram;
    protected final TrackManager trackManager = new TrackManager();
    boolean a = true;
    LinkedList b = new LinkedList();
    public static int c;
    private static final String[] z;

    public SVGElement() {
        this(null, null, null);
    }

    public SVGElement(String string, SVGElement sVGElement) {
        this(string, null, sVGElement);
    }

    public SVGElement(String string, String string2, SVGElement sVGElement) {
        this.id = string;
        this.cssClass = string2;
        this.parent = sVGElement;
    }

    public abstract String getTagName();

    public SVGElement getParent() {
        return this.parent;
    }

    public List getPath(List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<SVGElement>();
        }
        if (this.parent != null) {
            this.parent.getPath(arrayList);
        }
        arrayList.add(this);
        return arrayList;
    }

    public List getChildren(List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        arrayList.addAll(this.children);
        return arrayList;
    }

    public SVGElement getChild(String string) {
        boolean bl = SVGException.a;
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            SVGElement sVGElement = (SVGElement)iterator.next();
            String string2 = sVGElement.getId();
            if (string2 != null && string2.equals(string)) {
                return sVGElement;
            }
            if (!bl) continue;
        }
        return null;
    }

    public int indexOfChild(SVGElement sVGElement) {
        return this.children.indexOf(sVGElement);
    }

    public void swapChildren(int n2, int n3) throws SVGException {
        if (this.children == null || n2 < 0 || n2 >= this.children.size() || n3 < 0 || n3 >= this.children.size()) {
            return;
        }
        Object e2 = this.children.get(n2);
        this.children.set(n2, this.children.get(n3));
        this.children.set(n3, e2);
        this.build();
    }

    public void loaderStartElement(SVGLoaderHelper sVGLoaderHelper, Attributes attributes, SVGElement sVGElement) throws SAXException {
        Object object;
        String string;
        boolean bl = SVGException.a;
        this.parent = sVGElement;
        this.diagram = sVGLoaderHelper.diagram;
        this.id = attributes.getValue(z[2]);
        if (this.id != null && !this.id.equals("")) {
            this.diagram.setElement(this.id, this);
        }
        this.cssClass = (string = attributes.getValue(z[18])) == null || string.equals("") ? null : string;
        String string2 = attributes.getValue(z[20]);
        if (string2 != null) {
            object = XMLParseUtil.parseStyle(string2, this.inlineStyles);
        }
        if ((object = attributes.getValue(z[19])) != null && !((String)object).equals("")) {
            try {
                this.xmlBase = new URI((String)object);
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
        int n2 = attributes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = attributes.getQName(i2);
            if (ignorePresAttrib.contains(string3) && !bl) continue;
            String string4 = attributes.getValue(i2);
            this.presAttribs.put(string3, new StyleAttribute(string3, string4));
            if (!bl) continue;
        }
    }

    public void removeAttribute(String string, int n2) {
        switch (n2) {
            case 0: {
                this.inlineStyles.remove(string);
                return;
            }
            case 1: {
                this.presAttribs.remove(string);
                return;
            }
        }
    }

    public void addAttribute(String string, int n2, String string2) throws SVGElementException {
        if (this.hasAttribute(string, n2)) {
            throw new SVGElementException(this, z[16] + string + "(" + AnimationElement.animationElementToString(n2) + z[17]);
        }
        if (z[2].equals(string)) {
            if (this.diagram != null) {
                this.diagram.removeElement(this.id);
                this.diagram.setElement(string2, this);
            }
            this.id = string2;
        }
        switch (n2) {
            case 0: {
                this.inlineStyles.put(string, new StyleAttribute(string, string2));
                return;
            }
            case 1: {
                this.presAttribs.put(string, new StyleAttribute(string, string2));
                return;
            }
        }
        throw new SVGElementException(this, z[5] + n2);
    }

    public boolean hasAttribute(String string, int n2) throws SVGElementException {
        switch (n2) {
            case 0: {
                return this.inlineStyles.containsKey(string);
            }
            case 1: {
                return this.presAttribs.containsKey(string);
            }
            case 2: {
                return this.inlineStyles.containsKey(string) || this.presAttribs.containsKey(string);
            }
        }
        throw new SVGElementException(this, z[5] + n2);
    }

    public Set getInlineAttributes() {
        return this.inlineStyles.keySet();
    }

    public Set getPresentationAttributes() {
        return this.presAttribs.keySet();
    }

    public void loaderAddChild(SVGLoaderHelper sVGLoaderHelper, SVGElement sVGElement) throws SVGElementException {
        this.children.add(sVGElement);
        sVGElement.parent = this;
        sVGElement.setDiagram(this.diagram);
        if (sVGElement instanceof AnimationElement) {
            this.trackManager.addTrackElement((AnimationElement)sVGElement);
        }
    }

    protected void setDiagram(SVGDiagram sVGDiagram) {
        boolean bl = SVGException.a;
        this.diagram = sVGDiagram;
        sVGDiagram.setElement(this.id, this);
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            SVGElement sVGElement = (SVGElement)iterator.next();
            sVGElement.setDiagram(sVGDiagram);
            if (!bl) continue;
        }
    }

    public void removeChild(SVGElement sVGElement) throws SVGElementException {
        if (!this.children.contains(sVGElement)) {
            throw new SVGElementException(this, z[15] + sVGElement);
        }
        this.children.remove(sVGElement);
    }

    public void loaderAddText(SVGLoaderHelper sVGLoaderHelper, String string) {
    }

    public void loaderEndElement(SVGLoaderHelper sVGLoaderHelper) throws SVGParseException {
    }

    protected void build() throws SVGException {
        String string;
        boolean bl = SVGException.a;
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName(z[2])) && !(string = styleAttribute.getStringValue()).equals(this.id)) {
            this.diagram.removeElement(this.id);
            this.id = string;
            this.diagram.setElement(this.id, this);
        }
        if (this.getPres(styleAttribute.setName(z[18]))) {
            this.cssClass = styleAttribute.getStringValue();
        }
        if (this.getPres(styleAttribute.setName(z[19]))) {
            this.xmlBase = styleAttribute.getURIValue();
        }
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            SVGElement sVGElement = (SVGElement)this.children.get(i2);
            sVGElement.build();
            if (!bl) continue;
        }
    }

    public URI getXMLBase() {
        return this.xmlBase != null ? this.xmlBase : (this.parent != null ? this.parent.getXMLBase() : this.diagram.getXMLBase());
    }

    public String getId() {
        return this.id;
    }

    protected void pushParentContext(SVGElement sVGElement) {
        this.b.addLast(sVGElement);
    }

    protected SVGElement popParentContext() {
        return (SVGElement)this.b.removeLast();
    }

    protected SVGElement getParentContext() {
        return this.b.isEmpty() ? null : (SVGElement)this.b.getLast();
    }

    public SVGRoot getRoot() {
        return this.parent == null ? null : this.parent.getRoot();
    }

    public boolean getStyle(StyleAttribute styleAttribute) throws SVGException {
        return this.getStyle(styleAttribute, true);
    }

    public void setAttribute(String string, int n2, String string2) throws SVGElementException {
        StyleAttribute styleAttribute;
        boolean bl = SVGException.a;
        switch (n2) {
            case 0: {
                styleAttribute = (StyleAttribute)this.inlineStyles.get(string);
                if (!bl) break;
            }
            case 1: {
                styleAttribute = (StyleAttribute)this.presAttribs.get(string);
                if (!bl) break;
            }
            case 2: {
                styleAttribute = (StyleAttribute)this.inlineStyles.get(string);
                if (styleAttribute != null) break;
                styleAttribute = (StyleAttribute)this.presAttribs.get(string);
                if (!bl) break;
            }
            default: {
                throw new SVGElementException(this, z[5] + n2);
            }
        }
        if (styleAttribute == null) {
            throw new SVGElementException(this, z[4] + string + "(" + AnimationElement.animationElementToString(n2) + z[3]);
        }
        if (z[2].equals(styleAttribute.getName())) {
            if (this.diagram != null) {
                this.diagram.removeElement(this.id);
                this.diagram.setElement(string2, this);
            }
            this.id = string2;
        }
        styleAttribute.setStringValue(string2);
    }

    public boolean getStyle(StyleAttribute styleAttribute, boolean bl) throws SVGException {
        Object object;
        String string = styleAttribute.getName();
        StyleAttribute styleAttribute2 = (StyleAttribute)this.inlineStyles.get(string);
        styleAttribute.setStringValue(styleAttribute2 == null ? "" : styleAttribute2.getStringValue());
        TrackBase trackBase = this.trackManager.getTrack(string, 0);
        if (trackBase != null) {
            trackBase.getValue(styleAttribute, this.diagram.getUniverse().getCurTime());
            return true;
        }
        if (styleAttribute2 != null) {
            return true;
        }
        StyleAttribute styleAttribute3 = (StyleAttribute)this.presAttribs.get(string);
        styleAttribute.setStringValue(styleAttribute3 == null ? "" : styleAttribute3.getStringValue());
        trackBase = this.trackManager.getTrack(string, 1);
        if (trackBase != null) {
            trackBase.getValue(styleAttribute, this.diagram.getUniverse().getCurTime());
            return true;
        }
        if (styleAttribute3 != null) {
            return true;
        }
        SVGRoot sVGRoot = this.getRoot();
        if (sVGRoot != null && (object = sVGRoot.getStyleSheet()) != null) {
            return ((StyleSheet)object).getStyle(styleAttribute, this.getTagName(), this.cssClass);
        }
        if (bl) {
            object = this.getParentContext();
            if (object != null) {
                return ((SVGElement)object).getStyle(styleAttribute, true);
            }
            if (this.parent != null) {
                return this.parent.getStyle(styleAttribute, true);
            }
        }
        return false;
    }

    public StyleAttribute getStyleAbsolute(String string) {
        return (StyleAttribute)this.inlineStyles.get(string);
    }

    public boolean getPres(StyleAttribute styleAttribute) throws SVGException {
        String string = styleAttribute.getName();
        StyleAttribute styleAttribute2 = (StyleAttribute)this.presAttribs.get(string);
        styleAttribute.setStringValue(styleAttribute2 == null ? "" : styleAttribute2.getStringValue());
        TrackBase trackBase = this.trackManager.getTrack(string, 1);
        if (trackBase != null) {
            trackBase.getValue(styleAttribute, this.diagram.getUniverse().getCurTime());
            return true;
        }
        return styleAttribute2 != null;
    }

    public StyleAttribute getPresAbsolute(String string) {
        return (StyleAttribute)this.presAttribs.get(string);
    }

    protected static AffineTransform parseTransform(String string) throws SVGException {
        boolean bl = SVGException.a;
        Matcher matcher = Pattern.compile(z[6]).matcher("");
        AffineTransform affineTransform = new AffineTransform();
        matcher.reset(string);
        while (matcher.find()) {
            affineTransform.concatenate(SVGElement.parseSingleTransform(matcher.group()));
            if (!bl) continue;
        }
        return affineTransform;
    }

    public static AffineTransform parseSingleTransform(String string) throws SVGException {
        AffineTransform affineTransform;
        block7: {
            block15: {
                double[] dArray;
                String string2;
                boolean bl;
                block14: {
                    block12: {
                        block13: {
                            block10: {
                                block11: {
                                    block8: {
                                        block9: {
                                            block6: {
                                                bl = SVGException.a;
                                                Matcher matcher = Pattern.compile(z[8]).matcher("");
                                                affineTransform = new AffineTransform();
                                                matcher.reset(string);
                                                if (!matcher.find()) {
                                                    return affineTransform;
                                                }
                                                string2 = matcher.group().toLowerCase();
                                                LinkedList<String> linkedList = new LinkedList<String>();
                                                while (matcher.find()) {
                                                    linkedList.add(matcher.group());
                                                    if (!bl) continue;
                                                }
                                                dArray = new double[linkedList.size()];
                                                Iterator iterator = linkedList.iterator();
                                                int n2 = 0;
                                                while (iterator.hasNext()) {
                                                    dArray[n2++] = XMLParseUtil.parseDouble((String)iterator.next());
                                                    if (!bl) continue;
                                                }
                                                if (!string2.equals(z[9])) break block6;
                                                affineTransform.setTransform(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                                                if (!bl) break block7;
                                            }
                                            if (!string2.equals(z[10])) break block8;
                                            if (dArray.length != 1) break block9;
                                            affineTransform.setToTranslation(dArray[0], 0.0);
                                            if (!bl) break block7;
                                        }
                                        affineTransform.setToTranslation(dArray[0], dArray[1]);
                                        if (!bl) break block7;
                                    }
                                    if (!string2.equals(z[14])) break block10;
                                    if (dArray.length <= 1) break block11;
                                    affineTransform.setToScale(dArray[0], dArray[1]);
                                    if (!bl) break block7;
                                }
                                affineTransform.setToScale(dArray[0], dArray[0]);
                                if (!bl) break block7;
                            }
                            if (!string2.equals(z[13])) break block12;
                            if (dArray.length <= 2) break block13;
                            affineTransform.setToRotation(Math.toRadians(dArray[0]), dArray[1], dArray[2]);
                            if (!bl) break block7;
                        }
                        affineTransform.setToRotation(Math.toRadians(dArray[0]));
                        if (!bl) break block7;
                    }
                    if (!string2.equals(z[12])) break block14;
                    affineTransform.setToShear(Math.toRadians(dArray[0]), 0.0);
                    if (!bl) break block7;
                }
                if (!string2.equals(z[7])) break block15;
                affineTransform.setToShear(0.0, Math.toRadians(dArray[0]));
                if (!bl) break block7;
            }
            throw new SVGException(z[11]);
        }
        return affineTransform;
    }

    protected static float nextFloat(LinkedList linkedList) {
        String string = (String)linkedList.removeFirst();
        return Float.parseFloat(string);
    }

    protected static PathCommand[] parsePathList(String string) {
        PathCommand[] pathCommandArray;
        boolean bl = SVGException.a;
        Matcher matcher = Pattern.compile(z[1]).matcher(string);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (matcher.find()) {
            linkedList.addLast(matcher.group());
            if (!bl) continue;
        }
        boolean bl2 = false;
        LinkedList<Terminal> linkedList2 = new LinkedList<Terminal>();
        int n2 = 90;
        while (linkedList.size() != 0) {
            block26: {
                block25: {
                    pathCommandArray = (PathCommand[])linkedList.removeFirst();
                    char c2 = pathCommandArray.charAt(0);
                    if ((c2 < 'A' || c2 > 'Z') && (c2 < 'a' || c2 > 'z')) break block25;
                    n2 = c2;
                    if (!bl) break block26;
                }
                linkedList.addFirst(pathCommandArray);
            }
            PathCommand pathCommand = null;
            switch (n2) {
                case 77: {
                    pathCommand = new MoveTo(false, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    n2 = 76;
                    break;
                }
                case 109: {
                    pathCommand = new MoveTo(true, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    n2 = 108;
                    break;
                }
                case 76: {
                    pathCommand = new LineTo(false, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 108: {
                    pathCommand = new LineTo(true, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 72: {
                    pathCommand = new Horizontal(false, SVGElement.nextFloat(linkedList));
                    break;
                }
                case 104: {
                    pathCommand = new Horizontal(true, SVGElement.nextFloat(linkedList));
                    break;
                }
                case 86: {
                    pathCommand = new Vertical(false, SVGElement.nextFloat(linkedList));
                    break;
                }
                case 118: {
                    pathCommand = new Vertical(true, SVGElement.nextFloat(linkedList));
                    break;
                }
                case 65: {
                    pathCommand = new Arc(false, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList) == 1.0f, SVGElement.nextFloat(linkedList) == 1.0f, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 97: {
                    pathCommand = new Arc(true, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList) == 1.0f, SVGElement.nextFloat(linkedList) == 1.0f, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 81: {
                    pathCommand = new Quadratic(false, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 113: {
                    pathCommand = new Quadratic(true, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 84: {
                    pathCommand = new QuadraticSmooth(false, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 116: {
                    pathCommand = new QuadraticSmooth(true, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 67: {
                    pathCommand = new Cubic(false, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 99: {
                    pathCommand = new Cubic(true, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 83: {
                    pathCommand = new CubicSmooth(false, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 115: {
                    pathCommand = new CubicSmooth(true, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 90: 
                case 122: {
                    pathCommand = new Terminal();
                    break;
                }
                default: {
                    throw new RuntimeException(z[0]);
                }
            }
            linkedList2.add((Terminal)pathCommand);
            bl2 = pathCommand.isRelative;
            if (!bl) continue;
        }
        pathCommandArray = new PathCommand[linkedList2.size()];
        linkedList2.toArray(pathCommandArray);
        return pathCommandArray;
    }

    protected static GeneralPath buildPath(String string, int n2) {
        boolean bl = SVGException.a;
        PathCommand[] pathCommandArray = SVGElement.parsePathList(string);
        int n3 = 2;
        for (int i2 = 0; i2 < pathCommandArray.length; ++i2) {
            n3 += pathCommandArray[i2].getNumKnotsAdded();
            if (!bl) continue;
        }
        GeneralPath generalPath = new GeneralPath(n2, n3);
        BuildHistory buildHistory = new BuildHistory();
        for (int i3 = 0; i3 < pathCommandArray.length; ++i3) {
            PathCommand pathCommand = pathCommandArray[i3];
            pathCommand.appendPath(generalPath, buildHistory);
            if (!bl) continue;
        }
        return generalPath;
    }

    public abstract boolean updateTime(double var1) throws SVGException;

    public int getNumChildren() {
        return this.children.size();
    }

    public SVGElement getChild(int n2) {
        return (SVGElement)this.children.get(n2);
    }

    public double lerp(double d2, double d3, double d4) {
        return (1.0 - d4) * d2 + d4 * d3;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block241: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block240: {
                char[] cArray3;
                Object var1;
                block239: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block238: {
                        char[] cArray5;
                        block237: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block236: {
                                char[] cArray7;
                                block235: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block234: {
                                        char[] cArray9;
                                        block233: {
                                            int n11;
                                            int n12;
                                            char[] cArray10;
                                            block232: {
                                                char[] cArray11;
                                                block231: {
                                                    int n13;
                                                    int n14;
                                                    char[] cArray12;
                                                    block230: {
                                                        char[] cArray13;
                                                        block229: {
                                                            int n15;
                                                            int n16;
                                                            char[] cArray14;
                                                            block228: {
                                                                char[] cArray15;
                                                                block227: {
                                                                    int n17;
                                                                    int n18;
                                                                    char[] cArray16;
                                                                    block226: {
                                                                        char[] cArray17;
                                                                        block225: {
                                                                            int n19;
                                                                            int n20;
                                                                            char[] cArray18;
                                                                            block224: {
                                                                                char[] cArray19;
                                                                                block223: {
                                                                                    int n21;
                                                                                    int n22;
                                                                                    char[] cArray20;
                                                                                    block222: {
                                                                                        char[] cArray21;
                                                                                        block221: {
                                                                                            int n23;
                                                                                            int n24;
                                                                                            char[] cArray22;
                                                                                            block220: {
                                                                                                char[] cArray23;
                                                                                                block219: {
                                                                                                    int n25;
                                                                                                    int n26;
                                                                                                    char[] cArray24;
                                                                                                    block218: {
                                                                                                        char[] cArray25;
                                                                                                        block217: {
                                                                                                            int n27;
                                                                                                            int n28;
                                                                                                            char[] cArray26;
                                                                                                            block216: {
                                                                                                                char[] cArray27;
                                                                                                                block215: {
                                                                                                                    int n29;
                                                                                                                    int n30;
                                                                                                                    char[] cArray28;
                                                                                                                    block214: {
                                                                                                                        char[] cArray29;
                                                                                                                        block213: {
                                                                                                                            int n31;
                                                                                                                            int n32;
                                                                                                                            char[] cArray30;
                                                                                                                            block212: {
                                                                                                                                char[] cArray31;
                                                                                                                                block211: {
                                                                                                                                    int n33;
                                                                                                                                    int n34;
                                                                                                                                    char[] cArray32;
                                                                                                                                    block210: {
                                                                                                                                        char[] cArray33;
                                                                                                                                        block209: {
                                                                                                                                            int n35;
                                                                                                                                            int n36;
                                                                                                                                            char[] cArray34;
                                                                                                                                            block208: {
                                                                                                                                                char[] cArray35;
                                                                                                                                                block207: {
                                                                                                                                                    int n37;
                                                                                                                                                    int n38;
                                                                                                                                                    char[] cArray36;
                                                                                                                                                    block206: {
                                                                                                                                                        char[] cArray37;
                                                                                                                                                        block205: {
                                                                                                                                                            int n39;
                                                                                                                                                            int n40;
                                                                                                                                                            char[] cArray38;
                                                                                                                                                            block204: {
                                                                                                                                                                char[] cArray39;
                                                                                                                                                                block203: {
                                                                                                                                                                    int n41;
                                                                                                                                                                    int n42;
                                                                                                                                                                    char[] cArray40;
                                                                                                                                                                    block202: {
                                                                                                                                                                        char[] cArray41;
                                                                                                                                                                        block201: {
                                                                                                                                                                            int n43;
                                                                                                                                                                            int n44;
                                                                                                                                                                            char[] cArray42;
                                                                                                                                                                            block200: {
                                                                                                                                                                                char[] cArray43;
                                                                                                                                                                                block199: {
                                                                                                                                                                                    int n45;
                                                                                                                                                                                    int n46;
                                                                                                                                                                                    char[] cArray44;
                                                                                                                                                                                    block198: {
                                                                                                                                                                                        stringArray = new String[21];
                                                                                                                                                                                        var1 = null;
                                                                                                                                                                                        char[] cArray45 = "0b+ \u0019w9('Tval~L*qpb\u0013h&p#U?".toCharArray();
                                                                                                                                                                                        n4 = 0;
                                                                                                                                                                                        int n47 = cArray45.length;
                                                                                                                                                                                        cArray44 = cArray45;
                                                                                                                                                                                        n46 = n47;
                                                                                                                                                                                        if (n47 <= 1) break block198;
                                                                                                                                                                                        cArray43 = cArray44;
                                                                                                                                                                                        n45 = n46;
                                                                                                                                                                                        if (n46 <= n4) break block199;
                                                                                                                                                                                    }
                                                                                                                                                                                    do {
                                                                                                                                                                                        char[] cArray46 = cArray44;
                                                                                                                                                                                        char[] cArray47 = cArray44;
                                                                                                                                                                                        int n48 = n4;
                                                                                                                                                                                        while (true) {
                                                                                                                                                                                            int n49;
                                                                                                                                                                                            char c2 = cArray46[n48];
                                                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                                                case 0: {
                                                                                                                                                                                                    n49 = 88;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                case 1: {
                                                                                                                                                                                                    n49 = 22;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                case 2: {
                                                                                                                                                                                                    n49 = 95;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                case 3: {
                                                                                                                                                                                                    n49 = 80;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                default: {
                                                                                                                                                                                                    n49 = 35;
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                            cArray46[n48] = (char)(c2 ^ n49);
                                                                                                                                                                                            ++n4;
                                                                                                                                                                                            cArray44 = cArray47;
                                                                                                                                                                                            n46 = n46;
                                                                                                                                                                                            if (n46 != 0) break;
                                                                                                                                                                                            cArray47 = cArray44;
                                                                                                                                                                                            n45 = n46;
                                                                                                                                                                                            n48 = n46;
                                                                                                                                                                                            cArray46 = cArray44;
                                                                                                                                                                                        }
                                                                                                                                                                                        cArray43 = cArray44;
                                                                                                                                                                                        n45 = n46;
                                                                                                                                                                                    } while (n46 > n4);
                                                                                                                                                                                }
                                                                                                                                                                                SVG_NS = new String(cArray43).intern();
                                                                                                                                                                                var1 = null;
                                                                                                                                                                                char[] cArray48 = "\u0011x)1O1r\u007f B,~\u007f5O={:>W".toCharArray();
                                                                                                                                                                                n4 = 0;
                                                                                                                                                                                int n50 = cArray48.length;
                                                                                                                                                                                cArray42 = cArray48;
                                                                                                                                                                                n44 = n50;
                                                                                                                                                                                if (n50 <= 1) break block200;
                                                                                                                                                                                cArray41 = cArray42;
                                                                                                                                                                                n43 = n44;
                                                                                                                                                                                if (n44 <= n4) break block201;
                                                                                                                                                                            }
                                                                                                                                                                            do {
                                                                                                                                                                                char[] cArray49 = cArray42;
                                                                                                                                                                                char[] cArray50 = cArray42;
                                                                                                                                                                                int n51 = n4;
                                                                                                                                                                                while (true) {
                                                                                                                                                                                    int n52;
                                                                                                                                                                                    char c3 = cArray49[n51];
                                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                                        case 0: {
                                                                                                                                                                                            n52 = 88;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        case 1: {
                                                                                                                                                                                            n52 = 22;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        case 2: {
                                                                                                                                                                                            n52 = 95;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        case 3: {
                                                                                                                                                                                            n52 = 80;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        default: {
                                                                                                                                                                                            n52 = 35;
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                    cArray49[n51] = (char)(c3 ^ n52);
                                                                                                                                                                                    ++n4;
                                                                                                                                                                                    cArray42 = cArray50;
                                                                                                                                                                                    n44 = n44;
                                                                                                                                                                                    if (n44 != 0) break;
                                                                                                                                                                                    cArray50 = cArray42;
                                                                                                                                                                                    n43 = n44;
                                                                                                                                                                                    n51 = n44;
                                                                                                                                                                                    cArray49 = cArray42;
                                                                                                                                                                                }
                                                                                                                                                                                cArray41 = cArray42;
                                                                                                                                                                                n43 = n44;
                                                                                                                                                                            } while (n44 > n4);
                                                                                                                                                                        }
                                                                                                                                                                        stringArray[0] = new String(cArray41).intern();
                                                                                                                                                                        var1 = null;
                                                                                                                                                                        char[] cArray51 = "pM\u0012=o4^7\u0006U\u0019w\u000e!w,U<\u0003P\u0002l\u0002y_pMr{~g>w\fGrJq\fGs?#x\u007f<=vy\u000b\u0003s\u001a\rxu=\u0002o\u007f<=vo\n".toCharArray();
                                                                                                                                                                        n4 = 0;
                                                                                                                                                                        int n53 = cArray51.length;
                                                                                                                                                                        cArray40 = cArray51;
                                                                                                                                                                        n42 = n53;
                                                                                                                                                                        if (n53 <= 1) break block202;
                                                                                                                                                                        cArray39 = cArray40;
                                                                                                                                                                        n41 = n42;
                                                                                                                                                                        if (n42 <= n4) break block203;
                                                                                                                                                                    }
                                                                                                                                                                    do {
                                                                                                                                                                        char[] cArray52 = cArray40;
                                                                                                                                                                        char[] cArray53 = cArray40;
                                                                                                                                                                        int n54 = n4;
                                                                                                                                                                        while (true) {
                                                                                                                                                                            int n55;
                                                                                                                                                                            char c4 = cArray52[n54];
                                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                                case 0: {
                                                                                                                                                                                    n55 = 88;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 1: {
                                                                                                                                                                                    n55 = 22;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 2: {
                                                                                                                                                                                    n55 = 95;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 3: {
                                                                                                                                                                                    n55 = 80;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                default: {
                                                                                                                                                                                    n55 = 35;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                            cArray52[n54] = (char)(c4 ^ n55);
                                                                                                                                                                            ++n4;
                                                                                                                                                                            cArray40 = cArray53;
                                                                                                                                                                            n42 = n42;
                                                                                                                                                                            if (n42 != 0) break;
                                                                                                                                                                            cArray53 = cArray40;
                                                                                                                                                                            n41 = n42;
                                                                                                                                                                            n54 = n42;
                                                                                                                                                                            cArray52 = cArray40;
                                                                                                                                                                        }
                                                                                                                                                                        cArray39 = cArray40;
                                                                                                                                                                        n41 = n42;
                                                                                                                                                                    } while (n42 > n4);
                                                                                                                                                                }
                                                                                                                                                                stringArray[1] = new String(cArray39).intern();
                                                                                                                                                                var1 = null;
                                                                                                                                                                char[] cArray54 = "1r".toCharArray();
                                                                                                                                                                n4 = 0;
                                                                                                                                                                int n56 = cArray54.length;
                                                                                                                                                                cArray38 = cArray54;
                                                                                                                                                                n40 = n56;
                                                                                                                                                                if (n56 <= 1) break block204;
                                                                                                                                                                cArray37 = cArray38;
                                                                                                                                                                n39 = n40;
                                                                                                                                                                if (n40 <= n4) break block205;
                                                                                                                                                            }
                                                                                                                                                            do {
                                                                                                                                                                char[] cArray55 = cArray38;
                                                                                                                                                                char[] cArray56 = cArray38;
                                                                                                                                                                int n57 = n4;
                                                                                                                                                                while (true) {
                                                                                                                                                                    int n58;
                                                                                                                                                                    char c5 = cArray55[n57];
                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                        case 0: {
                                                                                                                                                                            n58 = 88;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 1: {
                                                                                                                                                                            n58 = 22;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 2: {
                                                                                                                                                                            n58 = 95;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 3: {
                                                                                                                                                                            n58 = 80;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        default: {
                                                                                                                                                                            n58 = 35;
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                    cArray55[n57] = (char)(c5 ^ n58);
                                                                                                                                                                    ++n4;
                                                                                                                                                                    cArray38 = cArray56;
                                                                                                                                                                    n40 = n40;
                                                                                                                                                                    if (n40 != 0) break;
                                                                                                                                                                    cArray56 = cArray38;
                                                                                                                                                                    n39 = n40;
                                                                                                                                                                    n57 = n40;
                                                                                                                                                                    cArray55 = cArray38;
                                                                                                                                                                }
                                                                                                                                                                cArray37 = cArray38;
                                                                                                                                                                n39 = n40;
                                                                                                                                                            } while (n40 > n4);
                                                                                                                                                        }
                                                                                                                                                        stringArray[2] = new String(cArray37).intern();
                                                                                                                                                        var1 = null;
                                                                                                                                                        char[] cArray57 = "q8\u007fpn9}:pP-d:pW76<\"F9b:pB,b-9A-b:pA=p0\"Fxe:$W1x8pJ,8".toCharArray();
                                                                                                                                                        n4 = 0;
                                                                                                                                                        int n59 = cArray57.length;
                                                                                                                                                        cArray36 = cArray57;
                                                                                                                                                        n38 = n59;
                                                                                                                                                        if (n59 <= 1) break block206;
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n37 = n38;
                                                                                                                                                        if (n38 <= n4) break block207;
                                                                                                                                                    }
                                                                                                                                                    do {
                                                                                                                                                        char[] cArray58 = cArray36;
                                                                                                                                                        char[] cArray59 = cArray36;
                                                                                                                                                        int n60 = n4;
                                                                                                                                                        while (true) {
                                                                                                                                                            int n61;
                                                                                                                                                            char c6 = cArray58[n60];
                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                case 0: {
                                                                                                                                                                    n61 = 88;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 1: {
                                                                                                                                                                    n61 = 22;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 2: {
                                                                                                                                                                    n61 = 95;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 3: {
                                                                                                                                                                    n61 = 80;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                default: {
                                                                                                                                                                    n61 = 35;
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                            cArray58[n60] = (char)(c6 ^ n61);
                                                                                                                                                            ++n4;
                                                                                                                                                            cArray36 = cArray59;
                                                                                                                                                            n38 = n38;
                                                                                                                                                            if (n38 != 0) break;
                                                                                                                                                            cArray59 = cArray36;
                                                                                                                                                            n37 = n38;
                                                                                                                                                            n60 = n38;
                                                                                                                                                            cArray58 = cArray36;
                                                                                                                                                        }
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n37 = n38;
                                                                                                                                                    } while (n38 > n4);
                                                                                                                                                }
                                                                                                                                                stringArray[3] = new String(cArray35).intern();
                                                                                                                                                var1 = null;
                                                                                                                                                char[] cArray60 = "\u001by*<Gxx0$\u0003>\u007f14\u00039b+\"J:c+5\u0003".toCharArray();
                                                                                                                                                n4 = 0;
                                                                                                                                                int n62 = cArray60.length;
                                                                                                                                                cArray34 = cArray60;
                                                                                                                                                n36 = n62;
                                                                                                                                                if (n62 <= 1) break block208;
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n35 = n36;
                                                                                                                                                if (n36 <= n4) break block209;
                                                                                                                                            }
                                                                                                                                            do {
                                                                                                                                                char[] cArray61 = cArray34;
                                                                                                                                                char[] cArray62 = cArray34;
                                                                                                                                                int n63 = n4;
                                                                                                                                                while (true) {
                                                                                                                                                    int n64;
                                                                                                                                                    char c7 = cArray61[n63];
                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                        case 0: {
                                                                                                                                                            n64 = 88;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 1: {
                                                                                                                                                            n64 = 22;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 2: {
                                                                                                                                                            n64 = 95;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 3: {
                                                                                                                                                            n64 = 80;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        default: {
                                                                                                                                                            n64 = 35;
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                    cArray61[n63] = (char)(c7 ^ n64);
                                                                                                                                                    ++n4;
                                                                                                                                                    cArray34 = cArray62;
                                                                                                                                                    n36 = n36;
                                                                                                                                                    if (n36 != 0) break;
                                                                                                                                                    cArray62 = cArray34;
                                                                                                                                                    n35 = n36;
                                                                                                                                                    n63 = n36;
                                                                                                                                                    cArray61 = cArray34;
                                                                                                                                                }
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n35 = n36;
                                                                                                                                            } while (n36 > n4);
                                                                                                                                        }
                                                                                                                                        stringArray[4] = new String(cArray33).intern();
                                                                                                                                        var1 = null;
                                                                                                                                        char[] cArray63 = "\u0011x)1O1r\u007f1W,d62V,s\u007f$Z(s\u007f".toCharArray();
                                                                                                                                        n4 = 0;
                                                                                                                                        int n65 = cArray63.length;
                                                                                                                                        cArray32 = cArray63;
                                                                                                                                        n34 = n65;
                                                                                                                                        if (n65 <= 1) break block210;
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n33 = n34;
                                                                                                                                        if (n34 <= n4) break block211;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        char[] cArray64 = cArray32;
                                                                                                                                        char[] cArray65 = cArray32;
                                                                                                                                        int n66 = n4;
                                                                                                                                        while (true) {
                                                                                                                                            int n67;
                                                                                                                                            char c8 = cArray64[n66];
                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                case 0: {
                                                                                                                                                    n67 = 88;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 1: {
                                                                                                                                                    n67 = 22;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 2: {
                                                                                                                                                    n67 = 95;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 3: {
                                                                                                                                                    n67 = 80;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                default: {
                                                                                                                                                    n67 = 35;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            cArray64[n66] = (char)(c8 ^ n67);
                                                                                                                                            ++n4;
                                                                                                                                            cArray32 = cArray65;
                                                                                                                                            n34 = n34;
                                                                                                                                            if (n34 != 0) break;
                                                                                                                                            cArray65 = cArray32;
                                                                                                                                            n33 = n34;
                                                                                                                                            n66 = n34;
                                                                                                                                            cArray64 = cArray32;
                                                                                                                                        }
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n33 = n34;
                                                                                                                                    } while (n34 > n4);
                                                                                                                                }
                                                                                                                                stringArray[5] = new String(cArray31).intern();
                                                                                                                                var1 = null;
                                                                                                                                char[] cArray66 = "\u0004at\f\u000b\u0003Hv\r\t\u0004?".toCharArray();
                                                                                                                                n4 = 0;
                                                                                                                                int n68 = cArray66.length;
                                                                                                                                cArray30 = cArray66;
                                                                                                                                n32 = n68;
                                                                                                                                if (n68 <= 1) break block212;
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                                if (n32 <= n4) break block213;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                char[] cArray67 = cArray30;
                                                                                                                                char[] cArray68 = cArray30;
                                                                                                                                int n69 = n4;
                                                                                                                                while (true) {
                                                                                                                                    int n70;
                                                                                                                                    char c9 = cArray67[n69];
                                                                                                                                    switch (n4 % 5) {
                                                                                                                                        case 0: {
                                                                                                                                            n70 = 88;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 1: {
                                                                                                                                            n70 = 22;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 2: {
                                                                                                                                            n70 = 95;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 3: {
                                                                                                                                            n70 = 80;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        default: {
                                                                                                                                            n70 = 35;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    cArray67[n69] = (char)(c9 ^ n70);
                                                                                                                                    ++n4;
                                                                                                                                    cArray30 = cArray68;
                                                                                                                                    n32 = n32;
                                                                                                                                    if (n32 != 0) break;
                                                                                                                                    cArray68 = cArray30;
                                                                                                                                    n31 = n32;
                                                                                                                                    n69 = n32;
                                                                                                                                    cArray67 = cArray30;
                                                                                                                                }
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                            } while (n32 > n4);
                                                                                                                        }
                                                                                                                        stringArray[6] = new String(cArray29).intern();
                                                                                                                        var1 = null;
                                                                                                                        char[] cArray69 = "+}:'Z".toCharArray();
                                                                                                                        n4 = 0;
                                                                                                                        int n71 = cArray69.length;
                                                                                                                        cArray28 = cArray69;
                                                                                                                        n30 = n71;
                                                                                                                        if (n71 <= 1) break block214;
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                        if (n30 <= n4) break block215;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        char[] cArray70 = cArray28;
                                                                                                                        char[] cArray71 = cArray28;
                                                                                                                        int n72 = n4;
                                                                                                                        while (true) {
                                                                                                                            int n73;
                                                                                                                            char c10 = cArray70[n72];
                                                                                                                            switch (n4 % 5) {
                                                                                                                                case 0: {
                                                                                                                                    n73 = 88;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 1: {
                                                                                                                                    n73 = 22;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 2: {
                                                                                                                                    n73 = 95;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 3: {
                                                                                                                                    n73 = 80;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                default: {
                                                                                                                                    n73 = 35;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            cArray70[n72] = (char)(c10 ^ n73);
                                                                                                                            ++n4;
                                                                                                                            cArray28 = cArray71;
                                                                                                                            n30 = n30;
                                                                                                                            if (n30 != 0) break;
                                                                                                                            cArray71 = cArray28;
                                                                                                                            n29 = n30;
                                                                                                                            n72 = n30;
                                                                                                                            cArray70 = cArray28;
                                                                                                                        }
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                    } while (n30 > n4);
                                                                                                                }
                                                                                                                stringArray[7] = new String(cArray27).intern();
                                                                                                                var1 = null;
                                                                                                                char[] cArray72 = "\u0003;q\fT\u0005=".toCharArray();
                                                                                                                n4 = 0;
                                                                                                                int n74 = cArray72.length;
                                                                                                                cArray26 = cArray72;
                                                                                                                n28 = n74;
                                                                                                                if (n74 <= 1) break block216;
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                                if (n28 <= n4) break block217;
                                                                                                            }
                                                                                                            do {
                                                                                                                char[] cArray73 = cArray26;
                                                                                                                char[] cArray74 = cArray26;
                                                                                                                int n75 = n4;
                                                                                                                while (true) {
                                                                                                                    int n76;
                                                                                                                    char c11 = cArray73[n75];
                                                                                                                    switch (n4 % 5) {
                                                                                                                        case 0: {
                                                                                                                            n76 = 88;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 1: {
                                                                                                                            n76 = 22;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 2: {
                                                                                                                            n76 = 95;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 3: {
                                                                                                                            n76 = 80;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        default: {
                                                                                                                            n76 = 35;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    cArray73[n75] = (char)(c11 ^ n76);
                                                                                                                    ++n4;
                                                                                                                    cArray26 = cArray74;
                                                                                                                    n28 = n28;
                                                                                                                    if (n28 != 0) break;
                                                                                                                    cArray74 = cArray26;
                                                                                                                    n27 = n28;
                                                                                                                    n75 = n28;
                                                                                                                    cArray73 = cArray26;
                                                                                                                }
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                            } while (n28 > n4);
                                                                                                        }
                                                                                                        stringArray[8] = new String(cArray25).intern();
                                                                                                        var1 = null;
                                                                                                        char[] cArray75 = "5w+\"J ".toCharArray();
                                                                                                        n4 = 0;
                                                                                                        int n77 = cArray75.length;
                                                                                                        cArray24 = cArray75;
                                                                                                        n26 = n77;
                                                                                                        if (n77 <= 1) break block218;
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                        if (n26 <= n4) break block219;
                                                                                                    }
                                                                                                    do {
                                                                                                        char[] cArray76 = cArray24;
                                                                                                        char[] cArray77 = cArray24;
                                                                                                        int n78 = n4;
                                                                                                        while (true) {
                                                                                                            int n79;
                                                                                                            char c12 = cArray76[n78];
                                                                                                            switch (n4 % 5) {
                                                                                                                case 0: {
                                                                                                                    n79 = 88;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 1: {
                                                                                                                    n79 = 22;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 2: {
                                                                                                                    n79 = 95;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 3: {
                                                                                                                    n79 = 80;
                                                                                                                    break;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    n79 = 35;
                                                                                                                }
                                                                                                            }
                                                                                                            cArray76[n78] = (char)(c12 ^ n79);
                                                                                                            ++n4;
                                                                                                            cArray24 = cArray77;
                                                                                                            n26 = n26;
                                                                                                            if (n26 != 0) break;
                                                                                                            cArray77 = cArray24;
                                                                                                            n25 = n26;
                                                                                                            n78 = n26;
                                                                                                            cArray76 = cArray24;
                                                                                                        }
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                    } while (n26 > n4);
                                                                                                }
                                                                                                stringArray[9] = new String(cArray23).intern();
                                                                                                var1 = null;
                                                                                                char[] cArray78 = ",d>>P4w+5".toCharArray();
                                                                                                n4 = 0;
                                                                                                int n80 = cArray78.length;
                                                                                                cArray22 = cArray78;
                                                                                                n24 = n80;
                                                                                                if (n80 <= 1) break block220;
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                                if (n24 <= n4) break block221;
                                                                                            }
                                                                                            do {
                                                                                                char[] cArray79 = cArray22;
                                                                                                char[] cArray80 = cArray22;
                                                                                                int n81 = n4;
                                                                                                while (true) {
                                                                                                    int n82;
                                                                                                    char c13 = cArray79[n81];
                                                                                                    switch (n4 % 5) {
                                                                                                        case 0: {
                                                                                                            n82 = 88;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 1: {
                                                                                                            n82 = 22;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 2: {
                                                                                                            n82 = 95;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 3: {
                                                                                                            n82 = 80;
                                                                                                            break;
                                                                                                        }
                                                                                                        default: {
                                                                                                            n82 = 35;
                                                                                                        }
                                                                                                    }
                                                                                                    cArray79[n81] = (char)(c13 ^ n82);
                                                                                                    ++n4;
                                                                                                    cArray22 = cArray80;
                                                                                                    n24 = n24;
                                                                                                    if (n24 != 0) break;
                                                                                                    cArray80 = cArray22;
                                                                                                    n23 = n24;
                                                                                                    n81 = n24;
                                                                                                    cArray79 = cArray22;
                                                                                                }
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                            } while (n24 > n4);
                                                                                        }
                                                                                        stringArray[10] = new String(cArray21).intern();
                                                                                        var1 = null;
                                                                                        char[] cArray81 = "\rx4>L/x\u007f$Q9x,6L*{\u007f$Z(s".toCharArray();
                                                                                        n4 = 0;
                                                                                        int n83 = cArray81.length;
                                                                                        cArray20 = cArray81;
                                                                                        n22 = n83;
                                                                                        if (n83 <= 1) break block222;
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                        if (n22 <= n4) break block223;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray82 = cArray20;
                                                                                        char[] cArray83 = cArray20;
                                                                                        int n84 = n4;
                                                                                        while (true) {
                                                                                            int n85;
                                                                                            char c14 = cArray82[n84];
                                                                                            switch (n4 % 5) {
                                                                                                case 0: {
                                                                                                    n85 = 88;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n85 = 22;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n85 = 95;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n85 = 80;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n85 = 35;
                                                                                                }
                                                                                            }
                                                                                            cArray82[n84] = (char)(c14 ^ n85);
                                                                                            ++n4;
                                                                                            cArray20 = cArray83;
                                                                                            n22 = n22;
                                                                                            if (n22 != 0) break;
                                                                                            cArray83 = cArray20;
                                                                                            n21 = n22;
                                                                                            n84 = n22;
                                                                                            cArray82 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                    } while (n22 > n4);
                                                                                }
                                                                                stringArray[11] = new String(cArray19).intern();
                                                                                var1 = null;
                                                                                char[] cArray84 = "+}:'[".toCharArray();
                                                                                n4 = 0;
                                                                                int n86 = cArray84.length;
                                                                                cArray18 = cArray84;
                                                                                n20 = n86;
                                                                                if (n86 <= 1) break block224;
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                                if (n20 <= n4) break block225;
                                                                            }
                                                                            do {
                                                                                char[] cArray85 = cArray18;
                                                                                char[] cArray86 = cArray18;
                                                                                int n87 = n4;
                                                                                while (true) {
                                                                                    int n88;
                                                                                    char c15 = cArray85[n87];
                                                                                    switch (n4 % 5) {
                                                                                        case 0: {
                                                                                            n88 = 88;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n88 = 22;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n88 = 95;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n88 = 80;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n88 = 35;
                                                                                        }
                                                                                    }
                                                                                    cArray85[n87] = (char)(c15 ^ n88);
                                                                                    ++n4;
                                                                                    cArray18 = cArray86;
                                                                                    n20 = n20;
                                                                                    if (n20 != 0) break;
                                                                                    cArray86 = cArray18;
                                                                                    n19 = n20;
                                                                                    n87 = n20;
                                                                                    cArray85 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                            } while (n20 > n4);
                                                                        }
                                                                        stringArray[12] = new String(cArray17).intern();
                                                                        var1 = null;
                                                                        char[] cArray87 = "*y+1W=".toCharArray();
                                                                        n4 = 0;
                                                                        int n89 = cArray87.length;
                                                                        cArray16 = cArray87;
                                                                        n18 = n89;
                                                                        if (n89 <= 1) break block226;
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                        if (n18 <= n4) break block227;
                                                                    }
                                                                    do {
                                                                        char[] cArray88 = cArray16;
                                                                        char[] cArray89 = cArray16;
                                                                        int n90 = n4;
                                                                        while (true) {
                                                                            int n91;
                                                                            char c16 = cArray88[n90];
                                                                            switch (n4 % 5) {
                                                                                case 0: {
                                                                                    n91 = 88;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n91 = 22;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n91 = 95;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n91 = 80;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n91 = 35;
                                                                                }
                                                                            }
                                                                            cArray88[n90] = (char)(c16 ^ n91);
                                                                            ++n4;
                                                                            cArray16 = cArray89;
                                                                            n18 = n18;
                                                                            if (n18 != 0) break;
                                                                            cArray89 = cArray16;
                                                                            n17 = n18;
                                                                            n90 = n18;
                                                                            cArray88 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                    } while (n18 > n4);
                                                                }
                                                                stringArray[13] = new String(cArray15).intern();
                                                                var1 = null;
                                                                char[] cArray90 = "+u><F".toCharArray();
                                                                n4 = 0;
                                                                int n92 = cArray90.length;
                                                                cArray14 = cArray90;
                                                                n16 = n92;
                                                                if (n92 <= 1) break block228;
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                                if (n16 <= n4) break block229;
                                                            }
                                                            do {
                                                                char[] cArray91 = cArray14;
                                                                char[] cArray92 = cArray14;
                                                                int n93 = n4;
                                                                while (true) {
                                                                    int n94;
                                                                    char c17 = cArray91[n93];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n94 = 88;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n94 = 22;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n94 = 95;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n94 = 80;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n94 = 35;
                                                                        }
                                                                    }
                                                                    cArray91[n93] = (char)(c17 ^ n94);
                                                                    ++n4;
                                                                    cArray14 = cArray92;
                                                                    n16 = n16;
                                                                    if (n16 != 0) break;
                                                                    cArray92 = cArray14;
                                                                    n15 = n16;
                                                                    n93 = n16;
                                                                    cArray91 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                            } while (n16 > n4);
                                                        }
                                                        stringArray[14] = new String(cArray13).intern();
                                                        var1 = null;
                                                        char[] cArray93 = "\u001dz:=F6b\u007f4L=e\u007f>L,6<?M,w6>\u0003;~6<Gx".toCharArray();
                                                        n4 = 0;
                                                        int n95 = cArray93.length;
                                                        cArray12 = cArray93;
                                                        n14 = n95;
                                                        if (n95 <= 1) break block230;
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                        if (n14 <= n4) break block231;
                                                    }
                                                    do {
                                                        char[] cArray94 = cArray12;
                                                        char[] cArray95 = cArray12;
                                                        int n96 = n4;
                                                        while (true) {
                                                            int n97;
                                                            char c18 = cArray94[n96];
                                                            switch (n4 % 5) {
                                                                case 0: {
                                                                    n97 = 88;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n97 = 22;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n97 = 95;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n97 = 80;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n97 = 35;
                                                                }
                                                            }
                                                            cArray94[n96] = (char)(c18 ^ n97);
                                                            ++n4;
                                                            cArray12 = cArray95;
                                                            n14 = n14;
                                                            if (n14 != 0) break;
                                                            cArray95 = cArray12;
                                                            n13 = n14;
                                                            n96 = n14;
                                                            cArray94 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                    } while (n14 > n4);
                                                }
                                                stringArray[15] = new String(cArray11).intern();
                                                var1 = null;
                                                char[] cArray96 = "\u0019b+\"J:c+5\u0003".toCharArray();
                                                n4 = 0;
                                                int n98 = cArray96.length;
                                                cArray10 = cArray96;
                                                n12 = n98;
                                                if (n98 <= 1) break block232;
                                                cArray9 = cArray10;
                                                n11 = n12;
                                                if (n12 <= n4) break block233;
                                            }
                                            do {
                                                char[] cArray97 = cArray10;
                                                char[] cArray98 = cArray10;
                                                int n99 = n4;
                                                while (true) {
                                                    int n100;
                                                    char c19 = cArray97[n99];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n100 = 88;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n100 = 22;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n100 = 95;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n100 = 80;
                                                            break;
                                                        }
                                                        default: {
                                                            n100 = 35;
                                                        }
                                                    }
                                                    cArray97[n99] = (char)(c19 ^ n100);
                                                    ++n4;
                                                    cArray10 = cArray98;
                                                    n12 = n12;
                                                    if (n12 != 0) break;
                                                    cArray98 = cArray10;
                                                    n11 = n12;
                                                    n99 = n12;
                                                    cArray97 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n11 = n12;
                                            } while (n12 > n4);
                                        }
                                        stringArray[16] = new String(cArray9).intern();
                                        var1 = null;
                                        char[] cArray99 = "q6><Q=w;)\u0003=n6#W+".toCharArray();
                                        n4 = 0;
                                        int n101 = cArray99.length;
                                        cArray8 = cArray99;
                                        n10 = n101;
                                        if (n101 <= 1) break block234;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block235;
                                    }
                                    do {
                                        char[] cArray100 = cArray8;
                                        char[] cArray101 = cArray8;
                                        int n102 = n4;
                                        while (true) {
                                            int n103;
                                            char c20 = cArray100[n102];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n103 = 88;
                                                    break;
                                                }
                                                case 1: {
                                                    n103 = 22;
                                                    break;
                                                }
                                                case 2: {
                                                    n103 = 95;
                                                    break;
                                                }
                                                case 3: {
                                                    n103 = 80;
                                                    break;
                                                }
                                                default: {
                                                    n103 = 35;
                                                }
                                            }
                                            cArray100[n102] = (char)(c20 ^ n103);
                                            ++n4;
                                            cArray8 = cArray101;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray101 = cArray8;
                                            n9 = n10;
                                            n102 = n10;
                                            cArray100 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[17] = new String(cArray7).intern();
                                var1 = null;
                                char[] cArray102 = ";z>#P".toCharArray();
                                n4 = 0;
                                int n104 = cArray102.length;
                                cArray6 = cArray102;
                                n8 = n104;
                                if (n104 <= 1) break block236;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block237;
                            }
                            do {
                                char[] cArray103 = cArray6;
                                char[] cArray104 = cArray6;
                                int n105 = n4;
                                while (true) {
                                    int n106;
                                    char c21 = cArray103[n105];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n106 = 88;
                                            break;
                                        }
                                        case 1: {
                                            n106 = 22;
                                            break;
                                        }
                                        case 2: {
                                            n106 = 95;
                                            break;
                                        }
                                        case 3: {
                                            n106 = 80;
                                            break;
                                        }
                                        default: {
                                            n106 = 35;
                                        }
                                    }
                                    cArray103[n105] = (char)(c21 ^ n106);
                                    ++n4;
                                    cArray6 = cArray104;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray104 = cArray6;
                                    n7 = n8;
                                    n105 = n8;
                                    cArray103 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[18] = new String(cArray5).intern();
                        var1 = null;
                        char[] cArray105 = " {3jA9e:".toCharArray();
                        n4 = 0;
                        int n107 = cArray105.length;
                        cArray4 = cArray105;
                        n6 = n107;
                        if (n107 <= 1) break block238;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block239;
                    }
                    do {
                        char[] cArray106 = cArray4;
                        char[] cArray107 = cArray4;
                        int n108 = n4;
                        while (true) {
                            int n109;
                            char c22 = cArray106[n108];
                            switch (n4 % 5) {
                                case 0: {
                                    n109 = 88;
                                    break;
                                }
                                case 1: {
                                    n109 = 22;
                                    break;
                                }
                                case 2: {
                                    n109 = 95;
                                    break;
                                }
                                case 3: {
                                    n109 = 80;
                                    break;
                                }
                                default: {
                                    n109 = 35;
                                }
                            }
                            cArray106[n108] = (char)(c22 ^ n109);
                            ++n4;
                            cArray4 = cArray107;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray107 = cArray4;
                            n5 = n6;
                            n108 = n6;
                            cArray106 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[19] = new String(cArray3).intern();
                var1 = null;
                char[] cArray108 = "+b&<F".toCharArray();
                n4 = 0;
                int n110 = cArray108.length;
                cArray2 = cArray108;
                n3 = n110;
                if (n110 <= 1) break block240;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block241;
            }
            do {
                char[] cArray109 = cArray2;
                char[] cArray110 = cArray2;
                int n111 = n4;
                while (true) {
                    int n112;
                    char c23 = cArray109[n111];
                    switch (n4 % 5) {
                        case 0: {
                            n112 = 88;
                            break;
                        }
                        case 1: {
                            n112 = 22;
                            break;
                        }
                        case 2: {
                            n112 = 95;
                            break;
                        }
                        case 3: {
                            n112 = 80;
                            break;
                        }
                        default: {
                            n112 = 35;
                        }
                    }
                    cArray109[n111] = (char)(c23 ^ n112);
                    ++n4;
                    cArray2 = cArray110;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray110 = cArray2;
                    n2 = n3;
                    n111 = n3;
                    cArray109 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[20] = new String(cArray).intern();
        z = stringArray;
        HashSet hashSet = new HashSet();
        ignorePresAttrib = Collections.unmodifiableSet(hashSet);
    }
}

