/*
 * Decompiled with CFR 0.152.
 */
package com.moyosoft.connector.ms.outlook.recipient;

import com.moyosoft.connector.com.ComUtil;
import com.moyosoft.connector.com.Dispatch;
import com.moyosoft.connector.com.Variant;
import com.moyosoft.connector.ms.outlook.addressentry.AddressEntry;
import com.moyosoft.connector.ms.outlook.appointment.ResponseStatus;
import com.moyosoft.connector.ms.outlook.item.DisplayType;
import com.moyosoft.connector.ms.outlook.item.OutlookItemType;
import com.moyosoft.connector.ms.outlook.recipient.OutlookAppointmentRecipient;
import com.moyosoft.connector.ms.outlook.recipient.OutlookJournalRecipient;
import com.moyosoft.connector.ms.outlook.recipient.OutlookMailRecipient;
import com.moyosoft.connector.ms.outlook.recipient.OutlookMeetingRecipient;
import com.moyosoft.connector.ms.outlook.recipient.OutlookTaskRecipient;
import com.moyosoft.connector.ms.outlook.recipient.TrackingStatus;
import java.util.Date;

public class OutlookRecipient {
    private Dispatch a;

    public static OutlookRecipient create(OutlookItemType outlookItemType, Dispatch dispatch) {
        if (dispatch == null) {
            return null;
        }
        long l = outlookItemType.getTypeValue();
        if (l == (long)OutlookItemType.APPOINTMENT.getTypeValue()) {
            return new OutlookAppointmentRecipient(dispatch);
        }
        if (l == (long)OutlookItemType.JOURNAL.getTypeValue()) {
            return new OutlookJournalRecipient(dispatch);
        }
        if (l == (long)OutlookItemType.MAIL.getTypeValue()) {
            return new OutlookMailRecipient(dispatch);
        }
        if (l == (long)OutlookItemType.MEETING.getTypeValue()) {
            return new OutlookMeetingRecipient(dispatch);
        }
        if (l == (long)OutlookItemType.TASK.getTypeValue()) {
            return new OutlookTaskRecipient(dispatch);
        }
        return new OutlookRecipient(dispatch);
    }

    public static OutlookRecipient create(Dispatch dispatch) {
        if (dispatch == null) {
            return null;
        }
        return new OutlookRecipient(dispatch);
    }

    protected OutlookRecipient(Dispatch dispatch) {
        this.a = dispatch;
    }

    public Dispatch getDispatch() {
        return this.a;
    }

    public String getAddress() {
        return this.a.invokeGetter("Address").getString();
    }

    public AddressEntry getAddressEntry() {
        Dispatch dispatch = this.a.invokeGetter("AddressEntry").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new AddressEntry(dispatch);
    }

    public String getAutoResponse() {
        return this.a.invokeGetter("AutoResponse").getString();
    }

    public void setAutoResponse(String string) {
        this.a.invokeSetter("AutoResponse", ComUtil.createVariant(this.a, string));
    }

    public DisplayType getDisplayType() {
        return DisplayType.getById(this.a.invokeGetter("DisplayType").getAsInt());
    }

    public String getEntryId() {
        return this.a.invokeGetter("EntryID").getString();
    }

    public int getIndex() {
        return this.a.invokeGetter("Index").getInt();
    }

    protected ResponseStatus getMeetingResponseStatus() {
        return ResponseStatus.getById(this.a.invokeGetter("MeetingResponseStatus").getAsInt());
    }

    public String getName() {
        return this.a.invokeGetter("Name").getString();
    }

    public boolean isResolved() {
        return this.a.invokeGetter("Resolved").getBoolean();
    }

    public TrackingStatus getTrackingStatus() {
        return TrackingStatus.getById(this.a.invokeGetter("TrackingStatus").getAsInt());
    }

    public void setTrackingStatus(TrackingStatus trackingStatus) {
        this.a.invokeSetter("TrackingStatus", ComUtil.createVariant(this.a, trackingStatus.getTypeValue()));
    }

    public Date getTrackingStatusTime() {
        return this.a.invokeGetter("TrackingStatusTime").getDate();
    }

    public void setTrackingStatusTime(Date date) {
        this.a.invokeSetter("TrackingStatusTime", ComUtil.createVariant(this.a, date));
    }

    protected int getTypeValue() {
        return this.a.invokeGetter("Type").getInt();
    }

    protected void setTypeValue(int n) {
        this.a.invokeSetter("Type", ComUtil.createVariant(this.a, n));
    }

    public void delete() {
        this.a.invokeMethod("Delete");
    }

    public String freeBusy(Date date, int n) {
        return this.a.invokeMethod("FreeBusy", new Variant[]{ComUtil.createVariant(this.a, date), ComUtil.createVariant(this.a, n)}).getString();
    }

    public String freeBusy(Date date, int n, boolean bl) {
        return this.a.invokeMethod("FreeBusy", new Variant[]{ComUtil.createVariant(this.a, date), ComUtil.createVariant(this.a, n), ComUtil.createVariant(this.a, bl)}).getString();
    }

    public boolean resolve() {
        return this.a.invokeMethod("Resolve").getBoolean();
    }

    public void dispose() {
        if (this.a != null) {
            this.a.dispose();
        }
    }
}

