/*
 * Decompiled with CFR 0.152.
 */
package com.moyosoft.connector.ms.outlook.note;

import com.moyosoft.connector.com.ComUtil;
import com.moyosoft.connector.com.ComponentObjectModelException;
import com.moyosoft.connector.com.Dispatch;
import com.moyosoft.connector.com.Variant;
import com.moyosoft.connector.ms.outlook.Outlook;
import com.moyosoft.connector.ms.outlook.folder.FolderType;
import com.moyosoft.connector.ms.outlook.folder.OutlookFolder;
import com.moyosoft.connector.ms.outlook.item.ConflictsCollection;
import com.moyosoft.connector.ms.outlook.item.DownloadState;
import com.moyosoft.connector.ms.outlook.item.ItemType;
import com.moyosoft.connector.ms.outlook.item.OutlookItem;
import com.moyosoft.connector.ms.outlook.item.OutlookItemType;
import com.moyosoft.connector.ms.outlook.note.NoteColor;
import com.moyosoft.connector.ms.outlook.properties.ItemPropertiesCollection;
import com.moyosoft.connector.ms.outlook.remote.RemoteStatus;
import com.moyosoft.connector.ms.outlook.ui.Inspector;
import com.moyosoft.connector.ms.outlook.ui.InspectorClose;

public class OutlookNote
extends OutlookItem {
    public OutlookNote(OutlookFolder outlookFolder) throws ComponentObjectModelException {
        this.mDispatch = outlookFolder.createItem(ItemType.NOTE).getDispatch();
    }

    public OutlookNote(Outlook outlook) throws ComponentObjectModelException {
        this.mDispatch = outlook.getDefaultFolder(FolderType.NOTES).createItem(ItemType.NOTE).getDispatch();
    }

    public OutlookNote(Dispatch dispatch) {
        super(dispatch);
    }

    public OutlookItemType getType() {
        return OutlookItemType.NOTE;
    }

    protected OutlookItem createInstance(Dispatch dispatch) {
        return new OutlookNote(dispatch);
    }

    public String getBody() {
        return this.mDispatch.invokeGetter("Body").getString();
    }

    public void setBody(String string) {
        this.mDispatch.invokeSetter("Body", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getCategories() {
        return this.mDispatch.invokeGetter("Categories").getString();
    }

    public void setCategories(String string) {
        this.mDispatch.invokeSetter("Categories", ComUtil.createVariant(this.mDispatch, string));
    }

    public NoteColor getColor() {
        return NoteColor.getById(this.mDispatch.invokeGetter("Color").getAsInt());
    }

    public void setColor(NoteColor noteColor) {
        this.mDispatch.invokeSetter("Color", ComUtil.createVariant(this.mDispatch, noteColor.getTypeValue()));
    }

    public Inspector getInspector() {
        Dispatch dispatch = this.mDispatch.invokeGetter("GetInspector").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new Inspector(dispatch);
    }

    public int getHeight() {
        return this.mDispatch.invokeGetter("Height").getInt();
    }

    public void setHeight(int n) {
        this.mDispatch.invokeSetter("Height", ComUtil.createVariant(this.mDispatch, n));
    }

    public int getLeft() {
        return this.mDispatch.invokeGetter("Left").getInt();
    }

    public void setLeft(int n) {
        this.mDispatch.invokeSetter("Left", ComUtil.createVariant(this.mDispatch, n));
    }

    public String getMessageClass() {
        return this.mDispatch.invokeGetter("MessageClass").getString();
    }

    public void setMessageClass(String string) {
        this.mDispatch.invokeSetter("MessageClass", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isSaved() {
        return this.mDispatch.invokeGetter("Saved").getBoolean();
    }

    public int getSize() {
        return this.mDispatch.invokeGetter("Size").getInt();
    }

    public String getSubject() {
        return this.mDispatch.invokeGetter("Subject").getString();
    }

    public int getTop() {
        return this.mDispatch.invokeGetter("Top").getInt();
    }

    public void setTop(int n) {
        this.mDispatch.invokeSetter("Top", ComUtil.createVariant(this.mDispatch, n));
    }

    public int getWidth() {
        return this.mDispatch.invokeGetter("Width").getInt();
    }

    public void setWidth(int n) {
        this.mDispatch.invokeSetter("Width", ComUtil.createVariant(this.mDispatch, n));
    }

    public void close(InspectorClose inspectorClose) {
        this.mDispatch.invokeMethod("Close", new Variant[]{ComUtil.createVariant(this.mDispatch, inspectorClose.getTypeValue())});
    }

    public DownloadState getDownloadState() {
        return DownloadState.getById(this.mDispatch.invokeGetter("DownloadState").getAsInt());
    }

    public ItemPropertiesCollection getItemProperties() {
        Dispatch dispatch = this.mDispatch.invokeGetter("ItemProperties").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new ItemPropertiesCollection(dispatch);
    }

    public RemoteStatus getMarkForDownload() {
        return RemoteStatus.getById(this.mDispatch.invokeGetter("MarkForDownload").getAsInt());
    }

    public void setMarkForDownload(RemoteStatus remoteStatus) {
        this.mDispatch.invokeSetter("MarkForDownload", ComUtil.createVariant(this.mDispatch, remoteStatus.getTypeValue()));
    }

    public boolean isConflict() {
        return this.mDispatch.invokeGetter("IsConflict").getBoolean();
    }

    public boolean isAutoResolvedWinner() {
        return this.mDispatch.invokeGetter("AutoResolvedWinner").getBoolean();
    }

    public ConflictsCollection getConflicts() {
        Dispatch dispatch = this.mDispatch.invokeGetter("Conflicts").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new ConflictsCollection(dispatch);
    }
}

