/*
 * Decompiled with CFR 0.152.
 */
package com.moyosoft.connector.ms.outlook.mail;

import com.moyosoft.connector.com.ComUtil;
import com.moyosoft.connector.com.ComponentObjectModelException;
import com.moyosoft.connector.com.Dispatch;
import com.moyosoft.connector.com.Variant;
import com.moyosoft.connector.ms.outlook.Outlook;
import com.moyosoft.connector.ms.outlook.addressentry.AddressEntry;
import com.moyosoft.connector.ms.outlook.attachment.AttachmentType;
import com.moyosoft.connector.ms.outlook.attachment.AttachmentsCollection;
import com.moyosoft.connector.ms.outlook.attachment.IAttachmentsContainer;
import com.moyosoft.connector.ms.outlook.attachment.OutlookAttachment;
import com.moyosoft.connector.ms.outlook.folder.FolderType;
import com.moyosoft.connector.ms.outlook.folder.OutlookFolder;
import com.moyosoft.connector.ms.outlook.item.ConflictsCollection;
import com.moyosoft.connector.ms.outlook.item.DownloadState;
import com.moyosoft.connector.ms.outlook.item.FlagIcon;
import com.moyosoft.connector.ms.outlook.item.FlagStatus;
import com.moyosoft.connector.ms.outlook.item.ImportanceType;
import com.moyosoft.connector.ms.outlook.item.ItemType;
import com.moyosoft.connector.ms.outlook.item.OutlookItem;
import com.moyosoft.connector.ms.outlook.item.OutlookItemType;
import com.moyosoft.connector.ms.outlook.item.SensitivityType;
import com.moyosoft.connector.ms.outlook.mail.BodyFormat;
import com.moyosoft.connector.ms.outlook.mail.Permission;
import com.moyosoft.connector.ms.outlook.mail.PermissionService;
import com.moyosoft.connector.ms.outlook.properties.ItemPropertiesCollection;
import com.moyosoft.connector.ms.outlook.properties.UserPropertiesCollection;
import com.moyosoft.connector.ms.outlook.recipient.OutlookMailRecipient;
import com.moyosoft.connector.ms.outlook.recipient.OutlookRecipient;
import com.moyosoft.connector.ms.outlook.recipient.RecipientsCollection;
import com.moyosoft.connector.ms.outlook.remote.RemoteStatus;
import com.moyosoft.connector.ms.outlook.ui.FormDescription;
import com.moyosoft.connector.ms.outlook.ui.Inspector;
import com.moyosoft.connector.ms.outlook.ui.InspectorClose;
import com.moyosoft.connector.ms.outlook.util.Mapi;
import java.io.File;
import java.util.Date;

public class OutlookMail
extends OutlookItem
implements IAttachmentsContainer {
    public OutlookMail(OutlookFolder outlookFolder) throws ComponentObjectModelException {
        this.mDispatch = outlookFolder.createItem(ItemType.MAIL).getDispatch();
    }

    public OutlookMail(Outlook outlook) throws ComponentObjectModelException {
        this.mDispatch = outlook.getDefaultFolder(FolderType.OUTBOX).createItem(ItemType.MAIL).getDispatch();
    }

    public OutlookMail(Dispatch dispatch) {
        super(dispatch);
    }

    public OutlookItemType getType() {
        return OutlookItemType.MAIL;
    }

    protected OutlookItem createInstance(Dispatch dispatch) {
        return new OutlookMail(dispatch);
    }

    public AttachmentsCollection getAttachments() {
        Dispatch dispatch = this.mDispatch.invokeGetter("Attachments").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new AttachmentsCollection(dispatch);
    }

    public OutlookAttachment createAttachment(File file, AttachmentType attachmentType) {
        return this.getAttachments().add(file, attachmentType);
    }

    public int getAttachmentsCount() {
        return this.getAttachments().getCount();
    }

    public String getBillingInformation() {
        return this.mDispatch.invokeGetter("BillingInformation").getString();
    }

    public void setBillingInformation(String string) {
        this.mDispatch.invokeSetter("BillingInformation", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getBody() {
        return this.mDispatch.invokeGetter("Body").getString();
    }

    public void setBody(String string) {
        this.mDispatch.invokeSetter("Body", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getCategories() {
        return this.mDispatch.invokeGetter("Categories").getString();
    }

    public void setCategories(String string) {
        this.mDispatch.invokeSetter("Categories", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getCompanies() {
        return this.mDispatch.invokeGetter("Companies").getString();
    }

    public void setCompanies(String string) {
        this.mDispatch.invokeSetter("Companies", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getConversationIndex() {
        return this.mDispatch.invokeGetter("ConversationIndex").getString();
    }

    public String getConversationTopic() {
        return this.mDispatch.invokeGetter("ConversationTopic").getString();
    }

    public FormDescription getFormDescription() {
        Dispatch dispatch = this.mDispatch.invokeGetter("FormDescription").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new FormDescription(dispatch);
    }

    public Inspector getInspector() {
        Dispatch dispatch = this.mDispatch.invokeGetter("GetInspector").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new Inspector(dispatch);
    }

    public ImportanceType getImportance() {
        return ImportanceType.getById(this.mDispatch.invokeGetter("Importance").getAsInt());
    }

    public void setImportance(ImportanceType importanceType) {
        this.mDispatch.invokeSetter("Importance", ComUtil.createVariant(this.mDispatch, importanceType.getTypeValue()));
    }

    public String getMessageClass() {
        return this.mDispatch.invokeGetter("MessageClass").getString();
    }

    public void setMessageClass(String string) {
        this.mDispatch.invokeSetter("MessageClass", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getMileage() {
        return this.mDispatch.invokeGetter("Mileage").getString();
    }

    public void setMileage(String string) {
        this.mDispatch.invokeSetter("Mileage", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isNoAging() {
        return this.mDispatch.invokeGetter("NoAging").getBoolean();
    }

    public void setNoAging(boolean bl) {
        this.mDispatch.invokeSetter("NoAging", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isSaved() {
        return this.mDispatch.invokeGetter("Saved").getBoolean();
    }

    public SensitivityType getSensitivity() {
        return SensitivityType.getById(this.mDispatch.invokeGetter("Sensitivity").getAsInt());
    }

    public void setSensitivity(SensitivityType sensitivityType) {
        this.mDispatch.invokeSetter("Sensitivity", ComUtil.createVariant(this.mDispatch, sensitivityType.getTypeValue()));
    }

    public int getSize() {
        return this.mDispatch.invokeGetter("Size").getInt();
    }

    public String getSubject() {
        return this.mDispatch.invokeGetter("Subject").getString();
    }

    public void setSubject(String string) {
        this.mDispatch.invokeSetter("Subject", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isUnRead() {
        return this.mDispatch.invokeGetter("UnRead").getBoolean();
    }

    public void setUnRead(boolean bl) {
        this.mDispatch.invokeSetter("UnRead", ComUtil.createVariant(this.mDispatch, bl));
    }

    public UserPropertiesCollection getUserProperties() {
        Dispatch dispatch = this.mDispatch.invokeGetter("UserProperties").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new UserPropertiesCollection(dispatch);
    }

    public void close(InspectorClose inspectorClose) {
        this.mDispatch.invokeMethod("Close", new Variant[]{ComUtil.createVariant(this.mDispatch, inspectorClose.getTypeValue())});
    }

    public boolean isAlternateRecipientAllowed() {
        return this.mDispatch.invokeGetter("AlternateRecipientAllowed").getBoolean();
    }

    public void setAlternateRecipientAllowed(boolean bl) {
        this.mDispatch.invokeSetter("AlternateRecipientAllowed", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isAutoForwarded() {
        return this.mDispatch.invokeGetter("AutoForwarded").getBoolean();
    }

    public void setAutoForwarded(boolean bl) {
        this.mDispatch.invokeSetter("AutoForwarded", ComUtil.createVariant(this.mDispatch, bl));
    }

    public String getBCC() {
        return this.mDispatch.invokeGetter("BCC").getString();
    }

    public void setBCC(String string) {
        this.mDispatch.invokeSetter("BCC", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getCC() {
        return this.mDispatch.invokeGetter("CC").getString();
    }

    public void setCC(String string) {
        this.mDispatch.invokeSetter("CC", ComUtil.createVariant(this.mDispatch, string));
    }

    public Date getDeferredDeliveryTime() {
        return this.mDispatch.invokeGetter("DeferredDeliveryTime").getDate();
    }

    public void setDeferredDeliveryTime(Date date) {
        this.mDispatch.invokeSetter("DeferredDeliveryTime", ComUtil.createVariant(this.mDispatch, date));
    }

    public boolean isDeleteAfterSubmit() {
        return this.mDispatch.invokeGetter("DeleteAfterSubmit").getBoolean();
    }

    public void setDeleteAfterSubmit(boolean bl) {
        this.mDispatch.invokeSetter("DeleteAfterSubmit", ComUtil.createVariant(this.mDispatch, bl));
    }

    public Date getExpiryTime() {
        return this.mDispatch.invokeGetter("ExpiryTime").getDate();
    }

    public void setExpiryTime(Date date) {
        this.mDispatch.invokeSetter("ExpiryTime", ComUtil.createVariant(this.mDispatch, date));
    }

    public Date getFlagDueBy() {
        return this.mDispatch.invokeGetter("FlagDueBy").getDate();
    }

    public void setFlagDueBy(Date date) {
        this.mDispatch.invokeSetter("FlagDueBy", ComUtil.createVariant(this.mDispatch, date));
    }

    public String getFlagRequest() {
        return this.mDispatch.invokeGetter("FlagRequest").getString();
    }

    public void setFlagRequest(String string) {
        this.mDispatch.invokeSetter("FlagRequest", ComUtil.createVariant(this.mDispatch, string));
    }

    public FlagStatus getFlagStatus() {
        return FlagStatus.getById(this.mDispatch.invokeGetter("FlagStatus").getAsInt());
    }

    public void setFlagStatus(FlagStatus flagStatus) {
        this.mDispatch.invokeSetter("FlagStatus", ComUtil.createVariant(this.mDispatch, flagStatus.getTypeValue()));
    }

    public String getHTMLBody() {
        return this.mDispatch.invokeGetter("HTMLBody").getString();
    }

    public void setHTMLBody(String string) {
        this.mDispatch.invokeSetter("HTMLBody", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isOriginatorDeliveryReportRequested() {
        return this.mDispatch.invokeGetter("OriginatorDeliveryReportRequested").getBoolean();
    }

    public void setOriginatorDeliveryReportRequested(boolean bl) {
        this.mDispatch.invokeSetter("OriginatorDeliveryReportRequested", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isReadReceiptRequested() {
        return this.mDispatch.invokeGetter("ReadReceiptRequested").getBoolean();
    }

    public void setReadReceiptRequested(boolean bl) {
        this.mDispatch.invokeSetter("ReadReceiptRequested", ComUtil.createVariant(this.mDispatch, bl));
    }

    public String getReceivedByEntryID() {
        return this.mDispatch.invokeGetter("ReceivedByEntryID").getString();
    }

    public String getReceivedByName() {
        return this.mDispatch.invokeGetter("ReceivedByName").getString();
    }

    public String getReceivedOnBehalfOfEntryID() {
        return this.mDispatch.invokeGetter("ReceivedOnBehalfOfEntryID").getString();
    }

    public String getReceivedOnBehalfOfName() {
        return this.mDispatch.invokeGetter("ReceivedOnBehalfOfName").getString();
    }

    public Date getReceivedTime() {
        return this.mDispatch.invokeGetter("ReceivedTime").getDate();
    }

    public boolean isRecipientReassignmentProhibited() {
        return this.mDispatch.invokeGetter("RecipientReassignmentProhibited").getBoolean();
    }

    public void setRecipientReassignmentProhibited(boolean bl) {
        this.mDispatch.invokeSetter("RecipientReassignmentProhibited", ComUtil.createVariant(this.mDispatch, bl));
    }

    public RecipientsCollection getRecipients() {
        Dispatch dispatch = this.mDispatch.invokeGetter("Recipients").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new RecipientsCollection(OutlookItemType.MAIL, dispatch);
    }

    public boolean isReminderOverrideDefault() {
        return this.mDispatch.invokeGetter("ReminderOverrideDefault").getBoolean();
    }

    public void setReminderOverrideDefault(boolean bl) {
        this.mDispatch.invokeSetter("ReminderOverrideDefault", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isReminderPlaySound() {
        return this.mDispatch.invokeGetter("ReminderPlaySound").getBoolean();
    }

    public void setReminderPlaySound(boolean bl) {
        this.mDispatch.invokeSetter("ReminderPlaySound", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isReminderSet() {
        return this.mDispatch.invokeGetter("ReminderSet").getBoolean();
    }

    public void setReminderSet(boolean bl) {
        this.mDispatch.invokeSetter("ReminderSet", ComUtil.createVariant(this.mDispatch, bl));
    }

    public String getReminderSoundFile() {
        return this.mDispatch.invokeGetter("ReminderSoundFile").getString();
    }

    public void setReminderSoundFile(String string) {
        this.mDispatch.invokeSetter("ReminderSoundFile", ComUtil.createVariant(this.mDispatch, string));
    }

    public Date getReminderTime() {
        return this.mDispatch.invokeGetter("ReminderTime").getDate();
    }

    public void setReminderTime(Date date) {
        this.mDispatch.invokeSetter("ReminderTime", ComUtil.createVariant(this.mDispatch, date));
    }

    public RemoteStatus getRemoteStatus() {
        return RemoteStatus.getById(this.mDispatch.invokeGetter("RemoteStatus").getAsInt());
    }

    public void setRemoteStatus(RemoteStatus remoteStatus) {
        this.mDispatch.invokeSetter("RemoteStatus", ComUtil.createVariant(this.mDispatch, remoteStatus.getTypeValue()));
    }

    public String getReplyRecipientNames() {
        return this.mDispatch.invokeGetter("ReplyRecipientNames").getString();
    }

    public RecipientsCollection getReplyRecipients() {
        Dispatch dispatch = this.mDispatch.invokeGetter("ReplyRecipients").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new RecipientsCollection(OutlookItemType.MAIL, dispatch);
    }

    public OutlookFolder getSaveSentMessageFolder() {
        Dispatch dispatch = this.mDispatch.invokeGetter("SaveSentMessageFolder").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new OutlookFolder(dispatch);
    }

    public void setSaveSentMessageFolder(OutlookFolder outlookFolder) {
        this.mDispatch.invokeSetterRef("SaveSentMessageFolder", new Variant[]{ComUtil.createVariant(outlookFolder.getDispatch())});
    }

    public String getSenderName() {
        return this.mDispatch.invokeGetter("SenderName").getString();
    }

    public boolean isSent() {
        return this.mDispatch.invokeGetter("Sent").getBoolean();
    }

    public Date getSentOn() {
        return this.mDispatch.invokeGetter("SentOn").getDate();
    }

    public String getSentOnBehalfOfName() {
        return this.mDispatch.invokeGetter("SentOnBehalfOfName").getString();
    }

    public void setSentOnBehalfOfName(String string) {
        this.mDispatch.invokeSetter("SentOnBehalfOfName", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isSubmitted() {
        return this.mDispatch.invokeGetter("Submitted").getBoolean();
    }

    public String getTo() {
        return this.mDispatch.invokeGetter("To").getString();
    }

    public void setTo(String string) {
        this.mDispatch.invokeSetter("To", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getVotingOptions() {
        return this.mDispatch.invokeGetter("VotingOptions").getString();
    }

    public void setVotingOptions(String string) {
        this.mDispatch.invokeSetter("VotingOptions", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getVotingResponse() {
        return this.mDispatch.invokeGetter("VotingResponse").getString();
    }

    public void setVotingResponse(String string) {
        this.mDispatch.invokeSetter("VotingResponse", ComUtil.createVariant(this.mDispatch, string));
    }

    public void clearConversationIndex() {
        this.mDispatch.invokeMethod("ClearConversationIndex");
    }

    public OutlookMail forward() {
        Dispatch dispatch = this.mDispatch.invokeMethod("Forward").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new OutlookMail(dispatch);
    }

    public OutlookMail reply() {
        Dispatch dispatch = this.mDispatch.invokeMethod("Reply").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new OutlookMail(dispatch);
    }

    public OutlookMail replyAll() {
        Dispatch dispatch = this.mDispatch.invokeMethod("ReplyAll").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new OutlookMail(dispatch);
    }

    public void send() {
        this.mDispatch.invokeMethod("Send");
    }

    public ItemPropertiesCollection getItemProperties() {
        Dispatch dispatch = this.mDispatch.invokeGetter("ItemProperties").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new ItemPropertiesCollection(dispatch);
    }

    public BodyFormat getBodyFormat() {
        return BodyFormat.getById(this.mDispatch.invokeGetter("BodyFormat").getAsInt());
    }

    public void setBodyFormat(BodyFormat bodyFormat) {
        this.mDispatch.invokeSetter("BodyFormat", ComUtil.createVariant(this.mDispatch, bodyFormat.getTypeValue()));
    }

    public DownloadState getDownloadState() {
        return DownloadState.getById(this.mDispatch.invokeGetter("DownloadState").getAsInt());
    }

    public void showCategoriesDialog() {
        this.mDispatch.invokeMethod("ShowCategoriesDialog");
    }

    public int getInternetCodepage() {
        return this.mDispatch.invokeGetter("InternetCodepage").getInt();
    }

    public void setInternetCodepage(int n) {
        this.mDispatch.invokeSetter("InternetCodepage", ComUtil.createVariant(this.mDispatch, n));
    }

    public RemoteStatus getMarkForDownload() {
        return RemoteStatus.getById(this.mDispatch.invokeGetter("MarkForDownload").getAsInt());
    }

    public void setMarkForDownload(RemoteStatus remoteStatus) {
        this.mDispatch.invokeSetter("MarkForDownload", ComUtil.createVariant(this.mDispatch, remoteStatus.getTypeValue()));
    }

    public boolean isConflict() {
        return this.mDispatch.invokeGetter("IsConflict").getBoolean();
    }

    public boolean isIPFax() {
        return this.mDispatch.invokeGetter("IsIPFax").getBoolean();
    }

    public void setIsIPFax(boolean bl) {
        this.mDispatch.invokeSetter("IsIPFax", ComUtil.createVariant(this.mDispatch, bl));
    }

    public FlagIcon getFlagIcon() {
        return FlagIcon.getById(this.mDispatch.invokeGetter("FlagIcon").getAsInt());
    }

    public void setFlagIcon(FlagIcon flagIcon) {
        this.mDispatch.invokeSetter("FlagIcon", ComUtil.createVariant(this.mDispatch, flagIcon.getTypeValue()));
    }

    public boolean isHasCoverSheet() {
        return this.mDispatch.invokeGetter("HasCoverSheet").getBoolean();
    }

    public void setHasCoverSheet(boolean bl) {
        this.mDispatch.invokeSetter("HasCoverSheet", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isAutoResolvedWinner() {
        return this.mDispatch.invokeGetter("AutoResolvedWinner").getBoolean();
    }

    public ConflictsCollection getConflicts() {
        Dispatch dispatch = this.mDispatch.invokeGetter("Conflicts").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new ConflictsCollection(dispatch);
    }

    public String getSenderEmailAddress() {
        return this.mDispatch.invokeGetter("SenderEmailAddress").getString();
    }

    public String getSenderEmailType() {
        return this.mDispatch.invokeGetter("SenderEmailType").getString();
    }

    public String getFrom() {
        return this.getSenderAddress();
    }

    public OutlookMailRecipient getReplyToRecipient() {
        OutlookMail outlookMail = this.reply();
        RecipientsCollection recipientsCollection = outlookMail.getRecipients();
        if (recipientsCollection != null && recipientsCollection.getCount() > 0) {
            OutlookMailRecipient outlookMailRecipient = (OutlookMailRecipient)recipientsCollection.getItem(0);
            outlookMail.dispose();
            return outlookMailRecipient;
        }
        outlookMail.dispose();
        return null;
    }

    public String getReplyToAddress() {
        OutlookMailRecipient outlookMailRecipient = this.getReplyToRecipient();
        if (outlookMailRecipient == null) {
            return null;
        }
        return outlookMailRecipient.getAddress();
    }

    public String getSenderAddress() {
        String string = this.mDispatch.hasIdOfName("SenderEmailAddress") > 0 ? this.mDispatch.invokeGetter("SenderEmailAddress").getString() : this.getPropertyString(Mapi.PR_SENDER_EMAIL_ADDRESS, null);
        return string;
    }

    private OutlookRecipient a(Dispatch dispatch, String string) {
        Dispatch dispatch2 = dispatch.invokeMethod("GetRecipientFromID", new Variant[]{ComUtil.createVariant(dispatch, string)}).getDispatch();
        if (dispatch2 == null) {
            return null;
        }
        return OutlookRecipient.create(dispatch2);
    }

    private AddressEntry b(Dispatch dispatch, String string) {
        if (dispatch.hasIdOfName("GetAddressEntryFromID") > 0) {
            Dispatch dispatch2 = dispatch.invokeMethod("GetAddressEntryFromID", new Variant[]{ComUtil.createVariant(dispatch, string)}).getDispatch();
            if (dispatch2 == null) {
                return null;
            }
            return new AddressEntry(dispatch2);
        }
        return null;
    }

    public AddressEntry getSender() {
        Object object;
        Dispatch dispatch = this.mDispatch.invokeGetter("Session").getDispatch();
        if (dispatch == null) {
            return null;
        }
        String string = this.getPropertyString(Mapi.PR_SENT_REPRESENTING_ENTRYID, "http://schemas.microsoft.com/mapi/proptag/0x00410102");
        if (string != null && string.length() > 0 && (object = this.b(dispatch, string)) != null) {
            return object;
        }
        object = this.getPropertyString(Mapi.PR_SENDER_ENTRYID, "http://schemas.microsoft.com/mapi/proptag/0x0C190102");
        if (object == null || ((String)object).length() == 0) {
            return null;
        }
        OutlookRecipient outlookRecipient = this.a(dispatch, (String)object);
        if (outlookRecipient == null) {
            return null;
        }
        AddressEntry addressEntry = outlookRecipient.getAddressEntry();
        outlookRecipient.dispose();
        dispatch.dispose();
        return addressEntry;
    }

    public boolean isEnableSharedAttachments() {
        return this.mDispatch.invokeGetter("EnableSharedAttachments").getBoolean();
    }

    public void setEnableSharedAttachments(boolean bl) {
        this.mDispatch.invokeSetter("EnableSharedAttachments", ComUtil.createVariant(this.mDispatch, bl));
    }

    public Permission getPermission() {
        return Permission.getById(this.mDispatch.invokeGetter("Permission").getAsInt());
    }

    public void setPermission(Permission permission) {
        this.mDispatch.invokeSetter("Permission", ComUtil.createVariant(this.mDispatch, permission.getTypeValue()));
    }

    public PermissionService getPermissionService() {
        return PermissionService.getById(this.mDispatch.invokeGetter("PermissionService").getAsInt());
    }

    public void setPermissionService(PermissionService permissionService) {
        this.mDispatch.invokeSetter("PermissionService", ComUtil.createVariant(this.mDispatch, permissionService.getTypeValue()));
    }
}

