/*
 * Decompiled with CFR 0.152.
 */
package com.moyosoft.connector.ms.outlook.journal;

import com.moyosoft.connector.com.ComUtil;
import com.moyosoft.connector.com.ComponentObjectModelException;
import com.moyosoft.connector.com.Dispatch;
import com.moyosoft.connector.com.Variant;
import com.moyosoft.connector.ms.outlook.Outlook;
import com.moyosoft.connector.ms.outlook.attachment.AttachmentType;
import com.moyosoft.connector.ms.outlook.attachment.AttachmentsCollection;
import com.moyosoft.connector.ms.outlook.attachment.IAttachmentsContainer;
import com.moyosoft.connector.ms.outlook.attachment.OutlookAttachment;
import com.moyosoft.connector.ms.outlook.folder.FolderType;
import com.moyosoft.connector.ms.outlook.folder.OutlookFolder;
import com.moyosoft.connector.ms.outlook.item.ConflictsCollection;
import com.moyosoft.connector.ms.outlook.item.DownloadState;
import com.moyosoft.connector.ms.outlook.item.ImportanceType;
import com.moyosoft.connector.ms.outlook.item.ItemType;
import com.moyosoft.connector.ms.outlook.item.OutlookItem;
import com.moyosoft.connector.ms.outlook.item.OutlookItemType;
import com.moyosoft.connector.ms.outlook.item.SensitivityType;
import com.moyosoft.connector.ms.outlook.mail.OutlookMail;
import com.moyosoft.connector.ms.outlook.properties.ItemPropertiesCollection;
import com.moyosoft.connector.ms.outlook.properties.UserPropertiesCollection;
import com.moyosoft.connector.ms.outlook.recipient.RecipientsCollection;
import com.moyosoft.connector.ms.outlook.remote.RemoteStatus;
import com.moyosoft.connector.ms.outlook.ui.FormDescription;
import com.moyosoft.connector.ms.outlook.ui.Inspector;
import com.moyosoft.connector.ms.outlook.ui.InspectorClose;
import java.io.File;
import java.util.Date;

public class OutlookJournal
extends OutlookItem
implements IAttachmentsContainer {
    public OutlookJournal(OutlookFolder outlookFolder) throws ComponentObjectModelException {
        this.mDispatch = outlookFolder.createItem(ItemType.CONTACT).getDispatch();
    }

    public OutlookJournal(Outlook outlook) throws ComponentObjectModelException {
        this.mDispatch = outlook.getDefaultFolder(FolderType.JOURNAL).createItem(ItemType.JOURNAL).getDispatch();
    }

    public OutlookJournal(Dispatch dispatch) {
        super(dispatch);
    }

    public OutlookItemType getType() {
        return OutlookItemType.JOURNAL;
    }

    protected OutlookItem createInstance(Dispatch dispatch) {
        return new OutlookJournal(dispatch);
    }

    public AttachmentsCollection getAttachments() {
        Dispatch dispatch = this.mDispatch.invokeGetter("Attachments").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new AttachmentsCollection(dispatch);
    }

    public OutlookAttachment createAttachment(File file, AttachmentType attachmentType) {
        return this.getAttachments().add(file, attachmentType);
    }

    public int getAttachmentsCount() {
        return this.getAttachments().getCount();
    }

    public String getBillingInformation() {
        return this.mDispatch.invokeGetter("BillingInformation").getString();
    }

    public void setBillingInformation(String string) {
        this.mDispatch.invokeSetter("BillingInformation", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getBody() {
        return this.mDispatch.invokeGetter("Body").getString();
    }

    public void setBody(String string) {
        this.mDispatch.invokeSetter("Body", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getCategories() {
        return this.mDispatch.invokeGetter("Categories").getString();
    }

    public void setCategories(String string) {
        this.mDispatch.invokeSetter("Categories", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getCompanies() {
        return this.mDispatch.invokeGetter("Companies").getString();
    }

    public void setCompanies(String string) {
        this.mDispatch.invokeSetter("Companies", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getConversationIndex() {
        return this.mDispatch.invokeGetter("ConversationIndex").getString();
    }

    public String getConversationTopic() {
        return this.mDispatch.invokeGetter("ConversationTopic").getString();
    }

    public FormDescription getFormDescription() {
        Dispatch dispatch = this.mDispatch.invokeGetter("FormDescription").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new FormDescription(dispatch);
    }

    public Inspector getInspector() {
        Dispatch dispatch = this.mDispatch.invokeGetter("GetInspector").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new Inspector(dispatch);
    }

    public ImportanceType getImportance() {
        return ImportanceType.getById(this.mDispatch.invokeGetter("Importance").getAsInt());
    }

    public void setImportance(ImportanceType importanceType) {
        this.mDispatch.invokeSetter("Importance", ComUtil.createVariant(this.mDispatch, importanceType.getTypeValue()));
    }

    public String getMessageClass() {
        return this.mDispatch.invokeGetter("MessageClass").getString();
    }

    public void setMessageClass(String string) {
        this.mDispatch.invokeSetter("MessageClass", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getMileage() {
        return this.mDispatch.invokeGetter("Mileage").getString();
    }

    public void setMileage(String string) {
        this.mDispatch.invokeSetter("Mileage", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isNoAging() {
        return this.mDispatch.invokeGetter("NoAging").getBoolean();
    }

    public void setNoAging(boolean bl) {
        this.mDispatch.invokeSetter("NoAging", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isSaved() {
        return this.mDispatch.invokeGetter("Saved").getBoolean();
    }

    public SensitivityType getSensitivity() {
        return SensitivityType.getById(this.mDispatch.invokeGetter("Sensitivity").getAsInt());
    }

    public void setSensitivity(SensitivityType sensitivityType) {
        this.mDispatch.invokeSetter("Sensitivity", ComUtil.createVariant(this.mDispatch, sensitivityType.getTypeValue()));
    }

    public int getSize() {
        return this.mDispatch.invokeGetter("Size").getInt();
    }

    public String getSubject() {
        return this.mDispatch.invokeGetter("Subject").getString();
    }

    public void setSubject(String string) {
        this.mDispatch.invokeSetter("Subject", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isUnRead() {
        return this.mDispatch.invokeGetter("UnRead").getBoolean();
    }

    public void setUnRead(boolean bl) {
        this.mDispatch.invokeSetter("UnRead", ComUtil.createVariant(this.mDispatch, bl));
    }

    public UserPropertiesCollection getUserProperties() {
        Dispatch dispatch = this.mDispatch.invokeGetter("UserProperties").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new UserPropertiesCollection(dispatch);
    }

    public void close(InspectorClose inspectorClose) {
        this.mDispatch.invokeMethod("Close", new Variant[]{ComUtil.createVariant(this.mDispatch, inspectorClose.getTypeValue())});
    }

    public String getContactNames() {
        return this.mDispatch.invokeGetter("ContactNames").getString();
    }

    public void setContactNames(String string) {
        this.mDispatch.invokeSetter("ContactNames", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isDocPosted() {
        return this.mDispatch.invokeGetter("DocPosted").getBoolean();
    }

    public void setDocPosted(boolean bl) {
        this.mDispatch.invokeSetter("DocPosted", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isDocPrinted() {
        return this.mDispatch.invokeGetter("DocPrinted").getBoolean();
    }

    public void setDocPrinted(boolean bl) {
        this.mDispatch.invokeSetter("DocPrinted", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isDocRouted() {
        return this.mDispatch.invokeGetter("DocRouted").getBoolean();
    }

    public void setDocRouted(boolean bl) {
        this.mDispatch.invokeSetter("DocRouted", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isDocSaved() {
        return this.mDispatch.invokeGetter("DocSaved").getBoolean();
    }

    public void setDocSaved(boolean bl) {
        this.mDispatch.invokeSetter("DocSaved", ComUtil.createVariant(this.mDispatch, bl));
    }

    public int getDuration() {
        return this.mDispatch.invokeGetter("Duration").getInt();
    }

    public void setDuration(int n) {
        this.mDispatch.invokeSetter("Duration", ComUtil.createVariant(this.mDispatch, n));
    }

    public Date getEnd() {
        return this.mDispatch.invokeGetter("End").getDate();
    }

    public void setEnd(Date date) {
        this.mDispatch.invokeSetter("End", ComUtil.createVariant(this.mDispatch, date));
    }

    public String getJournalType() {
        return this.mDispatch.invokeGetter("Type").getString();
    }

    public void setJournalType(String string) {
        this.mDispatch.invokeSetter("Type", ComUtil.createVariant(this.mDispatch, string));
    }

    public RecipientsCollection getRecipients() {
        Dispatch dispatch = this.mDispatch.invokeGetter("Recipients").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new RecipientsCollection(OutlookItemType.JOURNAL, dispatch);
    }

    public Date getStart() {
        return this.mDispatch.invokeGetter("Start").getDate();
    }

    public void setStart(Date date) {
        this.mDispatch.invokeSetter("Start", ComUtil.createVariant(this.mDispatch, date));
    }

    public OutlookMail forward() {
        Dispatch dispatch = this.mDispatch.invokeMethod("Forward").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new OutlookMail(dispatch);
    }

    public OutlookMail reply() {
        Dispatch dispatch = this.mDispatch.invokeMethod("Reply").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new OutlookMail(dispatch);
    }

    public OutlookMail replyAll() {
        Dispatch dispatch = this.mDispatch.invokeMethod("ReplyAll").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new OutlookMail(dispatch);
    }

    public void startTimer() {
        this.mDispatch.invokeMethod("StartTimer");
    }

    public void stopTimer() {
        this.mDispatch.invokeMethod("StopTimer");
    }

    public DownloadState getDownloadState() {
        return DownloadState.getById(this.mDispatch.invokeGetter("DownloadState").getAsInt());
    }

    public void showCategoriesDialog() {
        this.mDispatch.invokeMethod("ShowCategoriesDialog");
    }

    public ItemPropertiesCollection getItemProperties() {
        Dispatch dispatch = this.mDispatch.invokeGetter("ItemProperties").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new ItemPropertiesCollection(dispatch);
    }

    public RemoteStatus getMarkForDownload() {
        return RemoteStatus.getById(this.mDispatch.invokeGetter("MarkForDownload").getAsInt());
    }

    public void setMarkForDownload(RemoteStatus remoteStatus) {
        this.mDispatch.invokeSetter("MarkForDownload", ComUtil.createVariant(this.mDispatch, remoteStatus.getTypeValue()));
    }

    public boolean isConflict() {
        return this.mDispatch.invokeGetter("IsConflict").getBoolean();
    }

    public boolean isAutoResolvedWinner() {
        return this.mDispatch.invokeGetter("AutoResolvedWinner").getBoolean();
    }

    public ConflictsCollection getConflicts() {
        Dispatch dispatch = this.mDispatch.invokeGetter("Conflicts").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new ConflictsCollection(dispatch);
    }
}

