/*
 * Decompiled with CFR 0.152.
 */
package com.zfqjava.swing.cell;

import java.io.Serializable;
import java.text.ParseException;

public final class Cell
implements Serializable {
    private static final long serialVersionUID = 6612689682964056049L;
    private static final char A = '$';
    private final int B;
    private final int H;
    private final int F;
    private final int I;
    private boolean D;
    private boolean E;
    private boolean G;
    private boolean C;

    public Cell(int n, int n2) {
        this(n, n, n2, n2);
    }

    public Cell(int n, int n2, boolean bl, boolean bl2) {
        this(n, n, n2, n2, bl, bl, bl2, bl2);
    }

    public Cell(int n, int n2, int n3, int n4) {
        this.A(n, n2, n3, n4);
        this.B = n;
        this.H = n2;
        this.F = n3;
        this.I = n4;
    }

    public Cell(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.A(n, n2, n3, n4);
        this.B = n;
        this.H = n2;
        this.F = n3;
        this.I = n4;
        this.D = bl;
        this.E = bl2;
        this.G = bl3;
        this.C = bl4;
    }

    public int getFirstRow() {
        return this.B;
    }

    public int getFirstColumn() {
        return this.F;
    }

    public int getLastRow() {
        return this.H;
    }

    public int getLastColumn() {
        return this.I;
    }

    public int getX() {
        return this.F;
    }

    public int getY() {
        return this.B;
    }

    public int getWidth() {
        return this.I - this.F + 1;
    }

    public int getHeight() {
        return this.H - this.B + 1;
    }

    public boolean containsRow(int n) {
        return this.B <= n && this.H >= n;
    }

    public boolean containsColumn(int n) {
        return this.F <= n && this.I >= n;
    }

    public boolean contains(int n, int n2) {
        this.A(n, n2);
        return n >= this.B && n <= this.H && n2 >= this.F && n2 <= this.I;
    }

    public boolean contains(int n, int n2, int n3, int n4) {
        this.A(n, n2, n3, n4);
        return this.B <= n && this.H >= n2 && this.F <= n3 && this.I >= n4;
    }

    public boolean contains(Cell cell) {
        return this.contains(cell.getFirstRow(), cell.getLastRow(), cell.getFirstColumn(), cell.getLastColumn());
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        this.A(n, n2, n3, n4);
        int n5 = Math.max(this.B, n);
        int n6 = Math.min(this.H, n2);
        int n7 = Math.max(this.F, n3);
        int n8 = Math.min(this.I, n4);
        return n6 >= n5 && n8 >= n7;
    }

    public boolean intersects(Cell cell) {
        return this.intersects(cell.getFirstRow(), cell.getLastRow(), cell.getFirstColumn(), cell.getLastColumn());
    }

    public boolean isSingleCell() {
        return this.B == this.H && this.F == this.I;
    }

    public boolean isSingleColumn() {
        return this.F == this.I;
    }

    public boolean isSingleRow() {
        return this.B == this.H;
    }

    public boolean isFullRow(int n, int n2) {
        return this.F <= n && this.I >= n2;
    }

    public boolean isFullRow(int n, int n2, int n3) {
        if (this.F > n2 || this.I < n3) {
            return false;
        }
        return this.containsRow(n);
    }

    public boolean isFullColumn(int n, int n2) {
        return this.B <= n && this.H >= n2;
    }

    public boolean isFullColumn(int n, int n2, int n3) {
        if (this.B > n2 || this.H < n3) {
            return false;
        }
        return this.containsColumn(n);
    }

    public Cell union(Cell cell) {
        int n = Math.min(this.B, cell.B);
        int n2 = Math.max(this.H, cell.H);
        int n3 = Math.min(this.F, cell.F);
        int n4 = Math.max(this.I, cell.I);
        boolean bl = n == this.B ? this.D : cell.D;
        boolean bl2 = n2 == this.H ? this.E : cell.E;
        boolean bl3 = n3 == this.F ? this.G : cell.G;
        boolean bl4 = n4 == this.I ? this.C : cell.C;
        return new Cell(n, n2, n3, n4, bl, bl2, bl3, bl4);
    }

    public Cell intersection(Cell cell) {
        return this.intersection(cell.getFirstRow(), cell.getLastRow(), cell.getFirstColumn(), cell.getLastColumn());
    }

    public Cell intersection(int n, int n2, int n3, int n4) {
        int n5 = Math.max(this.B, n);
        int n6 = Math.min(this.H, n2);
        int n7 = Math.max(this.F, n3);
        int n8 = Math.min(this.I, n4);
        if (n6 >= n5 && n8 >= n7) {
            boolean bl = n5 == this.B ? this.D : this.D;
            boolean bl2 = n6 == this.H ? this.E : this.E;
            boolean bl3 = n7 == this.F ? this.G : this.G;
            boolean bl4 = n8 == this.I ? this.C : this.C;
            return new Cell(n5, n6, n7, n8, bl, bl2, bl3, bl4);
        }
        return null;
    }

    public boolean isFirstRowAbsolute() {
        return this.D;
    }

    public boolean isFirstColumnAbsolute() {
        return this.G;
    }

    public boolean isLastRowAbsolute() {
        return this.E;
    }

    public boolean isLastColumnAbsolute() {
        return this.C;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.B;
        n = 37 * n + this.H;
        n = 37 * n + this.F;
        n = 37 * n + this.I;
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cell)) {
            return false;
        }
        Cell cell = (Cell)object;
        return cell.B == this.B && cell.H == this.H && cell.F == this.F && cell.I == this.I;
    }

    public String toString() {
        return Cell.A(this);
    }

    public static Cell valueOf(String string) throws ParseException {
        string = string.trim();
        int n = string.indexOf(32);
        try {
            if (n != -1) {
                Cell cell = Cell.D(string.substring(0, n));
                Cell cell2 = Cell.D(string.substring(n + 1));
                if (cell != null && cell2 != null) {
                    return cell.intersection(cell2);
                }
                if (cell != null) {
                    return cell;
                }
                if (cell2 != null) {
                    return cell2;
                }
                return null;
            }
            return Cell.D(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ParseException(indexOutOfBoundsException.getMessage(), 0);
        }
    }

    private static Cell D(String string) throws ParseException {
        String string2 = string.toUpperCase();
        int n = string2.indexOf(":");
        if (n != -1) {
            Cell cell = Cell.valueOf(string2.substring(0, n));
            Cell cell2 = Cell.valueOf(string2.substring(n + 1));
            return cell.union(cell2);
        }
        int n2 = Cell.A(string2);
        int n3 = Cell.F(string2);
        boolean bl = Cell.B(string2);
        boolean bl2 = Cell.E(string2);
        return new Cell(n2, n3, bl, bl2);
    }

    private static String A(Cell cell) {
        return Cell.toString(cell.B, cell.H, cell.F, cell.I, cell.D, cell.E, cell.G, cell.C);
    }

    public static String toString(int n, int n2) {
        return Cell.toString(n, n2, false, false);
    }

    public static String toString(int n, int n2, boolean bl, boolean bl2) {
        return Cell.toString(n, n, n2, n2, bl, bl, bl2, bl2);
    }

    public static String toString(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl3) {
            stringBuffer.append('$');
        }
        stringBuffer.append(Cell.getColumnName(n3));
        if (bl) {
            stringBuffer.append('$');
        }
        stringBuffer.append(n + 1);
        if (n != n2 || n3 != n4) {
            stringBuffer.append(":");
            if (bl4) {
                stringBuffer.append('$');
            }
            stringBuffer.append(Cell.getColumnName(n4));
            if (bl2) {
                stringBuffer.append('$');
            }
            stringBuffer.append(n2 + 1);
        }
        return stringBuffer.toString();
    }

    public static String getColumnName(int n) {
        String string = "";
        while (n >= 0) {
            string = (char)((char)(n % 26) + 65) + string;
            n = n / 26 - 1;
        }
        return string;
    }

    private static int F(String string) {
        int n = 0;
        int n2 = Cell.C(string);
        int n3 = 0;
        if (string.charAt(0) == '$') {
            ++n3;
        }
        int n4 = n2;
        if (string.charAt(n2 - 1) == '$') {
            --n4;
        }
        int n5 = n3;
        while (n5 < n4) {
            if (n5 != n3) {
                n = (n + 1) * 26;
            }
            n += string.charAt(n5) - 65;
            ++n5;
        }
        return n;
    }

    private static int A(String string) {
        try {
            return Integer.parseInt(string.substring(Cell.C(string))) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    private static int C(String string) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (Character.isDigit(c)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static boolean E(String string) {
        return string.charAt(0) == '$';
    }

    private static boolean B(String string) {
        return string.charAt(Cell.C(string) - 1) == '$';
    }

    private void A(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("index cannot < 0");
        }
    }

    private void A(int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("index cannot < 0");
        }
        if (n > n2 || n3 > n4) {
            throw new IllegalArgumentException("first index cannot > last index");
        }
    }

    private void B(Cell cell) {
        if (cell == null) {
            throw new NullPointerException();
        }
    }
}

