/*
 * Decompiled with CFR 0.152.
 */
package com.zfqjava.swing;

import com.zfqjava.swing.ValueAction;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class ResourceManager {
    private List A = new ArrayList(8);
    private Map B = new HashMap(8);
    private Map C = new HashMap();

    public ResourceManager() {
    }

    public ResourceManager(String string) {
        if (string != null) {
            this.addBundle(string);
        }
    }

    public void addBundle(String string) {
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (!this.B.containsKey(string)) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
                this.A.add(resourceBundle);
                this.B.put(string, resourceBundle);
            }
            catch (MissingResourceException missingResourceException) {
                missingResourceException.printStackTrace();
            }
        }
    }

    public void removeBundle(String string) {
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        ResourceBundle resourceBundle = (ResourceBundle)this.B.get(string);
        if (resourceBundle != null) {
            this.A.remove(resourceBundle);
            this.B.remove(string);
        }
    }

    public Integer getMnemonic(String string) {
        String string2 = this.getString(string);
        if (string2 != null && string2.length() > 0) {
            return new Integer(string2.charAt(0));
        }
        return null;
    }

    public Icon getIcon(String string) {
        URL uRL = this.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public KeyStroke getKeyStroke(String string) {
        String string2 = this.getString(string);
        if (string2 != null) {
            return KeyStroke.getKeyStroke(string2);
        }
        return null;
    }

    public URL getResource(String string) {
        String string2 = this.getString(string);
        if (string2 != null) {
            return this.getClass().getResource(string2);
        }
        return null;
    }

    public String getString(String string) {
        String string2 = null;
        int n = this.A.size() - 1;
        while (n >= 0) {
            ResourceBundle resourceBundle = (ResourceBundle)this.A.get(n);
            try {
                string2 = resourceBundle.getString(string);
                break;
            }
            catch (MissingResourceException missingResourceException) {
                --n;
            }
        }
        if ("".equals(string2)) {
            return null;
        }
        return string2;
    }

    public Action getAction(String string) {
        Action action = (Action)this.C.get(string);
        if (action == null) {
            action = this.A(string);
            this.C.put(string, action);
        }
        return action;
    }

    private Action A(String string) {
        ValueAction valueAction = new ValueAction();
        valueAction.putValue("ActionCommandKey", string);
        String string2 = this.getString(string + ".name");
        Integer n = this.getMnemonic(string + ".mnemonic");
        Icon icon = this.getIcon(string + ".smallIcon");
        String string3 = this.getString(string + ".shortDescription");
        KeyStroke keyStroke = this.getKeyStroke(string + ".accelerator");
        if (string2 != null) {
            valueAction.putValue("Name", string2);
        }
        if (n != null) {
            valueAction.putValue("MnemonicKey", n);
        }
        if (icon != null) {
            valueAction.putValue("SmallIcon", icon);
        }
        if (string3 != null) {
            valueAction.putValue("ShortDescription", string3);
            valueAction.putValue("LongDescription", string3);
        }
        if (keyStroke != null) {
            valueAction.putValue("AcceleratorKey", keyStroke);
        }
        return valueAction;
    }
}

