/*
 * Decompiled with CFR 0.152.
 */
package com.zfqjava.swing;

import com.zfqjava.swing.ActionManager;
import com.zfqjava.swing.ActionVetoException;
import com.zfqjava.swing.JCommonPane;
import com.zfqjava.swing.JStatusBar;
import com.zfqjava.swing.ResourceManager;
import com.zfqjava.swing.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class JBean
extends JPanel
implements WindowConstants {
    private static final String E = "com.zfqjava.swing.resources.common";
    public static final String FILE = "file";
    public static final String VIEW = "view";
    public static final String TOOL = "tool";
    public static final String HELP = "help";
    public static final String NEW = "new";
    public static final String OPEN = "open";
    public static final String SAVE = "save";
    public static final String SAVE_AS = "saveAs";
    public static final String IMPORT = "import";
    public static final String EXPORT = "export";
    public static final String PAGE_SETUP = "pageSetup";
    public static final String PRINT = "print";
    public static final String PRINT_PREVIEW = "printPreview";
    public static final String EXIT = "exit";
    public static final String UNDO = "undo";
    public static final String REDO = "redo";
    public static final String CUT = "cut";
    public static final String COPY = "copy";
    public static final String PASTE = "paste";
    public static final String FIND = "find";
    public static final String FIND_NEXT = "findNext";
    public static final String REPLACE = "replace";
    public static final String CLEAR = "clear";
    public static final String CLEAR_ALL = "clearAll";
    public static final String SELECT_ALL = "selectAll";
    public static final String SPELL = "spell";
    public static final String TIP = "tip";
    public static final String ABOUT = "about";
    public static final int EXIT_ON_CLOSE = 3;
    private static final String N = "sub-menus";
    private static final String M = "toggle-actions";
    private static final String C = "select-actions";
    private static final String O = "group-actions";
    private static final String K = "application.defaultlaf";
    private ResourceManager H = this.createResourceManager();
    private ActionManager I = this.createActionManager();
    private UIFactory G = this.createUIFactory();
    private JFrame A;
    private JInternalFrame F;
    private String J;
    private JStatusBar P = this.createStatusBar();
    private int L = 2;
    private Map D;
    private Frame B;

    public JBean() {
        super(new BorderLayout());
        this.init();
    }

    protected ResourceManager createResourceManager() {
        return new ResourceManager(E);
    }

    protected ActionManager createActionManager() {
        return new ActionManager(this.H, this);
    }

    protected UIFactory createUIFactory() {
        return new UIFactory(this.H, this.I);
    }

    protected JStatusBar createStatusBar() {
        return new JStatusBar();
    }

    public ResourceManager getResourceManager() {
        return this.H;
    }

    public ActionManager getActionManager() {
        return this.I;
    }

    public UIFactory getUIFactory() {
        return this.G;
    }

    public JStatusBar getStatusBar() {
        return this.P;
    }

    protected void init() {
    }

    public void setTitle(String string) {
        this.J = string;
        if (this.A != null) {
            this.A.setTitle(string);
        }
        if (this.F != null) {
            this.F.setTitle(string);
        }
    }

    public String getTitle() {
        return this.J;
    }

    public void setDefaultCloseOperation(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("defaultCloseOperation must be one of: DO_NOTHING_ON_CLOSE, HIDE_ON_CLOSE, DISPOSE_ON_CLOSE, or EXIT_ON_CLOSE");
        }
        this.L = n;
    }

    public int getDefaultCloseOperation() {
        return this.L;
    }

    public void showFrame() {
        this.A = this.createFrame();
        this.A.pack();
        JBean.A(this.A);
        this.A.show();
    }

    protected JFrame createFrame() {
        JFrame jFrame = new JFrame(this.getTitle());
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JBean.this.doClose();
            }
        });
        jFrame.getContentPane().add(this);
        return jFrame;
    }

    public JFrame getFrame() {
        return this.A;
    }

    public void showInternalFrame(Component component) {
        JDesktopPane jDesktopPane = JOptionPane.getDesktopPaneForComponent(component);
        if (jDesktopPane == null) {
            throw new RuntimeException("JBean: parent dose not have a JDesktopPane parent");
        }
        this.F = this.createInternalFrame();
        this.F.pack();
        jDesktopPane.add(this.F);
        JBean.A(jDesktopPane, this.F);
        this.F.show();
    }

    protected JInternalFrame createInternalFrame() {
        JInternalFrame jInternalFrame = new JInternalFrame(this.getTitle(), true, true, true, true);
        jInternalFrame.setDefaultCloseOperation(0);
        jInternalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                JBean.this.doClose();
            }
        });
        jInternalFrame.getContentPane().add(this);
        return jInternalFrame;
    }

    public JInternalFrame getInternalFrame() {
        return this.F;
    }

    public void doSplash() {
        JBean jBean = this;
        synchronized (jBean) {
            if (this.D == null) {
                this.B = new Frame(){

                    public void show() {
                    }
                };
                HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
                hashMap.put("product-name", this.getString("product-name"));
                hashMap.put("copyright-note", this.getString("copyright-note"));
                hashMap.put("background-image", this.H.getResource("background-image"));
                hashMap.put("splash-image", this.H.getResource("splash-image"));
                this.D = JCommonPane.showSplashWindow(this.B, hashMap);
            } else {
                Window window = (Window)this.D.get("window");
                ((Component)window).setVisible(false);
                window.dispose();
                this.B.dispose();
                this.B = null;
                this.D = null;
            }
        }
    }

    public void doExit() {
        this.doClose();
    }

    public void doTip() {
        HashMap<String, URL> hashMap = new HashMap<String, URL>(1);
        hashMap.put("tip-url", this.H.getResource("tip-url"));
        JCommonPane.showTipOfTheDayDialog(this, hashMap);
    }

    public void doAbout() {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("product-name", this.getString("product-name"));
        hashMap.put("copyright-note", this.getString("copyright-note"));
        JCommonPane.showAboutDialog(this, hashMap);
    }

    public void doFeedback() {
        HashMap<String, String> hashMap = new HashMap<String, String>(5);
        hashMap.put("feedback-action-url", this.getString("feedback-action-url"));
        hashMap.put("feedback-realname-param-name", this.getString("feedback-realname-param-name"));
        hashMap.put("feedback-email-param-name", this.getString("feedback-email-param-name"));
        hashMap.put("feedback-subject-param-name", this.getString("feedback-subject-param-name"));
        hashMap.put("feedback-subject-param-value", this.getString("feedback-subject-param-value"));
        hashMap.put("feedback-content-param-name", this.getString("feedback-content-param-name"));
        hashMap.put("feedback-recipient-param-name", this.getString("feedback-recipient-param-name"));
        hashMap.put("feedback-recipient-param-value", this.getString("feedback-recipient-param-value"));
        JCommonPane.showFeedbackDialog(this, hashMap);
    }

    public void doClose() {
        try {
            this.doBeforeClose();
        }
        catch (ActionVetoException actionVetoException) {
            return;
        }
        switch (this.L) {
            case 0: {
                break;
            }
            case 1: {
                if (this.A != null) {
                    ((Component)this.A).setVisible(false);
                }
                if (this.F == null) break;
                this.F.setVisible(false);
                if (!this.F.isSelected()) break;
                try {
                    this.F.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
            case 2: {
                if (this.A != null) {
                    ((Component)this.A).setVisible(false);
                    this.A.dispose();
                }
                if (this.F == null) break;
                this.F.dispose();
                break;
            }
            case 3: {
                System.exit(0);
            }
        }
    }

    protected void doBeforeClose() throws ActionVetoException {
    }

    public String getString(String string) {
        return this.H.getString(string);
    }

    public Icon getIcon(String string) {
        return this.H.getIcon(string);
    }

    public Action getAction(String string) {
        return this.I.getAction(string);
    }

    protected JMenuBar createMenuBar(String string) {
        return this.G.createMenuBar(string);
    }

    protected JPopupMenu createPopupMenu(String string) {
        return this.G.createPopupMenu(string);
    }

    protected JToolBar createToolBar(String string) {
        return this.G.createToolBar(string);
    }

    protected JMenu createMenu(String string) {
        return this.G.createMenu(string);
    }

    protected JMenuItem createMenuItem(String string) {
        return this.G.createMenuItem(string);
    }

    protected AbstractButton createButton(String string) {
        return this.G.createButton(string);
    }

    public static void main(String[] stringArray) {
        JBean jBean = new JBean();
        jBean.showFrame();
        jBean.setDefaultCloseOperation(3);
    }

    private static void A(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)window).setLocation((dimension.width - window.getWidth()) / 2, (dimension.height - window.getHeight()) / 2);
    }

    private static void A(JDesktopPane jDesktopPane, JInternalFrame jInternalFrame) {
        Dimension dimension = jDesktopPane.getSize();
        int n = (dimension.width - jInternalFrame.getWidth()) / 2;
        int n2 = (dimension.height - jInternalFrame.getHeight()) / 2;
        n = Math.max(n, 0);
        n2 = Math.max(n2, 0);
        jInternalFrame.setLocation(n, n2);
    }

    static {
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
        String string = null;
        try {
            string = System.getProperty(K);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null) {
            try {
                if ("system".equals(string)) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                } else if ("java".equals(string)) {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

