/*
 * Decompiled with CFR 0.152.
 */
package sferyx.javascript.engine;

import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.ElementIterator;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.HTMLEditor;
import sferyx.javascript.engine.DocumentElement;
import sferyx.javascript.engine.FormElement;

public class DocumentReference {
    HTMLEditor htmlEditor;
    int mode = 0;
    public String form_name;
    public String activeElement;
    public String alinkColor;
    public String background;
    public String bgColor;
    public String body;
    public String characterset;
    public String charset;
    public String cookie;
    public String defaultCharset;
    public String designMode;
    public String doctype;
    public String documentElement;
    public String domain;
    public String expando;
    public String fgColor;
    public String fileCreatedDate;
    public String fileModifiedDate;
    public String fileSize;
    public String height;
    public String implementation;
    public String lastModified;
    public String linkColor;
    public String location;
    public String parentWindow;
    public String protocol;
    public String readyState;
    public String referrer;
    public String selection;
    public String title;
    public String uniqueID;
    public String URL;
    public String vlinkColor;
    public String width;
    public String[] all;
    public String[] anchors;
    public String[] applets;
    public String[] classes;
    public String[] embeds;
    public FormElement[] forms;
    public String[] frames;
    public String[] ids;
    public String[] images;
    public String[] layers;
    public String[] links;
    public String[] plugins;
    public String[] scripts;
    public String[] styleSheets;
    public String[] tags;

    public DocumentReference(HTMLEditor htmlEditor) {
        this.htmlEditor = htmlEditor;
        this.forms();
    }

    public void updateReferences() {
        this.forms();
    }

    public DocumentElement[] forms() {
        Vector<FormElement> vec = null;
        try {
            EditorHTMLDocument htdoc = (EditorHTMLDocument)this.htmlEditor.getSelectedEditorComponent().getDocument();
            ElementIterator iterator = new ElementIterator(htdoc);
            AbstractDocument.AbstractElement currentElement = null;
            while ((currentElement = (AbstractDocument.AbstractElement)iterator.next()) != null) {
                if (currentElement.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.FORM) continue;
                if (vec == null) {
                    vec = new Vector<FormElement>();
                }
                vec.addElement(new FormElement(currentElement));
            }
            if (vec == null) {
                return null;
            }
            Object[] elements = new FormElement[vec.size()];
            vec.copyInto(elements);
            this.forms = elements;
            return elements;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void attachEvent() {
    }

    public void clear() {
    }

    public void close() {
    }

    public void contextual() {
    }

    public void createAttribute() {
    }

    public void createCDATASection() {
    }

    public void createComment() {
    }

    public void createDocumentFragment() {
    }

    public void createElement() {
    }

    public void createEntityReference() {
    }

    public void createProcessingInstruction() {
    }

    public void createStyleSheet() {
    }

    public void createTextNode() {
    }

    public void detachEvent() {
    }

    public void elementFromPoint() {
    }

    public void execCommand() {
    }

    public void getSelection() {
    }

    public void open() {
    }

    public void queryCommandEnabled() {
    }

    public void queryCommandIndeterm() {
    }

    public void queryCommandState() {
    }

    public void queryCommandSupported() {
    }

    public void queryCommandText() {
    }

    public void queryCommandValue() {
    }

    public void recalc() {
    }

    public void write(String content) {
        this.htmlEditor.insertContent(content);
    }

    public void writeln(String content) {
        this.htmlEditor.insertContent(content);
    }

    public DocumentElement getElementById(String ID) {
        EditorHTMLDocument htdoc = (EditorHTMLDocument)this.htmlEditor.getSelectedEditorComponent().getDocument();
        ElementIterator iterator = new ElementIterator(htdoc);
        AbstractDocument.AbstractElement currentElement = null;
        while ((currentElement = (AbstractDocument.AbstractElement)iterator.next()) != null) {
            if (currentElement.getAttribute(HTML.Attribute.ID) == null || !currentElement.getAttribute(HTML.Attribute.ID).toString().equalsIgnoreCase(ID)) continue;
            return new DocumentElement(currentElement);
        }
        return null;
    }

    public DocumentElement[] getElementsByName(String name) {
        Vector<DocumentElement> vec = null;
        EditorHTMLDocument htdoc = (EditorHTMLDocument)this.htmlEditor.getSelectedEditorComponent().getDocument();
        ElementIterator iterator = new ElementIterator(htdoc);
        AbstractDocument.AbstractElement currentElement = null;
        while ((currentElement = (AbstractDocument.AbstractElement)iterator.next()) != null) {
            if (currentElement.getAttribute(HTML.Attribute.NAME) == null || !currentElement.getAttribute(HTML.Attribute.NAME).toString().equalsIgnoreCase(name)) continue;
            if (vec == null) {
                vec = new Vector<DocumentElement>();
            }
            vec.addElement(new DocumentElement(currentElement));
        }
        if (vec == null) {
            return null;
        }
        Object[] elements = new DocumentElement[vec.size()];
        vec.copyInto(elements);
        return elements;
    }

    public DocumentElement[] getElementsByTagName(String tagName) {
        Vector<DocumentElement> vec = null;
        EditorHTMLDocument htdoc = (EditorHTMLDocument)this.htmlEditor.getSelectedEditorComponent().getDocument();
        ElementIterator iterator = new ElementIterator(htdoc);
        AbstractDocument.AbstractElement currentElement = null;
        while ((currentElement = (AbstractDocument.AbstractElement)iterator.next()) != null) {
            DocumentElement elem;
            if (currentElement.getAttribute(StyleConstants.NameAttribute) != null && currentElement.getAttribute(StyleConstants.NameAttribute).toString().equalsIgnoreCase(tagName)) {
                if (vec == null) {
                    vec = new Vector<DocumentElement>();
                }
                vec.addElement(new DocumentElement(currentElement));
                continue;
            }
            if (tagName != null && tagName.equalsIgnoreCase("a")) {
                if (currentElement.getAttribute(StyleConstants.NameAttribute) == null || !currentElement.getAttribute(StyleConstants.NameAttribute).toString().equalsIgnoreCase("content") || currentElement.getAttributes().getAttribute(HTML.Tag.A) == null) continue;
                if (vec == null) {
                    vec = new Vector();
                }
                elem = new DocumentElement(currentElement);
                elem.tagName = "a";
                vec.addElement(elem);
                continue;
            }
            if (tagName != null && tagName.equalsIgnoreCase("span")) {
                if (currentElement.getAttribute(StyleConstants.NameAttribute) == null || !currentElement.getAttribute(StyleConstants.NameAttribute).toString().equalsIgnoreCase("content") || currentElement.getAttributes().getAttribute(HTML.Tag.SPAN) == null) continue;
                if (vec == null) {
                    vec = new Vector();
                }
                elem = new DocumentElement(currentElement);
                elem.tagName = "span";
                vec.addElement(elem);
                continue;
            }
            if (tagName == null || !tagName.equalsIgnoreCase("font") || currentElement.getAttribute(StyleConstants.NameAttribute) == null || !currentElement.getAttribute(StyleConstants.NameAttribute).toString().equalsIgnoreCase("content") || currentElement.getAttributes().getAttribute(HTML.Tag.FONT) == null) continue;
            if (vec == null) {
                vec = new Vector();
            }
            elem = new DocumentElement(currentElement);
            elem.tagName = "font";
            vec.addElement(elem);
        }
        if (vec == null) {
            return null;
        }
        Object[] elements = new DocumentElement[vec.size()];
        vec.copyInto(elements);
        return elements;
    }
}

