/*
 * Decompiled with CFR 0.152.
 */
package sferyx.javascript.engine;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import sferyx.javascript.engine.ElementAttribute;

public class DocumentElement {
    public boolean canHaveChildren;
    public boolean canHaveHTML;
    public String className;
    public String clientHeight;
    public String clientLeft;
    public String clientTop;
    public String clientWidth;
    public String contentEditable;
    public String currentStyle;
    public String dir;
    public String document;
    public String firstChild;
    public String hideFocus;
    public String id;
    public String innerHTML;
    public String innerText;
    public String isContentEditable;
    public String isDisabled;
    public String isTextEdit;
    public String lang;
    public String language;
    public String lastChild;
    public String nextSibling;
    public String nodeName;
    public int nodeType;
    public String nodeValue;
    public String offsetHeight;
    public String offsetLeft;
    public String offsetParent;
    public String offsetTop;
    public String offsetWidth;
    public String onevent;
    public String outerHTML;
    public String outerText;
    public String ownerDocument;
    public String parentElement;
    public String parentNode;
    public String parentTextEdit;
    public String previousSibling;
    public String readyState;
    public String runtimeStyle;
    public String scopeName;
    public String scrollHeight;
    public String scrollLeft;
    public String scrollTop;
    public String scrollWidth;
    public String sourceIndex;
    public String style;
    public String tagName;
    public String title;
    public String uniqueID;
    public String tagUrn;
    public String[] all;
    public ElementAttribute[] attributes;
    public String[] behaviorUrns;
    public String[] childNodes;
    public String[] children;
    public String[] filters;
    public AbstractDocument.AbstractElement element;

    public DocumentElement(AbstractDocument.AbstractElement element) {
        this.element = element;
        this.tagName = element.getAttribute(StyleConstants.NameAttribute).toString();
        this.nodeType = this.tagName.equals("content") ? 3 : 1;
        if (element.getAttribute(HTML.Attribute.CLASS) != null) {
            this.className = element.getAttribute(HTML.Attribute.CLASS).toString();
        }
        if (element.getAttribute(HTML.Attribute.STYLE) != null) {
            this.style = element.getAttribute(HTML.Attribute.STYLE).toString();
        }
        if (element.getAttribute(HTML.Attribute.ID) != null) {
            this.id = element.getAttribute(HTML.Attribute.ID).toString();
        }
        this.canHaveChildren = element.isLeaf();
        this.canHaveHTML = element.isLeaf();
        if (element.getAttribute(HTML.Attribute.TITLE) != null) {
            this.title = element.getAttribute(HTML.Attribute.TITLE).toString();
        }
        this.nodeName = this.tagName;
        this.initAttributes();
    }

    void initAttributes() {
        AttributeSet attribs = this.element.getAttributes();
        Enumeration<?> names = attribs.getAttributeNames();
        Vector<ElementAttribute> vec = null;
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            Object value = attribs.getAttribute(name);
            if (vec == null) {
                vec = new Vector<ElementAttribute>();
            }
            if (name == StyleConstants.NameAttribute) {
                name = "tagName";
            }
            if (name == StyleConstants.ModelAttribute) continue;
            ElementAttribute attribute = new ElementAttribute(name.toString(), value.toString());
            vec.addElement(attribute);
        }
        this.attributes = new ElementAttribute[vec.size()];
        vec.copyInto(this.attributes);
    }

    public ElementAttribute[] getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String attributeName) {
        if (this.attributes == null) {
            return null;
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!this.attributes[i].getName().equalsIgnoreCase(attributeName)) continue;
            return this.attributes[i].getValue();
        }
        return null;
    }

    public String toString() {
        String elementString = "";
        for (int i = 0; i < this.attributes.length; ++i) {
            elementString = elementString + this.attributes[i].nodeName + " = " + this.attributes[i].nodeValue + "\n";
        }
        return elementString;
    }
}

