/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.searchreplace;

import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.SferyxUtilities;

public class ReplaceDialog
extends JDialog {
    JTextComponent textComponent;
    int pos = -1;
    boolean outOfRange = false;
    private JLabel findWhatLabel;
    private JLabel searchDirectionLabel;
    private JRadioButton upRadioButton;
    private JButton replaceButtonAll;
    private JTextField replaceWithTextField;
    private JButton replaceButton;
    private JCheckBox matchCaseCheckBox;
    private JButton findButton;
    private JLabel searchOptionsTitle;
    private JLabel replaceWithLabel;
    private JButton cancelButton;
    private JSeparator jSeparator1;
    private JLabel searchOptionsLabel;
    private JRadioButton downRadioButton;
    private ButtonGroup searchDirectionRadioButtonGroup;
    private JTextField searchedWordTextField;
    private JCheckBox wholeWordsCheckBox;

    public ReplaceDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public ReplaceDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.searchDirectionRadioButtonGroup = new ButtonGroup();
        this.replaceWithTextField = new JTextField();
        this.replaceWithLabel = new JLabel();
        this.searchOptionsTitle = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.cancelButton = new JButton();
        this.findButton = new JButton();
        this.upRadioButton = new JRadioButton();
        this.downRadioButton = new JRadioButton();
        this.searchOptionsLabel = new JLabel();
        this.searchDirectionLabel = new JLabel();
        this.matchCaseCheckBox = new JCheckBox();
        this.wholeWordsCheckBox = new JCheckBox();
        this.findWhatLabel = new JLabel();
        this.searchedWordTextField = new JTextField();
        this.replaceButton = new JButton();
        this.replaceButtonAll = new JButton();
        this.getContentPane().setLayout(null);
        this.setTitle("Search & Replace");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ReplaceDialog.this.closeDialog(evt);
            }
        });
        this.replaceWithTextField.setFont(new Font("Dialog", 0, 11));
        this.replaceWithTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.replaceWithTextFieldActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.replaceWithTextField);
        this.replaceWithTextField.setBounds(130, 50, 270, 20);
        this.replaceWithLabel.setHorizontalAlignment(4);
        this.replaceWithLabel.setText("Replace with:");
        this.getContentPane().add(this.replaceWithLabel);
        this.replaceWithLabel.setBounds(0, 50, 120, 20);
        this.searchOptionsTitle.setHorizontalAlignment(4);
        this.searchOptionsTitle.setText("Search options:");
        this.getContentPane().add(this.searchOptionsTitle);
        this.searchOptionsTitle.setBounds(10, 100, 130, 16);
        this.getContentPane().add(this.jSeparator1);
        this.jSeparator1.setBounds(150, 110, 250, 2);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.cancelButton);
        this.cancelButton.setBounds(430, 50, 120, 26);
        this.findButton.setText("Find");
        this.findButton.setToolTipText("Find");
        this.findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.findButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.findButton);
        this.findButton.setBounds(430, 20, 120, 26);
        this.upRadioButton.setText("Up");
        this.searchDirectionRadioButtonGroup.add(this.upRadioButton);
        this.upRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.upRadioButtonActionPerformed(evt);
            }
        });
        this.upRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ReplaceDialog.this.upRadioButtonStateChanged(evt);
            }
        });
        this.getContentPane().add(this.upRadioButton);
        this.upRadioButton.setBounds(120, 140, 130, 24);
        this.downRadioButton.setSelected(true);
        this.downRadioButton.setText("Down");
        this.searchDirectionRadioButtonGroup.add(this.downRadioButton);
        this.downRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ReplaceDialog.this.downRadioButtonStateChanged(evt);
            }
        });
        this.getContentPane().add(this.downRadioButton);
        this.downRadioButton.setBounds(120, 160, 130, 24);
        this.searchOptionsLabel.setText("Options:");
        this.getContentPane().add(this.searchOptionsLabel);
        this.searchOptionsLabel.setBounds(250, 120, 110, 16);
        this.searchDirectionLabel.setText("Direction:");
        this.getContentPane().add(this.searchDirectionLabel);
        this.searchDirectionLabel.setBounds(110, 120, 130, 16);
        this.matchCaseCheckBox.setText("Match case");
        this.matchCaseCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ReplaceDialog.this.matchCaseCheckBoxStateChanged(evt);
            }
        });
        this.getContentPane().add(this.matchCaseCheckBox);
        this.matchCaseCheckBox.setBounds(260, 140, 340, 24);
        this.wholeWordsCheckBox.setText("Whole words only");
        this.wholeWordsCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ReplaceDialog.this.wholeWordsCheckBoxStateChanged(evt);
            }
        });
        this.getContentPane().add(this.wholeWordsCheckBox);
        this.wholeWordsCheckBox.setBounds(260, 160, 340, 24);
        this.findWhatLabel.setHorizontalAlignment(4);
        this.findWhatLabel.setText("Find what:");
        this.getContentPane().add(this.findWhatLabel);
        this.findWhatLabel.setBounds(10, 20, 110, 20);
        this.searchedWordTextField.setFont(new Font("Dialog", 0, 11));
        this.searchedWordTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.searchedWordTextFieldActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.searchedWordTextField);
        this.searchedWordTextField.setBounds(130, 20, 270, 20);
        this.replaceButton.setText("Replace");
        this.replaceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.replaceButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.replaceButton);
        this.replaceButton.setBounds(430, 80, 120, 26);
        this.replaceButtonAll.setText("Replace All");
        this.replaceButtonAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.replaceButtonAllActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.replaceButtonAll);
        this.replaceButtonAll.setBounds(430, 110, 120, 26);
        this.pack();
    }

    private void replaceWithTextFieldActionPerformed(ActionEvent evt) {
        this.pos = -1;
        this.findNext();
    }

    private void searchedWordTextFieldActionPerformed(ActionEvent evt) {
        this.pos = -1;
        this.findNext();
    }

    private void replaceButtonAllActionPerformed(ActionEvent evt) {
        EditorHTMLDocument htdoc;
        if (this.searchedWordTextField.getText() == null || this.searchedWordTextField.getText().equals("")) {
            return;
        }
        Document doc = this.textComponent.getDocument();
        if (doc instanceof EditorHTMLDocument && (htdoc = (EditorHTMLDocument)doc).getBodyElement().getStartOffset() + 1 == htdoc.getBodyElement().getEndOffset()) {
            return;
        }
        if (this.textComponent.getDocument().getLength() == 0) {
            return;
        }
        this.textComponent.setCaretPosition(0);
        this.downRadioButton.setSelected(true);
        this.outOfRange = false;
        while (!this.outOfRange) {
            this.replaceButtonActionPerformed(evt);
        }
    }

    private void replaceButtonActionPerformed(ActionEvent evt) {
        if (this.searchedWordTextField.getText() == null || this.searchedWordTextField.getText().equals("")) {
            return;
        }
        if (this.textComponent.getSelectedText() == null || this.textComponent.getSelectedText().equals("")) {
            this.pos = -1;
            this.findNext();
        }
        if (this.outOfRange) {
            return;
        }
        if (this.textComponent.getDocument() instanceof DefaultStyledDocument) {
            DefaultStyledDocument doc = (DefaultStyledDocument)this.textComponent.getDocument();
            int start = this.textComponent.getSelectionStart();
            Element e = doc.getCharacterElement(start);
            AttributeSet attribs = e.getAttributes();
            this.textComponent.replaceSelection(this.replaceWithTextField.getText());
            Element e2 = ((DefaultStyledDocument)this.textComponent.getDocument()).getCharacterElement(start);
            if (attribs.getAttributeCount() > 1) {
                doc.setCharacterAttributes(start, e2.getEndOffset() - start, attribs, true);
            }
        } else {
            this.textComponent.replaceSelection(this.replaceWithTextField.getText());
        }
        this.pos = -1;
        this.findNext();
    }

    private void downRadioButtonStateChanged(ChangeEvent evt) {
    }

    private void upRadioButtonStateChanged(ChangeEvent evt) {
    }

    private void wholeWordsCheckBoxStateChanged(ChangeEvent evt) {
    }

    private void matchCaseCheckBoxStateChanged(ChangeEvent evt) {
    }

    private void upRadioButtonActionPerformed(ActionEvent evt) {
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void findButtonActionPerformed(ActionEvent evt) {
        this.pos = -1;
        this.findNext();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setSize(570, 220);
            this.setLocation((int)(this.getParent().getBounds().getX() + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)(this.getParent().getBounds().getY() + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        super.setVisible(b);
        if (b) {
            this.searchedWordTextField.requestFocus();
        }
    }

    public void setTargetTextComponent(JTextComponent textComponent) {
        this.textComponent = textComponent;
    }

    public void findNext() {
        if (this.textComponent != null) {
            this.textComponent.grabFocus();
        }
        if (this.wholeWordsCheckBox.isSelected()) {
            if (this.upRadioButton.isSelected()) {
                this.findNextWordBackward();
            } else {
                this.findNextWord();
            }
        } else if (this.upRadioButton.isSelected()) {
            this.findNextOccuranceBackward();
        } else {
            this.findNextOccurance();
        }
    }

    public void findNextOccurance() {
        int index = -1;
        try {
            while (index == -1) {
                this.outOfRange = false;
                if (this.pos == -1) {
                    this.pos = this.textComponent.getCaretPosition();
                } else if (this.pos >= this.textComponent.getDocument().getEndPosition().getOffset()) {
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                    this.outOfRange = true;
                    return;
                }
                Element paragraph = Utilities.getParagraphElement(this.textComponent, this.pos);
                int start = paragraph.getStartOffset();
                int end = paragraph.getEndOffset();
                String text = this.textComponent.getText(start, end - start);
                index = this.matchCaseCheckBox.isSelected() ? text.indexOf(this.searchedWordTextField.getText(), this.pos - start) : text.toLowerCase().indexOf(this.searchedWordTextField.getText().toLowerCase(), this.pos - start);
                if (index == -1) {
                    ++this.pos;
                    continue;
                }
                this.textComponent.select(start + index, start + index + this.searchedWordTextField.getText().length());
                this.pos = start + index + this.searchedWordTextField.getText().length();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void findNextOccuranceBackward() {
        int index = -1;
        try {
            while (index == -1) {
                this.outOfRange = false;
                if (this.pos == -1) {
                    this.pos = this.textComponent.getSelectionStart();
                    if (this.searchedWordTextField.getText().length() == 1) {
                        --this.pos;
                    }
                } else if (this.pos <= this.textComponent.getDocument().getStartPosition().getOffset()) {
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the beginning of the document"), this.getTranslatedString("Search"), 1);
                    this.outOfRange = true;
                    return;
                }
                Element paragraph = Utilities.getParagraphElement(this.textComponent, this.pos);
                int start = paragraph.getStartOffset();
                int end = paragraph.getEndOffset();
                if (this.pos - start + 1 <= this.textComponent.getDocument().getStartPosition().getOffset()) {
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the beginning of the document"), this.getTranslatedString("Search"), 1);
                    this.outOfRange = true;
                    return;
                }
                String text = this.textComponent.getText(start, this.pos - start + 1);
                index = this.matchCaseCheckBox.isSelected() ? text.lastIndexOf(this.searchedWordTextField.getText()) : text.toLowerCase().lastIndexOf(this.searchedWordTextField.getText().toLowerCase());
                if (index == -1) {
                    --this.pos;
                    if (this.pos > this.textComponent.getDocument().getStartPosition().getOffset()) continue;
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the beginning of the document"), this.getTranslatedString("Search"), 1);
                    this.outOfRange = true;
                    return;
                }
                this.textComponent.select(start + index, start + index + this.searchedWordTextField.getText().length());
                this.pos = start + index - this.searchedWordTextField.getText().length();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void findNextWord() {
        int index = -1;
        int pos = -1;
        try {
            while (index == -1) {
                int end;
                this.outOfRange = false;
                if (pos == -1) {
                    pos = this.textComponent.getCaretPosition();
                }
                if (pos >= this.textComponent.getDocument().getEndPosition().getOffset()) {
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                    this.outOfRange = true;
                    return;
                }
                int start = Utilities.getWordStart(this.textComponent, pos);
                String selectedText = this.textComponent.getText(start, (end = Utilities.getWordEnd(this.textComponent, pos)) - start);
                if (selectedText == null) {
                    return;
                }
                if (end == this.textComponent.getDocument().getLength() && selectedText.trim().equals("")) {
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                    this.outOfRange = true;
                    return;
                }
                if (start == this.textComponent.getDocument().getLength()) {
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                    this.outOfRange = true;
                    return;
                }
                if (this.textComponent.getDocument().getLength() < this.textComponent.getCaretPosition()) continue;
                if (selectedText.trim().equals("")) {
                    if ((pos += selectedText.length()) < this.textComponent.getDocument().getEndPosition().getOffset()) continue;
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                    this.outOfRange = true;
                    return;
                }
                if (this.matchCaseCheckBox.isSelected()) {
                    if (!selectedText.equals(this.searchedWordTextField.getText())) {
                        if ((pos += selectedText.length()) < this.textComponent.getDocument().getEndPosition().getOffset()) continue;
                        JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                        this.outOfRange = true;
                        return;
                    }
                    this.textComponent.select(Math.min(start, end), Math.max(start, end));
                    index = 1;
                    if ((pos += selectedText.length()) < this.textComponent.getDocument().getEndPosition().getOffset()) continue;
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                    this.outOfRange = true;
                    return;
                }
                if (!selectedText.equalsIgnoreCase(this.searchedWordTextField.getText())) {
                    if ((pos += selectedText.length()) < this.textComponent.getDocument().getEndPosition().getOffset()) continue;
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                    this.outOfRange = true;
                    return;
                }
                this.textComponent.select(Math.min(start, end), Math.max(start, end));
                index = 1;
                if ((pos += selectedText.length()) < this.textComponent.getDocument().getEndPosition().getOffset()) continue;
                JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                this.outOfRange = true;
                return;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void findNextWordBackward() {
        int index = -1;
        int pos = -1;
        try {
            while (index == -1) {
                int end;
                this.outOfRange = false;
                if (pos == -1) {
                    pos = this.textComponent.getSelectionStart() - 1;
                }
                if (pos <= this.textComponent.getDocument().getStartPosition().getOffset()) {
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the beginning of the document"), this.getTranslatedString("Search"), 1);
                    this.outOfRange = true;
                    return;
                }
                int start = Utilities.getWordStart(this.textComponent, pos);
                String selectedText = this.textComponent.getText(start, (end = Utilities.getWordEnd(this.textComponent, pos)) - start);
                if (selectedText == null) {
                    return;
                }
                if (this.textComponent.getDocument().getLength() < this.textComponent.getCaretPosition()) continue;
                if (selectedText.trim().equals("")) {
                    pos -= selectedText.length();
                    continue;
                }
                if (this.matchCaseCheckBox.isSelected()) {
                    if (!selectedText.equals(this.searchedWordTextField.getText())) {
                        if ((pos = pos - selectedText.length() - 1) > this.textComponent.getDocument().getStartPosition().getOffset()) continue;
                        JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the beginning of the document"), this.getTranslatedString("Search"), 1);
                        this.outOfRange = true;
                        return;
                    }
                    this.textComponent.select(Math.min(start, end), Math.max(start, end));
                    pos = pos - selectedText.length() - 1;
                    index = 1;
                    continue;
                }
                if (!selectedText.equalsIgnoreCase(this.searchedWordTextField.getText())) {
                    if ((pos = pos - selectedText.length() - 1) > this.textComponent.getDocument().getStartPosition().getOffset()) continue;
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the beginning of the document"), this.getTranslatedString("Search"), 1);
                    this.outOfRange = true;
                    return;
                }
                this.textComponent.select(Math.min(start, end), Math.max(start, end));
                pos = pos - selectedText.length() - 1;
                index = 1;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    String getTranslatedString(String s) {
        if (s == null) {
            return s;
        }
        HTMLEditor editor = SferyxUtilities.getHostHTMLEditor(this.textComponent);
        if (editor != null) {
            return editor.getTranslatedString(s);
        }
        return s;
    }

    public static void main(String[] args) {
        new ReplaceDialog((Frame)new JFrame(), true).show();
    }
}

